/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateKeySpec;

public class RSAMultiPrimePrivateCrtKeySpec
extends RSAPrivateKeySpec {
    private BigInteger publicExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;
    private RSAOtherPrimeInfo[] otherPrimeInfo;

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrimeP() {
        return this.primeP;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public RSAOtherPrimeInfo[] getOtherPrimeInfo() {
        return this.otherPrimeInfo == null ? null : (RSAOtherPrimeInfo[])this.otherPrimeInfo.clone();
    }

    public RSAMultiPrimePrivateCrtKeySpec(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient, RSAOtherPrimeInfo[] otherPrimeInfo) {
        super(modulus, privateExponent);
        if (modulus == null) {
            throw new NullPointerException("modulus");
        }
        if (publicExponent == null) {
            throw new NullPointerException("publicExponent");
        }
        if (privateExponent == null) {
            throw new NullPointerException("privateExponent");
        }
        if (primeP == null) {
            throw new NullPointerException("primeP");
        }
        if (primeQ == null) {
            throw new NullPointerException("primeQ");
        }
        if (primeExponentP == null) {
            throw new NullPointerException("primeExponentP");
        }
        if (primeExponentQ == null) {
            throw new NullPointerException("primeExponentQ");
        }
        if (crtCoefficient == null) {
            throw new NullPointerException("crtCoefficient");
        }
        if (otherPrimeInfo != null) {
            if (otherPrimeInfo.length == 0) {
                throw new IllegalArgumentException();
            }
            this.otherPrimeInfo = (RSAOtherPrimeInfo[])otherPrimeInfo.clone();
        }
        this.publicExponent = publicExponent;
        this.primeP = primeP;
        this.primeQ = primeQ;
        this.primeExponentP = primeExponentP;
        this.primeExponentQ = primeExponentQ;
        this.crtCoefficient = crtCoefficient;
    }
}

