/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.DOMSourceLocator;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class LiteralNode
extends TemplateNode {
    final Node source;
    final Collection elementExcludeResultPrefixes;

    final TemplateNode clone(Stylesheet stylesheet) {
        LiteralNode ret = new LiteralNode(this.source);
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    final void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        Node result = null;
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        short nodeType = this.source.getNodeType();
        if (nodeType != 2 || parent.getFirstChild() == null) {
            if (nodeType == 1) {
                String resultPrefix;
                String prefix = this.source.getPrefix();
                if (prefix == null) {
                    prefix = "#default";
                }
                if ((resultPrefix = (String)stylesheet.namespaceAliases.get(prefix)) != null) {
                    if ("#default".equals(resultPrefix)) {
                        resultPrefix = null;
                    }
                    String uri = this.source.lookupNamespaceURI(resultPrefix);
                    String name = this.source.getNodeName();
                    result = doc.createElementNS(uri, name);
                    NamedNodeMap srcAttrs = this.source.getAttributes();
                    NamedNodeMap dstAttrs = result.getAttributes();
                    int l = srcAttrs.getLength();
                    int i = 0;
                    while (i < l) {
                        Node attr = srcAttrs.item(i);
                        if (!"http://www.w3.org/1999/XSL/Transform".equals(attr.getNamespaceURI())) {
                            attr = attr.cloneNode(true);
                            attr = doc.adoptNode(attr);
                            dstAttrs.setNamedItemNS(attr);
                        }
                        ++i;
                    }
                }
            }
            if (result == null) {
                Node result2;
                result = this.source.cloneNode(false);
                NamedNodeMap attrs = result.getAttributes();
                if (attrs != null) {
                    int l = attrs.getLength();
                    int i = 0;
                    while (i < l) {
                        Node attr = attrs.item(i);
                        if ("http://www.w3.org/1999/XSL/Transform".equals(attr.getNamespaceURI())) {
                            attrs.removeNamedItem(attr.getNodeName());
                            --i;
                            --l;
                        }
                        ++i;
                    }
                }
                if ((result2 = doc.adoptNode(result)) == null) {
                    String msg = "Error adopting node to result tree: " + result + " (" + result.getClass().getName() + ')';
                    DOMSourceLocator l = new DOMSourceLocator(context);
                    throw new TransformerException(msg, l);
                }
                result = result2;
            }
            if (nextSibling != null) {
                parent.insertBefore(result, nextSibling);
            } else {
                parent.appendChild(result);
            }
            if (nodeType == 1) {
                stylesheet.addNamespaceNodes(this.source, result, doc, this.elementExcludeResultPrefixes);
            }
            if (this.children != null) {
                this.children.apply(stylesheet, mode, context, pos, len, result, null);
            }
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('[');
        buf.append("source=");
        buf.append(this.source);
        buf.append(']');
        return buf.toString();
    }

    LiteralNode(Node source) {
        this.source = source;
        if (source.getNodeType() == 1) {
            NamedNodeMap attrs = source.getAttributes();
            Node attr = attrs.getNamedItemNS("http://www.w3.org/1999/XSL/Transform", "exclude-result-prefixes");
            if (attr != null) {
                this.elementExcludeResultPrefixes = new HashSet();
                StringTokenizer st = new StringTokenizer(attr.getNodeValue());
                while (st.hasMoreTokens()) {
                    this.elementExcludeResultPrefixes.add(st.nextToken());
                }
            } else {
                this.elementExcludeResultPrefixes = Collections.EMPTY_SET;
            }
        } else {
            this.elementExcludeResultPrefixes = null;
        }
    }
}

