/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.BitMaskExtent;
import gnu.java.awt.Buffers;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;

public class SinglePixelPackedSampleModel
extends SampleModel {
    private int scanlineStride;
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] sampleSize;

    public int getNumDataElements() {
        return 1;
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new SinglePixelPackedSampleModel(this.dataType, w, h, this.bitMasks);
    }

    public DataBuffer createDataBuffer() {
        int size = this.scanlineStride * (this.height - 1) + this.width;
        return Buffers.createBuffer(this.getDataType(), size);
    }

    public int[] getSampleSize() {
        return this.sampleSize;
    }

    public int getSampleSize(int band) {
        return this.sampleSize[band];
    }

    public int getOffset(int x, int y) {
        return this.scanlineStride * y + x;
    }

    public int[] getBitOffsets() {
        return this.bitOffsets;
    }

    public int[] getBitMasks() {
        return this.bitMasks;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public SampleModel createSubsetSampleModel(int[] bands) {
        int numBands = bands.length;
        int[] bitMasks = new int[numBands];
        int b = 0;
        while (b < numBands) {
            bitMasks[b] = this.bitMasks[bands[b]];
            ++b;
        }
        return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, bitMasks);
    }

    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        int offset = this.scanlineStride * y + x + data.getOffset();
        return Buffers.getData(data, offset, obj, 0, 1);
    }

    public Object getDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        int size;
        int dataSize = size = w * h;
        Object[] pixelData = null;
        switch (this.getTransferType()) {
            case 0: {
                pixelData = ((DataBufferByte)data).getData();
                if (obj != null) break;
                obj = new byte[dataSize];
                break;
            }
            case 1: {
                pixelData = ((DataBufferUShort)data).getData();
                if (obj != null) break;
                obj = new short[dataSize];
                break;
            }
            case 3: {
                pixelData = ((DataBufferInt)data).getData();
                if (obj != null) break;
                obj = new int[dataSize];
                break;
            }
            default: {
                throw new ClassCastException();
            }
        }
        if (x == 0 && this.scanlineStride == w) {
            System.arraycopy(pixelData, this.scanlineStride * y + data.getOffset(), obj, 0, size);
        } else {
            int outOffset = 0;
            int dataOffset = this.scanlineStride * y + x + data.getOffset();
            int yy = y;
            while (yy < y + h) {
                System.arraycopy(pixelData, dataOffset, obj, outOffset, w);
                dataOffset += this.scanlineStride;
                outOffset += w;
                ++yy;
            }
        }
        return obj;
    }

    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        int offset = this.scanlineStride * y + x;
        if (iArray == null) {
            iArray = new int[this.numBands];
        }
        int samples = data.getElem(offset);
        int b = 0;
        while (b < this.numBands) {
            iArray[b] = (samples & this.bitMasks[b]) >>> this.bitOffsets[b];
            ++b;
        }
        return iArray;
    }

    public int[] getPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int offset = this.scanlineStride * y + x;
        if (iArray == null) {
            iArray = new int[this.numBands * w * h];
        }
        int outOffset = 0;
        y = 0;
        while (y < h) {
            int lineOffset = offset;
            x = 0;
            while (x < w) {
                int samples = data.getElem(lineOffset++);
                int b = 0;
                while (b < this.numBands) {
                    iArray[outOffset++] = (samples & this.bitMasks[b]) >>> this.bitOffsets[b];
                    ++b;
                }
                ++x;
            }
            offset += this.scanlineStride;
            ++y;
        }
        return iArray;
    }

    public int getSample(int x, int y, int b, DataBuffer data) {
        int offset = this.scanlineStride * y + x;
        int samples = data.getElem(offset);
        return (samples & this.bitMasks[b]) >>> this.bitOffsets[b];
    }

    public void setDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        Object[] pixelData;
        switch (this.getTransferType()) {
            case 0: {
                pixelData = ((DataBufferByte)data).getData();
                break;
            }
            case 1: {
                pixelData = ((DataBufferUShort)data).getData();
                break;
            }
            case 3: {
                pixelData = ((DataBufferInt)data).getData();
                break;
            }
            default: {
                throw new ClassCastException();
            }
        }
        int inOffset = 0;
        int dataOffset = this.scanlineStride * y + x + data.getOffset();
        int yy = y;
        while (yy < y + h) {
            System.arraycopy(obj, inOffset, pixelData, dataOffset, w);
            dataOffset += this.scanlineStride;
            inOffset += w;
            ++yy;
        }
    }

    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        int offset = this.scanlineStride * y + x + data.getOffset();
        int transferType = this.getTransferType();
        if (this.getTransferType() != data.getDataType()) {
            throw new IllegalArgumentException("transfer type (" + this.getTransferType() + "), does not match data buffer type (" + data.getDataType() + ").");
        }
        try {
            switch (transferType) {
                case 0: {
                    DataBufferByte out = (DataBufferByte)data;
                    byte[] in = (byte[])obj;
                    out.getData()[offset] = in[0];
                    return;
                }
                case 1: {
                    DataBufferUShort out = (DataBufferUShort)data;
                    short[] in = (short[])obj;
                    out.getData()[offset] = in[0];
                    return;
                }
                case 3: {
                    DataBufferInt out = (DataBufferInt)data;
                    int[] in = (int[])obj;
                    out.getData()[offset] = in[0];
                    return;
                }
            }
            throw new InternalError();
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            String msg = "While writing data elements, x=" + x + ", y=" + y + ", width=" + this.width + ", height=" + this.height + ", scanlineStride=" + this.scanlineStride + ", offset=" + offset + ", data.getSize()=" + data.getSize() + ", data.getOffset()=" + data.getOffset() + ": " + aioobe;
            throw new ArrayIndexOutOfBoundsException(msg);
        }
    }

    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        int offset = this.scanlineStride * y + x;
        int samples = 0;
        int b = 0;
        while (b < this.numBands) {
            samples |= iArray[b] << this.bitOffsets[b] & this.bitMasks[b];
            ++b;
        }
        data.setElem(offset, samples);
    }

    public void setPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int inOffset = 0;
        int[] pixel = new int[this.numBands];
        int yy = y;
        while (yy < y + h) {
            int offset = this.scanlineStride * yy + x;
            int xx = x;
            while (xx < x + w) {
                int samples = 0;
                int b = 0;
                while (b < this.numBands) {
                    samples |= iArray[inOffset + b] << this.bitOffsets[b] & this.bitMasks[b];
                    ++b;
                }
                data.setElem(0, offset, samples);
                inOffset += this.numBands;
                ++offset;
                ++xx;
            }
            ++yy;
        }
    }

    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        int offset = this.scanlineStride * y + x;
        int samples = data.getElem(offset);
        int bitMask = this.bitMasks[b];
        samples &= ~bitMask;
        data.setElem(offset, samples |= s << this.bitOffsets[b] & bitMask);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName());
        result.append("[");
        result.append("scanlineStride=").append(this.scanlineStride);
        int i = 0;
        while (i < this.bitMasks.length) {
            result.append(", mask[").append(i).append("]=0x").append(Integer.toHexString(this.bitMasks[i]));
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public SinglePixelPackedSampleModel(int dataType, int w, int h, int[] bitMasks) {
        this(dataType, w, h, w, bitMasks);
    }

    public SinglePixelPackedSampleModel(int dataType, int w, int h, int scanlineStride, int[] bitMasks) {
        super(dataType, w, h, bitMasks.length);
        switch (dataType) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("SinglePixelPackedSampleModel unsupported dataType");
            }
        }
        this.scanlineStride = scanlineStride;
        this.bitMasks = bitMasks;
        this.bitOffsets = new int[this.numBands];
        this.sampleSize = new int[this.numBands];
        BitMaskExtent extent = new BitMaskExtent();
        int b = 0;
        while (b < this.numBands) {
            extent.setMask(bitMasks[b]);
            this.sampleSize[b] = extent.bitWidth;
            this.bitOffsets[b] = extent.leastSignificantBit;
            ++b;
        }
    }
}

