##
# Borges::ActionCallback is used by Borges::CallbackStore and
# Borges::HtmlRenderer to provide an callback that will be run
# when the form has completed processing.
# 
# CallbackStore enforces that only one ActionCallback will be
# called.

class Borges::ActionCallback < Borges::Callback

  ##
  # Creates a new ActionCallback from +block+.

  def initialize(&block)
    @block = block
  end

  ##
  # Sets this callback as +store+'s default action.

  def evaluate(input, store)
    store.action do @block.call end
  end

  ##
  # Is this an ActionCallback?

  def action_callback?
    true
  end

end # class Borges::ActionCallback

