class Borges::Path < Borges::Component

  def choose(assoc)
    new_stack = []

    @stack.each do |item|
      new_stack << item
      if item == assoc then
        @stack = new_stack
        return
      end
    end
  end

  def current_segment
    if @stack.empty? then
      nil
    else
      @stack.last[0]
    end
  end

  def initialize
    @stack = []
    self.session.register_for_backtracking self
  end

  def push(segment, name)
    @stack.push [segment, name]
  end

  def pop
    @stack.pop
  end

  def render_content_on(r)
    return if @stack.empty?

    r.div_named('path') do
      @stack[0..-2].each do |assoc|
        r.anchor(assoc[1]) do
          choose assoc
        end

        r.text ' >> '
      end

      r.bold @stack.last[1]
    end
  end

end

