/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wiztools.commons.ImplementationLoadException;

public class Implementation {
    private static final String PROP_NAME = "wiztools-service-locator.properties";
    private static final Logger LOG = Logger.getLogger(Implementation.class.getName());
    private static final Map<String, Object> map = Collections.synchronizedMap(new HashMap());
    private static final Properties props = new Properties();

    public static <T> T of(Class<T> c) throws ImplementationLoadException {
        try {
            String className = c.getName();
            String implClassStr = props.getProperty(className);
            boolean isSingleton = false;
            String isSingletonStr = props.getProperty(className + ".singleton");
            if (isSingletonStr != null) {
                isSingleton = Boolean.parseBoolean(isSingletonStr);
            } else {
                LOG.log(Level.FINEST, "Singleton property not set for class: {0}", className);
            }
            if (!isSingleton) {
                return (T)Class.forName(implClassStr).newInstance();
            }
            Object o = map.get(c.getName());
            if (o == null) {
                o = Class.forName(implClassStr).newInstance();
                map.put(c.getName(), o);
                LOG.log(Level.FINEST, "Class created, and put into cache: {0}", o.getClass().getName());
            } else {
                LOG.log(Level.FINEST, "Object already available in cache: {0}", className);
            }
            return (T)o;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ImplementationLoadException(ex);
        }
    }

    static {
        try {
            Enumeration<URL> e = Implementation.class.getClassLoader().getResources(PROP_NAME);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                URLConnection con = url.openConnection();
                con.connect();
                props.load(con.getInputStream());
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }
}

