/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RepaintManager {
    static RepaintManager globalManager;
    HashMap dirtyComponents = new HashMap();
    HashMap workDirtyComponents = new HashMap();
    ArrayList repaintOrder = new ArrayList();
    ArrayList workRepaintOrder = new ArrayList();
    Comparator comparator;
    RepaintWorker repaintWorker;
    ArrayList invalidComponents = new ArrayList();
    ArrayList workInvalidComponents = new ArrayList();
    boolean doubleBufferingEnabled = true;
    Image doubleBuffer;
    Dimension doubleBufferMaximumSize;

    public static RepaintManager currentManager(Component component) {
        if (globalManager == null) {
            globalManager = new RepaintManager();
        }
        return globalManager;
    }

    public static RepaintManager currentManager(JComponent component) {
        return RepaintManager.currentManager((Component)component);
    }

    public static void setCurrentManager(RepaintManager manager) {
        globalManager = manager;
    }

    public synchronized void addInvalidComponent(JComponent component) {
        Container ancestor = component.getParent();
        while (!(ancestor == null || ancestor instanceof JComponent && ((JComponent)ancestor).isValidateRoot())) {
            ancestor = ancestor.getParent();
        }
        if (ancestor != null && ancestor instanceof JComponent && ((JComponent)ancestor).isValidateRoot()) {
            component = (JComponent)ancestor;
        }
        if (this.invalidComponents.contains(component)) {
            return;
        }
        this.invalidComponents.add(component);
        if (!this.repaintWorker.isLive()) {
            this.repaintWorker.setLive(true);
            SwingUtilities.invokeLater(this.repaintWorker);
        }
    }

    public synchronized void removeInvalidComponent(JComponent component) {
        this.invalidComponents.remove(component);
    }

    public synchronized void addDirtyRegion(JComponent component, int x, int y, int w, int h) {
        if (w == 0 || h == 0 || !component.isShowing()) {
            return;
        }
        Rectangle r = new Rectangle(x, y, w, h);
        if (this.dirtyComponents.containsKey(component)) {
            r = r.union((Rectangle)this.dirtyComponents.get(component));
        } else {
            this.insertInRepaintOrder(component);
        }
        this.dirtyComponents.put(component, r);
        if (!this.repaintWorker.isLive()) {
            this.repaintWorker.setLive(true);
            SwingUtilities.invokeLater(this.repaintWorker);
        }
    }

    private final void insertInRepaintOrder(JComponent c) {
        int insertIndex;
        if (this.comparator == null) {
            this.comparator = new ComponentComparator();
        }
        if ((insertIndex = Collections.binarySearch(this.repaintOrder, c, this.comparator)) < 0) {
            insertIndex = -(insertIndex + 1);
        }
        this.repaintOrder.add(insertIndex, c);
    }

    public Rectangle getDirtyRegion(JComponent component) {
        Rectangle dirty = (Rectangle)this.dirtyComponents.get(component);
        if (dirty == null) {
            dirty = new Rectangle();
        }
        return dirty;
    }

    public void markCompletelyDirty(JComponent component) {
        Rectangle r = component.getBounds();
        this.addDirtyRegion(component, r.x, r.y, r.width, r.height);
        component.isCompletelyDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void markCompletelyClean(JComponent component) {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            this.dirtyComponents.remove(component);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            component.isCompletelyDirty = false;
            return;
        }
    }

    public boolean isCompletelyDirty(JComponent component) {
        if (!this.dirtyComponents.containsKey(component)) {
            return false;
        }
        return component.isCompletelyDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validateInvalidComponents() {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            ArrayList swap = this.invalidComponents;
            this.invalidComponents = this.workInvalidComponents;
            this.workInvalidComponents = swap;
        }
        Iterator i = this.workInvalidComponents.iterator();
        while (i.hasNext()) {
            JComponent comp = (JComponent)i.next();
            if (!comp.isVisible() || !comp.isShowing()) continue;
            comp.validate();
        }
        this.workInvalidComponents.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void paintDirtyRegions() {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            ArrayList swap = this.workRepaintOrder;
            this.workRepaintOrder = this.repaintOrder;
            this.repaintOrder = swap;
            HashMap swap2 = this.workDirtyComponents;
            this.workDirtyComponents = this.dirtyComponents;
            this.dirtyComponents = swap2;
        }
        Iterator i = this.workRepaintOrder.iterator();
        while (i.hasNext()) {
            JComponent comp = (JComponent)i.next();
            Rectangle damaged = (Rectangle)this.workDirtyComponents.get(comp);
            if (damaged == null || damaged.isEmpty()) continue;
            comp.paintImmediately(damaged);
        }
        this.workRepaintOrder.clear();
        this.workDirtyComponents.clear();
    }

    public Image getOffscreenBuffer(Component component, int proposedWidth, int proposedHeight) {
        if (this.doubleBuffer == null || (this.doubleBuffer.getWidth(null) < proposedWidth || this.doubleBuffer.getHeight(null) < proposedHeight) && proposedWidth < this.doubleBufferMaximumSize.width && proposedHeight < this.doubleBufferMaximumSize.height) {
            this.doubleBuffer = component.createImage(proposedWidth, proposedHeight);
        }
        return this.doubleBuffer;
    }

    public Image getVolatileOffscreenBuffer(Component comp, int proposedWidth, int proposedHeight) {
        int maxWidth = this.doubleBufferMaximumSize.width;
        int maxHeight = this.doubleBufferMaximumSize.height;
        return comp.createVolatileImage(Math.min(maxWidth, proposedWidth), Math.min(maxHeight, proposedHeight));
    }

    public Dimension getDoubleBufferMaximumSize() {
        return this.doubleBufferMaximumSize;
    }

    public void setDoubleBufferMaximumSize(Dimension size) {
        this.doubleBufferMaximumSize = size;
    }

    public void setDoubleBufferingEnabled(boolean buffer) {
        this.doubleBufferingEnabled = buffer;
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    public String toString() {
        return "RepaintManager";
    }

    public RepaintManager() {
        this.repaintWorker = new RepaintWorker();
        this.doubleBufferMaximumSize = new Dimension(2000, 2000);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class RepaintWorker
    implements Runnable {
        boolean live = false;

        public synchronized void setLive(boolean b) {
            this.live = b;
        }

        public synchronized boolean isLive() {
            return this.live;
        }

        public void run() {
            RepaintManager rm = globalManager;
            this.setLive(false);
            rm.validateInvalidComponents();
            rm.paintDirtyRegions();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ComponentComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof JComponent && o2 instanceof JComponent) {
                JComponent c1 = (JComponent)o1;
                JComponent c2 = (JComponent)o2;
                return this.getDepth(c1) - this.getDepth(c2);
            }
            throw new ClassCastException("This comparator can only be used with JComponents");
        }

        private final int getDepth(JComponent c) {
            Container comp = c;
            int depth = 0;
            while (comp != null) {
                comp = comp.getParent();
                ++depth;
            }
            return depth;
        }

        private ComponentComparator() {
        }
    }
}

