/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DataFlavor
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 8367026044764648243L;
    public static final DataFlavor plainTextFlavor;
    public static final DataFlavor stringFlavor;
    public static final DataFlavor javaFileListFlavor;
    public static final DataFlavor imageFlavor;
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-objectref";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    private final String mimeType;
    private final Class representationClass;
    private String humanPresentableName;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$nio$ByteBuffer;
    static /* synthetic */ Class class$java$nio$CharBuffer;

    protected static final Class tryToLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
                return Class.forName(string, true, classLoader2);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    ClassLoader classLoader3 = Thread.currentThread().getContextClassLoader();
                    return Class.forName(string, true, classLoader3);
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    if (classLoader != null) {
                        return Class.forName(string, true, classLoader);
                    }
                    throw new ClassNotFoundException(string);
                }
            }
        }
    }

    private static final Class getRepresentationClassFromMime(String string, ClassLoader classLoader) {
        String string2 = DataFlavor.getParameter("class", string);
        if (string2 != null) {
            try {
                return DataFlavor.tryToLoadClass(string2, classLoader);
            }
            catch (Exception exception) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("mimeString: " + string + " classLoader: " + classLoader);
                illegalArgumentException.initCause(exception);
                throw illegalArgumentException;
            }
        }
        Class clazz = class$java$io$InputStream;
        if (clazz == null) {
            clazz = class$java$io$InputStream = DataFlavor.class("[Ljava.io.InputStream;", false);
        }
        return clazz;
    }

    private static final String getParameter(String string, String string2) {
        int n = string2.indexOf(string + '=');
        if (n == -1) {
            return null;
        }
        String string3 = string2.substring(n + string.length() + 1);
        if ((n = string3.indexOf(" ")) == -1) {
            return string3;
        }
        return string3.substring(0, n);
    }

    public static final DataFlavor getTextPlainUnicodeFlavor() {
        return plainTextFlavor;
    }

    public static final DataFlavor selectBestTextFlavor(DataFlavor[] dataFlavorArray) {
        int n = 0;
        while (n < dataFlavorArray.length) {
            Class clazz;
            DataFlavor dataFlavor;
            block14: {
                block13: {
                    dataFlavor = dataFlavorArray[n];
                    clazz = dataFlavor.representationClass;
                    Class clazz2 = class$java$io$Reader;
                    if (clazz2 == null) {
                        clazz2 = DataFlavor.class("[Ljava.io.Reader;", false);
                    }
                    if (clazz2.isAssignableFrom(clazz)) break block13;
                    Class clazz3 = class$java$lang$String;
                    if (clazz3 == null) {
                        clazz3 = DataFlavor.class("[Ljava.lang.String;", false);
                    }
                    if (!clazz3.isAssignableFrom(clazz)) break block14;
                }
                return dataFlavor;
            }
            Class clazz4 = class$java$io$InputStream;
            if (clazz4 == null) {
                clazz4 = DataFlavor.class("[Ljava.io.InputStream;", false);
            }
            if (clazz4.isAssignableFrom(clazz) && "text".equals(dataFlavor.getPrimaryType())) {
                String string = dataFlavorArray[n].getParameter("charset");
                if (string == null) {
                    string = "us-ascii";
                }
                InputStreamReader inputStreamReader = null;
                try {
                    inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                if (inputStreamReader != null) {
                    return dataFlavor;
                }
            }
            ++n;
        }
        return null;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public String getPrimaryType() {
        int n = this.mimeType.indexOf("/");
        if (n == -1) {
            return this.mimeType;
        }
        return this.mimeType.substring(0, n);
    }

    public String getSubType() {
        int n = this.mimeType.indexOf("/");
        if (n == -1) {
            return "";
        }
        int n2 = this.mimeType.indexOf(";", n + 1);
        if (n2 == -1) {
            return this.mimeType.substring(n + 1);
        }
        return this.mimeType.substring(n + 1, n2);
    }

    public String getParameter(String string) {
        if ("humanPresentableName".equals(string)) {
            return this.getHumanPresentableName();
        }
        return DataFlavor.getParameter(string, this.mimeType);
    }

    public void setHumanPresentableName(String string) {
        this.humanPresentableName = string;
    }

    public boolean isMimeTypeEqual(String string) {
        String string2 = this.getMimeType();
        int n = string2.indexOf(";");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if ((n = string.indexOf(";")) != -1) {
            string = string.substring(0, n);
        }
        return string2.equals(string);
    }

    public final boolean isMimeTypeEqual(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor.getMimeType());
    }

    public boolean isMimeTypeSerializedObject() {
        return this.mimeType.startsWith(javaSerializedObjectMimeType);
    }

    public boolean isRepresentationClassInputStream() {
        return this.representationClass.getName().equals("java.io.InputStream");
    }

    public boolean isRepresentationClassSerializable() {
        Class[] classArray = this.representationClass.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].getName().equals("java.io.Serializable")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isRepresentationClassRemote() {
        Class clazz = class$java$rmi$Remote;
        if (clazz == null) {
            clazz = class$java$rmi$Remote = DataFlavor.class("[Ljava.rmi.Remote;", false);
        }
        return clazz.isAssignableFrom(this.representationClass);
    }

    public boolean isFlavorSerializedObjectType() {
        return this.mimeType.startsWith(javaSerializedObjectMimeType);
    }

    public boolean isFlavorRemoteObjectType() {
        return this.mimeType.startsWith(javaRemoteObjectMimeType);
    }

    public boolean isFlavorJavaFileListType() {
        return this.mimeType.equals(DataFlavor.javaFileListFlavor.mimeType) && this.representationClass.equals(DataFlavor.javaFileListFlavor.representationClass);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            return false;
        }
        if (!this.mimeType.toLowerCase().equals(dataFlavor.mimeType.toLowerCase())) {
            return false;
        }
        return this.representationClass.equals(dataFlavor.representationClass);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataFlavor)) {
            return false;
        }
        return this.equals((DataFlavor)object);
    }

    public boolean equals(String string) {
        return this.isMimeTypeEqual(string);
    }

    public int hashCode() {
        return this.mimeType.toLowerCase().hashCode() ^ this.representationClass.hashCode();
    }

    public boolean match(DataFlavor dataFlavor) {
        return this.equals(dataFlavor);
    }

    protected String normalizeMimeTypeParameter(String string, String string2) {
        return string + '=' + string2;
    }

    protected String normalizeMimeType(String string) {
        return string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public String toString() {
        return this.getClass().getName() + "[representationClass=" + this.getRepresentationClass().getName() + ",mimeType=" + this.getMimeType() + ",humanPresentableName=" + this.getHumanPresentableName() + ']';
    }

    public final Class getDefaultRepresentationClass() {
        Class clazz = class$java$io$InputStream;
        if (clazz == null) {
            clazz = class$java$io$InputStream = DataFlavor.class("[Ljava.io.InputStream;", false);
        }
        return clazz;
    }

    public final String getDefaultRepresentationClassAsString() {
        return this.getDefaultRepresentationClass().getName();
    }

    public Reader getReaderForText(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (!transferable.isDataFlavorSupported(this)) {
            throw new UnsupportedFlavorException(this);
        }
        Class clazz = class$java$io$Reader;
        if (clazz == null) {
            clazz = class$java$io$Reader = DataFlavor.class("[Ljava.io.Reader;", false);
        }
        if (clazz.isAssignableFrom(this.representationClass)) {
            return (Reader)transferable.getTransferData(this);
        }
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = DataFlavor.class("[Ljava.lang.String;", false);
        }
        if (clazz2.isAssignableFrom(this.representationClass)) {
            return new StringReader((String)transferable.getTransferData(this));
        }
        Class clazz3 = class$java$io$InputStream;
        if (clazz3 == null) {
            clazz3 = class$java$io$InputStream = DataFlavor.class("[Ljava.io.InputStream;", false);
        }
        if (clazz3.isAssignableFrom(this.representationClass) && "text".equals(this.getPrimaryType())) {
            InputStream inputStream = (InputStream)transferable.getTransferData(this);
            String string = this.getParameter("charset");
            if (string == null) {
                string = "us-ascii";
            }
            return new InputStreamReader(inputStream, string);
        }
        throw new UnsupportedFlavorException(this);
    }

    public boolean isRepresentationClassByteBuffer() {
        Class clazz = class$java$nio$ByteBuffer;
        if (clazz == null) {
            clazz = class$java$nio$ByteBuffer = DataFlavor.class("[Ljava.nio.ByteBuffer;", false);
        }
        return clazz.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassCharBuffer() {
        Class clazz = class$java$nio$CharBuffer;
        if (clazz == null) {
            clazz = class$java$nio$CharBuffer = DataFlavor.class("[Ljava.nio.CharBuffer;", false);
        }
        return clazz.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassReader() {
        Class clazz = class$java$io$Reader;
        if (clazz == null) {
            clazz = class$java$io$Reader = DataFlavor.class("[Ljava.io.Reader;", false);
        }
        return clazz.isAssignableFrom(this.representationClass);
    }

    public boolean isFlavorTextType() {
        block17: {
            block22: {
                Class clazz;
                block18: {
                    String string;
                    block21: {
                        block20: {
                            block19: {
                                if (!this.equals(stringFlavor) && !this.getPrimaryType().equals("text")) break block17;
                                string = this.getParameter("charset");
                                clazz = this.getRepresentationClass();
                                if (string == null) break block18;
                                Class clazz2 = class$java$io$Reader;
                                if (clazz2 == null) {
                                    clazz2 = class$java$io$Reader = DataFlavor.class("[Ljava.io.Reader;", false);
                                }
                                if (clazz2.isAssignableFrom(clazz)) break block19;
                                Class clazz3 = class$java$nio$CharBuffer;
                                if (clazz3 == null) {
                                    clazz3 = class$java$nio$CharBuffer = DataFlavor.class("[Ljava.nio.CharBuffer;", false);
                                }
                                if (clazz3.isAssignableFrom(clazz)) break block19;
                                Class clazz4 = class$java$lang$String;
                                if (clazz4 == null) {
                                    clazz4 = class$java$lang$String = DataFlavor.class("[Ljava.lang.String;", false);
                                }
                                if (!clazz4.isAssignableFrom(clazz)) break block20;
                            }
                            return true;
                        }
                        Class clazz5 = class$java$io$InputStream;
                        if (clazz5 == null) {
                            clazz5 = class$java$io$InputStream = DataFlavor.class("[Ljava.io.InputStream;", false);
                        }
                        if (clazz5.isAssignableFrom(clazz)) break block21;
                        Class clazz6 = class$java$nio$ByteBuffer;
                        if (clazz6 == null) {
                            clazz6 = class$java$nio$ByteBuffer = DataFlavor.class("[Ljava.nio.ByteBuffer;", false);
                        }
                        if (!clazz6.isAssignableFrom(clazz)) break block17;
                    }
                    return Charset.isSupported(string);
                }
                Class clazz7 = class$java$io$InputStream;
                if (clazz7 == null) {
                    clazz7 = class$java$io$InputStream = DataFlavor.class("[Ljava.io.InputStream;", false);
                }
                if (clazz7.isAssignableFrom(clazz)) break block22;
                Class clazz8 = class$java$nio$ByteBuffer;
                if (clazz8 == null) {
                    clazz8 = class$java$nio$ByteBuffer = DataFlavor.class("[Ljava.nio.ByteBuffer;", false);
                }
                if (!clazz8.isAssignableFrom(clazz)) break block17;
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public DataFlavor() {
        this.mimeType = null;
        this.representationClass = null;
        this.humanPresentableName = null;
    }

    private DataFlavor(Class clazz, String string, String string2) {
        this.representationClass = clazz;
        this.mimeType = string;
        this.humanPresentableName = string2 != null ? string2 : string;
    }

    public DataFlavor(Class clazz, String string) {
        this(clazz, "application/x-java-serialized-object; class=" + clazz.getName(), string);
    }

    public DataFlavor(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        this(DataFlavor.getRepresentationClassFromMime(string, classLoader), string, string2);
    }

    public DataFlavor(String string, String string2) {
        this(DataFlavor.getRepresentationClassFromMime(string, null), string, string2);
    }

    public DataFlavor(String string) throws ClassNotFoundException {
        this(string, null);
    }

    static {
        Class clazz = class$java$io$InputStream;
        if (clazz == null) {
            clazz = class$java$io$InputStream = DataFlavor.class("[Ljava.io.InputStream;", false);
        }
        plainTextFlavor = new DataFlavor(clazz, "text/plain; charset=unicode", "plain unicode text");
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = DataFlavor.class("[Ljava.lang.String;", false);
        }
        stringFlavor = new DataFlavor(clazz2, "Java Unicode String");
        Class clazz3 = class$java$util$List;
        if (clazz3 == null) {
            clazz3 = class$java$util$List = DataFlavor.class("[Ljava.util.List;", false);
        }
        javaFileListFlavor = new DataFlavor(clazz3, "application/x-java-file-list; class=java.util.List", "Java File List");
        Class clazz4 = class$java$awt$Image;
        if (clazz4 == null) {
            clazz4 = class$java$awt$Image = DataFlavor.class("[Ljava.awt.Image;", false);
        }
        imageFlavor = new DataFlavor(clazz4, "Java Image");
    }
}

