/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.CodeAttr;
import gnu.bytecodecvssnap.Label;
import gnu.bytecodecvssnap.Type;
import gnu.bytecodecvssnap.VarEnumerator;
import gnu.bytecodecvssnap.Variable;

public class Scope {
    Scope parent;
    Scope nextSibling;
    Scope firstChild;
    Scope lastChild;
    boolean preserved;
    Label start;
    Label end;
    Variable vars;
    Variable last_var;

    public final Variable firstVar() {
        return this.vars;
    }

    public VarEnumerator allVars() {
        return new VarEnumerator(this);
    }

    public void linkChild(Scope scope) {
        this.parent = scope;
        if (scope == null) {
            return;
        }
        if (scope.lastChild == null) {
            scope.firstChild = this;
        } else {
            scope.lastChild.nextSibling = this;
        }
        scope.lastChild = this;
    }

    public Variable addVariable(CodeAttr codeAttr, Type type, String string) {
        Variable variable = new Variable(string, type);
        this.addVariable(codeAttr, variable);
        return variable;
    }

    public void addVariable(Variable variable) {
        if (this.last_var == null) {
            this.vars = variable;
        } else {
            this.last_var.next = variable;
        }
        this.last_var = variable;
        variable.scope = this;
    }

    public void addVariableAfter(Variable variable, Variable variable2) {
        if (variable == null) {
            variable2.next = this.vars;
            this.vars = variable2;
        } else {
            variable2.next = variable.next;
            variable.next = variable2;
        }
        if (this.last_var == variable) {
            this.last_var = variable2;
        }
        if (variable2.next == variable2) {
            throw new Error("cycle");
        }
        variable2.scope = this;
    }

    public void addVariable(CodeAttr codeAttr, Variable variable) {
        this.addVariable(variable);
        if (variable.isSimple() && codeAttr != null) {
            variable.allocateLocal(codeAttr);
        }
    }

    public Variable getVariable(int n) {
        Variable variable = this.vars;
        while (--n >= 0) {
            variable = variable.next;
        }
        return variable;
    }

    static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        if (byArray == byArray2) {
            return true;
        }
        int n = byArray.length;
        while (--n >= 0) {
            if (byArray[n] == byArray2[n]) continue;
            return false;
        }
        return true;
    }

    public void setStartPC(CodeAttr codeAttr) {
        this.start = codeAttr.getLabel();
    }

    public Variable lookup(String string) {
        Variable variable = this.vars;
        while (variable != null) {
            if (string.equals(variable.name)) {
                return variable;
            }
            variable = variable.next;
        }
        return null;
    }

    void freeLocals(CodeAttr codeAttr) {
        if (this.preserved) {
            return;
        }
        Object object = this.vars;
        while (object != null) {
            if (((Variable)object).isSimple() && !((Variable)object).dead()) {
                ((Variable)object).freeLocal(codeAttr);
            }
            object = ((Variable)object).next;
        }
        object = this.firstChild;
        while (object != null) {
            if (((Scope)object).preserved) {
                ((Scope)object).preserved = false;
                ((Scope)object).freeLocals(codeAttr);
            }
            object = ((Scope)object).nextSibling;
        }
    }

    public Scope() {
    }

    public Scope(Label label, Label label2) {
        this.start = label;
        this.end = label2;
    }
}

