<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataproc;

class SparkRJob extends \Google\Collection
{
  protected $collection_key = 'fileUris';
  public $archiveUris;
  public $args;
  public $fileUris;
  protected $loggingConfigType = LoggingConfig::class;
  protected $loggingConfigDataType = '';
  public $mainRFileUri;
  public $properties;

  public function setArchiveUris($archiveUris)
  {
    $this->archiveUris = $archiveUris;
  }
  public function getArchiveUris()
  {
    return $this->archiveUris;
  }
  public function setArgs($args)
  {
    $this->args = $args;
  }
  public function getArgs()
  {
    return $this->args;
  }
  public function setFileUris($fileUris)
  {
    $this->fileUris = $fileUris;
  }
  public function getFileUris()
  {
    return $this->fileUris;
  }
  /**
   * @param LoggingConfig
   */
  public function setLoggingConfig(LoggingConfig $loggingConfig)
  {
    $this->loggingConfig = $loggingConfig;
  }
  /**
   * @return LoggingConfig
   */
  public function getLoggingConfig()
  {
    return $this->loggingConfig;
  }
  public function setMainRFileUri($mainRFileUri)
  {
    $this->mainRFileUri = $mainRFileUri;
  }
  public function getMainRFileUri()
  {
    return $this->mainRFileUri;
  }
  public function setProperties($properties)
  {
    $this->properties = $properties;
  }
  public function getProperties()
  {
    return $this->properties;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SparkRJob::class, 'Google_Service_Dataproc_SparkRJob');
