<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class Project extends \Google\Collection
{
  protected $collection_key = 'quotas';
  protected $commonInstanceMetadataType = Metadata::class;
  protected $commonInstanceMetadataDataType = '';
  public $creationTimestamp;
  public $defaultNetworkTier;
  public $defaultServiceAccount;
  public $description;
  public $enabledFeatures;
  public $id;
  public $kind;
  public $name;
  protected $quotasType = Quota::class;
  protected $quotasDataType = 'array';
  public $selfLink;
  protected $usageExportLocationType = UsageExportLocation::class;
  protected $usageExportLocationDataType = '';
  public $xpnProjectStatus;

  /**
   * @param Metadata
   */
  public function setCommonInstanceMetadata(Metadata $commonInstanceMetadata)
  {
    $this->commonInstanceMetadata = $commonInstanceMetadata;
  }
  /**
   * @return Metadata
   */
  public function getCommonInstanceMetadata()
  {
    return $this->commonInstanceMetadata;
  }
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  public function setDefaultNetworkTier($defaultNetworkTier)
  {
    $this->defaultNetworkTier = $defaultNetworkTier;
  }
  public function getDefaultNetworkTier()
  {
    return $this->defaultNetworkTier;
  }
  public function setDefaultServiceAccount($defaultServiceAccount)
  {
    $this->defaultServiceAccount = $defaultServiceAccount;
  }
  public function getDefaultServiceAccount()
  {
    return $this->defaultServiceAccount;
  }
  public function setDescription($description)
  {
    $this->description = $description;
  }
  public function getDescription()
  {
    return $this->description;
  }
  public function setEnabledFeatures($enabledFeatures)
  {
    $this->enabledFeatures = $enabledFeatures;
  }
  public function getEnabledFeatures()
  {
    return $this->enabledFeatures;
  }
  public function setId($id)
  {
    $this->id = $id;
  }
  public function getId()
  {
    return $this->id;
  }
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  public function getKind()
  {
    return $this->kind;
  }
  public function setName($name)
  {
    $this->name = $name;
  }
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param Quota[]
   */
  public function setQuotas($quotas)
  {
    $this->quotas = $quotas;
  }
  /**
   * @return Quota[]
   */
  public function getQuotas()
  {
    return $this->quotas;
  }
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * @param UsageExportLocation
   */
  public function setUsageExportLocation(UsageExportLocation $usageExportLocation)
  {
    $this->usageExportLocation = $usageExportLocation;
  }
  /**
   * @return UsageExportLocation
   */
  public function getUsageExportLocation()
  {
    return $this->usageExportLocation;
  }
  public function setXpnProjectStatus($xpnProjectStatus)
  {
    $this->xpnProjectStatus = $xpnProjectStatus;
  }
  public function getXpnProjectStatus()
  {
    return $this->xpnProjectStatus;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Project::class, 'Google_Service_Compute_Project');
