/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;

public final class Move {
    private static int s_size;
    private static Move s_passBlack;
    private static Move s_passWhite;
    private static Move[][] s_movesBlack;
    private static Move[][] s_movesEmpty;
    private static Move[][] s_movesWhite;
    private final GoColor m_color;
    private final GoPoint m_point;
    private final String m_string;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public static Move get(int n, int n2, GoColor goColor) {
        return Move.get(GoPoint.get(n, n2), goColor);
    }

    public static Move get(GoPoint goPoint, GoColor goColor) {
        int n;
        if (goPoint == null) {
            if (goColor == GoColor.BLACK) {
                return s_passBlack;
            }
            if (!$assertionsDisabled && goColor != GoColor.WHITE) {
                throw new AssertionError();
            }
            return s_passWhite;
        }
        int n2 = goPoint.getX();
        int n3 = Math.max(n2, n = goPoint.getY());
        if (n3 >= s_size) {
            Move.grow(n3 + 1);
        }
        if (goColor == GoColor.BLACK) {
            return s_movesBlack[n2][n];
        }
        if (goColor == GoColor.WHITE) {
            return s_movesWhite[n2][n];
        }
        return s_movesEmpty[n2][n];
    }

    public static Move getPass(GoColor goColor) {
        return Move.get(null, goColor);
    }

    public GoColor getColor() {
        return this.m_color;
    }

    public GoPoint getPoint() {
        return this.m_point;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.m_string;
    }

    private static void grow(int n) {
        if (!$assertionsDisabled && n <= s_size) {
            throw new AssertionError();
        }
        s_movesBlack = Move.grow(n, GoColor.BLACK, s_movesBlack);
        s_movesWhite = Move.grow(n, GoColor.WHITE, s_movesWhite);
        s_movesEmpty = Move.grow(n, GoColor.EMPTY, s_movesEmpty);
        s_size = n;
    }

    private static Move[][] grow(int n, GoColor goColor, Move[][] moveArray) {
        if (!$assertionsDisabled && n <= s_size) {
            throw new AssertionError();
        }
        Move[][] moveArray2 = new Move[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                moveArray2[i][j] = i < s_size && j < s_size ? moveArray[i][j] : new Move(GoPoint.get(i, j), goColor);
            }
        }
        return moveArray2;
    }

    private Move(GoPoint goPoint, GoColor goColor) {
        this.m_point = goPoint;
        this.m_color = goColor;
        this.m_string = this.m_color.toString() + " " + GoPoint.toString(this.m_point);
    }

    static {
        $assertionsDisabled = !Move.class.desiredAssertionStatus();
        s_passBlack = new Move(null, GoColor.BLACK);
        s_passWhite = new Move(null, GoColor.WHITE);
        s_size = 0;
        Move.grow(19);
    }
}

