/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.igoweb.go.Game;
import org.igoweb.go.Loc;
import org.igoweb.go.swing.BoardBackground;
import org.igoweb.go.swing.GobanController;
import org.igoweb.go.swing.StoneImages;
import org.igoweb.go.swing.StoneWidget;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.Prefs;

public class GobanWidget
extends JPanel
implements LayoutManager,
ActionListener {
    private Game game;
    private static final String SHOW_COORDS_PREF = "U&Z{<m;*";
    public final JButton passBut = new JButton(Defs.getString(-1337055796));
    private GobanController controller = null;
    private final StoneWidget[][] stones;
    private int imageSize = -1;
    private int xOff;
    private int yOff;
    private int stoneSize = -1;
    private BoardBackground background = null;
    private final EventListener gameListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            if (event.type == 0) {
                Loc loc = (Loc)event.arg;
                GobanWidget.this.stones[loc.x][loc.y].set(GobanWidget.this.game.getColor(loc));
                GobanWidget.this.enablePassBut();
            } else if (event.type == 3 && event.arg.equals(Loc.PASS) || event.type == 2) {
                GobanWidget.this.enablePassBut();
            }
        }
    };
    private final PropertyChangeListener prefsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            GobanWidget.this.propChanged(event.getPropertyName());
        }
    };

    public GobanWidget(Game game) {
        this.passBut.addActionListener(this);
        this.setLayout(this);
        this.setOpaque(false);
        this.game = game;
        int size = game.size;
        this.stones = new StoneWidget[size][size];
        Iterator<Loc> locs = game.allLocs();
        while (locs.hasNext()) {
            Loc loc = locs.next();
            StoneWidget stoneWidget = new StoneWidget(loc, size, game.getColor(loc), (loc.x == 0 ? 8 : (loc.x == size - 1 ? 10 : 9)) + (loc.y == 0 ? 0 : (loc.y == size - 1 ? 6 : 3)));
            this.stones[loc.x][loc.y] = stoneWidget;
            this.add((Component)stoneWidget, 0);
        }
        int[] hoshi = Game.hoshiLines(size);
        for (int i = 0; i < hoshi.length; ++i) {
            for (int j = 0; j < hoshi.length; ++j) {
                this.stones[hoshi[i]][hoshi[j]].setGridType(17);
            }
        }
        this.passBut.setEnabled(false);
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game newGame) {
        if (this.game != null) {
            this.game.removeListener(this.gameListener);
        }
        this.game = newGame;
        if (newGame != null) {
            if (newGame.size != this.stones.length) {
                throw new IllegalArgumentException("Cannot change board size");
            }
            if (this.isDisplayable()) {
                this.syncWithGame();
            }
        }
        if (this.controller != null) {
            this.controller.setGame(newGame);
        }
    }

    public void clearMarks() {
        int size = this.stones.length;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.stones[i][j].clearMark();
            }
        }
    }

    public int getColor(Loc l) {
        return this.stones[l.x][l.y].getColor();
    }

    public int getMark(Loc l) {
        return this.stones[l.x][l.y].getMark();
    }

    public String getLabel(Loc l) {
        return this.stones[l.x][l.y].getLabel();
    }

    public StoneWidget getStoneWidget(Loc l) {
        return this.stones[l.x][l.y];
    }

    public void setMark(Loc loc, int mark) {
        if (loc != Loc.PASS) {
            this.stones[loc.x][loc.y].setMark(mark);
        }
    }

    public final void clearMark(Loc loc) {
        this.stones[loc.x][loc.y].clearMark();
    }

    public final void clearMark(Loc loc, int mark) {
        if (loc != Loc.PASS) {
            this.stones[loc.x][loc.y].clearMark(mark);
        }
    }

    public void setLabel(Loc l, String label) {
        this.stones[l.x][l.y].setLabel(label);
    }

    public void setController(GobanController newController) {
        this.controller = newController;
        for (int x = 0; x < this.stones.length; ++x) {
            for (int y = 0; y < this.stones.length; ++y) {
                this.stones[x][y].setController(newController);
            }
        }
        this.enablePassBut();
    }

    @Override
    public void paint(Graphics g) {
        if (this.background != null) {
            g.drawImage(this.background.image, this.xOff, this.yOff, null);
        }
        super.paint(g);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container cont) {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int totalW = size.width - (insets.left + insets.right);
        int totalH = size.height - (insets.top + insets.bottom);
        this.imageSize = totalW > totalH ? totalH : totalW;
        this.xOff = (totalW - this.imageSize) / 2;
        this.yOff = (totalH - this.imageSize) / 2;
        if (this.background == null || this.background.imageSize != this.imageSize) {
            this.background = this.createBackground(this.imageSize);
        }
        if (this.background == null) {
            return;
        }
        if (this.background.gridW != this.stoneSize) {
            this.stoneSize = this.background.gridW;
        }
        int stoneW = (int)Math.ceil((double)this.stoneSize * (1.0 + StoneImages.shadowOffsetRatio));
        for (int x = 0; x < this.stones.length; ++x) {
            for (int y = 0; y < this.stones.length; ++y) {
                this.stones[x][y].setBounds(this.xOff + this.background.gridOffset + x * this.stoneSize, this.yOff + this.background.gridOffset + y * this.stoneSize, stoneW, stoneW);
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container cont) {
        Insets insets = this.getInsets();
        Dimension size = this.stones[0][0].getMinimumSize();
        int borderSize = 2 * BoardBackground.borderSize(this.stones.length);
        size.width = size.width * this.stones.length + insets.left + insets.right + borderSize;
        size.height = size.height * this.stones.length + insets.top + insets.bottom + borderSize;
        return size;
    }

    @Override
    public Dimension preferredLayoutSize(Container cont) {
        Insets insets = this.getInsets();
        Dimension size = this.stones[0][0].getPreferredSize();
        int borderSize = 2 * BoardBackground.borderSize(this.stones.length);
        size.width = size.width * this.stones.length + insets.left + insets.right + borderSize;
        size.height = size.height * this.stones.length + insets.top + insets.bottom + borderSize;
        return size;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    private BoardBackground createBackground(int newImageSize) {
        return newImageSize > 0 ? BoardBackground.get(this, newImageSize, this.stones.length, Prefs.getBoolean(SHOW_COORDS_PREF, true), Prefs.getBoolean("d][N'B&\"", true)) : null;
    }

    @Override
    public void removeNotify() {
        if (this.game != null) {
            this.game.removeListener(this.gameListener);
        }
        Prefs.removeListener(SHOW_COORDS_PREF, this.prefsListener);
        Prefs.removeListener("d][N'B&\"", this.prefsListener);
        Prefs.removeListener(StoneWidget.SHOW_KO_PREF, this.prefsListener);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        this.syncWithGame();
        Prefs.addListener(SHOW_COORDS_PREF, this.prefsListener);
        Prefs.addListener("d][N'B&\"", this.prefsListener);
        Prefs.addListener(StoneWidget.SHOW_KO_PREF, this.prefsListener);
        super.addNotify();
    }

    public void syncWithGame() {
        if (this.game != null) {
            this.game.addListener(this.gameListener);
            Iterator<Loc> locs = this.game.allLocs();
            while (locs.hasNext()) {
                Loc loc = locs.next();
                this.stones[loc.x][loc.y].set(this.game.getColor(loc));
            }
        }
    }

    public static void setShowBoardCoords(boolean newValue) {
        Prefs.putBoolean(SHOW_COORDS_PREF, newValue);
    }

    public static void setBoardsTextured(boolean newValue) {
        Prefs.putBoolean("d][N'B&\"", newValue);
    }

    public static final boolean getShowBoardCoords() {
        return Prefs.getBoolean(SHOW_COORDS_PREF, true);
    }

    public static final boolean getBoardsTextured() {
        return Prefs.getBoolean("d][N'B&\"", true);
    }

    public static final boolean getKosMarked() {
        return Prefs.getBoolean(StoneWidget.SHOW_KO_PREF, true);
    }

    public static final void setKosMarked(boolean newValue) {
        Prefs.putBoolean(StoneWidget.SHOW_KO_PREF, newValue);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.controller.boardClicked(Loc.PASS, 0, false);
    }

    public void enablePassBut() {
        this.passBut.setEnabled(this.controller != null && this.isEnabled() && this.controller.getCursor(Loc.PASS, 0, false) != 2);
    }

    public final GobanController getController() {
        return this.controller;
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    public void addLabelAccelerator() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(76, 2), SHOW_COORDS_PREF);
        this.getActionMap().put(SHOW_COORDS_PREF, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GobanWidget.setShowBoardCoords(!GobanWidget.getShowBoardCoords());
            }
        });
    }

    private void propChanged(String propName) {
        if (propName.equals(StoneWidget.SHOW_KO_PREF)) {
            this.repaint();
        } else if (this.background != null) {
            this.background = this.createBackground(this.background.imageSize);
            this.layoutContainer(this);
            for (int x = 0; x < this.stones.length; ++x) {
                for (int y = 0; y < this.stones.length; ++y) {
                    this.stones[x][y].clearImages();
                }
            }
            this.repaint();
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        for (int x = 0; x < this.stones.length; ++x) {
            for (int y = 0; y < this.stones.length; ++y) {
                this.stones[x][y].setEnabled(isEnabled);
            }
        }
        this.enablePassBut();
    }

    public BoardBackground getBoardBackground() {
        return this.background;
    }

    public int getXOffset() {
        return this.xOff;
    }

    public int getYOffset() {
        return this.yOff;
    }

    @Override
    public String toString() {
        return "GobanWidget[]";
    }
}

