/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileIterator;

public class JarFileIterator
implements ClassFileIterator {
    private ZipInputStream jarStream;

    public JarFileIterator(InputStream stream) throws IOException {
        this.jarStream = new ZipInputStream(stream);
    }

    private byte[] getEntryBytes(InputStream stream) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        while ((n = stream.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, n);
        }
        return baos.toByteArray();
    }

    public ClassFile getNextClassFile() {
        ClassFile nextElement = null;
        try {
            ZipEntry jarEntry = this.jarStream.getNextEntry();
            while (nextElement == null && jarEntry != null) {
                String entryName = jarEntry.getName();
                if (!jarEntry.isDirectory() && entryName.endsWith(".class")) {
                    ClassFile javaClass = new ClassFile();
                    javaClass.read(this.jarStream);
                    nextElement = javaClass;
                    continue;
                }
                jarEntry = this.jarStream.getNextEntry();
            }
        }
        catch (IOException e) {
            String message = e.getMessage();
            String text = e.getClass().getName();
            if (message != null) {
                text = text + ": " + message;
            }
            throw new RuntimeException("Problem reading JAR file: " + text);
        }
        return nextElement;
    }
}

