<?php

/**
 * BaseScreen
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                              $id                                                    Type: integer, primary key
 * @property string                                           $name                                                  Type: string(100)
 * @property int                                              $module_id                                             Type: integer
 * @property string                                           $action_url                                            Type: string(255)
 * @property Module                                           $Module                                                
 * @property Doctrine_Collection|ScreenPermission[]           $ScreenPermission                                      
 * @property Doctrine_Collection|DataGroup[]                  $DataGroup                                             
 * @property Doctrine_Collection|DataGroupScreenPermission[]  $DataGroupScreenPermission                             
 * @property Doctrine_Collection|MenuItem[]                   $MenuItem                                              
 *  
 * @method int                                                getId()                                                Type: integer, primary key
 * @method string                                             getName()                                              Type: string(100)
 * @method int                                                getModuleId()                                          Type: integer
 * @method string                                             getActionUrl()                                         Type: string(255)
 * @method Module                                             getModule()                                            
 * @method Doctrine_Collection|ScreenPermission[]             getScreenPermission()                                  
 * @method Doctrine_Collection|DataGroup[]                    getDataGroup()                                         
 * @method Doctrine_Collection|DataGroupScreenPermission[]    getDataGroupScreenPermission()                         
 * @method Doctrine_Collection|MenuItem[]                     getMenuItem()                                          
 *  
 * @method Screen                                             setId(int $val)                                        Type: integer, primary key
 * @method Screen                                             setName(string $val)                                   Type: string(100)
 * @method Screen                                             setModuleId(int $val)                                  Type: integer
 * @method Screen                                             setActionUrl(string $val)                              Type: string(255)
 * @method Screen                                             setModule(Module $val)                                 
 * @method Screen                                             setScreenPermission(Doctrine_Collection $val)          
 * @method Screen                                             setDataGroup(Doctrine_Collection $val)                 
 * @method Screen                                             setDataGroupScreenPermission(Doctrine_Collection $val) 
 * @method Screen                                             setMenuItem(Doctrine_Collection $val)                  
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseScreen extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_screen');
        $this->hasColumn('id', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             ));
        $this->hasColumn('name', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('module_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('action_url', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Module', array(
             'local' => 'module_id',
             'foreign' => 'id'));

        $this->hasMany('ScreenPermission', array(
             'local' => 'id',
             'foreign' => 'screen_id'));

        $this->hasMany('DataGroup', array(
             'refClass' => 'DataGroupScreenPermission',
             'local' => 'screen_id',
             'foreign' => 'data_group_id'));

        $this->hasMany('DataGroupScreenPermission', array(
             'local' => 'id',
             'foreign' => 'screen_id'));

        $this->hasMany('MenuItem', array(
             'local' => 'id',
             'foreign' => 'screenId'));
    }
}