/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Storable;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Vector;

public class StorableInput {
    private StreamTokenizer fTokenizer;
    private Vector fMap;

    public StorableInput(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.fTokenizer = new StreamTokenizer(bufferedReader);
        this.fMap = new Vector();
    }

    public Storable readStorable() throws IOException {
        String string = this.readString();
        if (string.equals("NULL")) {
            return null;
        }
        if (string.equals("REF")) {
            int n = this.readInt();
            return this.retrieve(n);
        }
        Storable storable = (Storable)this.makeInstance(string);
        this.map(storable);
        storable.read(this);
        return storable;
    }

    public boolean testForNumber() throws IOException {
        int n = this.fTokenizer.nextToken();
        this.fTokenizer.pushBack();
        return n == -2;
    }

    public String readString() throws IOException {
        int n = this.fTokenizer.nextToken();
        if (n == -3 || n == 34) {
            return this.fTokenizer.sval;
        }
        String string = "String expected in line: " + this.fTokenizer.lineno();
        throw new IOException(string);
    }

    public int readInt() throws IOException {
        int n = this.fTokenizer.nextToken();
        if (n == -2) {
            return (int)this.fTokenizer.nval;
        }
        String string = "Integer expected in line: " + this.fTokenizer.lineno();
        throw new IOException(string);
    }

    public Color readColor() throws IOException {
        return new Color(this.readInt(), this.readInt(), this.readInt());
    }

    public double readDouble() throws IOException {
        int n = this.fTokenizer.nextToken();
        if (n == -2) {
            return this.fTokenizer.nval;
        }
        String string = "Double expected in line: " + this.fTokenizer.lineno();
        throw new IOException(string);
    }

    public boolean readBoolean() throws IOException {
        int n = this.fTokenizer.nextToken();
        if (n == -2) {
            return (int)this.fTokenizer.nval == 1;
        }
        String string = "Integer expected in line: " + this.fTokenizer.lineno();
        throw new IOException(string);
    }

    private Object makeInstance(String string) throws IOException {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.newInstance();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new IOException("Class " + string + " does not seem to have a no-arg constructor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("No class: " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Cannot instantiate: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Class (" + string + ") not accessible");
        }
    }

    private void map(Storable storable) {
        if (!this.fMap.contains(storable)) {
            this.fMap.addElement(storable);
        }
    }

    private Storable retrieve(int n) {
        return (Storable)this.fMap.elementAt(n);
    }
}

