/* Generated by wayland-scanner 1.23.0 */

#ifndef XDG_SHELL_ENUM_PROTOCOL_H
#define XDG_SHELL_ENUM_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef XDG_WM_BASE_ERROR_ENUM
#define XDG_WM_BASE_ERROR_ENUM
enum xdg_wm_base_error {
	/**
	 * given wl_surface has another role
	 */
	XDG_WM_BASE_ERROR_ROLE = 0,
	/**
	 * xdg_wm_base was destroyed before children
	 */
	XDG_WM_BASE_ERROR_DEFUNCT_SURFACES = 1,
	/**
	 * the client tried to map or destroy a non-topmost popup
	 */
	XDG_WM_BASE_ERROR_NOT_THE_TOPMOST_POPUP = 2,
	/**
	 * the client specified an invalid popup parent surface
	 */
	XDG_WM_BASE_ERROR_INVALID_POPUP_PARENT = 3,
	/**
	 * the client provided an invalid surface state
	 */
	XDG_WM_BASE_ERROR_INVALID_SURFACE_STATE = 4,
	/**
	 * the client provided an invalid positioner
	 */
	XDG_WM_BASE_ERROR_INVALID_POSITIONER = 5,
	/**
	 * the client didn’t respond to a ping event in time
	 */
	XDG_WM_BASE_ERROR_UNRESPONSIVE = 6,
};
#endif /* XDG_WM_BASE_ERROR_ENUM */

#ifndef XDG_POSITIONER_ERROR_ENUM
#define XDG_POSITIONER_ERROR_ENUM
enum xdg_positioner_error {
	/**
	 * invalid input provided
	 */
	XDG_POSITIONER_ERROR_INVALID_INPUT = 0,
};
#endif /* XDG_POSITIONER_ERROR_ENUM */

#ifndef XDG_POSITIONER_ANCHOR_ENUM
#define XDG_POSITIONER_ANCHOR_ENUM
enum xdg_positioner_anchor {
	XDG_POSITIONER_ANCHOR_NONE = 0,
	XDG_POSITIONER_ANCHOR_TOP = 1,
	XDG_POSITIONER_ANCHOR_BOTTOM = 2,
	XDG_POSITIONER_ANCHOR_LEFT = 3,
	XDG_POSITIONER_ANCHOR_RIGHT = 4,
	XDG_POSITIONER_ANCHOR_TOP_LEFT = 5,
	XDG_POSITIONER_ANCHOR_BOTTOM_LEFT = 6,
	XDG_POSITIONER_ANCHOR_TOP_RIGHT = 7,
	XDG_POSITIONER_ANCHOR_BOTTOM_RIGHT = 8,
};
#endif /* XDG_POSITIONER_ANCHOR_ENUM */

#ifndef XDG_POSITIONER_GRAVITY_ENUM
#define XDG_POSITIONER_GRAVITY_ENUM
enum xdg_positioner_gravity {
	XDG_POSITIONER_GRAVITY_NONE = 0,
	XDG_POSITIONER_GRAVITY_TOP = 1,
	XDG_POSITIONER_GRAVITY_BOTTOM = 2,
	XDG_POSITIONER_GRAVITY_LEFT = 3,
	XDG_POSITIONER_GRAVITY_RIGHT = 4,
	XDG_POSITIONER_GRAVITY_TOP_LEFT = 5,
	XDG_POSITIONER_GRAVITY_BOTTOM_LEFT = 6,
	XDG_POSITIONER_GRAVITY_TOP_RIGHT = 7,
	XDG_POSITIONER_GRAVITY_BOTTOM_RIGHT = 8,
};
#endif /* XDG_POSITIONER_GRAVITY_ENUM */

#ifndef XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_ENUM
#define XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_ENUM
/**
 * @ingroup iface_xdg_positioner
 * constraint adjustments
 *
 * The constraint adjustment value define ways the compositor will adjust
 * the position of the surface, if the unadjusted position would result
 * in the surface being partly constrained.
 *
 * Whether a surface is considered 'constrained' is left to the compositor
 * to determine. For example, the surface may be partly outside the
 * compositor's defined 'work area', thus necessitating the child surface's
 * position be adjusted until it is entirely inside the work area.
 *
 * The adjustments can be combined, according to a defined precedence: 1)
 * Flip, 2) Slide, 3) Resize.
 */
enum xdg_positioner_constraint_adjustment {
	/**
	 * don't move the child surface when constrained
	 *
	 * Don't alter the surface position even if it is constrained on
	 * some axis, for example partially outside the edge of an output.
	 */
	XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_NONE = 0,
	/**
	 * move along the x axis until unconstrained
	 *
	 * Slide the surface along the x axis until it is no longer
	 * constrained.
	 *
	 * First try to slide towards the direction of the gravity on the x
	 * axis until either the edge in the opposite direction of the
	 * gravity is unconstrained or the edge in the direction of the
	 * gravity is constrained.
	 *
	 * Then try to slide towards the opposite direction of the gravity
	 * on the x axis until either the edge in the direction of the
	 * gravity is unconstrained or the edge in the opposite direction
	 * of the gravity is constrained.
	 */
	XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_SLIDE_X = 1,
	/**
	 * move along the y axis until unconstrained
	 *
	 * Slide the surface along the y axis until it is no longer
	 * constrained.
	 *
	 * First try to slide towards the direction of the gravity on the y
	 * axis until either the edge in the opposite direction of the
	 * gravity is unconstrained or the edge in the direction of the
	 * gravity is constrained.
	 *
	 * Then try to slide towards the opposite direction of the gravity
	 * on the y axis until either the edge in the direction of the
	 * gravity is unconstrained or the edge in the opposite direction
	 * of the gravity is constrained.
	 */
	XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_SLIDE_Y = 2,
	/**
	 * invert the anchor and gravity on the x axis
	 *
	 * Invert the anchor and gravity on the x axis if the surface is
	 * constrained on the x axis. For example, if the left edge of the
	 * surface is constrained, the gravity is 'left' and the anchor is
	 * 'left', change the gravity to 'right' and the anchor to 'right'.
	 *
	 * If the adjusted position also ends up being constrained, the
	 * resulting position of the flip_x adjustment will be the one
	 * before the adjustment.
	 */
	XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_FLIP_X = 4,
	/**
	 * invert the anchor and gravity on the y axis
	 *
	 * Invert the anchor and gravity on the y axis if the surface is
	 * constrained on the y axis. For example, if the bottom edge of
	 * the surface is constrained, the gravity is 'bottom' and the
	 * anchor is 'bottom', change the gravity to 'top' and the anchor
	 * to 'top'.
	 *
	 * The adjusted position is calculated given the original anchor
	 * rectangle and offset, but with the new flipped anchor and
	 * gravity values.
	 *
	 * If the adjusted position also ends up being constrained, the
	 * resulting position of the flip_y adjustment will be the one
	 * before the adjustment.
	 */
	XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_FLIP_Y = 8,
	/**
	 * horizontally resize the surface
	 *
	 * Resize the surface horizontally so that it is completely
	 * unconstrained.
	 */
	XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_RESIZE_X = 16,
	/**
	 * vertically resize the surface
	 *
	 * Resize the surface vertically so that it is completely
	 * unconstrained.
	 */
	XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_RESIZE_Y = 32,
};
#endif /* XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_ENUM */

#ifndef XDG_SURFACE_ERROR_ENUM
#define XDG_SURFACE_ERROR_ENUM
enum xdg_surface_error {
	/**
	 * Surface was not fully constructed
	 */
	XDG_SURFACE_ERROR_NOT_CONSTRUCTED = 1,
	/**
	 * Surface was already constructed
	 */
	XDG_SURFACE_ERROR_ALREADY_CONSTRUCTED = 2,
	/**
	 * Attaching a buffer to an unconfigured surface
	 */
	XDG_SURFACE_ERROR_UNCONFIGURED_BUFFER = 3,
	/**
	 * Invalid serial number when acking a configure event
	 */
	XDG_SURFACE_ERROR_INVALID_SERIAL = 4,
	/**
	 * Width or height was zero or negative
	 */
	XDG_SURFACE_ERROR_INVALID_SIZE = 5,
	/**
	 * Surface was destroyed before its role object
	 */
	XDG_SURFACE_ERROR_DEFUNCT_ROLE_OBJECT = 6,
};
#endif /* XDG_SURFACE_ERROR_ENUM */

#ifndef XDG_TOPLEVEL_ERROR_ENUM
#define XDG_TOPLEVEL_ERROR_ENUM
enum xdg_toplevel_error {
	/**
	 * provided value is         not a valid variant of the resize_edge enum
	 */
	XDG_TOPLEVEL_ERROR_INVALID_RESIZE_EDGE = 0,
	/**
	 * invalid parent toplevel
	 */
	XDG_TOPLEVEL_ERROR_INVALID_PARENT = 1,
	/**
	 * client provided an invalid min or max size
	 */
	XDG_TOPLEVEL_ERROR_INVALID_SIZE = 2,
};
#endif /* XDG_TOPLEVEL_ERROR_ENUM */

#ifndef XDG_TOPLEVEL_RESIZE_EDGE_ENUM
#define XDG_TOPLEVEL_RESIZE_EDGE_ENUM
/**
 * @ingroup iface_xdg_toplevel
 * edge values for resizing
 *
 * These values are used to indicate which edge of a surface
 * is being dragged in a resize operation.
 */
enum xdg_toplevel_resize_edge {
	XDG_TOPLEVEL_RESIZE_EDGE_NONE = 0,
	XDG_TOPLEVEL_RESIZE_EDGE_TOP = 1,
	XDG_TOPLEVEL_RESIZE_EDGE_BOTTOM = 2,
	XDG_TOPLEVEL_RESIZE_EDGE_LEFT = 4,
	XDG_TOPLEVEL_RESIZE_EDGE_TOP_LEFT = 5,
	XDG_TOPLEVEL_RESIZE_EDGE_BOTTOM_LEFT = 6,
	XDG_TOPLEVEL_RESIZE_EDGE_RIGHT = 8,
	XDG_TOPLEVEL_RESIZE_EDGE_TOP_RIGHT = 9,
	XDG_TOPLEVEL_RESIZE_EDGE_BOTTOM_RIGHT = 10,
};
#endif /* XDG_TOPLEVEL_RESIZE_EDGE_ENUM */

#ifndef XDG_TOPLEVEL_STATE_ENUM
#define XDG_TOPLEVEL_STATE_ENUM
/**
 * @ingroup iface_xdg_toplevel
 * types of state on the surface
 *
 * The different state values used on the surface. This is designed for
 * state values like maximized, fullscreen. It is paired with the
 * configure event to ensure that both the client and the compositor
 * setting the state can be synchronized.
 *
 * States set in this way are double-buffered, see wl_surface.commit.
 */
enum xdg_toplevel_state {
	/**
	 * the surface is maximized
	 * the surface is maximized
	 *
	 * The surface is maximized. The window geometry specified in the
	 * configure event must be obeyed by the client, or the
	 * xdg_wm_base.invalid_surface_state error is raised.
	 *
	 * The client should draw without shadow or other decoration
	 * outside of the window geometry.
	 */
	XDG_TOPLEVEL_STATE_MAXIMIZED = 1,
	/**
	 * the surface is fullscreen
	 * the surface is fullscreen
	 *
	 * The surface is fullscreen. The window geometry specified in
	 * the configure event is a maximum; the client cannot resize
	 * beyond it. For a surface to cover the whole fullscreened area,
	 * the geometry dimensions must be obeyed by the client. For more
	 * details, see xdg_toplevel.set_fullscreen.
	 */
	XDG_TOPLEVEL_STATE_FULLSCREEN = 2,
	/**
	 * the surface is being resized
	 * the surface is being resized
	 *
	 * The surface is being resized. The window geometry specified in
	 * the configure event is a maximum; the client cannot resize
	 * beyond it. Clients that have aspect ratio or cell sizing
	 * configuration can use a smaller size, however.
	 */
	XDG_TOPLEVEL_STATE_RESIZING = 3,
	/**
	 * the surface is now activated
	 * the surface is now activated
	 *
	 * Client window decorations should be painted as if the window
	 * is active. Do not assume this means that the window actually has
	 * keyboard or pointer focus.
	 */
	XDG_TOPLEVEL_STATE_ACTIVATED = 4,
	/**
	 * the surface’s left edge is tiled
	 *
	 * The window is currently in a tiled layout and the left edge is
	 * considered to be adjacent to another part of the tiling grid.
	 *
	 * The client should draw without shadow or other decoration
	 * outside of the window geometry on the left edge.
	 * @since 2
	 */
	XDG_TOPLEVEL_STATE_TILED_LEFT = 5,
	/**
	 * the surface’s right edge is tiled
	 *
	 * The window is currently in a tiled layout and the right edge
	 * is considered to be adjacent to another part of the tiling grid.
	 *
	 * The client should draw without shadow or other decoration
	 * outside of the window geometry on the right edge.
	 * @since 2
	 */
	XDG_TOPLEVEL_STATE_TILED_RIGHT = 6,
	/**
	 * the surface’s top edge is tiled
	 *
	 * The window is currently in a tiled layout and the top edge is
	 * considered to be adjacent to another part of the tiling grid.
	 *
	 * The client should draw without shadow or other decoration
	 * outside of the window geometry on the top edge.
	 * @since 2
	 */
	XDG_TOPLEVEL_STATE_TILED_TOP = 7,
	/**
	 * the surface’s bottom edge is tiled
	 *
	 * The window is currently in a tiled layout and the bottom edge
	 * is considered to be adjacent to another part of the tiling grid.
	 *
	 * The client should draw without shadow or other decoration
	 * outside of the window geometry on the bottom edge.
	 * @since 2
	 */
	XDG_TOPLEVEL_STATE_TILED_BOTTOM = 8,
	/**
	 * surface repaint is suspended
	 *
	 * The surface is currently not ordinarily being repainted; for
	 * example because its content is occluded by another window, or
	 * its outputs are switched off due to screen locking.
	 * @since 6
	 */
	XDG_TOPLEVEL_STATE_SUSPENDED = 9,
	/**
	 * the surface’s left edge is constrained
	 *
	 * The left edge of the window is currently constrained, meaning
	 * it shouldn't attempt to resize from that edge. It can for
	 * example mean it's tiled next to a monitor edge on the
	 * constrained side of the window.
	 * @since 7
	 */
	XDG_TOPLEVEL_STATE_CONSTRAINED_LEFT = 10,
	/**
	 * the surface’s right edge is constrained
	 *
	 * The right edge of the window is currently constrained, meaning
	 * it shouldn't attempt to resize from that edge. It can for
	 * example mean it's tiled next to a monitor edge on the
	 * constrained side of the window.
	 * @since 7
	 */
	XDG_TOPLEVEL_STATE_CONSTRAINED_RIGHT = 11,
	/**
	 * the surface’s top edge is constrained
	 *
	 * The top edge of the window is currently constrained, meaning
	 * it shouldn't attempt to resize from that edge. It can for
	 * example mean it's tiled next to a monitor edge on the
	 * constrained side of the window.
	 * @since 7
	 */
	XDG_TOPLEVEL_STATE_CONSTRAINED_TOP = 12,
	/**
	 * the surface’s bottom edge is tiled
	 *
	 * The bottom edge of the window is currently constrained,
	 * meaning it shouldn't attempt to resize from that edge. It can
	 * for example mean it's tiled next to a monitor edge on the
	 * constrained side of the window.
	 * @since 7
	 */
	XDG_TOPLEVEL_STATE_CONSTRAINED_BOTTOM = 13,
};
/**
 * @ingroup iface_xdg_toplevel
 */
#define XDG_TOPLEVEL_STATE_TILED_LEFT_SINCE_VERSION 2
/**
 * @ingroup iface_xdg_toplevel
 */
#define XDG_TOPLEVEL_STATE_TILED_RIGHT_SINCE_VERSION 2
/**
 * @ingroup iface_xdg_toplevel
 */
#define XDG_TOPLEVEL_STATE_TILED_TOP_SINCE_VERSION 2
/**
 * @ingroup iface_xdg_toplevel
 */
#define XDG_TOPLEVEL_STATE_TILED_BOTTOM_SINCE_VERSION 2
/**
 * @ingroup iface_xdg_toplevel
 */
#define XDG_TOPLEVEL_STATE_SUSPENDED_SINCE_VERSION 6
/**
 * @ingroup iface_xdg_toplevel
 */
#define XDG_TOPLEVEL_STATE_CONSTRAINED_LEFT_SINCE_VERSION 7
/**
 * @ingroup iface_xdg_toplevel
 */
#define XDG_TOPLEVEL_STATE_CONSTRAINED_RIGHT_SINCE_VERSION 7
/**
 * @ingroup iface_xdg_toplevel
 */
#define XDG_TOPLEVEL_STATE_CONSTRAINED_TOP_SINCE_VERSION 7
/**
 * @ingroup iface_xdg_toplevel
 */
#define XDG_TOPLEVEL_STATE_CONSTRAINED_BOTTOM_SINCE_VERSION 7
#endif /* XDG_TOPLEVEL_STATE_ENUM */

#ifndef XDG_TOPLEVEL_WM_CAPABILITIES_ENUM
#define XDG_TOPLEVEL_WM_CAPABILITIES_ENUM
enum xdg_toplevel_wm_capabilities {
	/**
	 * show_window_menu is available
	 */
	XDG_TOPLEVEL_WM_CAPABILITIES_WINDOW_MENU = 1,
	/**
	 * set_maximized and unset_maximized are available
	 */
	XDG_TOPLEVEL_WM_CAPABILITIES_MAXIMIZE = 2,
	/**
	 * set_fullscreen and unset_fullscreen are available
	 */
	XDG_TOPLEVEL_WM_CAPABILITIES_FULLSCREEN = 3,
	/**
	 * set_minimized is available
	 */
	XDG_TOPLEVEL_WM_CAPABILITIES_MINIMIZE = 4,
};
#endif /* XDG_TOPLEVEL_WM_CAPABILITIES_ENUM */

#ifndef XDG_POPUP_ERROR_ENUM
#define XDG_POPUP_ERROR_ENUM
enum xdg_popup_error {
	/**
	 * tried to grab after being mapped
	 */
	XDG_POPUP_ERROR_INVALID_GRAB = 0,
};
#endif /* XDG_POPUP_ERROR_ENUM */

#ifdef  __cplusplus
}
#endif

#endif
