require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UFS_EXT2FS_EXT2FS_H_)) {
    eval 'sub _UFS_EXT2FS_EXT2FS_H_ () {1;}' unless defined(&_UFS_EXT2FS_EXT2FS_H_);
    require 'sys/bswap.ph';
    eval 'sub BBSIZE () {1024;}' unless defined(&BBSIZE);
    eval 'sub SBSIZE () {1024;}' unless defined(&SBSIZE);
    eval 'sub BBOFF () {(( &off_t)(0));}' unless defined(&BBOFF);
    eval 'sub SBOFF () {(( &off_t)( &BBOFF +  &BBSIZE));}' unless defined(&SBOFF);
    eval 'sub BBLOCK () {(( &daddr_t)(0));}' unless defined(&BBLOCK);
    eval 'sub SBLOCK () {(( &daddr_t)( &BBLOCK +  &BBSIZE /  &DEV_BSIZE));}' unless defined(&SBLOCK);
    eval 'sub fsbtodb {
        my($fs, $b) = @_;
	    eval q((( &daddr_t)($b) << ($fs)-> &e2fs_fsbtodb));
    }' unless defined(&fsbtodb);
    eval 'sub lblkno {
        my($fs, $loc) = @_;
	    eval q((($loc) >> ( ($fs->{e2fs_bshift}))));
    }' unless defined(&lblkno);
    eval 'sub blksize {
        my($fs, $ip, $lbn) = @_;
	    eval q((($fs)-> &e2fs_bsize));
    }' unless defined(&blksize);
    eval 'sub LOG_MINBSIZE () {10;}' unless defined(&LOG_MINBSIZE);
    eval 'sub MINBSIZE () {(1<<  &LOG_MINBSIZE);}' unless defined(&MINBSIZE);
    eval 'sub MAXMNTLEN () {512;}' unless defined(&MAXMNTLEN);
    eval 'sub MINFREE () {5;}' unless defined(&MINFREE);
    eval 'sub EXT2FS_LINK_MAX () {65000;}' unless defined(&EXT2FS_LINK_MAX);
    eval 'sub EXT2FS_LINK_INF () {1;}' unless defined(&EXT2FS_LINK_INF);
    eval 'sub E2FS_MAGIC () {0xef53;}' unless defined(&E2FS_MAGIC);
    eval 'sub E2FS_REV0 () {0;}' unless defined(&E2FS_REV0);
    eval 'sub E2FS_REV1 () {1;}' unless defined(&E2FS_REV1);
    eval 'sub EXT2F_COMPAT_PREALLOC () {0x1;}' unless defined(&EXT2F_COMPAT_PREALLOC);
    eval 'sub EXT2F_COMPAT_AFS () {0x2;}' unless defined(&EXT2F_COMPAT_AFS);
    eval 'sub EXT2F_COMPAT_HASJOURNAL () {0x4;}' unless defined(&EXT2F_COMPAT_HASJOURNAL);
    eval 'sub EXT2F_COMPAT_EXTATTR () {0x8;}' unless defined(&EXT2F_COMPAT_EXTATTR);
    eval 'sub EXT2F_COMPAT_RESIZE () {0x10;}' unless defined(&EXT2F_COMPAT_RESIZE);
    eval 'sub EXT2F_COMPAT_DIRHASHINDEX () {0x20;}' unless defined(&EXT2F_COMPAT_DIRHASHINDEX);
    eval 'sub EXT2F_COMPAT_SPARSESUPER2 () {0x200;}' unless defined(&EXT2F_COMPAT_SPARSESUPER2);
    eval 'sub EXT2F_COMPAT_BITS () {"\\20" "\\12COMPAT_SPARSESUPER2" "\\11" "\\10" "\\07" "\\06COMPAT_DIRHASHINDEX" "\\05COMPAT_RESIZE" "\\04COMPAT_EXTATTR" "\\03COMPAT_HASJOURNAL" "\\02COMPAT_AFS" "\\01COMPAT_PREALLOC";}' unless defined(&EXT2F_COMPAT_BITS);
    eval 'sub EXT2F_ROCOMPAT_SPARSESUPER () {0x1;}' unless defined(&EXT2F_ROCOMPAT_SPARSESUPER);
    eval 'sub EXT2F_ROCOMPAT_LARGEFILE () {0x2;}' unless defined(&EXT2F_ROCOMPAT_LARGEFILE);
    eval 'sub EXT2F_ROCOMPAT_BTREE_DIR () {0x4;}' unless defined(&EXT2F_ROCOMPAT_BTREE_DIR);
    eval 'sub EXT2F_ROCOMPAT_HUGE_FILE () {0x8;}' unless defined(&EXT2F_ROCOMPAT_HUGE_FILE);
    eval 'sub EXT2F_ROCOMPAT_GDT_CSUM () {0x10;}' unless defined(&EXT2F_ROCOMPAT_GDT_CSUM);
    eval 'sub EXT2F_ROCOMPAT_DIR_NLINK () {0x20;}' unless defined(&EXT2F_ROCOMPAT_DIR_NLINK);
    eval 'sub EXT2F_ROCOMPAT_EXTRA_ISIZE () {0x40;}' unless defined(&EXT2F_ROCOMPAT_EXTRA_ISIZE);
    eval 'sub EXT2F_ROCOMPAT_QUOTA () {0x100;}' unless defined(&EXT2F_ROCOMPAT_QUOTA);
    eval 'sub EXT2F_ROCOMPAT_BIGALLOC () {0x200;}' unless defined(&EXT2F_ROCOMPAT_BIGALLOC);
    eval 'sub EXT2F_ROCOMPAT_METADATA_CKSUM () {0x400;}' unless defined(&EXT2F_ROCOMPAT_METADATA_CKSUM);
    eval 'sub EXT2F_ROCOMPAT_READONLY () {0x1000;}' unless defined(&EXT2F_ROCOMPAT_READONLY);
    eval 'sub EXT2F_ROCOMPAT_PROJECT () {0x2000;}' unless defined(&EXT2F_ROCOMPAT_PROJECT);
    eval 'sub EXT2F_ROCOMPAT_BITS () {"\\20" "\\16ROCOMPAT_PROJECT" "\\15ROCOMPAT_READONLY" "\\14?" "\\13ROCOMPAT_METADATA_CKSUM" "\\12ROCOMPAT_BIGALLOC" "\\11ROCOMPAT_QUOTA" "\\10?" "\\07ROCOMPAT_EXTRA_ISIZE" "\\06ROCOMPAT_DIR_NLINK" "\\05ROCOMPAT_GDT_CSUM" "\\04ROCOMPAT_HUGE_FILE" "\\03ROCOMPAT_BTREE_DIR" "\\02ROCOMPAT_LARGEFILE" "\\01ROCOMPAT_SPARSESUPER";}' unless defined(&EXT2F_ROCOMPAT_BITS);
    eval 'sub EXT2F_INCOMPAT_COMP () {0x1;}' unless defined(&EXT2F_INCOMPAT_COMP);
    eval 'sub EXT2F_INCOMPAT_FTYPE () {0x2;}' unless defined(&EXT2F_INCOMPAT_FTYPE);
    eval 'sub EXT2F_INCOMPAT_REPLAY_JOURNAL () {0x4;}' unless defined(&EXT2F_INCOMPAT_REPLAY_JOURNAL);
    eval 'sub EXT2F_INCOMPAT_USES_JOURNAL () {0x8;}' unless defined(&EXT2F_INCOMPAT_USES_JOURNAL);
    eval 'sub EXT2F_INCOMPAT_META_BG () {0x10;}' unless defined(&EXT2F_INCOMPAT_META_BG);
    eval 'sub EXT2F_INCOMPAT_EXTENTS () {0x40;}' unless defined(&EXT2F_INCOMPAT_EXTENTS);
    eval 'sub EXT2F_INCOMPAT_64BIT () {0x80;}' unless defined(&EXT2F_INCOMPAT_64BIT);
    eval 'sub EXT2F_INCOMPAT_MMP () {0x100;}' unless defined(&EXT2F_INCOMPAT_MMP);
    eval 'sub EXT2F_INCOMPAT_FLEX_BG () {0x200;}' unless defined(&EXT2F_INCOMPAT_FLEX_BG);
    eval 'sub EXT2F_INCOMPAT_EA_INODE () {0x400;}' unless defined(&EXT2F_INCOMPAT_EA_INODE);
    eval 'sub EXT2F_INCOMPAT_DIRDATA () {0x1000;}' unless defined(&EXT2F_INCOMPAT_DIRDATA);
    eval 'sub EXT2F_INCOMPAT_CSUM_SEED () {0x2000;}' unless defined(&EXT2F_INCOMPAT_CSUM_SEED);
    eval 'sub EXT2F_INCOMPAT_LARGEDIR () {0x4000;}' unless defined(&EXT2F_INCOMPAT_LARGEDIR);
    eval 'sub EXT2F_INCOMPAT_INLINE_DATA () {0x8000;}' unless defined(&EXT2F_INCOMPAT_INLINE_DATA);
    eval 'sub EXT2F_INCOMPAT_ENCRYPT () {0x10000;}' unless defined(&EXT2F_INCOMPAT_ENCRYPT);
    eval 'sub EXT2F_INCOMPAT_BITS () {"\\20" "\\021INCOMPAT_ENCRYPT" "\\020INCOMPAT_INLINE_DATA" "\\017INCOMPAT_LARGEDIR" "\\016INCOMPAT_CSUM_SEED" "\\015INCOMPAT_DIRDATA" "\\014?" "\\013INCOMPAT_EA_INODE" "\\012INCOMPAT_FLEX_BG" "\\011INCOMPAT_MMP" "\\010INCOMPAT_64BIT" "\\07INCOMPAT_EXTENTS" "\\05INCOMPAT_META_BG" "\\04INCOMPAT_USES_JOURNAL" "\\03INCOMPAT_REPLAY_JOURNAL" "\\02INCOMPAT_FTYPE" "\\01INCOMPAT_COMP";}' unless defined(&EXT2F_INCOMPAT_BITS);
    eval 'sub EXT2F_COMPAT_SUPP () {0x;}' unless defined(&EXT2F_COMPAT_SUPP);
    eval 'sub EXT2F_ROCOMPAT_SUPP () {( &EXT2F_ROCOMPAT_SPARSESUPER |  &EXT2F_ROCOMPAT_LARGEFILE |  &EXT2F_ROCOMPAT_HUGE_FILE |  &EXT2F_ROCOMPAT_EXTRA_ISIZE |  &EXT2F_ROCOMPAT_DIR_NLINK |  &EXT2F_ROCOMPAT_GDT_CSUM);}' unless defined(&EXT2F_ROCOMPAT_SUPP);
    eval 'sub EXT2F_INCOMPAT_SUPP () {( &EXT2F_INCOMPAT_FTYPE |  &EXT2F_INCOMPAT_EXTENTS |  &EXT2F_INCOMPAT_FLEX_BG |  &EXT2F_INCOMPAT_64BIT);}' unless defined(&EXT2F_INCOMPAT_SUPP);
    eval 'sub EXT2F_HAS_COMPAT_FEATURE {
        my($fs, $feature) = @_;
	    eval q((($fs)-> ($e2fs->{e2fs_rev}) >=  &E2FS_REV1  && (($fs)-> ($e2fs->{e2fs_features_compat}) & ($feature)) != 0));
    }' unless defined(&EXT2F_HAS_COMPAT_FEATURE);
    eval 'sub EXT2F_HAS_ROCOMPAT_FEATURE {
        my($fs, $feature) = @_;
	    eval q((($fs)-> ($e2fs->{e2fs_rev}) >=  &E2FS_REV1  && (($fs)-> ($e2fs->{e2fs_features_rocompat}) & ($feature)) != 0));
    }' unless defined(&EXT2F_HAS_ROCOMPAT_FEATURE);
    eval 'sub EXT2F_HAS_INCOMPAT_FEATURE {
        my($fs, $feature) = @_;
	    eval q((($fs)-> ($e2fs->{e2fs_rev}) >=  &E2FS_REV1  && (($fs)-> ($e2fs->{e2fs_features_incompat}) & ($feature)) != 0));
    }' unless defined(&EXT2F_HAS_INCOMPAT_FEATURE);
    eval 'sub E2FS_BEH_CONTINUE () {1;}' unless defined(&E2FS_BEH_CONTINUE);
    eval 'sub E2FS_BEH_READONLY () {2;}' unless defined(&E2FS_BEH_READONLY);
    eval 'sub E2FS_BEH_PANIC () {3;}' unless defined(&E2FS_BEH_PANIC);
    eval 'sub E2FS_BEH_DEFAULT () { &E2FS_BEH_CONTINUE;}' unless defined(&E2FS_BEH_DEFAULT);
    eval 'sub E2FS_OS_LINUX () {0;}' unless defined(&E2FS_OS_LINUX);
    eval 'sub E2FS_OS_HURD () {1;}' unless defined(&E2FS_OS_HURD);
    eval 'sub E2FS_OS_MASIX () {2;}' unless defined(&E2FS_OS_MASIX);
    eval 'sub E2FS_OS_FREEBSD () {3;}' unless defined(&E2FS_OS_FREEBSD);
    eval 'sub E2FS_OS_LITES () {4;}' unless defined(&E2FS_OS_LITES);
    eval 'sub E2FS_ISCLEAN () {0x1;}' unless defined(&E2FS_ISCLEAN);
    eval 'sub E2FS_ERRORS () {0x2;}' unless defined(&E2FS_ERRORS);
    eval 'sub E2FS_REV0_GD_SIZE () {($sizeof{\'struct ext2_gd\'} / 2);}' unless defined(&E2FS_REV0_GD_SIZE);
    eval 'sub E2FS_BG_INODE_UNINIT () {0x1;}' unless defined(&E2FS_BG_INODE_UNINIT);
    eval 'sub E2FS_BG_BLOCK_UNINIT () {0x2;}' unless defined(&E2FS_BG_BLOCK_UNINIT);
    eval 'sub E2FS_BG_INODE_ZEROED () {0x4;}' unless defined(&E2FS_BG_INODE_ZEROED);
    eval 'sub E2FS_HAS_GD_CSUM {
        my($fs) = @_;
	    eval q( &EXT2F_HAS_ROCOMPAT_FEATURE($fs,  &EXT2F_ROCOMPAT_GDT_CSUM| &EXT2F_ROCOMPAT_METADATA_CKSUM) != 0);
    }' unless defined(&E2FS_HAS_GD_CSUM);
    eval 'sub cg_has_sb {
        my($i) = @_;
	    eval q({ \'int\'  &a3,  &a5,  &a7;  &if ($i == 0|| $i == 1) 1;  &for ( &a3 = 3,  &a5 = 5,  &a7 = 7;  &a3 <= $i ||  &a5 <= $i ||  &a7 <= $i;  &a3 *= 3,  &a5 *= 5,  &a7 *= 7)  &if ($i ==  &a3 || $i ==  &a5 || $i ==  &a7) 1; 0; });
    }' unless defined(&cg_has_sb);
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
	eval 'sub h2fs16 {
	    my($x) = @_;
    	    eval q(($x));
	}' unless defined(&h2fs16);
	eval 'sub h2fs32 {
	    my($x) = @_;
    	    eval q(($x));
	}' unless defined(&h2fs32);
	eval 'sub h2fs64 {
	    my($x) = @_;
    	    eval q(($x));
	}' unless defined(&h2fs64);
	eval 'sub fs2h16 {
	    my($x) = @_;
    	    eval q(($x));
	}' unless defined(&fs2h16);
	eval 'sub fs2h32 {
	    my($x) = @_;
    	    eval q(($x));
	}' unless defined(&fs2h32);
	eval 'sub fs2h64 {
	    my($x) = @_;
    	    eval q(($x));
	}' unless defined(&fs2h64);
	eval 'sub e2fs_sbload {
	    my($old, $new) = @_;
    	    eval q( &memcpy(($new), ($old),  &SBSIZE));
	}' unless defined(&e2fs_sbload);
	eval 'sub e2fs_sbsave {
	    my($old, $new) = @_;
    	    eval q( &memcpy(($new), ($old),  &SBSIZE));
	}' unless defined(&e2fs_sbsave);
    } else {
	eval 'sub h2fs16 {
	    my($x) = @_;
    	    eval q( &bswap16($x));
	}' unless defined(&h2fs16);
	eval 'sub h2fs32 {
	    my($x) = @_;
    	    eval q( &bswap32($x));
	}' unless defined(&h2fs32);
	eval 'sub h2fs64 {
	    my($x) = @_;
    	    eval q( &bswap64($x));
	}' unless defined(&h2fs64);
	eval 'sub fs2h16 {
	    my($x) = @_;
    	    eval q( &bswap16($x));
	}' unless defined(&fs2h16);
	eval 'sub fs2h32 {
	    my($x) = @_;
    	    eval q( &bswap32($x));
	}' unless defined(&fs2h32);
	eval 'sub fs2h64 {
	    my($x) = @_;
    	    eval q( &bswap64($x));
	}' unless defined(&fs2h64);
	eval 'sub e2fs_sbload {
	    my($old, $new) = @_;
    	    eval q( &e2fs_sb_bswap(($old), ($new)));
	}' unless defined(&e2fs_sbload);
	eval 'sub e2fs_sbsave {
	    my($old, $new) = @_;
    	    eval q( &e2fs_sb_bswap(($old), ($new)));
	}' unless defined(&e2fs_sbsave);
    }
    unless(defined(&_KERNEL)) {
	eval 'sub e2fs_cgload {
	    my($old, $new, $size) = @_;
    	    eval q( &memcpy(($new), ($old), ($size)));
	}' unless defined(&e2fs_cgload);
	eval 'sub e2fs_cgsave {
	    my($old, $new, $size) = @_;
    	    eval q( &memcpy(($new), ($old), ($size)));
	}' unless defined(&e2fs_cgsave);
    }
    eval 'sub EXT2_FSBTODB {
        my($fs, $b) = @_;
	    eval q((($b) << ($fs)-> &e2fs_fsbtodb));
    }' unless defined(&EXT2_FSBTODB);
    eval 'sub EXT2_FSBTODB64 {
        my($fs, $b, $b_hi) = @_;
	    eval q(((((( &uint64_t)($b_hi)) << 32) | ($b)) << ($fs)-> &e2fs_fsbtodb));
    }' unless defined(&EXT2_FSBTODB64);
    eval 'sub EXT2_FSBTODB64OFF {
        my($fs, $b, $b_hi, $off) = @_;
	    eval q((((((( &uint64_t)($b_hi)) << 32) | ($b)) + ($off)) << ($fs)-> &e2fs_fsbtodb));
    }' unless defined(&EXT2_FSBTODB64OFF);
    eval 'sub EXT2_DBTOFSB {
        my($fs, $b) = @_;
	    eval q((($b) >> ($fs)-> &e2fs_fsbtodb));
    }' unless defined(&EXT2_DBTOFSB);
    eval 'sub ino_to_cg {
        my($fs, $x) = @_;
	    eval q(((($x) - 1) / ($fs)-> ($e2fs->{e2fs_ipg})));
    }' unless defined(&ino_to_cg);
    eval 'sub _e2fs_gd {
        my($fs, $x) = @_;
	    eval q(($fs)-> $e2fs_gd[ &ino_to_cg(($fs), ($x))]);
    }' unless defined(&_e2fs_gd);
    eval 'sub ino_to_fsba {
        my($fs, $x) = @_;
	    eval q(( &fs2h32( &_e2fs_gd($fs, $x). &ext2bgd_i_tables) + ((( &uint64_t) &fs2h32( &_e2fs_gd($fs, $x). &ext2bgd_i_tables_hi)) << 32) + ((($x) - 1) % ($fs)-> ($e2fs->{e2fs_ipg})) / ($fs)-> &e2fs_ipb));
    }' unless defined(&ino_to_fsba);
    eval 'sub ino_to_fsbo {
        my($fs, $x) = @_;
	    eval q(((($x) - 1) % ($fs)-> &e2fs_ipb));
    }' unless defined(&ino_to_fsbo);
    eval 'sub dtog {
        my($fs, $d) = @_;
	    eval q(((($d) - ($fs)-> ($e2fs->{e2fs_first_dblock})) / ($fs)-> ($e2fs->{e2fs_fpg})));
    }' unless defined(&dtog);
    eval 'sub dtogd {
        my($fs, $d) = @_;
	    eval q(((($d) - ($fs)-> ($e2fs->{e2fs_first_dblock})) % ($fs)-> ($e2fs->{e2fs_fpg})));
    }' unless defined(&dtogd);
    eval 'sub ext2_blkoff {
        my($fs, $loc) = @_;
	    eval q((($loc) & ($fs)-> &e2fs_qbmask));
    }' unless defined(&ext2_blkoff);
    eval 'sub ext2_lblktosize {
        my($fs, $blk) = @_;
	    eval q((($blk) << ($fs)-> &e2fs_bshift));
    }' unless defined(&ext2_lblktosize);
    eval 'sub ext2_lblkno {
        my($fs, $loc) = @_;
	    eval q((($loc) >> ($fs)-> &e2fs_bshift));
    }' unless defined(&ext2_lblkno);
    eval 'sub ext2_blkroundup {
        my($fs, $size) = @_;
	    eval q(((($size) + ($fs)-> &e2fs_qbmask) & ($fs)-> &e2fs_bmask));
    }' unless defined(&ext2_blkroundup);
    eval 'sub ext2_fragroundup {
        my($fs, $size) = @_;
	    eval q(((($size) + ($fs)-> &e2fs_qbmask) & ($fs)-> &e2fs_bmask));
    }' unless defined(&ext2_fragroundup);
    eval 'sub freespace {
        my($fs) = @_;
	    eval q((($fs)-> ($e2fs->{e2fs_fbcount}) - ($fs)-> ($e2fs->{e2fs_rbcount})));
    }' unless defined(&freespace);
    eval 'sub EXT2_NINDIR {
        my($fs) = @_;
	    eval q((($fs)-> &e2fs_bsize / $sizeof{ &uint32_t}));
    }' unless defined(&EXT2_NINDIR);
}
1;
