require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_CMS_H)) {
    eval 'sub OPENSSL_CMS_H () {1;}' unless defined(&OPENSSL_CMS_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_CMS_H () {1;}' unless defined(&HEADER_CMS_H);
    }
    require 'openssl/opensslconf.ph';
    unless(defined(&OPENSSL_NO_CMS)) {
	require 'openssl/x509.ph';
	require 'openssl/x509v3.ph';
	require 'openssl/cmserr.ph';
	if(defined(&__cplusplus)) {
	}
	eval 'sub sk_CMS_SignerInfo_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_CMS_SignerInfo_sk_type($sk)));
	}' unless defined(&sk_CMS_SignerInfo_num);
	eval 'sub sk_CMS_SignerInfo_value {
	    my($sk, $idx) = @_;
    	    eval q((( &CMS_SignerInfo *) &OPENSSL_sk_value( &ossl_check_const_CMS_SignerInfo_sk_type($sk), ($idx))));
	}' unless defined(&sk_CMS_SignerInfo_value);
	eval 'sub sk_CMS_SignerInfo_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &CMS_SignerInfo) *) &OPENSSL_sk_new( &ossl_check_CMS_SignerInfo_compfunc_type($cmp))));
	}' unless defined(&sk_CMS_SignerInfo_new);
	eval 'sub sk_CMS_SignerInfo_new_null () {
	    eval q((( &STACK_OF( &CMS_SignerInfo) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_CMS_SignerInfo_new_null);
	eval 'sub sk_CMS_SignerInfo_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &CMS_SignerInfo) *) &OPENSSL_sk_new_reserve( &ossl_check_CMS_SignerInfo_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_CMS_SignerInfo_new_reserve);
	eval 'sub sk_CMS_SignerInfo_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_CMS_SignerInfo_sk_type($sk), ($n)));
	}' unless defined(&sk_CMS_SignerInfo_reserve);
	eval 'sub sk_CMS_SignerInfo_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_CMS_SignerInfo_sk_type($sk)));
	}' unless defined(&sk_CMS_SignerInfo_free);
	eval 'sub sk_CMS_SignerInfo_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_CMS_SignerInfo_sk_type($sk)));
	}' unless defined(&sk_CMS_SignerInfo_zero);
	eval 'sub sk_CMS_SignerInfo_delete {
	    my($sk, $i) = @_;
    	    eval q((( &CMS_SignerInfo *) &OPENSSL_sk_delete( &ossl_check_CMS_SignerInfo_sk_type($sk), ($i))));
	}' unless defined(&sk_CMS_SignerInfo_delete);
	eval 'sub sk_CMS_SignerInfo_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &CMS_SignerInfo *) &OPENSSL_sk_delete_ptr( &ossl_check_CMS_SignerInfo_sk_type($sk),  &ossl_check_CMS_SignerInfo_type($ptr))));
	}' unless defined(&sk_CMS_SignerInfo_delete_ptr);
	eval 'sub sk_CMS_SignerInfo_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_CMS_SignerInfo_sk_type($sk),  &ossl_check_CMS_SignerInfo_type($ptr)));
	}' unless defined(&sk_CMS_SignerInfo_push);
	eval 'sub sk_CMS_SignerInfo_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_CMS_SignerInfo_sk_type($sk),  &ossl_check_CMS_SignerInfo_type($ptr)));
	}' unless defined(&sk_CMS_SignerInfo_unshift);
	eval 'sub sk_CMS_SignerInfo_pop {
	    my($sk) = @_;
    	    eval q((( &CMS_SignerInfo *) &OPENSSL_sk_pop( &ossl_check_CMS_SignerInfo_sk_type($sk))));
	}' unless defined(&sk_CMS_SignerInfo_pop);
	eval 'sub sk_CMS_SignerInfo_shift {
	    my($sk) = @_;
    	    eval q((( &CMS_SignerInfo *) &OPENSSL_sk_shift( &ossl_check_CMS_SignerInfo_sk_type($sk))));
	}' unless defined(&sk_CMS_SignerInfo_shift);
	eval 'sub sk_CMS_SignerInfo_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_CMS_SignerInfo_sk_type($sk), &ossl_check_CMS_SignerInfo_freefunc_type($freefunc)));
	}' unless defined(&sk_CMS_SignerInfo_pop_free);
	eval 'sub sk_CMS_SignerInfo_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_CMS_SignerInfo_sk_type($sk),  &ossl_check_CMS_SignerInfo_type($ptr), ($idx)));
	}' unless defined(&sk_CMS_SignerInfo_insert);
	eval 'sub sk_CMS_SignerInfo_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &CMS_SignerInfo *) &OPENSSL_sk_set( &ossl_check_CMS_SignerInfo_sk_type($sk), ($idx),  &ossl_check_CMS_SignerInfo_type($ptr))));
	}' unless defined(&sk_CMS_SignerInfo_set);
	eval 'sub sk_CMS_SignerInfo_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_CMS_SignerInfo_sk_type($sk),  &ossl_check_CMS_SignerInfo_type($ptr)));
	}' unless defined(&sk_CMS_SignerInfo_find);
	eval 'sub sk_CMS_SignerInfo_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_CMS_SignerInfo_sk_type($sk),  &ossl_check_CMS_SignerInfo_type($ptr)));
	}' unless defined(&sk_CMS_SignerInfo_find_ex);
	eval 'sub sk_CMS_SignerInfo_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_CMS_SignerInfo_sk_type($sk),  &ossl_check_CMS_SignerInfo_type($ptr), $pnum));
	}' unless defined(&sk_CMS_SignerInfo_find_all);
	eval 'sub sk_CMS_SignerInfo_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_CMS_SignerInfo_sk_type($sk)));
	}' unless defined(&sk_CMS_SignerInfo_sort);
	eval 'sub sk_CMS_SignerInfo_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_CMS_SignerInfo_sk_type($sk)));
	}' unless defined(&sk_CMS_SignerInfo_is_sorted);
	eval 'sub sk_CMS_SignerInfo_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &CMS_SignerInfo) *) &OPENSSL_sk_dup( &ossl_check_const_CMS_SignerInfo_sk_type($sk))));
	}' unless defined(&sk_CMS_SignerInfo_dup);
	eval 'sub sk_CMS_SignerInfo_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &CMS_SignerInfo) *) &OPENSSL_sk_deep_copy( &ossl_check_const_CMS_SignerInfo_sk_type($sk),  &ossl_check_CMS_SignerInfo_copyfunc_type($copyfunc),  &ossl_check_CMS_SignerInfo_freefunc_type($freefunc))));
	}' unless defined(&sk_CMS_SignerInfo_deep_copy);
	eval 'sub sk_CMS_SignerInfo_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_CMS_SignerInfo_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_CMS_SignerInfo_sk_type($sk),  &ossl_check_CMS_SignerInfo_compfunc_type($cmp))));
	}' unless defined(&sk_CMS_SignerInfo_set_cmp_func);
	eval 'sub sk_CMS_RecipientEncryptedKey_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_CMS_RecipientEncryptedKey_sk_type($sk)));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_num);
	eval 'sub sk_CMS_RecipientEncryptedKey_value {
	    my($sk, $idx) = @_;
    	    eval q((( &CMS_RecipientEncryptedKey *) &OPENSSL_sk_value( &ossl_check_const_CMS_RecipientEncryptedKey_sk_type($sk), ($idx))));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_value);
	eval 'sub sk_CMS_RecipientEncryptedKey_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &CMS_RecipientEncryptedKey) *) &OPENSSL_sk_new( &ossl_check_CMS_RecipientEncryptedKey_compfunc_type($cmp))));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_new);
	eval 'sub sk_CMS_RecipientEncryptedKey_new_null () {
	    eval q((( &STACK_OF( &CMS_RecipientEncryptedKey) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_new_null);
	eval 'sub sk_CMS_RecipientEncryptedKey_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &CMS_RecipientEncryptedKey) *) &OPENSSL_sk_new_reserve( &ossl_check_CMS_RecipientEncryptedKey_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_new_reserve);
	eval 'sub sk_CMS_RecipientEncryptedKey_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk), ($n)));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_reserve);
	eval 'sub sk_CMS_RecipientEncryptedKey_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk)));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_free);
	eval 'sub sk_CMS_RecipientEncryptedKey_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk)));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_zero);
	eval 'sub sk_CMS_RecipientEncryptedKey_delete {
	    my($sk, $i) = @_;
    	    eval q((( &CMS_RecipientEncryptedKey *) &OPENSSL_sk_delete( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk), ($i))));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_delete);
	eval 'sub sk_CMS_RecipientEncryptedKey_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &CMS_RecipientEncryptedKey *) &OPENSSL_sk_delete_ptr( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk),  &ossl_check_CMS_RecipientEncryptedKey_type($ptr))));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_delete_ptr);
	eval 'sub sk_CMS_RecipientEncryptedKey_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk),  &ossl_check_CMS_RecipientEncryptedKey_type($ptr)));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_push);
	eval 'sub sk_CMS_RecipientEncryptedKey_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk),  &ossl_check_CMS_RecipientEncryptedKey_type($ptr)));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_unshift);
	eval 'sub sk_CMS_RecipientEncryptedKey_pop {
	    my($sk) = @_;
    	    eval q((( &CMS_RecipientEncryptedKey *) &OPENSSL_sk_pop( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk))));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_pop);
	eval 'sub sk_CMS_RecipientEncryptedKey_shift {
	    my($sk) = @_;
    	    eval q((( &CMS_RecipientEncryptedKey *) &OPENSSL_sk_shift( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk))));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_shift);
	eval 'sub sk_CMS_RecipientEncryptedKey_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk), &ossl_check_CMS_RecipientEncryptedKey_freefunc_type($freefunc)));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_pop_free);
	eval 'sub sk_CMS_RecipientEncryptedKey_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk),  &ossl_check_CMS_RecipientEncryptedKey_type($ptr), ($idx)));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_insert);
	eval 'sub sk_CMS_RecipientEncryptedKey_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &CMS_RecipientEncryptedKey *) &OPENSSL_sk_set( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk), ($idx),  &ossl_check_CMS_RecipientEncryptedKey_type($ptr))));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_set);
	eval 'sub sk_CMS_RecipientEncryptedKey_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk),  &ossl_check_CMS_RecipientEncryptedKey_type($ptr)));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_find);
	eval 'sub sk_CMS_RecipientEncryptedKey_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk),  &ossl_check_CMS_RecipientEncryptedKey_type($ptr)));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_find_ex);
	eval 'sub sk_CMS_RecipientEncryptedKey_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk),  &ossl_check_CMS_RecipientEncryptedKey_type($ptr), $pnum));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_find_all);
	eval 'sub sk_CMS_RecipientEncryptedKey_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk)));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_sort);
	eval 'sub sk_CMS_RecipientEncryptedKey_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_CMS_RecipientEncryptedKey_sk_type($sk)));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_is_sorted);
	eval 'sub sk_CMS_RecipientEncryptedKey_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &CMS_RecipientEncryptedKey) *) &OPENSSL_sk_dup( &ossl_check_const_CMS_RecipientEncryptedKey_sk_type($sk))));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_dup);
	eval 'sub sk_CMS_RecipientEncryptedKey_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &CMS_RecipientEncryptedKey) *) &OPENSSL_sk_deep_copy( &ossl_check_const_CMS_RecipientEncryptedKey_sk_type($sk),  &ossl_check_CMS_RecipientEncryptedKey_copyfunc_type($copyfunc),  &ossl_check_CMS_RecipientEncryptedKey_freefunc_type($freefunc))));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_deep_copy);
	eval 'sub sk_CMS_RecipientEncryptedKey_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_CMS_RecipientEncryptedKey_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_CMS_RecipientEncryptedKey_sk_type($sk),  &ossl_check_CMS_RecipientEncryptedKey_compfunc_type($cmp))));
	}' unless defined(&sk_CMS_RecipientEncryptedKey_set_cmp_func);
	eval 'sub sk_CMS_RecipientInfo_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_CMS_RecipientInfo_sk_type($sk)));
	}' unless defined(&sk_CMS_RecipientInfo_num);
	eval 'sub sk_CMS_RecipientInfo_value {
	    my($sk, $idx) = @_;
    	    eval q((( &CMS_RecipientInfo *) &OPENSSL_sk_value( &ossl_check_const_CMS_RecipientInfo_sk_type($sk), ($idx))));
	}' unless defined(&sk_CMS_RecipientInfo_value);
	eval 'sub sk_CMS_RecipientInfo_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &CMS_RecipientInfo) *) &OPENSSL_sk_new( &ossl_check_CMS_RecipientInfo_compfunc_type($cmp))));
	}' unless defined(&sk_CMS_RecipientInfo_new);
	eval 'sub sk_CMS_RecipientInfo_new_null () {
	    eval q((( &STACK_OF( &CMS_RecipientInfo) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_CMS_RecipientInfo_new_null);
	eval 'sub sk_CMS_RecipientInfo_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &CMS_RecipientInfo) *) &OPENSSL_sk_new_reserve( &ossl_check_CMS_RecipientInfo_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_CMS_RecipientInfo_new_reserve);
	eval 'sub sk_CMS_RecipientInfo_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_CMS_RecipientInfo_sk_type($sk), ($n)));
	}' unless defined(&sk_CMS_RecipientInfo_reserve);
	eval 'sub sk_CMS_RecipientInfo_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_CMS_RecipientInfo_sk_type($sk)));
	}' unless defined(&sk_CMS_RecipientInfo_free);
	eval 'sub sk_CMS_RecipientInfo_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_CMS_RecipientInfo_sk_type($sk)));
	}' unless defined(&sk_CMS_RecipientInfo_zero);
	eval 'sub sk_CMS_RecipientInfo_delete {
	    my($sk, $i) = @_;
    	    eval q((( &CMS_RecipientInfo *) &OPENSSL_sk_delete( &ossl_check_CMS_RecipientInfo_sk_type($sk), ($i))));
	}' unless defined(&sk_CMS_RecipientInfo_delete);
	eval 'sub sk_CMS_RecipientInfo_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &CMS_RecipientInfo *) &OPENSSL_sk_delete_ptr( &ossl_check_CMS_RecipientInfo_sk_type($sk),  &ossl_check_CMS_RecipientInfo_type($ptr))));
	}' unless defined(&sk_CMS_RecipientInfo_delete_ptr);
	eval 'sub sk_CMS_RecipientInfo_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_CMS_RecipientInfo_sk_type($sk),  &ossl_check_CMS_RecipientInfo_type($ptr)));
	}' unless defined(&sk_CMS_RecipientInfo_push);
	eval 'sub sk_CMS_RecipientInfo_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_CMS_RecipientInfo_sk_type($sk),  &ossl_check_CMS_RecipientInfo_type($ptr)));
	}' unless defined(&sk_CMS_RecipientInfo_unshift);
	eval 'sub sk_CMS_RecipientInfo_pop {
	    my($sk) = @_;
    	    eval q((( &CMS_RecipientInfo *) &OPENSSL_sk_pop( &ossl_check_CMS_RecipientInfo_sk_type($sk))));
	}' unless defined(&sk_CMS_RecipientInfo_pop);
	eval 'sub sk_CMS_RecipientInfo_shift {
	    my($sk) = @_;
    	    eval q((( &CMS_RecipientInfo *) &OPENSSL_sk_shift( &ossl_check_CMS_RecipientInfo_sk_type($sk))));
	}' unless defined(&sk_CMS_RecipientInfo_shift);
	eval 'sub sk_CMS_RecipientInfo_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_CMS_RecipientInfo_sk_type($sk), &ossl_check_CMS_RecipientInfo_freefunc_type($freefunc)));
	}' unless defined(&sk_CMS_RecipientInfo_pop_free);
	eval 'sub sk_CMS_RecipientInfo_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_CMS_RecipientInfo_sk_type($sk),  &ossl_check_CMS_RecipientInfo_type($ptr), ($idx)));
	}' unless defined(&sk_CMS_RecipientInfo_insert);
	eval 'sub sk_CMS_RecipientInfo_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &CMS_RecipientInfo *) &OPENSSL_sk_set( &ossl_check_CMS_RecipientInfo_sk_type($sk), ($idx),  &ossl_check_CMS_RecipientInfo_type($ptr))));
	}' unless defined(&sk_CMS_RecipientInfo_set);
	eval 'sub sk_CMS_RecipientInfo_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_CMS_RecipientInfo_sk_type($sk),  &ossl_check_CMS_RecipientInfo_type($ptr)));
	}' unless defined(&sk_CMS_RecipientInfo_find);
	eval 'sub sk_CMS_RecipientInfo_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_CMS_RecipientInfo_sk_type($sk),  &ossl_check_CMS_RecipientInfo_type($ptr)));
	}' unless defined(&sk_CMS_RecipientInfo_find_ex);
	eval 'sub sk_CMS_RecipientInfo_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_CMS_RecipientInfo_sk_type($sk),  &ossl_check_CMS_RecipientInfo_type($ptr), $pnum));
	}' unless defined(&sk_CMS_RecipientInfo_find_all);
	eval 'sub sk_CMS_RecipientInfo_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_CMS_RecipientInfo_sk_type($sk)));
	}' unless defined(&sk_CMS_RecipientInfo_sort);
	eval 'sub sk_CMS_RecipientInfo_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_CMS_RecipientInfo_sk_type($sk)));
	}' unless defined(&sk_CMS_RecipientInfo_is_sorted);
	eval 'sub sk_CMS_RecipientInfo_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &CMS_RecipientInfo) *) &OPENSSL_sk_dup( &ossl_check_const_CMS_RecipientInfo_sk_type($sk))));
	}' unless defined(&sk_CMS_RecipientInfo_dup);
	eval 'sub sk_CMS_RecipientInfo_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &CMS_RecipientInfo) *) &OPENSSL_sk_deep_copy( &ossl_check_const_CMS_RecipientInfo_sk_type($sk),  &ossl_check_CMS_RecipientInfo_copyfunc_type($copyfunc),  &ossl_check_CMS_RecipientInfo_freefunc_type($freefunc))));
	}' unless defined(&sk_CMS_RecipientInfo_deep_copy);
	eval 'sub sk_CMS_RecipientInfo_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_CMS_RecipientInfo_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_CMS_RecipientInfo_sk_type($sk),  &ossl_check_CMS_RecipientInfo_compfunc_type($cmp))));
	}' unless defined(&sk_CMS_RecipientInfo_set_cmp_func);
	eval 'sub sk_CMS_RevocationInfoChoice_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_CMS_RevocationInfoChoice_sk_type($sk)));
	}' unless defined(&sk_CMS_RevocationInfoChoice_num);
	eval 'sub sk_CMS_RevocationInfoChoice_value {
	    my($sk, $idx) = @_;
    	    eval q((( &CMS_RevocationInfoChoice *) &OPENSSL_sk_value( &ossl_check_const_CMS_RevocationInfoChoice_sk_type($sk), ($idx))));
	}' unless defined(&sk_CMS_RevocationInfoChoice_value);
	eval 'sub sk_CMS_RevocationInfoChoice_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &CMS_RevocationInfoChoice) *) &OPENSSL_sk_new( &ossl_check_CMS_RevocationInfoChoice_compfunc_type($cmp))));
	}' unless defined(&sk_CMS_RevocationInfoChoice_new);
	eval 'sub sk_CMS_RevocationInfoChoice_new_null () {
	    eval q((( &STACK_OF( &CMS_RevocationInfoChoice) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_CMS_RevocationInfoChoice_new_null);
	eval 'sub sk_CMS_RevocationInfoChoice_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &CMS_RevocationInfoChoice) *) &OPENSSL_sk_new_reserve( &ossl_check_CMS_RevocationInfoChoice_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_CMS_RevocationInfoChoice_new_reserve);
	eval 'sub sk_CMS_RevocationInfoChoice_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk), ($n)));
	}' unless defined(&sk_CMS_RevocationInfoChoice_reserve);
	eval 'sub sk_CMS_RevocationInfoChoice_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk)));
	}' unless defined(&sk_CMS_RevocationInfoChoice_free);
	eval 'sub sk_CMS_RevocationInfoChoice_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk)));
	}' unless defined(&sk_CMS_RevocationInfoChoice_zero);
	eval 'sub sk_CMS_RevocationInfoChoice_delete {
	    my($sk, $i) = @_;
    	    eval q((( &CMS_RevocationInfoChoice *) &OPENSSL_sk_delete( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk), ($i))));
	}' unless defined(&sk_CMS_RevocationInfoChoice_delete);
	eval 'sub sk_CMS_RevocationInfoChoice_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &CMS_RevocationInfoChoice *) &OPENSSL_sk_delete_ptr( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk),  &ossl_check_CMS_RevocationInfoChoice_type($ptr))));
	}' unless defined(&sk_CMS_RevocationInfoChoice_delete_ptr);
	eval 'sub sk_CMS_RevocationInfoChoice_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk),  &ossl_check_CMS_RevocationInfoChoice_type($ptr)));
	}' unless defined(&sk_CMS_RevocationInfoChoice_push);
	eval 'sub sk_CMS_RevocationInfoChoice_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk),  &ossl_check_CMS_RevocationInfoChoice_type($ptr)));
	}' unless defined(&sk_CMS_RevocationInfoChoice_unshift);
	eval 'sub sk_CMS_RevocationInfoChoice_pop {
	    my($sk) = @_;
    	    eval q((( &CMS_RevocationInfoChoice *) &OPENSSL_sk_pop( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk))));
	}' unless defined(&sk_CMS_RevocationInfoChoice_pop);
	eval 'sub sk_CMS_RevocationInfoChoice_shift {
	    my($sk) = @_;
    	    eval q((( &CMS_RevocationInfoChoice *) &OPENSSL_sk_shift( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk))));
	}' unless defined(&sk_CMS_RevocationInfoChoice_shift);
	eval 'sub sk_CMS_RevocationInfoChoice_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk), &ossl_check_CMS_RevocationInfoChoice_freefunc_type($freefunc)));
	}' unless defined(&sk_CMS_RevocationInfoChoice_pop_free);
	eval 'sub sk_CMS_RevocationInfoChoice_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk),  &ossl_check_CMS_RevocationInfoChoice_type($ptr), ($idx)));
	}' unless defined(&sk_CMS_RevocationInfoChoice_insert);
	eval 'sub sk_CMS_RevocationInfoChoice_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &CMS_RevocationInfoChoice *) &OPENSSL_sk_set( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk), ($idx),  &ossl_check_CMS_RevocationInfoChoice_type($ptr))));
	}' unless defined(&sk_CMS_RevocationInfoChoice_set);
	eval 'sub sk_CMS_RevocationInfoChoice_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk),  &ossl_check_CMS_RevocationInfoChoice_type($ptr)));
	}' unless defined(&sk_CMS_RevocationInfoChoice_find);
	eval 'sub sk_CMS_RevocationInfoChoice_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk),  &ossl_check_CMS_RevocationInfoChoice_type($ptr)));
	}' unless defined(&sk_CMS_RevocationInfoChoice_find_ex);
	eval 'sub sk_CMS_RevocationInfoChoice_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk),  &ossl_check_CMS_RevocationInfoChoice_type($ptr), $pnum));
	}' unless defined(&sk_CMS_RevocationInfoChoice_find_all);
	eval 'sub sk_CMS_RevocationInfoChoice_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk)));
	}' unless defined(&sk_CMS_RevocationInfoChoice_sort);
	eval 'sub sk_CMS_RevocationInfoChoice_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_CMS_RevocationInfoChoice_sk_type($sk)));
	}' unless defined(&sk_CMS_RevocationInfoChoice_is_sorted);
	eval 'sub sk_CMS_RevocationInfoChoice_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &CMS_RevocationInfoChoice) *) &OPENSSL_sk_dup( &ossl_check_const_CMS_RevocationInfoChoice_sk_type($sk))));
	}' unless defined(&sk_CMS_RevocationInfoChoice_dup);
	eval 'sub sk_CMS_RevocationInfoChoice_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &CMS_RevocationInfoChoice) *) &OPENSSL_sk_deep_copy( &ossl_check_const_CMS_RevocationInfoChoice_sk_type($sk),  &ossl_check_CMS_RevocationInfoChoice_copyfunc_type($copyfunc),  &ossl_check_CMS_RevocationInfoChoice_freefunc_type($freefunc))));
	}' unless defined(&sk_CMS_RevocationInfoChoice_deep_copy);
	eval 'sub sk_CMS_RevocationInfoChoice_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_CMS_RevocationInfoChoice_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_CMS_RevocationInfoChoice_sk_type($sk),  &ossl_check_CMS_RevocationInfoChoice_compfunc_type($cmp))));
	}' unless defined(&sk_CMS_RevocationInfoChoice_set_cmp_func);
	eval 'sub CMS_SIGNERINFO_ISSUER_SERIAL () {0;}' unless defined(&CMS_SIGNERINFO_ISSUER_SERIAL);
	eval 'sub CMS_SIGNERINFO_KEYIDENTIFIER () {1;}' unless defined(&CMS_SIGNERINFO_KEYIDENTIFIER);
	eval 'sub CMS_RECIPINFO_NONE () {-1;}' unless defined(&CMS_RECIPINFO_NONE);
	eval 'sub CMS_RECIPINFO_TRANS () {0;}' unless defined(&CMS_RECIPINFO_TRANS);
	eval 'sub CMS_RECIPINFO_AGREE () {1;}' unless defined(&CMS_RECIPINFO_AGREE);
	eval 'sub CMS_RECIPINFO_KEK () {2;}' unless defined(&CMS_RECIPINFO_KEK);
	eval 'sub CMS_RECIPINFO_PASS () {3;}' unless defined(&CMS_RECIPINFO_PASS);
	eval 'sub CMS_RECIPINFO_OTHER () {4;}' unless defined(&CMS_RECIPINFO_OTHER);
	eval 'sub CMS_TEXT () {0x1;}' unless defined(&CMS_TEXT);
	eval 'sub CMS_NOCERTS () {0x2;}' unless defined(&CMS_NOCERTS);
	eval 'sub CMS_NO_CONTENT_VERIFY () {0x4;}' unless defined(&CMS_NO_CONTENT_VERIFY);
	eval 'sub CMS_NO_ATTR_VERIFY () {0x8;}' unless defined(&CMS_NO_ATTR_VERIFY);
	eval 'sub CMS_NOSIGS () {( &CMS_NO_CONTENT_VERIFY| &CMS_NO_ATTR_VERIFY);}' unless defined(&CMS_NOSIGS);
	eval 'sub CMS_NOINTERN () {0x10;}' unless defined(&CMS_NOINTERN);
	eval 'sub CMS_NO_SIGNER_CERT_VERIFY () {0x20;}' unless defined(&CMS_NO_SIGNER_CERT_VERIFY);
	eval 'sub CMS_NOVERIFY () {0x20;}' unless defined(&CMS_NOVERIFY);
	eval 'sub CMS_DETACHED () {0x40;}' unless defined(&CMS_DETACHED);
	eval 'sub CMS_BINARY () {0x80;}' unless defined(&CMS_BINARY);
	eval 'sub CMS_NOATTR () {0x100;}' unless defined(&CMS_NOATTR);
	eval 'sub CMS_NOSMIMECAP () {0x200;}' unless defined(&CMS_NOSMIMECAP);
	eval 'sub CMS_NOOLDMIMETYPE () {0x400;}' unless defined(&CMS_NOOLDMIMETYPE);
	eval 'sub CMS_CRLFEOL () {0x800;}' unless defined(&CMS_CRLFEOL);
	eval 'sub CMS_STREAM () {0x1000;}' unless defined(&CMS_STREAM);
	eval 'sub CMS_NOCRL () {0x2000;}' unless defined(&CMS_NOCRL);
	eval 'sub CMS_PARTIAL () {0x4000;}' unless defined(&CMS_PARTIAL);
	eval 'sub CMS_REUSE_DIGEST () {0x8000;}' unless defined(&CMS_REUSE_DIGEST);
	eval 'sub CMS_USE_KEYID () {0x10000;}' unless defined(&CMS_USE_KEYID);
	eval 'sub CMS_DEBUG_DECRYPT () {0x20000;}' unless defined(&CMS_DEBUG_DECRYPT);
	eval 'sub CMS_KEY_PARAM () {0x40000;}' unless defined(&CMS_KEY_PARAM);
	eval 'sub CMS_ASCIICRLF () {0x80000;}' unless defined(&CMS_ASCIICRLF);
	eval 'sub CMS_CADES () {0x100000;}' unless defined(&CMS_CADES);
	eval 'sub CMS_USE_ORIGINATOR_KEYID () {0x200000;}' unless defined(&CMS_USE_ORIGINATOR_KEYID);
	eval 'sub CMS_NO_SIGNING_TIME () {0x400000;}' unless defined(&CMS_NO_SIGNING_TIME);
	if(defined(&OPENSSL_PEM_H)) {
	}
	eval 'sub CMS_R_UNKNOWN_DIGEST_ALGORITM () { &CMS_R_UNKNOWN_DIGEST_ALGORITHM;}' unless defined(&CMS_R_UNKNOWN_DIGEST_ALGORITM);
	eval 'sub CMS_R_UNSUPPORTED_RECPIENTINFO_TYPE () { &CMS_R_UNSUPPORTED_RECIPIENTINFO_TYPE;}' unless defined(&CMS_R_UNSUPPORTED_RECPIENTINFO_TYPE);
	if(defined(&__cplusplus)) {
	}
    }
}
1;
