/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;

public class PBEKeySpec
implements KeySpec {
    private int iterationCount;
    private int keyLength;
    private char[] password;
    private byte[] salt;

    public final void clearPassword() {
        if (this.password == null) {
            return;
        }
        int i = 0;
        while (i < this.password.length) {
            this.password[i] = '\u0000';
            ++i;
        }
    }

    public final int getIterationCount() {
        return this.iterationCount;
    }

    public final int getKeyLength() {
        return this.keyLength;
    }

    public final char[] getPassword() {
        return this.password;
    }

    public final byte[] getSalt() {
        return this.salt;
    }

    public PBEKeySpec(char[] password) {
        this(password, null, 0, 0);
    }

    public PBEKeySpec(char[] password, byte[] salt, int iterationCount) {
        this(password, salt, iterationCount, 0);
    }

    public PBEKeySpec(char[] password, byte[] salt, int iterationCount, int keyLength) {
        this.password = password;
        this.salt = salt;
        this.iterationCount = iterationCount;
        this.keyLength = keyLength;
    }
}

