.TH RAW2FBM 1 25-Jun-90
.CM 3
.SH NAME
raw2fbm \- convert raw image files to FBM format (especially Digi-View files)
.SH SYNOPSIS
.nf
raw2fbm [ -t'title' -c'credits' -a<aspect>
          -w<width> -h<height> -d'<planes> ] < rawfile > fbm
.fi
.SH DESCRIPTION
.PP
Converts a raw image (stored in row major order, or red/green/blue for
color images) to fbm format.  The defaults are width=640, height=400,
depth=1, and aspect ratio=1.2 (the correct settings for output
from the Amiga Digi-View package).
.SH OPTIONS
.TP
.BR -d
.I depth,
number of byte planes in image.  Default is 1.  Use -d3 for RGB color
images.
.TP
.BR -w
.I width,
number of pixels per row, assumes 1 byte per pixel.  The default is 640.
.TP
.BR -h
.I height,
number of rows in image.  The default is 400.
.TP
.BR -a
.I aspect ratio,
the ratio of the height to width of a single pixel.  The default is 1.2
(for Digi-View files).
.TP
.BR -t'title'
.I title,
specify a character string (up to 80 characters) to describe the image.
The default is no title.
.TP
.BR -c'credits'
.I credits or subtitle,
specify a second character string (up to 80 characters) to describe the
image.  The default is no credit string.
.SH EXAMPLE
.PP
Assume a Digi-View "raw" color image of a tiger, 640x400 pixels with
1.2 to 1 aspect ratio (EL Arts calls is 1.1):
.sp
    % raw2fbm -a1.2 -w640 -h400 -d3 \
.br
      -t'Tiger' -c'Joe' < tiger.raw > tiger.fbm
.sp
or in this case:
.sp
    % raw2fbm -d3 -t'Tiger' -c'Joe' < tiger.raw > tiger.fbm
.SH SEE ALSO
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
