# This code modifies the look/feel of Tk to be a bit more 'modern'
# and Windows-like instead of Motif-like.  It's from the Tk reviitalization
# project
set release(options.tcl) {$Header: /home/cvs/readi/code/dpe/src/balloon.tcl,v 1.
2 2003/12/02 14:41:31 clif Exp $}

# These convert fonts to 'normal' instead of bold.
# And set colors to values that seem closer to MS-Windows 2K.

switch $tcl_platform(platform) {
 "unix" {
   set fontSize 8
   set use 1
 } 
 
 "windows" {
   set fontSize 8
   set use 1
 } 

 "macintosh" -
 "mac" {
   set use 0
 }
}

if {$use} {
 array set Tutor [list  \
  opt,*background #d8d8d8 \
  opt,*Listbox.background white \
  opt,*Listbox.foreground black \
  opt,*Listbox.selectBorderWidth 0 \
  opt,*Listbox.selectForeground white \
  opt,*Listbox.selectBackground #4a6984 \
  opt,*Entry.background white \
  opt,*Entry.foreground black \
  opt,*Entry.selectBorderWidth 0 \
  opt,*Entry.selectForeground white \
  opt,*Entry.selectBackground #4a6984 \
  opt,*Text.background white \
  opt,*Text.foreground black \
  opt,*Text.selectBorderWidth 0 \
  opt,*Text.selectForeground white \
  opt,*Text.selectBackground #4a6984 \
  opt,*Menu.activeBackground #4a6984 \
  opt,*Menu.activeForeground white \
  opt,*Menu.activeBorderWidth 0 \
  opt,*Menu.highlightThickness 0 \
  opt,*Menu.borderWidth 2 \
  opt,*Menu.tearOff 0 \
  opt,*Menubutton.activeBackground #4a6984 \
  opt,*Menubutton.activeForeground white \
  opt,*Menubutton.activeBorderWidth 0 \
  opt,*Menubutton.highlightThickness 0 \
  opt,*Menubutton.borderWidth 0 \
  opt,*highlightThickness 0 \
  opt,*troughColor #bdb6ad \
  opt,*Menu.background #d8d8d8 \
  opt,*Frame.background #d8d8d8 \
  opt,*Labelframe.background #d8d8d8 \
  opt,*Menubutton.background #d8d8d8 \
  opt,*Label.font [list arial $fontSize normal] \
  opt,*Labelframe.font [list arial $fontSize normal] \
  opt,*Button.font [list arial $fontSize normal] \
  opt,*Button.foreground black \
  opt,*Button.background #d8d8d8 \
  opt,*Button.activeBackground #e8e8e8 \
  opt,*Menu.font [list arial $fontSize normal] \
  opt,*Menubutton.font [list arial $fontSize normal] \
  opt,*Radiobutton.font [list arial $fontSize normal] \
  opt,*Checkbutton.font [list arial $fontSize normal] \
  opt,*Listbox.font [list arial $fontSize normal] \
  opt,*Scrollbar.width 12 \
  ]
}

proc applyOptions {} {
  global Tutor
  foreach in [array names Tutor opt,*] {
    foreach {o v} [split $in ,] {break;}
# puts "    option add $v $Tutor($in)"
    option add $v $Tutor($in)
  }
  setWindows .
}

proc setWindows {parent} {
  global Tutor
  foreach w [winfo children $parent] {
    setWindows $w
    set t [winfo class $w]
    foreach in [array names Tutor opt,*${t}*ound] {
      foreach {a f} [split $in .] {break;}
      catch {$w configure -[string tolower $f] $Tutor($in)}
      # puts "      $w configure -[string tolower $f] $Tutor($in)"
    }
  }
}
