// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/helper/schema"
	"github.com/hashicorp/terraform-plugin-sdk/helper/validation"
	"google.golang.org/api/googleapi"
)

func validateMonitoringSloGoal(v interface{}, k string) (warnings []string, errors []error) {
	goal := v.(float64)
	if goal <= 0 || goal > 0.999 {
		errors = append(errors, fmt.Errorf("goal %f must be > 0 and <= 0.999", goal))
	}
	return
}

func resourceMonitoringSlo() *schema.Resource {
	return &schema.Resource{
		Create: resourceMonitoringSloCreate,
		Read:   resourceMonitoringSloRead,
		Update: resourceMonitoringSloUpdate,
		Delete: resourceMonitoringSloDelete,

		Importer: &schema.ResourceImporter{
			State: resourceMonitoringSloImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(4 * time.Minute),
			Update: schema.DefaultTimeout(4 * time.Minute),
			Delete: schema.DefaultTimeout(4 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"goal": {
				Type:         schema.TypeFloat,
				Required:     true,
				ValidateFunc: validateMonitoringSloGoal,
				Description: `The fraction of service that must be good in order for this objective
to be met. 0 < goal <= 0.999`,
			},
			"service": {
				Type:        schema.TypeString,
				Required:    true,
				ForceNew:    true,
				Description: `ID of the service to which this SLO belongs.`,
			},
			"calendar_period": {
				Type:         schema.TypeString,
				Optional:     true,
				ValidateFunc: validation.StringInSlice([]string{"DAY", "WEEK", "FORTNIGHT", "MONTH", ""}, false),
				Description: `A calendar period, semantically "since the start of the current
<calendarPeriod>". Possible values: ["DAY", "WEEK", "FORTNIGHT", "MONTH"]`,
				ExactlyOneOf: []string{"rolling_period_days", "calendar_period"},
			},
			"display_name": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `Name used for UI elements listing this SLO.`,
			},
			"rolling_period_days": {
				Type:         schema.TypeInt,
				Optional:     true,
				ValidateFunc: validation.IntBetween(1, 30),
				Description: `A rolling time period, semantically "in the past X days".
Must be between 1 to 30 days, inclusive.`,
				ExactlyOneOf: []string{"rolling_period_days", "calendar_period"},
			},
			"basic_sli": {
				Type:     schema.TypeList,
				Required: true,
				Description: `Basic Service-Level Indicator (SLI) on a well-known service type.
Performance will be computed on the basis of pre-defined metrics.

SLIs are used to measure and calculate the quality of the Service's
performance with respect to a single aspect of service quality.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"latency": {
							Type:        schema.TypeList,
							Required:    true,
							Description: `Parameters for a latency threshold SLI.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"threshold": {
										Type:     schema.TypeString,
										Required: true,
										Description: `A duration string, e.g. 10s.
Good service is defined to be the count of requests made to
this service that return in no more than threshold.`,
									},
								},
							},
						},
						"location": {
							Type:     schema.TypeSet,
							Optional: true,
							Description: `An optional set of locations to which this SLI is relevant.
Telemetry from other locations will not be used to calculate
performance for this SLI. If omitted, this SLI applies to all
locations in which the Service has activity. For service types
that don't support breaking down by location, setting this
field will result in an error.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
							Set: schema.HashString,
						},
						"method": {
							Type:     schema.TypeSet,
							Optional: true,
							Description: `An optional set of RPCs to which this SLI is relevant.
Telemetry from other methods will not be used to calculate
performance for this SLI. If omitted, this SLI applies to all
the Service's methods. For service types that don't support
breaking down by method, setting this field will result in an
error.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
							Set: schema.HashString,
						},
						"version": {
							Type:     schema.TypeSet,
							Optional: true,
							Description: `The set of API versions to which this SLI is relevant.
Telemetry from other API versions will not be used to
calculate performance for this SLI. If omitted,
this SLI applies to all API versions. For service types
that don't support breaking down by version, setting this
field will result in an error.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
							Set: schema.HashString,
						},
					},
				},
			},

			"slo_id": {
				Type:         schema.TypeString,
				Computed:     true,
				Optional:     true,
				ForceNew:     true,
				ValidateFunc: validateRegexp(`^[a-z0-9\-]+$`),
				Description:  `The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.`,
			},
			"name": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `The full resource name for this service. The syntax is:
projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]`,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
	}
}

func resourceMonitoringSloCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	obj := make(map[string]interface{})
	displayNameProp, err := expandMonitoringSloDisplayName(d.Get("display_name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("display_name"); !isEmptyValue(reflect.ValueOf(displayNameProp)) && (ok || !reflect.DeepEqual(v, displayNameProp)) {
		obj["displayName"] = displayNameProp
	}
	goalProp, err := expandMonitoringSloGoal(d.Get("goal"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("goal"); !isEmptyValue(reflect.ValueOf(goalProp)) && (ok || !reflect.DeepEqual(v, goalProp)) {
		obj["goal"] = goalProp
	}
	rollingPeriodProp, err := expandMonitoringSloRollingPeriodDays(d.Get("rolling_period_days"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("rolling_period_days"); !isEmptyValue(reflect.ValueOf(rollingPeriodProp)) && (ok || !reflect.DeepEqual(v, rollingPeriodProp)) {
		obj["rollingPeriod"] = rollingPeriodProp
	}
	calendarPeriodProp, err := expandMonitoringSloCalendarPeriod(d.Get("calendar_period"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("calendar_period"); !isEmptyValue(reflect.ValueOf(calendarPeriodProp)) && (ok || !reflect.DeepEqual(v, calendarPeriodProp)) {
		obj["calendarPeriod"] = calendarPeriodProp
	}
	serviceLevelIndicatorProp, err := expandMonitoringSloServiceLevelIndicator(nil, d, config)
	if err != nil {
		return err
	} else if !isEmptyValue(reflect.ValueOf(serviceLevelIndicatorProp)) {
		obj["serviceLevelIndicator"] = serviceLevelIndicatorProp
	}
	nameProp, err := expandMonitoringSloSloId(d.Get("slo_id"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("slo_id"); !isEmptyValue(reflect.ValueOf(nameProp)) && (ok || !reflect.DeepEqual(v, nameProp)) {
		obj["name"] = nameProp
	}

	obj, err = resourceMonitoringSloEncoder(d, meta, obj)
	if err != nil {
		return err
	}

	lockName, err := replaceVars(d, config, "monitoring/project/{{project}}/service/{{service}}")
	if err != nil {
		return err
	}
	mutexKV.Lock(lockName)
	defer mutexKV.Unlock(lockName)

	url, err := replaceVars(d, config, "{{MonitoringBasePath}}projects/{{project}}/services/{{service}}/serviceLevelObjectives?serviceLevelObjectiveId={{slo_id}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new Slo: %#v", obj)
	project, err := getProject(d, config)
	if err != nil {
		return err
	}
	res, err := sendRequestWithTimeout(config, "POST", project, url, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating Slo: %s", err)
	}
	if err := d.Set("name", flattenMonitoringSloName(res["name"], d, config)); err != nil {
		return fmt.Errorf(`Error setting computed identity field "name": %s`, err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	log.Printf("[DEBUG] Finished creating Slo %q: %#v", d.Id(), res)

	return resourceMonitoringSloRead(d, meta)
}

func resourceMonitoringSloRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	url, err := replaceVars(d, config, "{{MonitoringBasePath}}{{name}}")
	if err != nil {
		return err
	}

	project, err := getProject(d, config)
	if err != nil {
		return err
	}
	res, err := sendRequest(config, "GET", project, url, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("MonitoringSlo %q", d.Id()))
	}

	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading Slo: %s", err)
	}

	if err := d.Set("name", flattenMonitoringSloName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading Slo: %s", err)
	}
	if err := d.Set("display_name", flattenMonitoringSloDisplayName(res["displayName"], d, config)); err != nil {
		return fmt.Errorf("Error reading Slo: %s", err)
	}
	if err := d.Set("goal", flattenMonitoringSloGoal(res["goal"], d, config)); err != nil {
		return fmt.Errorf("Error reading Slo: %s", err)
	}
	if err := d.Set("rolling_period_days", flattenMonitoringSloRollingPeriodDays(res["rollingPeriod"], d, config)); err != nil {
		return fmt.Errorf("Error reading Slo: %s", err)
	}
	if err := d.Set("calendar_period", flattenMonitoringSloCalendarPeriod(res["calendarPeriod"], d, config)); err != nil {
		return fmt.Errorf("Error reading Slo: %s", err)
	}
	// Terraform must set the top level schema field, but since this object contains collapsed properties
	// it's difficult to know what the top level should be. Instead we just loop over the map returned from flatten.
	if flattenedProp := flattenMonitoringSloServiceLevelIndicator(res["serviceLevelIndicator"], d, config); flattenedProp != nil {
		if gerr, ok := flattenedProp.(*googleapi.Error); ok {
			return fmt.Errorf("Error reading Slo: %s", gerr)
		}
		casted := flattenedProp.([]interface{})[0]
		if casted != nil {
			for k, v := range casted.(map[string]interface{}) {
				d.Set(k, v)
			}
		}
	}
	if err := d.Set("slo_id", flattenMonitoringSloSloId(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading Slo: %s", err)
	}

	return nil
}

func resourceMonitoringSloUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	project, err := getProject(d, config)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	displayNameProp, err := expandMonitoringSloDisplayName(d.Get("display_name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("display_name"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, displayNameProp)) {
		obj["displayName"] = displayNameProp
	}
	goalProp, err := expandMonitoringSloGoal(d.Get("goal"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("goal"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, goalProp)) {
		obj["goal"] = goalProp
	}
	rollingPeriodProp, err := expandMonitoringSloRollingPeriodDays(d.Get("rolling_period_days"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("rolling_period_days"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, rollingPeriodProp)) {
		obj["rollingPeriod"] = rollingPeriodProp
	}
	calendarPeriodProp, err := expandMonitoringSloCalendarPeriod(d.Get("calendar_period"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("calendar_period"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, calendarPeriodProp)) {
		obj["calendarPeriod"] = calendarPeriodProp
	}
	serviceLevelIndicatorProp, err := expandMonitoringSloServiceLevelIndicator(nil, d, config)
	if err != nil {
		return err
	} else if !isEmptyValue(reflect.ValueOf(serviceLevelIndicatorProp)) {
		obj["serviceLevelIndicator"] = serviceLevelIndicatorProp
	}

	obj, err = resourceMonitoringSloEncoder(d, meta, obj)
	if err != nil {
		return err
	}

	lockName, err := replaceVars(d, config, "monitoring/project/{{project}}/service/{{service}}")
	if err != nil {
		return err
	}
	mutexKV.Lock(lockName)
	defer mutexKV.Unlock(lockName)

	url, err := replaceVars(d, config, "{{MonitoringBasePath}}{{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating Slo %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("display_name") {
		updateMask = append(updateMask, "displayName")
	}

	if d.HasChange("goal") {
		updateMask = append(updateMask, "goal")
	}

	if d.HasChange("rolling_period_days") {
		updateMask = append(updateMask, "rollingPeriod")
	}

	if d.HasChange("calendar_period") {
		updateMask = append(updateMask, "calendarPeriod")
	}

	if d.HasChange("basic_sli") {
		updateMask = append(updateMask, "serviceLevelIndicator")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}
	_, err = sendRequestWithTimeout(config, "PATCH", project, url, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating Slo %q: %s", d.Id(), err)
	}

	return resourceMonitoringSloRead(d, meta)
}

func resourceMonitoringSloDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	project, err := getProject(d, config)
	if err != nil {
		return err
	}

	lockName, err := replaceVars(d, config, "monitoring/project/{{project}}/service/{{service}}")
	if err != nil {
		return err
	}
	mutexKV.Lock(lockName)
	defer mutexKV.Unlock(lockName)

	url, err := replaceVars(d, config, "{{MonitoringBasePath}}{{name}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting Slo %q", d.Id())

	res, err := sendRequestWithTimeout(config, "DELETE", project, url, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "Slo")
	}

	log.Printf("[DEBUG] Finished deleting Slo %q: %#v", d.Id(), res)
	return nil
}

func resourceMonitoringSloImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {

	config := meta.(*Config)

	// current import_formats can't import fields with forward slashes in their value
	if err := parseImportId([]string{"(?P<project>[^ ]+) (?P<name>[^ ]+)", "(?P<name>[^ ]+)"}, d, config); err != nil {
		return nil, err
	}

	return []*schema.ResourceData{d}, nil
}

func flattenMonitoringSloName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenMonitoringSloDisplayName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenMonitoringSloGoal(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandMonitoringSloRollingPeriodDays(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	if v == nil {
		return nil, nil
	}
	i, ok := v.(int)
	if !ok {
		return nil, fmt.Errorf("unexpected value is not int: %v", v)
	}
	if i == 0 {
		return "", nil
	}
	// Day = 86400s
	return fmt.Sprintf("%ds", i*86400), nil
}

func flattenMonitoringSloCalendarPeriod(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenMonitoringSloServiceLevelIndicator(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["basic_sli"] =
		flattenMonitoringSloServiceLevelIndicatorBasicSli(original["basicSli"], d, config)
	return []interface{}{transformed}
}
func flattenMonitoringSloServiceLevelIndicatorBasicSli(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["method"] =
		flattenMonitoringSloServiceLevelIndicatorBasicSliMethod(original["method"], d, config)
	transformed["location"] =
		flattenMonitoringSloServiceLevelIndicatorBasicSliLocation(original["location"], d, config)
	transformed["version"] =
		flattenMonitoringSloServiceLevelIndicatorBasicSliVersion(original["version"], d, config)
	transformed["latency"] =
		flattenMonitoringSloServiceLevelIndicatorBasicSliLatency(original["latency"], d, config)
	return []interface{}{transformed}
}
func flattenMonitoringSloServiceLevelIndicatorBasicSliMethod(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	return schema.NewSet(schema.HashString, v.([]interface{}))
}

func flattenMonitoringSloServiceLevelIndicatorBasicSliLocation(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	return schema.NewSet(schema.HashString, v.([]interface{}))
}

func flattenMonitoringSloServiceLevelIndicatorBasicSliVersion(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	return schema.NewSet(schema.HashString, v.([]interface{}))
}

func flattenMonitoringSloServiceLevelIndicatorBasicSliLatency(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["threshold"] =
		flattenMonitoringSloServiceLevelIndicatorBasicSliLatencyThreshold(original["threshold"], d, config)
	return []interface{}{transformed}
}
func flattenMonitoringSloServiceLevelIndicatorBasicSliLatencyThreshold(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenMonitoringSloSloId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	return NameFromSelfLinkStateFunc(v)
}

func expandMonitoringSloDisplayName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandMonitoringSloGoal(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func flattenMonitoringSloRollingPeriodDays(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	if v.(string) == "" {
		return nil
	}
	dur, err := time.ParseDuration(v.(string))
	if err != nil {
		return nil
	}
	return int(dur / (time.Hour * 24))
}

func expandMonitoringSloCalendarPeriod(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandMonitoringSloServiceLevelIndicator(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	transformed := make(map[string]interface{})
	transformedBasicSli, err := expandMonitoringSloServiceLevelIndicatorBasicSli(d.Get("basic_sli"), d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBasicSli); val.IsValid() && !isEmptyValue(val) {
		transformed["basicSli"] = transformedBasicSli
	}

	return transformed, nil
}

func expandMonitoringSloServiceLevelIndicatorBasicSli(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedMethod, err := expandMonitoringSloServiceLevelIndicatorBasicSliMethod(original["method"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMethod); val.IsValid() && !isEmptyValue(val) {
		transformed["method"] = transformedMethod
	}

	transformedLocation, err := expandMonitoringSloServiceLevelIndicatorBasicSliLocation(original["location"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocation); val.IsValid() && !isEmptyValue(val) {
		transformed["location"] = transformedLocation
	}

	transformedVersion, err := expandMonitoringSloServiceLevelIndicatorBasicSliVersion(original["version"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedVersion); val.IsValid() && !isEmptyValue(val) {
		transformed["version"] = transformedVersion
	}

	transformedLatency, err := expandMonitoringSloServiceLevelIndicatorBasicSliLatency(original["latency"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLatency); val.IsValid() && !isEmptyValue(val) {
		transformed["latency"] = transformedLatency
	}

	return transformed, nil
}

func expandMonitoringSloServiceLevelIndicatorBasicSliMethod(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	v = v.(*schema.Set).List()
	return v, nil
}

func expandMonitoringSloServiceLevelIndicatorBasicSliLocation(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	v = v.(*schema.Set).List()
	return v, nil
}

func expandMonitoringSloServiceLevelIndicatorBasicSliVersion(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	v = v.(*schema.Set).List()
	return v, nil
}

func expandMonitoringSloServiceLevelIndicatorBasicSliLatency(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedThreshold, err := expandMonitoringSloServiceLevelIndicatorBasicSliLatencyThreshold(original["threshold"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedThreshold); val.IsValid() && !isEmptyValue(val) {
		transformed["threshold"] = transformedThreshold
	}

	return transformed, nil
}

func expandMonitoringSloServiceLevelIndicatorBasicSliLatencyThreshold(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandMonitoringSloSloId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func resourceMonitoringSloEncoder(d *schema.ResourceData, meta interface{}, obj map[string]interface{}) (map[string]interface{}, error) {
	// Name/Service Level Objective ID is a query parameter and cannot
	// be given in data
	delete(obj, "sloId")
	return obj, nil
}
