/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

public class BasicAttributes
implements Attributes {
    private static final long serialVersionUID = 4980164073184639448L;
    private boolean ignoreCase;
    transient Vector attributes;

    public Object clone() {
        BasicAttributes ba = new BasicAttributes(this.ignoreCase);
        ba.attributes = (Vector)this.attributes.clone();
        return ba;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Attributes)) {
            return false;
        }
        Attributes bs = (Attributes)obj;
        if (this.ignoreCase != bs.isCaseIgnored() || this.attributes.size() != bs.size()) {
            return false;
        }
        NamingEnumeration bas = bs.getAll();
        while (bas.hasMoreElements()) {
            Attribute b;
            Attribute a = (Attribute)bas.nextElement();
            if (a.equals(b = this.get(a.getID()))) continue;
            return false;
        }
        return true;
    }

    public Attribute get(String attrID) {
        int i = 0;
        while (i < this.attributes.size()) {
            Attribute at = (Attribute)this.attributes.get(i);
            if (this.ignoreCase && attrID.equalsIgnoreCase(at.getID()) || !this.ignoreCase && attrID.equals(at.getID())) {
                return at;
            }
            ++i;
        }
        return null;
    }

    public NamingEnumeration getAll() {
        return new BasicAttributesEnumeration(false);
    }

    public NamingEnumeration getIDs() {
        return new BasicAttributesEnumeration(true);
    }

    public int hashCode() {
        int val = 0;
        int i = 0;
        while (i < this.attributes.size()) {
            val += this.attributes.get(i).hashCode();
            ++i;
        }
        return val;
    }

    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    public Attribute put(Attribute attr) {
        Attribute r = this.remove(attr.getID());
        this.attributes.add(attr);
        return r;
    }

    public Attribute put(String attrID, Object val) {
        return this.put(new BasicAttribute(attrID, val));
    }

    public Attribute remove(String attrID) {
        int i = 0;
        while (i < this.attributes.size()) {
            Attribute at = (Attribute)this.attributes.get(i);
            if (this.ignoreCase && attrID.equalsIgnoreCase(at.getID()) || !this.ignoreCase && attrID.equals(at.getID())) {
                this.attributes.remove(i);
                return at;
            }
            ++i;
        }
        return null;
    }

    public int size() {
        return this.attributes.size();
    }

    public String toString() {
        String r = "";
        int i = 0;
        while (i < this.attributes.size()) {
            if (i > 0) {
                r = r + "; ";
            }
            r = r + this.attributes.get(i).toString();
            ++i;
        }
        return r;
    }

    public BasicAttributes() {
        this(false);
    }

    public BasicAttributes(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.attributes = new Vector();
    }

    public BasicAttributes(String attrID, Object val) {
        this(attrID, val, false);
    }

    public BasicAttributes(String attrID, Object val, boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.attributes = new Vector();
        this.attributes.add(new BasicAttribute(attrID, val));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BasicAttributesEnumeration
    implements NamingEnumeration {
        int where;
        boolean id;

        public void close() throws NamingException {
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public boolean hasMoreElements() {
            boolean bl = false;
            if (this.where < BasicAttributes.this.attributes.size()) {
                bl = true;
            }
            return bl;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.where >= BasicAttributes.this.attributes.size()) {
                throw new NoSuchElementException("no more elements");
            }
            Attribute at = (Attribute)BasicAttributes.this.attributes.get(this.where);
            ++this.where;
            return this.id ? at.getID() : at;
        }

        private final /* synthetic */ void this() {
            this.where = 0;
        }

        public BasicAttributesEnumeration(boolean id) {
            this.this();
            this.id = id;
        }
    }
}

