/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.util.Clipboard;
import CH.ifa.draw.util.Command;
import java.util.Vector;

abstract class FigureTransferCommand
extends Command {
    protected DrawingView fView;

    protected FigureTransferCommand(String string, DrawingView drawingView) {
        super(string);
        this.fView = drawingView;
    }

    protected void deleteSelection() {
        this.fView.drawing().removeAll(this.fView.selection());
        this.fView.clearSelection();
    }

    protected void copySelection() {
        FigureSelection figureSelection = this.fView.getFigureSelection();
        Clipboard.getClipboard().setContents(figureSelection);
    }

    protected void insertFigures(Vector vector, int n, int n2) {
        FigureEnumerator figureEnumerator = new FigureEnumerator(vector);
        while (figureEnumerator.hasMoreElements()) {
            Figure figure = figureEnumerator.nextFigure();
            figure = this.fView.add(figure);
            this.fView.addToSelection(figure);
        }
        this.fView.moveSelection(n, n2);
    }
}

