/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class CropImageFilter
extends ImageFilter {
    int x;
    int y;
    int width;
    int height;

    public void setDimensions(int width, int height) {
        if (this.consumer != null) {
            this.consumer.setDimensions(this.width, this.height);
        }
    }

    public void setProperties(Hashtable props) {
        props.put("filters", "CropImageFilter");
        if (this.consumer != null) {
            this.consumer.setProperties(props);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        Rectangle filterBounds = new Rectangle(this.x, this.y, this.width, this.height);
        Rectangle pixelBounds = new Rectangle(x, y, w, h);
        if (filterBounds.intersects(pixelBounds)) {
            Rectangle bounds = filterBounds.intersection(pixelBounds);
            byte[] cropped = new byte[bounds.width * bounds.height];
            int i = 0;
            while (i < bounds.height) {
                int start = (bounds.y - pixelBounds.y + i) * scansize + offset;
                int j = 0;
                while (j < bounds.width) {
                    cropped[i * bounds.width + j] = pixels[start + bounds.x + j];
                    ++j;
                }
                ++i;
            }
            if (this.consumer != null) {
                this.consumer.setPixels(0, 0, bounds.width, bounds.height, model, cropped, 0, bounds.width);
            }
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        Rectangle filterBounds = new Rectangle(this.x, this.y, this.width, this.height);
        Rectangle pixelBounds = new Rectangle(x, y, w, h);
        if (filterBounds.intersects(pixelBounds)) {
            Rectangle bounds = filterBounds.intersection(pixelBounds);
            int[] cropped = new int[bounds.width * bounds.height];
            int i = 0;
            while (i < bounds.height) {
                int start = (bounds.y - pixelBounds.y + i) * scansize + offset;
                int j = 0;
                while (j < bounds.width) {
                    cropped[i * bounds.width + j] = pixels[start + bounds.x + j];
                    ++j;
                }
                ++i;
            }
            if (this.consumer != null) {
                this.consumer.setPixels(0, 0, bounds.width, bounds.height, model, cropped, 0, bounds.width);
            }
        }
    }

    public CropImageFilter(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }
}

