##
# Borges::ValueCallback is used by Borges::CallbackStore and
# Borges::HtmlRenderer to process form input values.

class Borges::ValueCallback < Borges::Callback

  ##
  # Creates a new ValueCallback with +block+.

  def initialize(&block)
    @block = block
  end

  ##
  # Runs this callback passing it +obj+, if it accepts it.

  def evaluate(value, store)
    if @block.arity == 1 then
      @block.call value
    else
      @block.call
    end
  end

  ##
  # Is this a ValueCallback?

  def value_callback?
    true
  end

end # class Borges::ValueCallback

