/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.NativeWrapper;
import gnu.java.awt.peer.qt.QtCanvasPeer;
import gnu.java.awt.peer.qt.QtContainerPeer;
import gnu.java.awt.peer.qt.QtFontMetrics;
import gnu.java.awt.peer.qt.QtFontPeer;
import gnu.java.awt.peer.qt.QtGraphics;
import gnu.java.awt.peer.qt.QtImage;
import gnu.java.awt.peer.qt.QtScrollPanePeer;
import gnu.java.awt.peer.qt.QtToolkit;
import gnu.java.awt.peer.qt.QtVolatileImage;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QtComponentPeer
extends NativeWrapper
implements ComponentPeer {
    protected static final int POPUP_TRIGGER = 3;
    protected QtToolkit toolkit;
    Component owner;
    private long eventMask;
    private boolean hasMotionListeners;
    protected QtImage backBuffer;
    protected long qtApp;
    private boolean settingUp;
    private boolean ignoreResize;

    protected native void callInit();

    protected void init() {
    }

    protected void setup() {
        this.settingUp = true;
        if (this.owner != null) {
            if (this.owner instanceof JComponent) {
                this.setBackground(this.owner.getBackground());
            } else {
                this.owner.setBackground(this.getNativeBackground());
            }
            if (this.owner.getForeground() != null) {
                this.setForeground(this.owner.getForeground());
            } else {
                this.setForeground(Color.black);
            }
            if (this.owner.getCursor() != null && this.owner.getCursor().getType() != 0) {
                this.setCursor(this.owner.getCursor());
            }
            if (this.owner.getFont() != null) {
                this.setFont(this.owner.getFont());
            }
            this.setEnabled(this.owner.isEnabled());
            this.backBuffer = null;
            this.updateBounds();
            this.setVisible(this.owner.isVisible());
            QtToolkit.repaintThread.queueComponent(this);
        }
        this.settingUp = false;
    }

    native void QtUpdate();

    native void QtUpdateArea(int var1, int var2, int var3, int var4);

    private final synchronized native void disposeNative();

    private final native void setGround(int var1, int var2, int var3, boolean var4);

    private final native void setBoundsNative(int var1, int var2, int var3, int var4);

    private final native void setCursor(int var1);

    private final native Color getNativeBackground();

    private final native void setFontNative(QtFontPeer var1);

    private final native int whichScreen();

    private final native void reparentNative(QtContainerPeer var1);

    private final native void getLocationOnScreenNative(Point var1);

    private final boolean drawableComponent() {
        boolean bl = false;
        if (this instanceof QtContainerPeer && !(this instanceof QtScrollPanePeer) || this instanceof QtCanvasPeer) {
            bl = true;
        }
        return bl;
    }

    void updateBounds() {
        Rectangle rectangle = this.owner.getBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    synchronized void updateBackBuffer(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (!this.drawableComponent() && this.backBuffer == null) {
            return;
        }
        if (this.backBuffer != null) {
            if (n < this.backBuffer.width && n2 < this.backBuffer.height) {
                return;
            }
            this.backBuffer.dispose();
        }
        this.backBuffer = new QtImage(n, n2);
    }

    protected void closeEvent() {
        if (this.owner instanceof Window) {
            WindowEvent windowEvent = new WindowEvent((Window)this.owner, 201);
            QtToolkit.eventQueue.postEvent(windowEvent);
        }
    }

    protected void enterEvent(int n, int n2, int n3, int n4) {
        MouseEvent mouseEvent = new MouseEvent(this.owner, 504, System.currentTimeMillis(), n & 0x2FF, n2, n3, 0, false);
        QtToolkit.eventQueue.postEvent(mouseEvent);
    }

    protected void focusInEvent() {
        FocusEvent focusEvent = new FocusEvent(this.owner, 1004);
        QtToolkit.eventQueue.postEvent(focusEvent);
    }

    protected void focusOutEvent() {
        FocusEvent focusEvent = new FocusEvent(this.owner, 1005);
        QtToolkit.eventQueue.postEvent(focusEvent);
    }

    protected void keyPressEvent(int n, int n2, int n3, int n4) {
        KeyEvent keyEvent;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (!keyboardFocusManager.dispatchEvent(keyEvent = new KeyEvent(this.owner, 401, System.currentTimeMillis(), n, n2, (char)(n3 & (char)-1), 0))) {
            QtToolkit.eventQueue.postEvent(keyEvent);
        }
    }

    protected void keyReleaseEvent(int n, int n2, int n3, int n4) {
        KeyEvent keyEvent = new KeyEvent(this.owner, 402, System.currentTimeMillis(), n, n2, (char)(n3 & (char)-1), 0);
        QtToolkit.eventQueue.postEvent(keyEvent);
    }

    protected void leaveEvent(int n, int n2, int n3, int n4) {
        MouseEvent mouseEvent = new MouseEvent(this.owner, 505, System.currentTimeMillis(), n & 0x2FF, n2, n3, 0, false);
        QtToolkit.eventQueue.postEvent(mouseEvent);
    }

    protected void mouseDoubleClickEvent(int n, int n2, int n3, int n4) {
        if ((this.eventMask & 0x10L) == 0L) {
            return;
        }
        int n5 = 0;
        if ((n & 0x400) == 1024) {
            n5 = 1;
        }
        if ((n & 0x800) == 2048) {
            n5 = 2;
        }
        if ((n & 0x1000) == 4096) {
            n5 = 3;
        }
        MouseEvent mouseEvent = new MouseEvent(this.owner, 500, System.currentTimeMillis(), n & 0x2FF, n2, n3, n4, false, n5);
        QtToolkit.eventQueue.postEvent(mouseEvent);
    }

    protected void mouseMoveEvent(int n, int n2, int n3, int n4) {
        if ((this.eventMask & 0x10L) == 0L) {
            return;
        }
        int n5 = 0;
        if ((n & 0x400) == 1024) {
            n5 = 1;
        }
        if ((n & 0x800) == 2048) {
            n5 = 2;
        }
        if ((n & 0x1000) == 4096) {
            n5 = 3;
        }
        int n6 = n5 != 0 ? 506 : 503;
        MouseEvent mouseEvent = new MouseEvent(this.owner, n6, System.currentTimeMillis(), n & 0x2FF, n2, n3, n4, false, n5);
        QtToolkit.eventQueue.postEvent(mouseEvent);
    }

    protected void mousePressEvent(int n, int n2, int n3, int n4) {
        if ((this.eventMask & 0x10L) == 0L) {
            return;
        }
        int n5 = 0;
        if ((n & 0x400) == 1024) {
            n5 = 1;
        }
        if ((n & 0x800) == 2048) {
            n5 = 2;
        }
        if ((n & 0x1000) == 4096) {
            n5 = 3;
        }
        long l = System.currentTimeMillis();
        boolean bl = false;
        if (n5 == 3) {
            bl = true;
        }
        MouseEvent mouseEvent = new MouseEvent(this.owner, 501, l, n & 0x2FF, n2, n3, n4, bl, n5);
        QtToolkit.eventQueue.postEvent(mouseEvent);
    }

    protected void mouseReleaseEvent(int n, int n2, int n3, int n4) {
        if ((this.eventMask & 0x10L) == 0L) {
            return;
        }
        int n5 = 0;
        if ((n & 0x400) == 1024) {
            n5 = 1;
        }
        if ((n & 0x800) == 2048) {
            n5 = 2;
        }
        if ((n & 0x1000) == 4096) {
            n5 = 3;
        }
        MouseEvent mouseEvent = new MouseEvent(this.owner, 502, System.currentTimeMillis(), n & 0x2FF, n2, n3, n4, false, n5);
        QtToolkit.eventQueue.postEvent(mouseEvent);
    }

    protected void moveEvent(int n, int n2, int n3, int n4) {
        if (!this.ignoreResize) {
            this.ignoreResize = true;
            this.owner.setLocation(n, n2);
            this.ignoreResize = false;
        }
    }

    protected void resizeEvent(int n, int n2, int n3, int n4) {
        if (!(this.owner instanceof Window)) {
            return;
        }
        this.updateBackBuffer(n3, n4);
        this.ignoreResize = true;
        this.owner.setSize(n3, n4);
        this.ignoreResize = false;
        ComponentEvent componentEvent = new ComponentEvent(this.owner, 101);
        QtToolkit.eventQueue.postEvent(componentEvent);
        QtToolkit.repaintThread.queueComponent(this);
    }

    protected void showEvent() {
        if (this.owner instanceof Window) {
            WindowEvent windowEvent = new WindowEvent((Window)this.owner, 200);
            QtToolkit.eventQueue.postEvent(windowEvent);
        } else {
            ComponentEvent componentEvent = new ComponentEvent(this.owner, 102);
            QtToolkit.eventQueue.postEvent(componentEvent);
        }
    }

    protected void hideEvent() {
        ComponentEvent componentEvent = new ComponentEvent(this.owner, 103);
        QtToolkit.eventQueue.postEvent(componentEvent);
    }

    public void setEventMask(long l) {
        this.eventMask = l;
    }

    public boolean canDetermineObscurity() {
        return true;
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.toolkit.checkImage(image, n, n2, imageObserver);
    }

    public void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
    }

    public Image createImage(ImageProducer imageProducer) {
        return this.toolkit.createImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        return new QtImage(n, n2);
    }

    public void coalescePaintEvent(PaintEvent paintEvent) {
    }

    public VolatileImage createVolatileImage(int n, int n2) {
        return new QtVolatileImage(n, n2);
    }

    public void destroyBuffers() {
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void dispose() {
        this.disposeNative();
        if (this.backBuffer != null) {
            this.backBuffer.dispose();
        }
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void finalize() {
        this.dispose();
    }

    public void flip(BufferCapabilities.FlipContents flipContents) {
    }

    public Image getBackBuffer() {
        return this.backBuffer;
    }

    public ColorModel getColorModel() {
        return this.toolkit.getColorModel();
    }

    public FontMetrics getFontMetrics(Font font) {
        return new QtFontMetrics(font, this.getGraphics());
    }

    public Graphics getGraphics() {
        if (this.backBuffer == null) {
            Rectangle rectangle = this.owner.getBounds();
            this.backBuffer = new QtImage(rectangle.width, rectangle.height);
        }
        return this.backBuffer.getDirectGraphics(this);
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        int n = this.whichScreen();
        GraphicsDevice[] graphicsDeviceArray = QtToolkit.graphicsEnv.getScreenDevices();
        return graphicsDeviceArray[n].getDefaultConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Point getLocationOnScreen() {
        Point point = new Point();
        Point point2 = point;
        synchronized (point2) {
            this.getLocationOnScreenNative(point);
            try {
                point.wait();
            }
            catch (InterruptedException interruptedException) {}
            return point;
        }
    }

    private final native void getSizeNative(Dimension var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Dimension getSize(boolean bl) {
        Dimension dimension = new Dimension();
        Dimension dimension2 = dimension;
        synchronized (dimension2) {
            this.getSizeNative(dimension, bl);
            try {
                dimension.wait();
            }
            catch (InterruptedException interruptedException) {}
            return dimension;
        }
    }

    public Dimension getMinimumSize() {
        return this.getSize(false);
    }

    public Dimension getPreferredSize() {
        return this.getSize(true);
    }

    public Toolkit getToolkit() {
        return this.toolkit;
    }

    public native boolean handlesWheelScrolling();

    public void hide() {
        this.setVisible(false);
    }

    public native boolean isFocusable();

    public boolean isFocusTraversable() {
        return false;
    }

    public native boolean isObscured();

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public native void requestFocus();

    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l) {
        return true;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public void setBackground(Color color) {
        if (color == null && !this.settingUp) {
            return;
        }
        this.setGround(color.getRed(), color.getGreen(), color.getBlue(), false);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.ignoreResize) {
            return;
        }
        this.updateBackBuffer(n3, n4);
        QtToolkit.repaintThread.queueComponent(this);
        this.setBoundsNative(n, n2, n3, n4);
    }

    public void setCursor(Cursor cursor) {
        if (cursor != null) {
            this.setCursor(cursor.getType());
        }
    }

    public native void setEnabled(boolean var1);

    public void setFont(Font font) {
        if (font == null || font.getPeer() == null) {
            throw new IllegalArgumentException("Null font.");
        }
        this.setFontNative((QtFontPeer)font.getPeer());
    }

    public void setForeground(Color color) {
        if (color == null && !this.settingUp) {
            return;
        }
        this.setGround(color.getRed(), color.getGreen(), color.getBlue(), true);
    }

    public native void setVisible(boolean var1);

    public void show() {
        this.setVisible(true);
    }

    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        switch (n) {
            case 102: {
                QtToolkit.repaintThread.queueComponent(this);
                break;
            }
            case 800: 
            case 801: {
                Rectangle rectangle = ((PaintEvent)aWTEvent).getUpdateRect();
                QtToolkit.repaintThread.queueComponent(this, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                break;
            }
            case 401: {
                break;
            }
            case 402: {
                break;
            }
        }
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (this.backBuffer != null) {
            this.backBuffer.drawPixelsScaledFlipped((QtGraphics)graphics, 0, 0, 0, false, false, rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
    }

    public void paintBackBuffer() throws InterruptedException {
        if (this.backBuffer != null) {
            this.backBuffer.clear();
            Graphics2D graphics2D = (Graphics2D)this.backBuffer.getGraphics();
            this.owner.paint(graphics2D);
            graphics2D.dispose();
        }
    }

    public void paintBackBuffer(int n, int n2, int n3, int n4) throws InterruptedException {
        if (this.backBuffer != null) {
            Graphics2D graphics2D = (Graphics2D)this.backBuffer.getGraphics();
            graphics2D.setBackground(this.getNativeBackground());
            graphics2D.clearRect(n, n2, n3, n4);
            graphics2D.setClip(n, n2, n3, n4);
            this.owner.paint(graphics2D);
            graphics2D.dispose();
        }
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.toolkit.prepareImage(image, n, n2, imageObserver);
    }

    public void print(Graphics graphics) {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (l <= 0L) {
            QtToolkit.repaintThread.queueComponent(this, n, n2, n3, n4);
            return;
        }
        Timer timer = new Timer();
        timer.schedule((TimerTask)new RepaintTimerTask(this, n, n2, n3, n4), l);
    }

    public void updateCursorImmediately() {
        if (this.owner.getCursor() != null) {
            this.setCursor(this.owner.getCursor().getType());
        }
    }

    public native Rectangle getBounds();

    public void reparent(ContainerPeer containerPeer) {
        if (!(containerPeer instanceof QtContainerPeer)) {
            throw new IllegalArgumentException("Illegal peer.");
        }
        this.reparentNative((QtContainerPeer)containerPeer);
    }

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
    }

    public boolean isReparentSupported() {
        return true;
    }

    public void layout() {
    }

    private final /* synthetic */ void this() {
        this.ignoreResize = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    QtComponentPeer(QtToolkit qtToolkit, Component component) {
        this.this();
        this.owner = component;
        this.toolkit = qtToolkit;
        this.qtApp = QtToolkit.guiThread.QApplicationPointer;
        this.nativeObject = 0L;
        QtComponentPeer qtComponentPeer = this;
        synchronized (qtComponentPeer) {
            this.callInit();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
            this.setup();
            this.hasMotionListeners = false;
            return;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RepaintTimerTask
    extends TimerTask {
        private int x;
        private int y;
        private int w;
        private int h;
        private QtComponentPeer peer;

        public void run() {
            QtToolkit.repaintThread.queueComponent(this.peer, this.x, this.y, this.w, this.h);
        }

        RepaintTimerTask(QtComponentPeer qtComponentPeer2, int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.peer = qtComponentPeer2;
        }
    }
}

