/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.wiztools.restclient.ui.EscapableDialog;
import org.wiztools.restclient.ui.RESTUserInterface;

class MessageDialog
extends EscapableDialog {
    private final MessageDialog messageDialog;
    private RESTUserInterface ui;
    private JTextArea jta_error;
    private JButton jb_ok;

    @Inject
    public MessageDialog(RESTUserInterface ui) {
        super((Frame)ui.getFrame(), true);
        this.ui = ui;
        this.setTitle("Error!");
        this.initComponents();
        this.messageDialog = this;
    }

    private void initComponents() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        this.jta_error = new JTextArea(10, 40);
        this.jta_error.setEditable(false);
        JScrollPane jsp = new JScrollPane(this.jta_error);
        jp.add((Component)jsp, "Center");
        JPanel jp_south = new JPanel();
        jp_south.setLayout(new FlowLayout(1));
        this.jb_ok = new JButton("Ok");
        this.jb_ok.setMnemonic('o');
        this.getRootPane().setDefaultButton(this.jb_ok);
        this.jb_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MessageDialog.this.jb_okActionPerformed(event);
            }
        });
        jp_south.add(this.jb_ok);
        jp.add((Component)jp_south, "South");
        this.setContentPane(jp);
        this.pack();
    }

    @Override
    public void doEscape(AWTEvent event) {
        this.hideDialog();
    }

    private void jb_okActionPerformed(ActionEvent evt) {
        this.hideDialog();
    }

    private void hideDialog() {
        this.messageDialog.setVisible(false);
    }

    void showError(String error) {
        this.showMessage("Error", error);
    }

    void showMessage(String title, String message) {
        this.messageDialog.setTitle(title);
        this.jta_error.setText(message);
        this.jta_error.setCaretPosition(0);
        this.messageDialog.setLocationRelativeTo(this.ui.getFrame());
        this.jb_ok.requestFocus();
        this.messageDialog.setVisible(true);
    }
}

