/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.persistence;

import java.io.File;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.Versions;
import org.wiztools.restclient.bean.CookieVersion;
import org.wiztools.restclient.bean.HTTPMethod;
import org.wiztools.restclient.bean.HTTPVersion;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.RequestBean;
import org.wiztools.restclient.bean.Response;
import org.wiztools.restclient.bean.ResponseBean;
import org.wiztools.restclient.bean.TestResultBean;
import org.wiztools.restclient.persistence.PersistenceException;
import org.wiztools.restclient.persistence.PersistenceRead;
import org.wiztools.restclient.persistence.XMLException;
import org.wiztools.restclient.persistence.XmlAuthUtil;
import org.wiztools.restclient.persistence.XmlBodyRead;
import org.wiztools.restclient.persistence.XmlSslUtil;
import org.wiztools.restclient.util.Util;

public class XmlPersistenceRead
implements PersistenceRead {
    private String readVersion;

    public void setReadVersion(String version) {
        this.readVersion = version;
    }

    private Map<String, String> getHeadersFromHeaderNode(Element node) throws XMLException {
        LinkedHashMap<String, String> m3 = new LinkedHashMap<String, String>();
        for (int i = 0; i < node.getChildElements().size(); ++i) {
            Element headerElement = node.getChildElements().get(i);
            if (!"header".equals(headerElement.getQualifiedName())) {
                throw new XMLException("<headers> element should contain only <header> elements");
            }
            m3.put(headerElement.getAttributeValue("key"), headerElement.getAttributeValue("value"));
        }
        return m3;
    }

    private List<HttpCookie> getCookiesFromCookiesNode(Element node) throws XMLException {
        ArrayList<HttpCookie> out = new ArrayList<HttpCookie>();
        for (int i = 0; i < node.getChildElements().size(); ++i) {
            Element e = node.getChildElements().get(i);
            if (!"cookie".equals(e.getQualifiedName())) {
                throw new XMLException("<cookies> element should contain only <cookie> elements");
            }
            HttpCookie cookie = new HttpCookie(e.getAttributeValue("name"), e.getAttributeValue("value"));
            String cookieVerStr = e.getAttributeValue("version");
            if (StringUtil.isNotEmpty(cookieVerStr)) {
                cookie.setVersion(Integer.parseInt(cookieVerStr));
            } else {
                cookie.setVersion(CookieVersion.DEFAULT_VERSION.getIntValue());
            }
            out.add(cookie);
        }
        return out;
    }

    protected Request getRequestBean(Element requestNode) throws MalformedURLException, XMLException {
        RequestBean requestBean = new RequestBean();
        for (int i = 0; i < requestNode.getChildElements().size(); ++i) {
            Element tNode = requestNode.getChildElements().get(i);
            String nodeName = tNode.getQualifiedName();
            if ("http-version".equals(nodeName)) {
                String t = tNode.getValue();
                HTTPVersion httpVersion = "1.1".equals(t) ? HTTPVersion.HTTP_1_1 : HTTPVersion.HTTP_1_0;
                requestBean.setHttpVersion(httpVersion);
                continue;
            }
            if ("http-follow-redirects".equals(nodeName)) {
                requestBean.setFollowRedirect(true);
                continue;
            }
            if ("ignore-response-body".equals(nodeName)) {
                requestBean.setIgnoreResponseBody(true);
                continue;
            }
            if ("URL".equals(nodeName)) {
                URL url = new URL(tNode.getValue());
                requestBean.setUrl(url);
                continue;
            }
            if ("method".equals(nodeName)) {
                requestBean.setMethod(HTTPMethod.get(tNode.getValue()));
                continue;
            }
            if ("auth".equals(nodeName)) {
                requestBean.setAuth(XmlAuthUtil.getAuth(tNode));
                continue;
            }
            if ("ssl".equals(nodeName)) {
                requestBean.setSslReq(XmlSslUtil.getSslReq(tNode));
                continue;
            }
            if ("headers".equals(nodeName)) {
                Map<String, String> m3 = this.getHeadersFromHeaderNode(tNode);
                for (String key : m3.keySet()) {
                    requestBean.addHeader(key, m3.get(key));
                }
                continue;
            }
            if ("cookies".equals(nodeName)) {
                List<HttpCookie> cookies = this.getCookiesFromCookiesNode(tNode);
                for (HttpCookie cookie : cookies) {
                    requestBean.addCookie(cookie);
                }
                continue;
            }
            if ("body".equals(nodeName)) {
                XmlBodyRead bdUtl = new XmlBodyRead(this.readVersion);
                ReqEntity body = bdUtl.getReqEntity(tNode);
                requestBean.setBody(body);
                continue;
            }
            if ("test-script".equals(nodeName)) {
                requestBean.setTestScript(tNode.getValue());
                continue;
            }
            throw new XMLException("Invalid element encountered: <" + nodeName + ">");
        }
        return requestBean;
    }

    protected Request xml2Request(Document doc) throws MalformedURLException, XMLException {
        Element rootNode = doc.getRootElement();
        if (!"rest-client".equals(rootNode.getQualifiedName())) {
            throw new XMLException("Root node is not <rest-client>");
        }
        String rcVersion = rootNode.getAttributeValue("version");
        try {
            Versions.versionValidCheck(rcVersion);
        }
        catch (Versions.VersionValidationException ex) {
            throw new XMLException(ex);
        }
        this.readVersion = rcVersion;
        if (rootNode.getChildElements().size() != 1) {
            throw new XMLException("There can be only one child node for root node: <request>");
        }
        if (rootNode.getFirstChildElement("request") == null) {
            throw new XMLException("The child node of <rest-client> should be <request>");
        }
        Element requestNode = rootNode.getFirstChildElement("request");
        return this.getRequestBean(requestNode);
    }

    protected Response xml2Response(Document doc) throws XMLException {
        ResponseBean responseBean = new ResponseBean();
        Element rootNode = doc.getRootElement();
        if (!"rest-client".equals(rootNode.getQualifiedName())) {
            throw new XMLException("Root node is not <rest-client>");
        }
        try {
            Versions.versionValidCheck(rootNode.getAttributeValue("version"));
        }
        catch (Versions.VersionValidationException ex) {
            throw new XMLException(ex);
        }
        Element tNode = null;
        Element responseNode = null;
        if (rootNode.getChildElements().size() != 1) {
            throw new XMLException("There can be only one child node for root node: <response>");
        }
        if (rootNode.getFirstChildElement("response") == null) {
            throw new XMLException("The child node of <rest-client> should be <response>");
        }
        responseNode = rootNode.getFirstChildElement("response");
        for (int i = 0; i < responseNode.getChildElements().size(); ++i) {
            tNode = responseNode.getChildElements().get(i);
            String nodeName = tNode.getQualifiedName();
            if ("execution-time".equals(nodeName)) {
                responseBean.setExecutionTime(Long.parseLong(tNode.getValue()));
                continue;
            }
            if ("status".equals(nodeName)) {
                responseBean.setStatusLine(tNode.getValue());
                responseBean.setStatusCode(Integer.parseInt(tNode.getAttributeValue("code")));
                continue;
            }
            if ("headers".equals(nodeName)) {
                Map<String, String> m3 = this.getHeadersFromHeaderNode(tNode);
                for (String key : m3.keySet()) {
                    responseBean.addHeader(key, m3.get(key));
                }
                continue;
            }
            if ("body".equals(nodeName)) {
                String base64body = tNode.getValue();
                responseBean.setResponseBody(Util.base64decodeByteArray(base64body));
                continue;
            }
            if ("test-result".equals(nodeName)) {
                TestResultBean testResultBean = new TestResultBean();
                for (int j = 0; j < tNode.getChildCount(); ++j) {
                    String nn = tNode.getQualifiedName();
                    if ("run-count".equals(nn)) {
                        throw new XMLException("<headers> element should contain only <header> elements");
                    }
                    if ("failure-count".equals(nn)) {
                        throw new XMLException("<headers> element should contain only <header> elements");
                    }
                    if ("error-count".equals(nn)) {
                        throw new XMLException("<headers> element should contain only <header> elements");
                    }
                    if ("failures".equals(nn)) {
                        throw new XMLException("<headers> element should contain only <header> elements");
                    }
                    if (!"errors".equals(nn)) continue;
                    throw new XMLException("<headers> element should contain only <header> elements");
                }
                responseBean.setTestResult(testResultBean);
                continue;
            }
            throw new XMLException("Unrecognized element found: <" + nodeName + ">");
        }
        return responseBean;
    }

    protected Document getDocumentFromFile(File f) throws IOException, XMLException {
        try {
            Builder parser = new Builder();
            Document doc = parser.build(f);
            return doc;
        }
        catch (IOException | ParsingException ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
    }

    @Override
    public Request getRequestFromFile(File f) throws IOException, PersistenceException {
        Document doc = this.getDocumentFromFile(f);
        return this.xml2Request(doc);
    }

    @Override
    public Response getResponseFromFile(File f) throws IOException, PersistenceException {
        Document doc = this.getDocumentFromFile(f);
        return this.xml2Response(doc);
    }
}

