/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.io.Serializable;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TreePath
implements Serializable {
    static final long serialVersionUID = 4380036194768077479L;
    private Object[] path;

    public int hashCode() {
        return this.getLastPathComponent().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof TreePath) {
            Object[] objectArray = ((TreePath)object).getPath();
            if (objectArray.length != this.path.length) {
                return false;
            }
            int n = 0;
            while (n < this.path.length) {
                if (!objectArray[n].equals(this.path[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.path.length == 1) {
            return String.valueOf(this.path[0]);
        }
        return Arrays.asList(this.path).toString();
    }

    public Object[] getPath() {
        return (Object[])this.path.clone();
    }

    public Object getLastPathComponent() {
        return this.path[this.path.length - 1];
    }

    public int getPathCount() {
        return this.path.length;
    }

    public Object getPathComponent(int n) {
        if (n < 0 || n >= this.getPathCount()) {
            throw new IllegalArgumentException("Invalid position: " + n);
        }
        return this.path[n];
    }

    public boolean isDescendant(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        int n = this.getPathCount();
        if (treePath.getPathCount() < n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.path[n2].equals(treePath.getPathComponent(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public TreePath pathByAddingChild(Object object) {
        return new TreePath(this, object);
    }

    public TreePath getParentPath() {
        if (this.path.length <= 1) {
            return null;
        }
        return new TreePath(this.getPath(), this.path.length - 1);
    }

    private final /* synthetic */ void this() {
        this.path = null;
    }

    public TreePath(Object[] objectArray) {
        this.this();
        if (objectArray == null) {
            throw new IllegalArgumentException("Null 'path' not permitted.");
        }
        this.path = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, this.path, 0, objectArray.length);
    }

    public TreePath(Object object) {
        this.this();
        this.path = new Object[1];
        this.path[0] = object;
    }

    protected TreePath(TreePath treePath, Object object) {
        this.this();
        if (object == null) {
            throw new NullPointerException("Null 'element' argument.");
        }
        Object[] objectArray = treePath.getPath();
        this.path = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, this.path, 0, objectArray.length);
        this.path[objectArray.length] = object;
    }

    protected TreePath(Object[] objectArray, int n) {
        this.this();
        this.path = new Object[n];
        System.arraycopy(objectArray, 0, this.path, 0, n);
    }

    protected TreePath() {
        this.this();
        this.path = new Object[0];
    }
}

