/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.pipeline.NSFilter;
import gnu.xml.pipeline.PipelineFactory;
import gnu.xml.pipeline.TeeConsumer;
import gnu.xml.pipeline.ValidationConsumer;
import gnu.xml.pipeline.WellFormednessFilter;
import gnu.xml.util.Resolver;
import java.io.IOException;
import java.net.MalformedURLException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class DoParse {
    private static SAXParseException fatal;
    private static int errorCount;
    private static int fatalCount;

    public static final void main(String[] stringArray) throws IOException {
        int n = 1;
        if (stringArray.length != 2) {
            System.err.println("Usage: DoParse [filename|URL] pipeline-spec");
            System.err.println("Example pipeline specs:");
            System.err.println("  'nsfix | validate'");
            System.err.println("       ... restore namespace syntax, validate");
            System.err.println("  'nsfix | write ( stdout )'");
            System.err.println("       ... restore namespace syntax, write to stdout as XML");
            System.exit(1);
        }
        try {
            stringArray[0] = Resolver.getURL(stringArray[0]);
            InputSource inputSource = new InputSource(stringArray[0]);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            EventConsumer eventConsumer = PipelineFactory.createPipeline(stringArray[1]);
            xMLReader.setErrorHandler(new MyErrorHandler());
            EventFilter.bind(xMLReader, eventConsumer);
            xMLReader.parse(inputSource);
            try {
                if (xMLReader.getFeature("http://org.xml/sax/features/validation")) {
                    int n2 = 0;
                    if (errorCount + fatalCount > 0) {
                        n2 = 1;
                    }
                    n = n2;
                } else if (fatalCount == 0) {
                    n = 0;
                }
            }
            catch (SAXException sAXException) {
                if (DoParse.hasValidator(eventConsumer)) {
                    int n3 = 0;
                    if (errorCount + fatalCount > 0) {
                        n3 = 1;
                    }
                    n = n3;
                } else if (fatalCount == 0) {
                    n = 0;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("** Malformed URL: " + malformedURLException.getMessage());
            System.err.println("Is '" + stringArray[0] + "' a non-existent file?");
            malformedURLException.printStackTrace();
        }
        catch (SAXParseException sAXParseException) {
            if (sAXParseException != fatal) {
                System.err.print(DoParse.printParseException("Parsing Aborted", sAXParseException));
                sAXParseException.printStackTrace();
                if (sAXParseException.getException() != null) {
                    System.err.println("++ Wrapped exception:");
                    sAXParseException.getException().printStackTrace();
                }
            }
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.exit(n);
    }

    private static final boolean hasValidator(EventConsumer eventConsumer) {
        if (eventConsumer == null) {
            return false;
        }
        if (eventConsumer instanceof ValidationConsumer) {
            return true;
        }
        if (eventConsumer instanceof TeeConsumer) {
            TeeConsumer teeConsumer = (TeeConsumer)eventConsumer;
            boolean bl = false;
            if (DoParse.hasValidator(teeConsumer.getFirst()) || DoParse.hasValidator(teeConsumer.getRest())) {
                bl = true;
            }
            return bl;
        }
        if (eventConsumer instanceof WellFormednessFilter || eventConsumer instanceof NSFilter) {
            return DoParse.hasValidator(((EventFilter)eventConsumer).getNext());
        }
        return false;
    }

    private static final String printParseException(String string, SAXParseException sAXParseException) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("** ");
        stringBuffer.append(string);
        stringBuffer.append(": ");
        stringBuffer.append(sAXParseException.getMessage());
        stringBuffer.append('\n');
        if (sAXParseException.getSystemId() != null) {
            stringBuffer.append("   URI:  ");
            stringBuffer.append(sAXParseException.getSystemId());
            stringBuffer.append('\n');
        }
        if ((n = sAXParseException.getLineNumber()) != -1) {
            stringBuffer.append("   line: ");
            stringBuffer.append(n);
            stringBuffer.append('\n');
        }
        if ((n = sAXParseException.getColumnNumber()) != -1) {
            stringBuffer.append("   char: ");
            stringBuffer.append(n);
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private DoParse() {
    }

    static class MyErrorHandler
    implements ErrorHandler {
        public void error(SAXParseException sAXParseException) throws SAXParseException {
            errorCount = errorCount + 1;
            System.err.print(DoParse.printParseException("Error", sAXParseException));
        }

        public void warning(SAXParseException sAXParseException) throws SAXParseException {
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            fatalCount = fatalCount + 1;
            if (fatal == null) {
                fatal = sAXParseException;
            }
            System.err.print(DoParse.printParseException("Nonrecoverable Error", sAXParseException));
        }

        MyErrorHandler() {
        }
    }
}

