/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5TimeUnit;

public class HDF5TimeDuration {
    private final long duration;
    private final HDF5TimeUnit timeUnit;

    public HDF5TimeDuration(long duration, HDF5TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    @Deprecated
    public long getDuration() {
        return this.duration;
    }

    public long getValue() {
        return this.duration;
    }

    public long getValue(HDF5TimeUnit targetUnit) {
        return targetUnit == this.timeUnit ? this.duration : targetUnit.convert(this.duration, this.timeUnit);
    }

    public HDF5TimeUnit getUnit() {
        return this.timeUnit;
    }

    public boolean isEquivalent(HDF5TimeDuration that) {
        if (this.timeUnit == that.timeUnit) {
            return this.duration == that.duration;
        }
        return this.timeUnit.convert(that) == this.duration;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (this.timeUnit == null ? 0 : this.timeUnit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDF5TimeDuration other = (HDF5TimeDuration)obj;
        if (this.duration != other.duration) {
            return false;
        }
        return this.timeUnit == other.timeUnit;
    }

    public String toString() {
        return String.valueOf(Long.toString(this.duration)) + " " + this.timeUnit.toString();
    }
}

