/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C)  (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/
// read and write grind.dat (the configuration file)

package GoGrinder;

import java.io.*;
import java.awt.*;
import java.util.*;
import java.nio.charset.Charset;
import javax.swing.JOptionPane;

import GoGrinder.Main;
import GoGrinder.FileWorks;
import GoGrinder.ExceptionHandler;

/**
 *
 * @author  tkington
 * @author  Ruediger Klehn
 */
// GS = GrinderSettings; this is the interchange place for all user influenced 
// settings; at startup we have the presets for the settings, read in the sgf 
// collection, load old and new settings, and save them on program's end
public class GS {
    private GS() { /* This is a singleton */ }
    public static void GS(boolean dummy){/* Nothing */}
    
    private static final int REVISION = 9;
    private static Rectangle probFrameBounds = new Rectangle(0, 0, 580, 603); // position and mindest size for ProbFrame ...
    private static Rectangle windowedBounds = new Rectangle(0, 0, 580, 603); // newSettings, just the default for ProbFrame ...
    private static Rectangle wgfFrameBounds = new Rectangle(0, 0, 580, 603); // and WGFFrame when starting without grind.dat
    private static Selection selSets = new Selection(); // needs Messages initialized // selection settings (with filter?) in grind.dat: 
    private static TagList tags = new TagList();        // needs Messages initialized // tags pool
    private static boolean autoAdvance = true;
    private static boolean flip = true;                  // flip / rotate board
    private static boolean flipColors = true;
    private static boolean showGhost = true;             // show a stone instead of the mouse pointer, when over the board
    private static boolean showWrongPath = true;        // wrong path signal when entering the wrong path
    private static boolean soundEnabled = true;
    private static boolean clickSoundEnabled = true;     // set stone sound
    private static boolean checkForUpdates = true; // this is set to false in Main
    private static boolean useProxy = false;
    private static String proxyHost = ""; //$NON-NLS-1$
    private static int proxyPort = 0;
    private static ProbCollection colls;  // is complete collection as read in at program's start; GS is only place for exchange info
    private static boolean probState = true;             // is ProbFrame active? (else WGFFrame)
    private static int splitterPos = 381;   // in WGFFrame
    private static LinkedList history;      // files history of the WGF-editor
    private static File saveDir = new File(Main.USER_HOME); // last load/save directory, default = $HOME
    private static File sgfEditor; 
    private static boolean rightClickAdvance = true;

    private static String sgfEditor1Str = ""; // and later we kick File out
    private static String sgfEditor2Str = ""; // and later we kick File out
    private static boolean allowTextEdit = false;
    private static boolean show2ndEditorButton = false;
    private static boolean enableWGFEditor = false;
    private static boolean fullScreen = false;
    private static int windowStatusNoFullScreen = 0;
          // 0 = normal, 6 = MAXIMIZED_BOTH (2 = MAXIMIZED_HORIZ, 4 = MAXIMIZED_VERT, 1 = iconized)

    private static int sgfLogLevel = Main.parserLogLevel; 
     // 1 is default: filename + message (0 = file name only, 2 = + code example, 3 = + origin hint [~debug])
    private static long sgfLogWarnFileSize = 1000000; // if log is bigger, you get a warning
    private static long commonLogWarnFileSize = 1000000; // if log is bigger, you get a warning
    private static int sgfLogBufferSize = 10000; // collects the log strings while parsing a complete folder (validating)
    private static boolean parserAllowFF5 = false; // NOT YET: be ready for the future: try parsing FF5 or FF6
    private static boolean parserMoveDefectFile = false;
    private static long parserSGFMaxFileSize = Main.parserSGFMaxFileSize; // there is no sense to use Kogo's (or similar files) here
    private static String myDefaultCharset = Charset.defaultCharset().toString();
    private static boolean selectionOrderedDirs = true;
    
    private static final String NL = Main.NEW_LINE;
    
    //private static File pathToSettingsFileF;// = new File(Main.pathToSettingsFile);
    
    public static void loadSettings(){
      String msg = "";
      try {
        loadSettings(true);
        newLoadSettings();
      }
      catch (Exception e){ // the old loadSettings() can lead us here
          msg = Messages.getString("err_loading_settings") + NL
               + "File not found, not allowed to read file or no valid content: " + NL
               + "\"" + Main.settingsOldFilePath + "\"" + NL
               + "or \"" + Main.pathToSettingsFile + "\"" + NL + NL
               + "If this is your first start of MyGogrinder - don't bother!" + NL;
          if(Main.warningsStartup)
            JOptionPane.showMessageDialog(null, msg);
          if (!(e instanceof FileNotFoundException)) {
            ExceptionHandler.logCommonProblem(e, msg);
          }
      }
    }
    
    public static void loadSettings(boolean dummy) throws Exception { // load configuration from grind.dat
        // NOT YET: we will first try to read the mygrinder.ini ; when there is an error, we abort,
        // give a message and read instead the grind.dat (as long as it exists)
        if (!FileWorks.testFile(Main.settingsOldFilePath, true)){ // true: needWrite
          //if(Main.warningsStartup){
          //  JOptionPane.showMessageDialog(null, "Is there a problem with the settings file or folder? \n"
          //                                   + Main.settingsOldFilePath);
          //}
          return;
          // the defaults are already set at the top, so we will continue with those values
        }

        ObjectInputStream in = new ObjectInputStream(new FileInputStream(Main.settingsOldFilePath)); //$NON-NLS-1$
        String s = "";
        int rev = in.readInt();
        if(rev > REVISION) { // we check, if your GoGrinder tries to use a grind.dat of a newer GoGrinder version
                             // possible reason for a "downgrade": a newer version with a nerving bug or behaviour
            String msg = Messages.getString("err_data_file_newer") + ". Your Grinder uses revision number " + s.valueOf(REVISION) + ". " + NL
                                             + "The settings file (grind.dat) is revision number " + s.valueOf(rev) + ". " + NL
                                             + "Apparently the newer Grinder version doesn't work as you like." + NL
                                             + "Rename the grind.dat (to e.g. x-grind.dat) or delete it and restart your Grinder. " + NL 
                                             + NL
                                             + "If you want to preserve your tags pool, export all problems together (unfiltered) " + NL
                                             + "and reimport them. " + NL
                                             + "Voila! Your tags pool is back!"; //$NON-NLS-1$
            JOptionPane.showMessageDialog(null, msg);
            Main.logSilent(new Exception(msg));
            System.exit(-1);
        }

        probFrameBounds = (Rectangle)in.readObject(); 
        selSets = (Selection)in.readObject(); // ~ type changing on-the-fly,  ~ interprete as...
        tags = (TagList)in.readObject();
        autoAdvance = in.readBoolean(); // - why not here?? - possibly because of basic values (int, char, boolean, ...)
        flip = in.readBoolean();        // see docs/api/java/io/ObjectInputStream.html
        
        if(rev > 1) {
            flipColors = in.readBoolean();
            showGhost = in.readBoolean();
        }
        
        if(rev > 2)
            showWrongPath = in.readBoolean();
        
        if(rev > 3) {
            soundEnabled = in.readBoolean();
            clickSoundEnabled = in.readBoolean();
        }
        
        if(rev > 4) {
            checkForUpdates = in.readBoolean(); // order of read operations must be kept
            useProxy = in.readBoolean();
            proxyHost = (String)in.readObject();
            proxyPort = in.readInt();
            
            if(useProxy) {
                Properties sysProps = System.getProperties(); 
                sysProps.put( "proxySet", "true" ); //$NON-NLS-1$ //$NON-NLS-2$
                sysProps.put( "proxyHost", proxyHost); //$NON-NLS-1$
                sysProps.put( "proxyPort", String.valueOf(proxyPort)); //$NON-NLS-1$
            }
        }
        
        if(rev > 5) {
            probState = in.readBoolean();
            wgfFrameBounds = (Rectangle)in.readObject(); // type casting on-the-fly,  ~ interprete as...
            splitterPos = in.readInt();
            history = (LinkedList)in.readObject();
        }
        
        if(rev > 6) {
          File testSaveDir = (File)in.readObject();
          if (testSaveDir.exists()) // this is better, if we use Grinder as portable
        	  saveDir = testSaveDir;
        }
        
        if(rev > 7) {
        	sgfEditor = (File)in.readObject();
        }
        
        if(rev > 8) {
        	rightClickAdvance = in.readBoolean();
        }
        in.close();
    }
    
    public static void saveSettings(){
      String msg = "";
      try{
        saveSettings(true); // the boolean dummy is just because I wanted the saving old/new settings apart from the structure
        newSaveSettings();
      }
      catch (Exception e){
          msg = Messages.getString("err_saving_settings") + NL 
              + "Not allowed to write file, drive write protected or not connected or drive full: " + NL
              + "\"" + Main.settingsOldFilePath + "\"" + NL
              + " or \"" + Main.pathToSettingsFile + "\"" + NL;  // maybe the settings can show up here (without files)
          JOptionPane.showMessageDialog(null, msg);
          ExceptionHandler.logCommonProblem(e, msg);
      }
    }

    // save configuration to grind.dat // and NEW mygrinder.ini + tags.ini + collection.ini
    public static void saveSettings(boolean dummy) throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(Main.settingsOldFilePath)); //$NON-NLS-1$ 
                                        
        out.writeInt(REVISION);
        out.writeObject(probFrameBounds);
        out.writeObject(selSets);
        out.writeObject(tags);
        out.writeBoolean(autoAdvance);
        out.writeBoolean(flip);
        out.writeBoolean(flipColors);
        out.writeBoolean(showGhost);
        out.writeBoolean(showWrongPath);
        out.writeBoolean(soundEnabled);
        out.writeBoolean(clickSoundEnabled);
        out.writeBoolean(checkForUpdates);
        out.writeBoolean(useProxy);
        out.writeObject(proxyHost);
        out.writeInt(proxyPort);
        out.writeBoolean(probState);
        out.writeObject(wgfFrameBounds);
        out.writeInt(splitterPos);
        out.writeObject(history);
        out.writeObject(saveDir);
        out.writeObject(sgfEditor);
        out.writeBoolean(rightClickAdvance);
        
        out.close();
    }

      // we will not pass here, when the old settings file (grind.dat) couldn't be found
    public static void newLoadSettings() throws Exception { // public: Later I want to replace the old load settings routine
        int windowedWidth = 0; int windowedHeight = 0; int windowedX = 0; int windowedY = 0; 
        String[] linesInSettingsFile; // if "might not...": ... = null; solves this
        String msg = "";
        if (!FileWorks.testFile(Main.pathToSettingsFile, true)){ // true: needWrite
          //JOptionPane.showMessageDialog(null, "Is there a problem with the settings file or folder? \n"
          //                                   + Main.pathToSettingsFile);
          return;
          // the defaults are already set at the top, so we will continue with those values
        }
        if (new File(Main.pathToSettingsFile).length() < 1) return; // the defaults are already set at the top
        String firstLine = FileWReadWrite.readFileLineDefaultCharset(Main.pathToSettingsFile);
        if (firstLine.equals("# This file's encoding is utf-8")){ 
          linesInSettingsFile = FileWReadWrite.readFileLines(Main.pathToSettingsFile, "UTF-8");
          }
        else{ // MAKE BACKUP! z.B. FileWorksBackup.anyBackup(thisFile)
          linesInSettingsFile = FileWReadWrite.readFileLines(Main.pathToSettingsFile);
          FileWCpMv.backupSett(Main.pathToSettingsFile);
          FileWCpMv.backupLog(Main.sgfLogFilePath);
          FileWCpMv.backupLog(Main.commonLogFilePath);
          d.b.g("Beginning with this version we write settings and \n"
              + "log files with utf-8 encoding. Old logs and settings \n"
              + "are backed up in the settings folder.");
        }
        int linesCount = linesInSettingsFile.length;
        String[] lineParts = null;
        String line = "";
        for (int i = 0 ; i < linesCount ; i++) {
          line = linesInSettingsFile[i];
          if (line.equals("") || line.startsWith("#")){ // empty or comment
            continue;
          }
          lineParts = line.split("=", 2);
          if (lineParts.length == 1 || lineParts[1].equals("")) { 
            // line empty / without "=" OR no value
            // -> the values have a preset value, so it is no problem, 
            //      when a value is not in the list or without value
            continue;
          }
          lineParts[0] = lineParts[0].toLowerCase();
          try{
            switch (lineParts[0].charAt(0)){
              case 'e':
                if (lineParts[0].equals("editor1")){ // here is a problem: this is not written and read as unicode
                  sgfEditor1Str = lineParts[1];      // the problem: if in (e.g.) a Chinese system the program path 
                  break;                             // consists of unicode characters, they are only "???" in the ini file
                }
                if (lineParts[0].equals("editor2")){ // ... and unicode?
                  sgfEditor2Str = lineParts[1];
                  break;
                }
                if (lineParts[0].equals("editor2use")){
                  allowTextEdit = Boolean.valueOf(lineParts[1]); // boolean!
                  break;
                }
              case 'l':
                if (lineParts[0].equals("log.sgflog_buffersize")){sgfLogBufferSize = Integer.valueOf(lineParts[1]); break;}
                if (lineParts[0].equals("log.sgflog_level")){ // ###### WAS HAB ICH DA GEWOLLT ?? ######
                  sgfLogLevel = (!Main.parserLogLevelBySysVar) ? Integer.valueOf(lineParts[1]) : Main.parserLogLevel;
                  break;
                }
                if (lineParts[0].equals("log.sgflog_warn_filesize")){sgfLogWarnFileSize = Long.valueOf(lineParts[1]); break;}
                if (lineParts[0].equals("log.commonlog_warn_filesize")){commonLogWarnFileSize = Long.valueOf(lineParts[1]); break;}
              case 'm':
                if (lineParts[0].equals("main.debug2_sgf")){
                  if (Main.dbg2ToggledFromCLI){ // toggle temp!
                    Main.DEBUG2 = !Boolean.valueOf(lineParts[1]);
                    if (Main.DEBUG1)d.b.g("Toggled DEBUG2 (sfg, parser) to " + Main.DEBUG2);
                  }
                  else Main.DEBUG2 = Boolean.valueOf(lineParts[1]);
                  break;
                }
                if (lineParts[0].equals("main.debug4_contr")){
                  if (Main.dbg4ToggledFromCLI){ // toggle temp!
                    Main.DEBUG4 = !Boolean.valueOf(lineParts[1]);
                    if (Main.DEBUG1)d.b.g("Toggled DEBUG4 (sfg, controller, data) to " + Main.DEBUG4);
                  }
                  else Main.DEBUG4 = Boolean.valueOf(lineParts[1]);
                  break;
                }
              case 'p':
                if (lineParts[0].equals("parser.allow_ff5")){parserAllowFF5 = Boolean.valueOf(lineParts[1]); break;}
                if (lineParts[0].equals("parser.move_defect_file")){parserMoveDefectFile = Boolean.valueOf(lineParts[1]); break;}
                if (lineParts[0].equals("parser.sgf_max_filesize")){
                  parserSGFMaxFileSize = 
                    (Main.parserSGFMaxFileSize == 100000) ? Long.valueOf(lineParts[1]) : Main.parserSGFMaxFileSize; 
                  break;
                }
                if (lineParts[0].equals("prbframe.mydefault_charset")){
                  myDefaultCharset = CharsetWorks.getGenuineCharset(lineParts[1], false); // false: fromSGF
                    // if not a valid Charset, this gives ""
                  if (myDefaultCharset.equals("")){
                    myDefaultCharset = Charset.defaultCharset().toString();
                    msg = "While reading my default characterset from the .ini file:" + NL 
                        + "Textdecoding value not supported or invalid: \"" + lineParts[1] + "\"" + NL 
                        + "Using this machines default: " + myDefaultCharset;
                    d.b.g(msg);
                  }
                  break;
                }
                if (lineParts[0].equals("prbframe.height")){windowedHeight = Double.valueOf(lineParts[1]).intValue(); break;}
                if (lineParts[0].equals("prbframe.width")){windowedWidth = Double.valueOf(lineParts[1]).intValue(); break;}
                if (lineParts[0].equals("prbframe.x")){windowedX = Double.valueOf(lineParts[1]).intValue(); break;}
                if (lineParts[0].equals("prbframe.y")){windowedY = Double.valueOf(lineParts[1]).intValue(); break;}
                if (lineParts[0].equals("prbframe.fullscreen")){fullScreen = Boolean.valueOf(lineParts[1]); break;} 
                if (lineParts[0].equals("prbframe.show_2nd_editor_button")){ 
                                                     show2ndEditorButton = Boolean.valueOf(lineParts[1]); break;
                }
                if (lineParts[0].equals("prbframe.windowstatus")){
                  windowStatusNoFullScreen = Integer.valueOf(lineParts[1]); break;
                }
              case 's':
                if (lineParts[0].equals("select.ordered_dirs")){selectionOrderedDirs = Boolean.valueOf(lineParts[1]); break;}
              case 'w':
                if (lineParts[0].equals("wgfframe.height")){/*NOT YET*/; break;} // = Double.valueOf(...)
                if (lineParts[0].equals("wgfframe.width")){/*NOT YET*/; break;} // = Double.valueOf(...)
                if (lineParts[0].equals("wgfframe.x")){/*NOT YET*/; break;} // = Double.valueOf(...)
                if (lineParts[0].equals("wgfframe.y")){/*NOT YET*/; break;} // = Double.valueOf(...)
                if (lineParts[0].equals("wgfframe.history1")){/*NOT YET*/; break;}
                if (lineParts[0].equals("wgfframe.history2")){/*NOT YET*/; break;} // history 1...3 will be "first in - first out"
                if (lineParts[0].equals("wgfframe.history3")){/*NOT YET*/; break;}
                if (lineParts[0].equals("wgfframe.framesplitter")){/*splitterPos = Integer.valueOf(lineParts[1]);*/ break;} 
                if (lineParts[0].equals("wgfframe.enabled")){ 
                  enableWGFEditor = Boolean.valueOf(lineParts[1]); break;}
              case 'c':
                if (lineParts[0].equals("chorus")){/*...*/;}
              case 'd':
                if (lineParts[0].equals("dallas")){/*...*/;}
              case 'f':
                if (lineParts[0].equals("flutch")){/*...*/;}
              default:
                msg = lineParts[0] + ": not a usable identifier in settings file; read line was: " + NL
                     + linesInSettingsFile[i];
                System.out.println(msg);
                Main.logSilent (msg);
                //msg id + ": no usable identifier", log (linesInSettingsFile[i])
            }//switch lineParts[0]
          }
          catch (Exception e){
            msg = NL + " File = " + Main.pathToSettingsFile + NL + " Parse error in line " + (i+1) + ": " + NL
                 + linesInSettingsFile[i];
            JOptionPane.showMessageDialog(null, msg);
            ExceptionHandler.logCommonProblem(e, msg);
          }
        }//for linesCount
        if (windowedWidth < 50) windowedWidth = 500; if (windowedHeight < 50) windowedHeight = 600; // wormy!
        windowedBounds.setBounds(windowedX, windowedY, windowedWidth, windowedHeight);
        if (sgfEditor2Str.trim().length() < 2){
          allowTextEdit = false;
          show2ndEditorButton = false;
        } 
    }//meth newLoadSettings
    
    public static void newSaveSettings() throws Exception { // public: Later I want to replace the old save settings routine
        String NOT_YET = "NOT YET";
        // NL = \r\n - we use this to allow editing a settings file from e.g. a Linux install in Windows
        // apparently Linux has no problems in displaying a DOS/Windows text file
        // String commentUTF8 = "# Grinder 2.3.x+ will save the settings always with utf-8 encoding";
        // String warningEditThisFile = "# This is a utf-8 coded text file. If you edit this file - take care!";
        String commentEncodeing = "# This file's encoding is utf-8";
        String commentAddRemarks1 = "# Don't use this file for your own remarks, as it will be overwritten at program's end";
        String commentSGFLogLevel = "# sgf log level: 0 = file, 1 = + msg, 2 = + code, 3 = + Java origin";
        String commentParserMoveFile = "# PARSER.MOVE_DEFECT_FILE affects also move of files with unsupported features";
        String commentParserMoveFile2 = "# PARSER.MOVE_DEFECT_FILE deactivates EDITOR2USE (text edit of defect...)";
        // Comment lines begin with "#" and are ignored; also ignored are empty lines.
        // The order of entries is not important.
        // An entry is split at the first "=", e.g. EDITOR1=PATH/TO/editor
        StringBuffer writeSettStrBuff = new StringBuffer("");
        // writeSettStrBuff.append(commentUTF8 + NL);
        // writeSettStrBuff.append("THIS_FILE_HAS_ENCODING=utf-8" + NL)
        writeSettStrBuff.append(commentEncodeing + NL
                              + commentAddRemarks1 + NL + NL);
                             
        writeSettStrBuff.append("EDITOR1=" + sgfEditor1Str + NL);
        writeSettStrBuff.append("EDITOR2=" + sgfEditor2Str + NL);
        writeSettStrBuff.append("EDITOR2USE=" + Boolean.toString(allowTextEdit) + NL);

        writeSettStrBuff.append(NL + commentSGFLogLevel + NL + commentParserMoveFile2 + NL);
        writeSettStrBuff.append("LOG.SGFLOG_LEVEL=" + sgfLogLevel + NL);
        writeSettStrBuff.append("LOG.SGFLOG_WARN_FILESIZE=" + sgfLogWarnFileSize + NL);
        writeSettStrBuff.append("LOG.SGFLOG_BUFFERSIZE=" + sgfLogBufferSize + NL);
        writeSettStrBuff.append("LOG.COMMONLOG_WARN_FILESIZE=" + commonLogWarnFileSize + NL);
        writeSettStrBuff.append("MAIN.DEBUG2_SGF=" 
                               + Boolean.toString((Main.dbg2ToggledFromCLI) ? !Main.DEBUG2 : Main.DEBUG2) + NL);
        writeSettStrBuff.append("MAIN.DEBUG4_CONTR=" 
                               + Boolean.toString((Main.dbg4ToggledFromCLI) ? !Main.DEBUG4 : Main.DEBUG4) + NL);
        writeSettStrBuff.append("PARSER.ALLOW_FF5=" + Boolean.toString(parserAllowFF5) + NL);
        writeSettStrBuff.append(NL + commentParserMoveFile + NL + commentParserMoveFile2 + NL);
        writeSettStrBuff.append("PARSER.MOVE_DEFECT_FILE=" + Boolean.toString(parserMoveDefectFile) + NL);
        writeSettStrBuff.append("PARSER.SGF_MAX_FILESIZE=" + Long.toString(parserSGFMaxFileSize) + NL);
        writeSettStrBuff.append("PRBFRAME.MYDEFAULT_CHARSET=" + myDefaultCharset + NL);
        writeSettStrBuff.append("PRBFRAME.HEIGHT=" + windowedBounds.getHeight() + NL);
        writeSettStrBuff.append("PRBFRAME.WIDTH=" + windowedBounds.getWidth() + NL);
        writeSettStrBuff.append("PRBFRAME.X=" + windowedBounds.getX() + NL); // Var_name.toString()
        writeSettStrBuff.append("PRBFRAME.Y=" + windowedBounds.getY() + NL);
        writeSettStrBuff.append("PRBFRAME.WINDOWSTATUS=" + windowStatusNoFullScreen + NL);
        writeSettStrBuff.append("PRBFRAME.FULLSCREEN=" + Boolean.toString(fullScreen) + NL);
        writeSettStrBuff.append("PRBFRAME.SHOW_2ND_EDITOR_BUTTON=" + Boolean.toString(show2ndEditorButton) + NL);
        writeSettStrBuff.append("SELECT.ORDERED_DIRS=" + Boolean.toString(selectionOrderedDirs) + NL);
        writeSettStrBuff.append("WGFFRAME.ENABLED=" + Boolean.toString(enableWGFEditor) + NL);
        writeSettStrBuff.append("WGFFRAME.HEIGHT=" + NOT_YET + NL);
        writeSettStrBuff.append("WGFFRAME.WIDTH=" + NOT_YET + NL);
        writeSettStrBuff.append("WGFFRAME.X=" + NOT_YET + NL); // Var_name.toString()
        writeSettStrBuff.append("WGFFRAME.Y=" + NOT_YET + NL);
           
        /*
        */
        
        // why doesn't this test happen in FileWorks?
  //JOptionPane.showMessageDialog(null, pathToSettingsFileF.toString() + ">" + NL + Main.pathToSettingsFile);
        File pathToSettingsFileF = new File(Main.pathToSettingsFile);
        if (pathToSettingsFileF == null || // oops
           !pathToSettingsFileF.getParentFile().canWrite() || // folder: not allowed to write
            pathToSettingsFileF.isDirectory()){  // is directory
              String msg = "This shouldn't happen! - I cannot write " + Main.pathToSettingsFile;
              String stackTop = NL + "Happened where (~): " + new Exception().getStackTrace()[0];
              if (Main.TEST) msg = msg + stackTop;
              d.b.g(msg);
              System.out.println(msg);
              Main.logSilent(msg) ;
            }
            //Exception while removing reference. (sometimes; not clear, which circumstances) (connected to exit!)
        else {
          FileWReadWrite.writeFileStrBuff(Main.pathToSettingsFile, writeSettStrBuff, "UTF-8");
        }// write // )
        
        // datei pathtosettingsmygrinder.ini, sgfEditor2=..., allowTextEdit=...
    }
    
    public static Rectangle getProbFrameBounds() { return probFrameBounds; }
    public static void setProbFrameBounds(Rectangle b) { probFrameBounds = b; }
    public static Rectangle getWindowedBounds() { return windowedBounds; }
    public static void setWindowedBounds(Rectangle r) { windowedBounds = r; }
    public static Selection getSelectedSets() { return selSets; }
    public static void setSelection(Selection s) { selSets = s; } // ? not setSelectedSets() ?
    public static boolean getAutoAdv() { return autoAdvance; }
    public static void setAutoAdv(boolean a) { autoAdvance = a; }
    public static boolean getFlip() { return flip; }
    public static void setFlip(boolean f) { flip = f; }
    public static boolean getFlipColors() { return flipColors; }
    public static void setFlipColors(boolean f) { flipColors = f; }
    public static boolean getShowGhost() { return showGhost; }
    public static void setShowGhost(boolean s) { showGhost = s; }
    public static boolean getShowWrongPath() { return showWrongPath; }
    public static void setShowWrongPath(boolean s) { showWrongPath = s; }
    public static boolean getSoundEnabled() { return soundEnabled; }
    public static void setSoundEnabled(boolean e) { soundEnabled = e; }
    public static boolean getClickSoundEnabled() { return clickSoundEnabled; }
    public static void setClickSoundEnabled(boolean e) { clickSoundEnabled = e; }
    public static TagList getTagList() { return tags; }
    public static ProbCollection getCollections() { return colls; }
    public static void setCollections(ProbCollection c) { colls = c; }
    public static boolean getCheckForUpdates() { return checkForUpdates; }
    public static void setCheckForUpdates(boolean c) { checkForUpdates = c; }
    public static boolean getUseProxy() { return useProxy; }
    public static void setUseProxy(boolean u) { useProxy = u; }
    public static String getProxyHost() { return proxyHost; }
    public static void setProxyHost(String h) { proxyHost = h; }
    public static int getProxyPort() { return proxyPort; }
    public static void setProxyPort(int p) { proxyPort = p; }
    public static boolean getProbState() { return probState; }
    public static void setProbState(boolean b) { probState = b; }
    public static void setWGFFrameBounds(Rectangle r) { wgfFrameBounds = r; }
    public static Rectangle getWGFFrameBounds() { return wgfFrameBounds; }
    public static void setSplitterPos(int p) { splitterPos = p; }
    public static int getSplitterPos() { return splitterPos; }
    public static void setHistory(LinkedList h) { history = h; }
    public static LinkedList getHistory() { return history; }
    public static void setSaveDir(File d) { saveDir = d; }
    public static File getSaveDir() { return saveDir; }
    public static void setSGFEditor(File e) { sgfEditor = e; }
    public static File getSGFEditor() { return sgfEditor; }
    public static void setRightClickAdvance(boolean b) { rightClickAdvance = b; }
    public static boolean getRightClickAdvance() { return rightClickAdvance; }
    
    // #################### and the new values for mygrinder.ini
    public static void setSGFEditor1Str(String e) { sgfEditor1Str = e; }
    public static String getSGFEditor1Str() { return sgfEditor1Str; }
    public static void setSGFEditor2Str(String e) { sgfEditor2Str = e; }
    public static String getSGFEditor2Str() { return sgfEditor2Str; }
    public static void setAllowTextEdit(boolean a) { allowTextEdit = a; }
    public static boolean getAllowTextEdit() { return allowTextEdit; }
    public static void setShow2ndEditorButton(boolean s) { show2ndEditorButton = s; }
    public static boolean getShow2ndEditorButton() { return show2ndEditorButton; }
    public static void setEnableWGFEditor(boolean e) { enableWGFEditor = e; }
    public static boolean getEnableWGFEditor() { return enableWGFEditor; }
    public static void setFullScreen(boolean f) { fullScreen = f; }
    public static boolean getFullScreen() { return fullScreen; }
    public static void setWindowStatus(int s){ windowStatusNoFullScreen = s; }
    public static int getWindowStatus() {return windowStatusNoFullScreen;}
    public static void setSelectionOrderedDirs(boolean b) { selectionOrderedDirs = b; }
    public static boolean getSelectionOrderedDirs() { return selectionOrderedDirs; }
    public static void setMyDefaultCharset(String c){myDefaultCharset = c;}
    public static String getMyDefaultCharset(){return myDefaultCharset;}

    // #################### some new values for mygrinder.ini, which we cannot yet set in the settings window:
    // sgfLogLevel sgfLogWarnFileSize commonLogWarnFileSize sgfLogBufferSize
    // parserSGFMaxFileSize parserAllowFF5 parserMoveDefectFile
    public static void setSgfLogLevel(int s){ sgfLogLevel = s;}
    public static int getSgfLogLevel() {return sgfLogLevel;}
    public static void setSgfLogWarnFileSize(long s){sgfLogWarnFileSize = s;}
    public static long getSgfLogWarnFileSize() {return sgfLogWarnFileSize;}
    public static void setCommonLogWarnFileSize(long s){commonLogWarnFileSize = s;}
    public static long getCommonLogWarnFileSize() {return commonLogWarnFileSize;}
    public static void setSgfLogBufferSize(int s){sgfLogBufferSize = s;}
    public static int getSgfLogBufferSize() {return sgfLogBufferSize;}
    public static void setParserSGFMaxFileSize(long s){parserSGFMaxFileSize = s;}
    public static long getParserSGFMaxFileSize() {return parserSGFMaxFileSize;}
    public static void setParserAllowFF5(boolean s){parserAllowFF5 = s;}
    public static boolean getParserAllowFF5() {return parserAllowFF5;}
    public static void setParserMoveDefectFile(boolean s){parserMoveDefectFile = s;}
    public static boolean getParserMoveDefectFile() {return parserMoveDefectFile;}
}
