/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.VMStackWalker;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Class
implements Serializable {
    private int initializing_thread;
    private boolean erroneous_state;
    private Object[] signers;
    private final transient ProtectionDomain pd;
    final transient Object vmdata;
    private transient Constructor constructor;
    char primitiveType;
    private String name;
    private boolean isPrimitive;
    static /* synthetic */ Class class$java$lang$Cloneable;
    static /* synthetic */ Class class$java$io$Serializable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void initialize(int thread) throws InterruptedException {
        Error error;
        Class clazz = this;
        synchronized (clazz) {
            while (true) {
                if (this.initializing_thread == 0 || this.initializing_thread == thread) {
                    if (this.initializing_thread != thread) break;
                    return;
                }
                this.wait();
            }
            if (VMClass.isInitialized(this)) {
                return;
            }
            if (this.erroneous_state) {
                throw new NoClassDefFoundError();
            }
            this.initializing_thread = thread;
        }
        try {
            VMClass.step7(this);
        }
        catch (Error e) {
            Class clazz2 = this;
            synchronized (clazz2) {
                this.erroneous_state = true;
                this.initializing_thread = 0;
                this.notifyAll();
                throw e;
            }
        }
        try {
            VMClass.step8(this);
            Class e = this;
            synchronized (e) {
                VMClass.setInitialized(this);
                this.initializing_thread = 0;
                this.notifyAll();
                return;
            }
        }
        catch (Exception e) {
            try {
                error = new ExceptionInInitializerError(e);
            }
            catch (OutOfMemoryError e2) {
                error = e2;
            }
        }
        catch (Error e) {
            error = e;
        }
        clazz = this;
        synchronized (clazz) {
            this.erroneous_state = true;
            this.initializing_thread = 0;
            this.notifyAll();
            throw error;
        }
    }

    public static final Class forName(String name) throws ClassNotFoundException {
        Class result = VMClass.forName(name);
        if (result == null) {
            result = Class.forName(name, true, VMStackWalker.getCallingClassLoader());
        }
        return result;
    }

    public static final Class forName(String name, boolean initialize, ClassLoader classloader) throws ClassNotFoundException {
        if (name.charAt(0) == '[') {
            if (classloader == null) {
                Class cls = VMClassLoader.createArray(name, true);
                if (initialize) {
                    VMClassLoader.initializeClass(cls);
                }
                return cls;
            }
            return classloader.createArray(name, initialize);
        }
        if (classloader == null) {
            Class cls = VMClassLoader.loadClass(name, true);
            if (initialize) {
                VMClassLoader.initializeClass(cls);
            }
            return cls;
        }
        Class cls = classloader.loadClass(name, true);
        if (initialize) {
            VMClassLoader.initializeClass(cls);
        }
        return cls;
    }

    public final Class[] getClasses() {
        this.memberAccessCheck(0);
        return this.internalGetClasses();
    }

    private final Class[] internalGetClasses() {
        ArrayList list2 = new ArrayList();
        list2.addAll(Arrays.asList(this.getDeclaredClasses(true)));
        Class superClass = this.getSuperclass();
        if (superClass != null) {
            list2.addAll(Arrays.asList(superClass.internalGetClasses()));
        }
        return (Class[])list2.toArray(new Class[list2.size()]);
    }

    public final ClassLoader getClassLoader() {
        ClassLoader cl;
        if (this.isPrimitive()) {
            return null;
        }
        ClassLoader loader = VMClass.getClassLoader(this);
        SecurityManager sm = SecurityManager.current;
        if (sm != null && (cl = VMStackWalker.getCallingClassLoader()) != null && !cl.isAncestorOf(loader)) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return loader;
    }

    public final Class getComponentType() {
        if (this.isArray()) {
            try {
                String name = this.getName();
                switch (name.charAt(1)) {
                    case 'B': {
                        return Byte.TYPE;
                    }
                    case 'C': {
                        return Character.TYPE;
                    }
                    case 'D': {
                        return Double.TYPE;
                    }
                    case 'F': {
                        return Float.TYPE;
                    }
                    case 'I': {
                        return Integer.TYPE;
                    }
                    case 'J': {
                        return Long.TYPE;
                    }
                    case 'S': {
                        return Short.TYPE;
                    }
                    case 'Z': {
                        return Boolean.TYPE;
                    }
                    default: {
                        return null;
                    }
                    case '[': {
                        name = name.substring(1);
                        break;
                    }
                    case 'L': {
                        name = name.substring(2, name.length() - 1);
                    }
                }
                return Class.forName(name, false, this.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public final Constructor getConstructor(Class[] types) throws NoSuchMethodException {
        this.memberAccessCheck(0);
        Constructor[] constructors = this.getDeclaredConstructors(true);
        int i = 0;
        while (i < constructors.length) {
            Constructor constructor = constructors[i];
            if (Class.matchParameters(types, constructor.getParameterTypes())) {
                return constructor;
            }
            ++i;
        }
        throw new NoSuchMethodException();
    }

    public final Constructor[] getConstructors() {
        this.memberAccessCheck(0);
        return this.getDeclaredConstructors(true);
    }

    public final Constructor getDeclaredConstructor(Class[] types) throws NoSuchMethodException {
        this.memberAccessCheck(1);
        Constructor[] constructors = this.getDeclaredConstructors(false);
        int i = 0;
        while (i < constructors.length) {
            Constructor constructor = constructors[i];
            if (Class.matchParameters(types, constructor.getParameterTypes())) {
                return constructor;
            }
            ++i;
        }
        throw new NoSuchMethodException();
    }

    public final Class[] getDeclaredClasses() {
        this.memberAccessCheck(1);
        return this.getDeclaredClasses(false);
    }

    final Class[] getDeclaredClasses(boolean publicOnly) {
        if (this.isPrimitive() || this.isArray()) {
            return new Class[0];
        }
        return VMClass.getDeclaredClasses(this, publicOnly);
    }

    public final Constructor[] getDeclaredConstructors() {
        this.memberAccessCheck(1);
        return this.getDeclaredConstructors(false);
    }

    final Constructor[] getDeclaredConstructors(boolean publicOnly) {
        if (this.isPrimitive() || this.isArray() || this.isInterface()) {
            return new Constructor[0];
        }
        return VMClass.getDeclaredConstructors(this, publicOnly);
    }

    public final Field getDeclaredField(String name) throws NoSuchFieldException {
        this.memberAccessCheck(1);
        Field[] fields = this.getDeclaredFields(false);
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(name)) {
                return fields[i];
            }
            ++i;
        }
        throw new NoSuchFieldException();
    }

    public final Field[] getDeclaredFields() {
        this.memberAccessCheck(1);
        return this.getDeclaredFields(false);
    }

    final Field[] getDeclaredFields(boolean publicOnly) {
        if (this.isPrimitive() || this.isArray()) {
            return new Field[0];
        }
        return VMClass.getDeclaredFields(this, publicOnly);
    }

    public final Method getDeclaredMethod(String methodName, Class[] types) throws NoSuchMethodException {
        this.memberAccessCheck(1);
        Method match = Class.matchMethod(this.getDeclaredMethods(false), methodName, types);
        if (match == null) {
            throw new NoSuchMethodException(methodName);
        }
        return match;
    }

    public final Method[] getDeclaredMethods() {
        this.memberAccessCheck(1);
        return this.getDeclaredMethods(false);
    }

    final Method[] getDeclaredMethods(boolean publicOnly) {
        if (this.isPrimitive() || this.isArray()) {
            return new Method[0];
        }
        return VMClass.getDeclaredMethods(this, publicOnly);
    }

    public final Class getDeclaringClass() {
        return VMClass.getDeclaringClass(this);
    }

    public final Field getField(String fieldName) throws NoSuchFieldException {
        this.memberAccessCheck(0);
        Field field = this.internalGetField(fieldName);
        if (field == null) {
            throw new NoSuchFieldException(fieldName);
        }
        return field;
    }

    public final Field[] getFields() {
        this.memberAccessCheck(0);
        return this.internalGetFields();
    }

    private final Field[] internalGetFields() {
        HashSet set = new HashSet();
        set.addAll(Arrays.asList(this.getDeclaredFields(true)));
        Class[] interfaces = this.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            set.addAll(Arrays.asList(interfaces[i].internalGetFields()));
            ++i;
        }
        Class superClass = this.getSuperclass();
        if (superClass != null) {
            set.addAll(Arrays.asList(superClass.internalGetFields()));
        }
        return (Field[])set.toArray(new Field[set.size()]);
    }

    public final Package getPackage() {
        ClassLoader cl = this.getClassLoader();
        if (cl != null) {
            return cl.getPackage(Class.getPackagePortion(this.getName()));
        }
        return VMClassLoader.getPackage(Class.getPackagePortion(this.getName()));
    }

    public final Class[] getInterfaces() {
        if (this.isPrimitive()) {
            return new Class[0];
        }
        if (this.isArray()) {
            Class clazz;
            Class[] classArray = new Class[2];
            Class clazz2 = class$java$lang$Cloneable;
            if (clazz2 == null) {
                clazz2 = classArray[0] = (class$java$lang$Cloneable = Class.class("[Ljava.lang.Cloneable;", false));
            }
            if ((clazz = class$java$io$Serializable) == null) {
                clazz = class$java$io$Serializable = Class.class("[Ljava.io.Serializable;", false);
            }
            classArray[1] = clazz;
            return classArray;
        }
        return VMClass.getInterfaces(this);
    }

    public final Method getMethod(String methodName, Class[] types) throws NoSuchMethodException {
        this.memberAccessCheck(0);
        Method method = this.internalGetMethod(methodName, types);
        if (method == null) {
            throw new NoSuchMethodException(methodName);
        }
        return method;
    }

    private final Method internalGetMethod(String methodName, Class[] args) {
        Method match = Class.matchMethod(this.getDeclaredMethods(true), methodName, args);
        if (match != null) {
            return match;
        }
        Class superClass = this.getSuperclass();
        if (superClass != null && (match = superClass.internalGetMethod(methodName, args)) != null) {
            return match;
        }
        Class[] interfaces = this.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            match = interfaces[i].internalGetMethod(methodName, args);
            if (match != null) {
                return match;
            }
            ++i;
        }
        return null;
    }

    private static final Method matchMethod(Method[] list2, String name, Class[] args) {
        Method match = null;
        int i = 0;
        while (i < list2.length) {
            Method method = list2[i];
            if (method.getName().equals(name) && Class.matchParameters(args, method.getParameterTypes()) && (match == null || match.getReturnType().isAssignableFrom(method.getReturnType()))) {
                match = method;
            }
            ++i;
        }
        return match;
    }

    private static final boolean matchParameters(Class[] types1, Class[] types2) {
        if (types1 == null) {
            boolean bl = false;
            if (types2 == null || types2.length == 0) {
                bl = true;
            }
            return bl;
        }
        if (types2 == null) {
            boolean bl = false;
            if (types1 == null || types1.length == 0) {
                bl = true;
            }
            return bl;
        }
        if (types1.length != types2.length) {
            return false;
        }
        int i = 0;
        while (i < types1.length) {
            if (types1[i] != types2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final Method[] getMethods() {
        this.memberAccessCheck(0);
        return this.internalGetMethods();
    }

    private final Method[] internalGetMethods() {
        int i;
        Method[] methods;
        HashMap map = new HashMap();
        Class[] interfaces = this.getInterfaces();
        int i2 = 0;
        while (i2 < interfaces.length) {
            methods = interfaces[i2].internalGetMethods();
            int j = 0;
            while (j < methods.length) {
                map.put(new MethodKey(methods[j]), methods[j]);
                ++j;
            }
            ++i2;
        }
        Class superClass = this.getSuperclass();
        if (superClass != null) {
            methods = superClass.internalGetMethods();
            i = 0;
            while (i < methods.length) {
                map.put(new MethodKey(methods[i]), methods[i]);
                ++i;
            }
        }
        methods = this.getDeclaredMethods(true);
        i = 0;
        while (i < methods.length) {
            map.put(new MethodKey(methods[i]), methods[i]);
            ++i;
        }
        return (Method[])map.values().toArray(new Method[map.size()]);
    }

    public final int getModifiers() {
        return VMClass.getModifiers(this, false);
    }

    public final String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (!this.isPrimitive) {
            return VMClass.getName(this).replace('/', '.');
        }
        switch (this.primitiveType) {
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'V': {
                return "void";
            }
        }
        throw new InternalError("impossible control flow");
    }

    public final URL getResource(String resourceName) {
        String name = this.resourcePath(resourceName);
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            return ClassLoader.getSystemResource(name);
        }
        return loader.getResource(name);
    }

    public final InputStream getResourceAsStream(String resourceName) {
        String name = this.resourcePath(resourceName);
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            return ClassLoader.getSystemResourceAsStream(name);
        }
        return loader.getResourceAsStream(name);
    }

    private final String resourcePath(String resourceName) {
        if (resourceName.length() > 0) {
            if (resourceName.charAt(0) != '/') {
                String pkg = Class.getPackagePortion(this.getName());
                if (pkg.length() > 0) {
                    resourceName = pkg.replace('.', '/') + '/' + resourceName;
                }
            } else {
                resourceName = resourceName.substring(1);
            }
        }
        return resourceName;
    }

    public final Object[] getSigners() {
        return this.signers == null ? null : (Object[])this.signers.clone();
    }

    final void setSigners(Object[] signers) {
        this.signers = signers;
    }

    public final Class getSuperclass() {
        if (this.isPrimitive) {
            return null;
        }
        return VMClass.getSuperclass(this);
    }

    public final boolean isArray() {
        if (this.isPrimitive()) {
            return false;
        }
        boolean bl = false;
        if (this.getName().charAt(0) == '[') {
            bl = true;
        }
        return bl;
    }

    public final boolean isAssignableFrom(Class c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (this.isPrimitive() || c.isPrimitive()) {
            boolean bl = false;
            if (this == c) {
                bl = true;
            }
            return bl;
        }
        return VMClass.isAssignableFrom(this, c);
    }

    public final boolean isInstance(Object o) {
        if (this.isPrimitive() || o == null) {
            return false;
        }
        return VMClass.isInstance(this, o);
    }

    public final boolean isInterface() {
        if (this.isPrimitive()) {
            return false;
        }
        return VMClass.isInterface(this);
    }

    public final boolean isPrimitive() {
        return this.isPrimitive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object newInstance() throws InstantiationException, IllegalAccessException {
        block14: {
            this.memberAccessCheck(0);
            var2_1 = this;
            synchronized (var2_1) {
                constructor = this.constructor;
                // MONITOREXIT @DISABLED, blocks:[0, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var2_1
                if (constructor != null) break block14;
                constructors = this.getDeclaredConstructors(false);
                i = 0;
                if (true) ** GOTO lbl18
            }
            do {
                if (constructors[i].getParameterTypes().length == 0) {
                    constructor = constructors[i];
                    break;
                }
                ++i;
lbl18:
                // 2 sources

            } while (i < constructors.length);
            if (constructor == null) {
                throw new InstantiationException(this.getName());
            }
            if (!Modifier.isPublic(constructor.getModifiers()) || !Modifier.isPublic(VMClass.getModifiers(this, true))) {
                finalConstructor = constructor;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public final Object run() {
                        finalConstructor.setAccessible(true);
                        return null;
                    }
                });
            }
            finalConstructor = this;
            synchronized (finalConstructor) {
                if (this.constructor == null) {
                    this.constructor = constructor;
                }
            }
        }
        if (!(Modifier.isPublic(modifiers = constructor.getModifiers()) && Modifier.isPublic(VMClass.getModifiers(this, true)) || (caller = VMStackWalker.getCallingClass()) == null || caller == this || !Modifier.isPrivate(modifiers) && this.getClassLoader() == caller.getClassLoader() && Class.getPackagePortion(this.getName()).equals(Class.getPackagePortion(caller.getName())))) {
            throw new IllegalAccessException(this.getName() + " has an inaccessible constructor");
        }
        try {
            return constructor.newInstance(null);
        }
        catch (InvocationTargetException e) {
            VMClass.throwException(e.getTargetException());
            throw (InternalError)new InternalError("VMClass.throwException returned").initCause(e);
        }
    }

    public final ProtectionDomain getProtectionDomain() {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getProtectionDomain"));
        }
        return this.pd == null ? StaticData.unknownProtectionDomain : this.pd;
    }

    public final String toString() {
        if (this.isPrimitive()) {
            return this.getName();
        }
        return (this.isInterface() ? "interface " : "class ") + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean desiredAssertionStatus() {
        Object status;
        ClassLoader classLoader;
        ClassLoader c = this.getClassLoader();
        if (c == null) {
            return VMClassLoader.defaultAssertionStatus();
        }
        if (c.classAssertionStatus != null) {
            classLoader = c;
            synchronized (classLoader) {
                status = c.classAssertionStatus.get(this.getName());
                if (status != null) {
                    return status.equals(Boolean.TRUE);
                }
            }
        } else {
            status = ClassLoader.StaticData.systemClassAssertionStatus.get(this.getName());
            if (status != null) {
                return status.equals(Boolean.TRUE);
            }
        }
        if (c.packageAssertionStatus != null) {
            classLoader = c;
            synchronized (classLoader) {
                String name = Class.getPackagePortion(this.getName());
                if ("".equals(name)) {
                    status = c.packageAssertionStatus.get(null);
                } else {
                    do {
                        status = c.packageAssertionStatus.get(name);
                    } while (!"".equals(name = Class.getPackagePortion(name)) && status == null);
                }
                if (status != null) {
                    return status.equals(Boolean.TRUE);
                }
                return c.defaultAssertionStatus;
            }
        }
        String name = Class.getPackagePortion(this.getName());
        if ("".equals(name)) {
            status = ClassLoader.StaticData.systemPackageAssertionStatus.get(null);
        } else {
            do {
                status = ClassLoader.StaticData.systemPackageAssertionStatus.get(name);
            } while (!"".equals(name = Class.getPackagePortion(name)) && status == null);
        }
        if (status == null) return c.defaultAssertionStatus;
        return status.equals(Boolean.TRUE);
    }

    private final Field internalGetField(String name) {
        Field[] fields = this.getDeclaredFields(true);
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (field.getName().equals(name)) {
                return field;
            }
            ++i;
        }
        Class[] interfaces = this.getInterfaces();
        int i2 = 0;
        while (i2 < interfaces.length) {
            Field field = interfaces[i2].internalGetField(name);
            if (field != null) {
                return field;
            }
            ++i2;
        }
        Class superClass = this.getSuperclass();
        if (superClass != null) {
            return superClass.internalGetField(name);
        }
        return null;
    }

    private static final String getPackagePortion(String name) {
        int lastInd = name.lastIndexOf(46);
        if (lastInd == -1) {
            return "";
        }
        return name.substring(0, lastInd);
    }

    private final void memberAccessCheck(int which) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkMemberAccess(this, which);
            Package pkg = this.getPackage();
            if (pkg != null) {
                sm.checkPackageAccess(pkg.getName());
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    Class(Object vmdata, ProtectionDomain pd) {
        this.vmdata = vmdata;
        this.pd = pd;
    }

    private Class(char primitiveType) {
        this.primitiveType = primitiveType;
        this.isPrimitive = true;
        this.vmdata = null;
        this.pd = null;
    }

    private static final class MethodKey {
        private String name;
        private Class[] params;
        private Class returnType;
        private int hash;

        public final boolean equals(Object o) {
            if (o instanceof MethodKey) {
                MethodKey m = (MethodKey)o;
                if (m.name.equals(this.name) && m.params.length == this.params.length && m.returnType == this.returnType) {
                    int i = 0;
                    while (i < this.params.length) {
                        if (m.params[i] != this.params[i]) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }

        public final int hashCode() {
            return this.hash;
        }

        MethodKey(Method m) {
            this.name = m.getName();
            this.params = m.getParameterTypes();
            this.returnType = m.getReturnType();
            this.hash = this.name.hashCode() ^ this.returnType.hashCode();
            int i = 0;
            while (i < this.params.length) {
                this.hash ^= this.params[i].hashCode();
                ++i;
            }
        }
    }

    private static final class StaticData {
        static final ProtectionDomain unknownProtectionDomain;

        private StaticData() {
        }

        static {
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            unknownProtectionDomain = new ProtectionDomain(null, permissions);
        }
    }
}

