/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.prefs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NodeReader {
    private final BufferedReader br;
    private String line;
    private final PreferencesFactory factory;

    public void importPreferences() throws InvalidPreferencesFormatException, IOException {
        this.readPreferences();
    }

    private final void readPreferences() throws InvalidPreferencesFormatException, IOException {
        this.skipTill("<preferences");
        this.readRoot();
        this.skipTill("</preferences>");
    }

    private final void readRoot() throws InvalidPreferencesFormatException, IOException {
        Preferences root;
        this.skipTill("<root");
        this.skipTill("type=\"");
        String type = this.readTill("\"");
        if ("user".equals(type)) {
            root = this.factory.userRoot();
        } else if ("system".equals(type)) {
            root = this.factory.systemRoot();
        } else {
            throw new InvalidPreferencesFormatException("Unknown type: " + type);
        }
        this.readMap(root);
        this.readNodes(root);
        this.skipTill("</root>");
    }

    private final void readNodes(Preferences node2) throws InvalidPreferencesFormatException, IOException {
        while ("node".equals(this.nextTag())) {
            this.skipTill("<node");
            this.skipTill("name=\"");
            String name = this.readTill("\"");
            Preferences subnode = node2.node(name);
            System.out.println("Found subnode: " + subnode.absolutePath());
            this.readMap(subnode);
            this.readNodes(subnode);
            this.skipTill("</node>");
        }
    }

    private final void readMap(Preferences node2) throws InvalidPreferencesFormatException, IOException {
        this.skipTill("<map");
        if (this.line.startsWith("/>")) {
            this.line = this.line.substring(2);
            return;
        }
        this.readEntries(node2);
        this.skipTill("</map>");
    }

    private final void readEntries(Preferences node2) throws InvalidPreferencesFormatException, IOException {
        while ("entry".equals(this.nextTag())) {
            this.skipTill("<entry");
            this.skipTill("key=\"");
            String key = this.readTill("\"");
            this.skipTill("value=\"");
            String value = this.readTill("\"");
            System.out.println("Key: " + key + " Value: " + value);
            node2.put(key, value);
        }
    }

    private final void skipTill(String s) throws InvalidPreferencesFormatException, IOException {
        int index;
        while (true) {
            if (this.line == null) {
                throw new InvalidPreferencesFormatException(s + " not found");
            }
            index = this.line.indexOf(s);
            if (index != -1) break;
            this.line = this.br.readLine();
        }
        this.line = this.line.substring(index + s.length());
    }

    private final String readTill(String s) throws InvalidPreferencesFormatException {
        int index = this.line.indexOf(s);
        if (index == -1) {
            throw new InvalidPreferencesFormatException(s + " not found");
        }
        String read = this.line.substring(0, index);
        this.line = this.line.substring(index + s.length());
        return read;
    }

    private final String nextTag() throws InvalidPreferencesFormatException, IOException {
        int start;
        while (true) {
            if (this.line == null) {
                throw new InvalidPreferencesFormatException("unexpected EOF");
            }
            start = this.line.indexOf("<");
            if (start != -1) break;
            this.line = this.br.readLine();
        }
        int end = start + 1;
        while (end != this.line.length() && " \t\r\n".indexOf(this.line.charAt(end)) == -1) {
            ++end;
        }
        String tag = this.line.substring(start + 1, end);
        this.line = this.line.substring(start);
        return tag;
    }

    private final /* synthetic */ void this() {
        this.line = "";
    }

    public NodeReader(Reader r, PreferencesFactory factory) {
        this.this();
        this.br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        this.factory = factory;
    }

    public NodeReader(InputStream is, PreferencesFactory factory) {
        this(new InputStreamReader(is), factory);
    }
}

