//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 


#ifndef _ENDIANMESS_H
#define _ENDIANMESS_H

#include "libgpspoint_config.h"
#include "datatypes.h"


namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;


/// A Class to handle Endianess.
/**
 The Garmin Protocol uses little Endian. Mac OS-X and maybe others
 use BigEndian. This class can swap the bytes to the desired endianess if needed.
 This is done with the help of autotools and configuer when building the programm.
*/
class Endianmess
{

   protected:
/// this Funktion converts 16 bit Integer Host-Endianess to Little-Endian
/// on Little-Endian Machienes it does nothing
g_int htol16( g_int gi);
g_int ltoh16( g_int gi);
g_int h2l16( g_int gi);
g_int l2h16( g_int gi);

/// like htol16 but for 32 bit Integer
g_long htol32( g_long gl);
g_long ltoh32( g_long gl);
g_long h2l32( g_long gl);
g_long l2h32( g_long gl);

/// htol for float
float htolf(float f);
float ltohf(float f);
float h2lf(float f);
float l2hf(float f);

};

}
#endif

