/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Date;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509Certificate;

final class X509CertBridge
extends X509Certificate {
    private java.security.cert.X509Certificate cert;

    public final byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.cert.getEncoded();
        }
        catch (java.security.cert.CertificateEncodingException cee) {
            throw new CertificateEncodingException(cee.getMessage());
        }
    }

    public final void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.cert.verify(key);
        }
        catch (java.security.cert.CertificateException ce) {
            throw new CertificateException(ce.getMessage());
        }
    }

    public final void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.cert.verify(key, sigProvider);
        }
        catch (java.security.cert.CertificateException ce) {
            throw new CertificateException(ce.getMessage());
        }
    }

    public final String toString() {
        return this.cert.toString();
    }

    public final PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    public final void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        try {
            this.cert.checkValidity();
        }
        catch (java.security.cert.CertificateExpiredException cee) {
            throw new CertificateExpiredException(cee.getMessage());
        }
        catch (java.security.cert.CertificateNotYetValidException cnyve) {
            throw new CertificateNotYetValidException(cnyve.getMessage());
        }
    }

    public final void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        try {
            this.cert.checkValidity(date);
        }
        catch (java.security.cert.CertificateExpiredException cee) {
            throw new CertificateExpiredException(cee.getMessage());
        }
        catch (java.security.cert.CertificateNotYetValidException cnyve) {
            throw new CertificateNotYetValidException(cnyve.getMessage());
        }
    }

    public final int getVersion() {
        return this.cert.getVersion();
    }

    public final BigInteger getSerialNumber() {
        return this.cert.getSerialNumber();
    }

    public final Principal getIssuerDN() {
        return this.cert.getIssuerDN();
    }

    public final Principal getSubjectDN() {
        return this.cert.getSubjectDN();
    }

    public final Date getNotBefore() {
        return this.cert.getNotBefore();
    }

    public final Date getNotAfter() {
        return this.cert.getNotAfter();
    }

    public final String getSigAlgName() {
        return this.cert.getSigAlgName();
    }

    public final String getSigAlgOID() {
        return this.cert.getSigAlgOID();
    }

    public final byte[] getSigAlgParams() {
        return this.cert.getSigAlgParams();
    }

    X509CertBridge(java.security.cert.X509Certificate cert) {
        this.cert = cert;
    }
}

