/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.dom;

import gnu.xml.libxmlj.util.NamedInputStream;
import gnu.xml.libxmlj.util.StandaloneDocumentType;
import gnu.xml.libxmlj.util.StandaloneLocator;
import gnu.xml.libxmlj.util.XMLJ;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GnomeDocumentBuilder
extends DocumentBuilder
implements DOMImplementation {
    private boolean validate;
    private boolean coalesce;
    private boolean expandEntities;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private boolean seenFatalError;

    public DOMImplementation getDOMImplementation() {
        return this;
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public boolean isValidating() {
        return this.validate;
    }

    public Document newDocument() {
        return this.createDocument(null, null, null);
    }

    public Document parse(InputSource input) throws SAXException, IOException {
        NamedInputStream in = XMLJ.getInputStream(input);
        byte[] detectBuffer = in.getDetectBuffer();
        String publicId = input.getPublicId();
        String systemId = input.getSystemId();
        String base = XMLJ.getBaseURI(systemId);
        if (detectBuffer == null) {
            throw new SAXParseException("No document element", publicId, systemId, 0, 0);
        }
        this.seenFatalError = false;
        boolean bl = false;
        if (this.errorHandler != null) {
            bl = true;
        }
        return this.parseStream(in, detectBuffer, publicId, systemId, base, this.validate, this.coalesce, this.expandEntities, true, bl);
    }

    private final native Document parseStream(InputStream var1, byte[] var2, String var3, String var4, String var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10);

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public boolean hasFeature(String name, String version) {
        if (name.length() == 0) {
            return false;
        }
        if ((name = name.toLowerCase()).charAt(0) == '+') {
            name = name.substring(1);
        }
        if ("xml".equals(name) || "core".equals(name)) {
            boolean bl = false;
            if (version == null || "".equals(version) || "1.0".equals(version) || "2.0".equals(version) || "3.0".equals(version)) {
                bl = true;
            }
            return bl;
        }
        if ("ls".equals(name) || "ls-async".equals(name)) {
            return false;
        }
        if ("traversal".equals(name)) {
            boolean bl = false;
            if (version == null || "".equals(version) || "2.0".equals(version)) {
                bl = true;
            }
            return bl;
        }
        if ("xpath".equals(name)) {
            boolean bl = false;
            if (version == null || "".equals(version) || "3.0".equals(version)) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public Object getFeature(String feature, String version) {
        if (this.hasFeature(feature, version)) {
            return this;
        }
        return null;
    }

    public native Document createDocument(String var1, String var2, DocumentType var3);

    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
        return new StandaloneDocumentType(qualifiedName, publicId, systemId);
    }

    private final void setDocumentLocator(Object ctx, Object loc) {
    }

    private final InputStream resolveEntity(String publicId, String systemId, String base) throws SAXException, IOException {
        InputSource source;
        String url = XMLJ.getAbsoluteURI(base, systemId);
        NamedInputStream in = null;
        if (this.entityResolver != null && (source = this.entityResolver.resolveEntity(publicId, url)) != null) {
            in = XMLJ.getInputStream(source);
        }
        if (in == null) {
            in = XMLJ.getInputStream(new URL(url));
        }
        return in;
    }

    private final void warning(String message, int lineNumber, int columnNumber, String publicId, String systemId) throws SAXException {
        if (!this.seenFatalError && this.errorHandler != null) {
            StandaloneLocator l = new StandaloneLocator(lineNumber, columnNumber, publicId, systemId);
            this.errorHandler.warning(new SAXParseException(message, l));
        }
    }

    private final void error(String message, int lineNumber, int columnNumber, String publicId, String systemId) throws SAXException {
        if (!this.seenFatalError && this.errorHandler != null) {
            StandaloneLocator l = new StandaloneLocator(lineNumber, columnNumber, publicId, systemId);
            this.errorHandler.error(new SAXParseException(message, l));
        }
    }

    private final void fatalError(String message, int lineNumber, int columnNumber, String publicId, String systemId) throws SAXException {
        if (!this.seenFatalError && this.errorHandler != null) {
            this.seenFatalError = true;
            StandaloneLocator l = new StandaloneLocator(lineNumber, columnNumber, publicId, systemId);
            this.errorHandler.fatalError(new SAXParseException(message, l));
        }
    }

    public GnomeDocumentBuilder() {
        this(true, false, false);
    }

    public GnomeDocumentBuilder(boolean validate, boolean coalesce, boolean expandEntities) {
        this.validate = validate;
        this.coalesce = coalesce;
        this.expandEntities = expandEntities;
    }

    static {
        XMLJ.init();
    }
}

