/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqssl;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.KeyStoreType;
import org.wiztools.restclient.bean.SSLKeyStore;
import org.wiztools.restclient.bean.SSLKeyStoreBean;
import org.wiztools.restclient.ui.EscapableDialog;
import org.wiztools.restclient.ui.FileChooserType;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.dnd.DndAction;
import org.wiztools.restclient.ui.dnd.FileDropTargetListener;
import org.wiztools.restclient.ui.reqssl.KeyStoreListener;
import org.wiztools.restclient.ui.reqssl.StoreTypePanel;

public class KeyStoreDialog
extends EscapableDialog {
    @Inject
    private RESTUserInterface rest_ui;
    @Inject
    private RESTView view;
    private final List<KeyStoreListener> listeners = new ArrayList<KeyStoreListener>();
    private static final int auth_text_size = 20;
    private final StoreTypePanel jp_type = new StoreTypePanel();
    private final JTextField jtf_file = new JTextField(20);
    private final JButton jb_browse = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/load_from_file.png"));
    private final JPasswordField jpf_pwd = new JPasswordField(20);
    private final JButton jb_ok = new JButton("Ok");
    private final JButton jb_cancel = new JButton("Cancel");
    private static final String fmtChangeMsg = "Keystore seems to be in {0} format.\nWant to update the format to {0}?";
    private static final String fmtChangeDialogTitle = "Change `Format' to {0}?";

    @Inject
    public KeyStoreDialog(RESTUserInterface rest_ui) {
        super((Frame)rest_ui.getFrame(), true);
        this.getRootPane().setDefaultButton(this.jb_ok);
        this.setLocationRelativeTo(rest_ui.getFrame());
    }

    @PostConstruct
    protected void init() {
        this.jp_type.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    KeyStoreDialog.this.jpf_pwd.setEnabled(false);
                } else {
                    KeyStoreDialog.this.jpf_pwd.setEnabled(true);
                }
            }
        }, KeyStoreType.PEM);
        FileDropTargetListener dndListener = new FileDropTargetListener();
        dndListener.addDndAction(new DndAction(){

            @Override
            public void onDrop(List<File> files) {
                KeyStoreDialog.this.loadFile(files.get(0));
            }
        });
        new DropTarget(this.jtf_file, dndListener);
        new DropTarget(this.jb_browse, dndListener);
        this.jb_browse.setToolTipText("Open file");
        this.jb_browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyStoreDialog.this.loadFile();
            }
        });
        this.jb_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyStoreDialog.this.ok();
            }
        });
        this.jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyStoreDialog.this.cancel();
            }
        });
        JPanel jp = new JPanel(new BorderLayout(5, 2));
        JPanel jp_label = new JPanel(new GridLayout(3, 1));
        jp_label.add(new JLabel("Format: "));
        jp_label.add(new JLabel("File: "));
        jp_label.add(new JLabel("Password: "));
        jp.add((Component)jp_label, "West");
        JPanel jp_input = new JPanel(new GridLayout(3, 1));
        jp_input.add(this.jp_type);
        JPanel jp_file = UIUtil.getFlowLayoutPanelLeftAligned(this.jtf_file);
        jp_file.add(this.jb_browse);
        jp_input.add(jp_file);
        jp_input.add(UIUtil.getFlowLayoutPanelLeftAligned(this.jpf_pwd));
        jp.add((Component)jp_input, "Center");
        JPanel jp_okCancel = new JPanel(new FlowLayout(1));
        jp_okCancel.add(this.jb_ok);
        jp_okCancel.add(this.jb_cancel);
        jp.add((Component)jp_okCancel, "South");
        jp.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.setContentPane(jp);
        this.pack();
    }

    private void loadFile() {
        File f = this.rest_ui.getOpenFile(FileChooserType.OPEN_GENERIC);
        this.loadFile(f);
    }

    private void storeTypeUsingDetectedExtn(KeyStoreType detectedType) {
        int result;
        if (this.jp_type.getSelectedKeyStoreType() != detectedType && (result = JOptionPane.showConfirmDialog(this, MessageFormat.format(fmtChangeMsg, new Object[]{detectedType}), MessageFormat.format(fmtChangeDialogTitle, new Object[]{detectedType}), 0)) == 0) {
            this.jp_type.setSelectedKeyStoreType(detectedType);
        }
    }

    private void loadFile(File f) {
        if (f != null) {
            if (f.canRead()) {
                String fileName = f.getName();
                KeyStoreType detectedStoreType = KeyStoreType.detectByExtn(fileName);
                if (detectedStoreType != null) {
                    this.storeTypeUsingDetectedExtn(detectedStoreType);
                }
                this.jtf_file.setText(f.getAbsolutePath());
            } else {
                this.view.setStatusMessage("File cannot be read.");
            }
        }
    }

    public void setKeyStore(SSLKeyStore store) {
        if (store != null) {
            this.jp_type.setSelectedKeyStoreType(store.getType());
            this.jtf_file.setText(store.getFile().getAbsolutePath());
            if (store.getType() != KeyStoreType.PEM) {
                this.jpf_pwd.setText(new String(store.getPassword()));
            } else {
                this.jpf_pwd.setText("");
            }
        } else {
            this.clear();
        }
    }

    public SSLKeyStore getKeyStore() {
        String filePath = this.jtf_file.getText();
        if (StringUtil.isNotEmpty(filePath)) {
            SSLKeyStoreBean out = new SSLKeyStoreBean();
            out.setType(this.jp_type.getSelectedKeyStoreType());
            out.setFile(new File(filePath));
            out.setPassword(this.jpf_pwd.getPassword());
            return out;
        }
        return null;
    }

    public void clear() {
        this.jp_type.setSelectedKeyStoreType(KeyStoreType.JKS);
        this.jtf_file.setText("");
        this.jpf_pwd.setText("");
    }

    public void addKeyStoreListener(KeyStoreListener listener) {
        this.listeners.add(listener);
    }

    private void ok() {
        SSLKeyStore store = this.getKeyStore();
        if (store == null) {
            JOptionPane.showMessageDialog(this, "One or more required details not provided.", "Validation error", 0);
            return;
        }
        for (KeyStoreListener listener : this.listeners) {
            listener.onOk(store);
        }
        this.setVisible(false);
    }

    private void cancel() {
        for (KeyStoreListener listener : this.listeners) {
            listener.onCancel();
        }
        this.setVisible(false);
    }

    @Override
    public void doEscape(AWTEvent event) {
        this.cancel();
    }
}

