/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipUtil {
    private ZipUtil() {
    }

    public static void unzip(File input, File outputDir) throws IOException {
        if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException("Output directory does not exist; or, is not a directory.");
        }
        try (ZipFile zf = new ZipFile(input);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                File f;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory()) {
                    f = new File(outputDir, name);
                    if (f.mkdirs()) continue;
                    throw new IOException("Unable to create directory: " + f.getAbsolutePath());
                }
                f = new File(outputDir, name);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
                Throwable throwable = null;
                try {
                    InputStream zis = zf.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        int count;
                        byte[] buf = new byte[8192];
                        while ((count = zis.read(buf)) != -1) {
                            ((OutputStream)os).write(buf, 0, count);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (zis == null) continue;
                        if (throwable2 != null) {
                            try {
                                zis.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        zis.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (os == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    ((OutputStream)os).close();
                }
            }
        }
    }
}

