/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser;

import com.sun.media.parser.RawParser;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.SourceStream;

public class RawPullStreamParser
extends RawParser {
    protected SourceStream[] streams;
    protected Track[] tracks = null;
    static final String NAME = "Raw pull stream parser";

    public String getName() {
        return NAME;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.streams = ((PullDataSource)source).getStreams();
        if (this.streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (this.streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(this.streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.source = source;
        this.streams = this.streams;
    }

    protected boolean supports(SourceStream[] streams) {
        return streams[0] != null && streams[0] instanceof PullSourceStream;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        int i2 = 0;
        while (i2 < this.streams.length) {
            this.tracks[i2] = new FrameTrack(this, (PullSourceStream)this.streams[i2]);
            ++i2;
        }
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
    }

    public void start() throws IOException {
        this.source.start();
    }

    public void stop() {
        try {
            this.source.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class FrameTrack
    implements Track {
        Demultiplexer parser;
        PullSourceStream pss;
        boolean enabled = true;
        Format format = null;
        TrackListener listener;
        Integer stateReq = new Integer(0);

        public FrameTrack(Demultiplexer parser, PullSourceStream pss) {
            this.pss = pss;
        }

        public Format getFormat() {
            return this.format;
        }

        public void setEnabled(boolean t) {
            this.enabled = t;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time getDuration() {
            return this.parser.getDuration();
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public void setTrackListener(TrackListener l2) {
            this.listener = l2;
        }

        public void readFrame(Buffer buffer) {
            byte[] data = (byte[])buffer.getData();
            if (data == null) {
                data = new byte[500];
                buffer.setData(data);
            }
            try {
                int len = this.pss.read(data, 0, data.length);
                buffer.setLength(len);
            }
            catch (IOException e2) {
                buffer.setDiscard(true);
            }
        }

        public int mapTimeToFrame(Time t) {
            return -1;
        }

        public Time mapFrameToTime(int frameNumber) {
            return new Time(0L);
        }
    }
}

