/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar.activation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flexdock.dockbar.DockbarManager;
import org.flexdock.dockbar.ViewPane;

public class Animation
implements Runnable,
ActionListener {
    private static Log log = LogFactory.getLog((Class)Animation.class);
    private static int ANIMATION_INTERVAL = 20;
    private static int TOTAL_FRAME_COUNT = 5;
    private DockbarManager dockManager;
    private Timer timer;
    private float frameDelta;
    private int frameCount;
    private boolean hiding;
    private Runnable next;
    private Object lock;

    public Animation(DockbarManager mgr, boolean hide) {
        this.dockManager = mgr;
        this.timer = new Timer(ANIMATION_INTERVAL, this);
        this.frameDelta = 100.0f / (float)this.getTotalFrameCount() / 100.0f;
        this.hiding = hide;
        this.lock = new Object();
    }

    public void run() {
        this.timer.start();
        this.sleep();
    }

    public void actionPerformed(ActionEvent e) {
        this.resetViewpaneSize();
        this.dockManager.revalidate();
        if (this.frameCount == this.getTotalFrameCount() - 1) {
            this.timer.stop();
            this.wakeUp();
        } else {
            ++this.frameCount;
        }
    }

    private void resetViewpaneSize() {
        ViewPane viewPane = this.dockManager.getViewPane();
        int prefSize = this.dockManager.getPreferredViewpaneSize();
        if (this.frameCount == 0) {
            prefSize = this.getStartSize(prefSize);
        } else if (this.frameCount == this.getTotalFrameCount() - 1) {
            prefSize = this.getEndSize(prefSize);
        } else {
            int newSize = (int)((float)prefSize * ((float)this.frameCount * this.frameDelta));
            prefSize = this.hiding ? prefSize - newSize : newSize;
        }
        viewPane.setPrefSize(prefSize);
    }

    private int getStartSize(int prefSize) {
        if (this.hiding) {
            return prefSize;
        }
        return 0;
    }

    private int getEndSize(int prefSize) {
        if (this.hiding) {
            return 0;
        }
        return prefSize;
    }

    private int getTotalFrameCount() {
        return TOTAL_FRAME_COUNT;
    }

    public Runnable getNext() {
        return this.next;
    }

    public void setNext(Runnable next) {
        this.next = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

