/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.gui.plaf.skin.SkinWindowButton;
import com.l2fprod.gui.plaf.skin.Window;
import com.l2fprod.util.OS;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class SkinTitlePane
extends BasicInternalFrameTitlePane {
    protected Window m_Window;
    private SkinWindowButton[] m_WindowButtons;
    private Action shadeAction;
    private Skin skin;
    private WindowListener m_WindowListener;
    public static final int ICON_OFFSET = 16;
    public static final int ALIGN_TOP_LEFT = 0;
    public static final int ALIGN_TOP_RIGHT = 1;
    public static final int CLOSE_ACTION = 0;
    public static final int MAXIMIZE_ACTION = 22;
    public static final int MINIMIZE_ACTION = 23;
    public static final int NO_ACTION = -1;

    public SkinTitlePane(JInternalFrame f) {
        this(new Window.InternalFrameWindow(f));
    }

    public SkinTitlePane(Window f) {
        super(null);
        this.m_Window = f;
        if (OS.isOneDotFourOrMore()) {
            this.installListeners();
        }
    }

    public Window getWindow() {
        return this.m_Window;
    }

    public Dimension getPreferredSize() {
        return this.skin.getFrame().getTopPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.skin.getFrame().getTopPreferredSize();
    }

    public void paintComponent(Graphics g) {
        boolean isSelected = this.m_Window.isSelected();
        Font f = g.getFont();
        if (this.m_Window.getTitle() != null) {
            if (isSelected) {
                g.setColor(this.selectedTextColor);
            } else {
                g.setColor(this.notSelectedTextColor);
            }
            g.setFont(UIManager.getFont("InternalFrame.titleFont"));
        }
        this.skin.getFrame().paintTop(g, this, isSelected, this.m_Window.getTitle());
        g.setFont(f);
    }

    protected void setButtonIcons() {
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.createActions();
        this.enableActions();
        this.assembleSystemMenu();
        this.setLayout(this.createLayout());
        this.add(this.menuBar);
        this.setOpaque(true);
        this.skin = SkinLookAndFeel.getSkin();
        this.createButtons();
    }

    protected void createActions() {
        this.maximizeAction = new MaximizeAction();
        this.maximizeAction.setEnabled(true);
        this.iconifyAction = new IconifyAction();
        this.iconifyAction.setEnabled(true);
        this.closeAction = new CloseAction();
        this.closeAction.setEnabled(true);
        this.restoreAction = new RestoreAction();
        this.restoreAction.setEnabled(true);
        this.shadeAction = new ShadeAction();
        this.shadeAction.setEnabled(true);
    }

    protected void installListeners() {
        if (this.m_Window == null || this.m_Window.getContainer() == null) {
            return;
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
        }
        this.m_Window.addPropertyChangeListener(this.propertyChangeListener);
        if (this.m_Window instanceof Window.FrameWindow) {
            if (this.m_WindowListener == null) {
                this.m_WindowListener = this.createWindowListener();
            }
            ((Window.FrameWindow)this.m_Window).getMainFrame().addWindowListener(this.m_WindowListener);
        }
    }

    void windowSet() {
        this.installListeners();
    }

    private WindowListener createWindowListener() {
        return new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                try {
                    SkinTitlePane.this.m_Window.setSelected(true);
                    SkinTitlePane.this.updateButtons();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }

            public void windowDeactivated(WindowEvent e) {
                try {
                    SkinTitlePane.this.m_Window.setSelected(false);
                    SkinTitlePane.this.updateButtons();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        };
    }

    protected void uninstallListeners() {
        this.m_Window.removePropertyChangeListener(this.propertyChangeListener);
        if (this.m_Window instanceof Window.FrameWindow && this.m_WindowListener != null) {
            ((Window.FrameWindow)this.m_Window).getMainFrame().removeWindowListener(this.m_WindowListener);
        }
    }

    protected void installDefaults() {
        this.selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
        this.selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        this.notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        this.notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
    }

    protected void createButtons() {
        SkinWindowButton[] buttonsRight;
        SkinWindowButton[] buttonsLeft = this.skin.getFrame().getWindowButtons(0);
        if (buttonsLeft != null) {
            int c = buttonsLeft.length;
            for (int i = 0; i < c; ++i) {
                this.addButton(buttonsLeft[i]);
            }
        }
        if ((buttonsRight = this.skin.getFrame().getWindowButtons(1)) != null) {
            int c = buttonsRight.length;
            for (int i = 0; i < c; ++i) {
                this.addButton(buttonsRight[i]);
            }
        }
        this.m_WindowButtons = new SkinWindowButton[buttonsLeft.length + buttonsRight.length];
        System.arraycopy(buttonsLeft, 0, this.m_WindowButtons, 0, buttonsLeft.length);
        System.arraycopy(buttonsRight, 0, this.m_WindowButtons, buttonsLeft.length, buttonsRight.length);
    }

    private void updateButtons() {
        for (int i = 0; i < this.m_WindowButtons.length; ++i) {
            this.m_WindowButtons[i].setSelected(this.m_Window.isSelected());
        }
        this.repaint();
    }

    protected void addButton(SkinWindowButton button) {
        switch (button.getWindowAction()) {
            case 0: {
                button.addActionListener(this.closeAction);
                this.registerButtonForAction(button, this.closeAction);
                break;
            }
            case 22: {
                button.addActionListener(this.maximizeAction);
                this.registerButtonForAction(button, this.maximizeAction);
                break;
            }
            case 23: {
                button.addActionListener(this.iconifyAction);
                this.registerButtonForAction(button, this.iconifyAction);
            }
        }
        this.add(button);
    }

    protected void addSystemMenuItems(JMenu systemMenu) {
        JMenuItem mi = systemMenu.add(this.restoreAction);
        mi.setMnemonic('R');
        mi = systemMenu.add(this.iconifyAction);
        mi.setMnemonic('n');
        mi = systemMenu.add(this.maximizeAction);
        mi.setMnemonic('x');
        if (!Boolean.TRUE.equals(UIManager.get("TitlePane.disableShade"))) {
            systemMenu.add(this.shadeAction);
        }
        systemMenu.add(new JSeparator());
        mi = systemMenu.add(this.closeAction);
        mi.setMnemonic('C');
    }

    protected JMenuBar createSystemMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setBorderPainted(false);
        return this.menuBar;
    }

    protected void enableActions() {
        if (this.m_Window == null) {
            return;
        }
        this.restoreAction.setEnabled(this.m_Window.isMaximum() || this.m_Window.isIcon());
        this.maximizeAction.setEnabled(this.m_Window.isMaximizable());
        this.iconifyAction.setEnabled(this.m_Window.isIconifiable() && !this.m_Window.isIcon());
        this.closeAction.setEnabled(this.m_Window.isClosable());
        this.shadeAction.setEnabled(!this.m_Window.isMaximum() && !this.m_Window.isIcon());
        this.doLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected PropertyChangeListener createActionChangeListener(AbstractButton b) {
        return new ActionChangedListener(b);
    }

    private void registerButtonForAction(AbstractButton b, Action a) {
        PropertyChangeListener actionPropertyChangeListener = this.createActionChangeListener(b);
        a.addPropertyChangeListener(actionPropertyChangeListener);
        b.setEnabled(a.isEnabled());
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton b) {
            this.setTarget(b);
        }

        public void setTarget(AbstractButton b) {
            this.button = b;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                this.button.setText(text);
                this.button.repaint();
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
                this.button.repaint();
            } else if (e.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)e.getNewValue();
                this.button.setIcon(icon);
                this.button.invalidate();
                this.button.repaint();
            }
        }
    }

    public class SystemMenuBar
    extends JMenuBar {
        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isOpaque() {
            return true;
        }

        public void requestFocus() {
        }

        public void paint(Graphics g) {
            Icon icon = SkinTitlePane.this.m_Window.getFrameIcon();
            if (icon == null) {
                icon = UIManager.getIcon("InternalFrame.icon");
            }
            if (icon != null) {
                if (icon instanceof ImageIcon && (icon.getIconWidth() > 16 || icon.getIconHeight() > 16)) {
                    Image img = ((ImageIcon)icon).getImage();
                    ((ImageIcon)icon).setImage(img.getScaledInstance(16, 16, 4));
                }
                icon.paintIcon(this, g, 0, 0);
            }
        }
    }

    public class ShadeAction
    extends AbstractAction {
        public ShadeAction() {
            super("Shade");
        }

        public void actionPerformed(ActionEvent event) {
            SkinTitlePane.this.m_Window.setShaded(!SkinTitlePane.this.m_Window.isShaded());
        }
    }

    public class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super("Restore");
        }

        public void actionPerformed(ActionEvent e) {
            if (SkinTitlePane.this.m_Window.isMaximizable() && SkinTitlePane.this.m_Window.isMaximum()) {
                try {
                    SkinTitlePane.this.m_Window.setMaximum(false);
                }
                catch (PropertyVetoException e4) {}
            } else if (SkinTitlePane.this.m_Window.isIconifiable() && SkinTitlePane.this.m_Window.isIcon()) {
                try {
                    SkinTitlePane.this.m_Window.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super("Minimize");
        }

        public void actionPerformed(ActionEvent e) {
            if (SkinTitlePane.this.m_Window.isIconifiable()) {
                if (!SkinTitlePane.this.m_Window.isIcon()) {
                    try {
                        SkinTitlePane.this.m_Window.setIcon(true);
                    }
                    catch (PropertyVetoException e1) {}
                } else {
                    try {
                        SkinTitlePane.this.m_Window.setIcon(false);
                        if (SkinTitlePane.this.m_Window.isMaximizable() && SkinTitlePane.this.m_Window.isMaximum()) {
                            SkinTitlePane.this.m_Window.setMaximum(false);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super("Maximize");
        }

        public void actionPerformed(ActionEvent e) {
            if (SkinTitlePane.this.m_Window.isMaximizable()) {
                if (!SkinTitlePane.this.m_Window.isMaximum()) {
                    try {
                        SkinTitlePane.this.m_Window.setMaximum(true);
                    }
                    catch (PropertyVetoException e5) {}
                } else {
                    try {
                        SkinTitlePane.this.m_Window.setMaximum(false);
                        if (SkinTitlePane.this.m_Window.isIconifiable() && SkinTitlePane.this.m_Window.isIcon()) {
                            SkinTitlePane.this.m_Window.setIcon(false);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent e) {
            if (SkinTitlePane.this.m_Window.isClosable()) {
                try {
                    SkinTitlePane.this.m_Window.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(100, 18);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int w = SkinTitlePane.this.getWidth();
            int nmembers = c.getComponentCount();
            int atlX = 2;
            int atrX = 0;
            SkinTitlePane.this.menuBar.setBounds(atlX, (SkinTitlePane.this.getHeight() - 16) / 2, 16, 16);
            atlX += 18;
            for (int i = 1; i < nmembers; ++i) {
                boolean userDefinedAction;
                SkinWindowButton m = (SkinWindowButton)c.getComponent(i);
                m.setSelected(SkinTitlePane.this.m_Window.isSelected());
                boolean bl = userDefinedAction = m.getWindowAction() == -1;
                if (!userDefinedAction) {
                    m.setVisible(m.isEnabled());
                }
                if (!m.isEnabled() && !userDefinedAction) continue;
                if (m.getAlign() == 0) {
                    if (m.getXCoord() == -1) {
                        m.setLocation(atlX, Math.max(m.getYCoord(), 1));
                        atlX += m.getWidth();
                        continue;
                    }
                    m.setLocation(m.getXCoord(), m.getYCoord());
                    continue;
                }
                if (m.getAlign() != 1) continue;
                if (m.getXCoord() == -1) {
                    m.setLocation(w - atrX - m.getWidth(), Math.max(m.getYCoord(), 1));
                    atrX += m.getWidth();
                    continue;
                }
                m.setLocation(w - m.getXCoord(), m.getYCoord());
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if ("selected".equals(prop)) {
                SkinTitlePane.this.updateButtons();
                SkinTitlePane.this.repaint();
                return;
            }
            SkinTitlePane.this.enableActions();
            SkinTitlePane.this.revalidate();
            SkinTitlePane.this.repaint();
        }
    }
}

