# We want to use this with noemu, so we can't use make_sh_test_op,
# which relies on a second disk.  Also, the build log is directed
# to a file and only the last 1000 lines shown, because otherwise
# the build speed is limited by the serial console.

from bracket import *

name = 'selfhost'

def test_func(ts):
    logfn = os.path.join(results_dir(ts), name + ".log")
    return anita_run_1(ts, "boot",
            logfn,
            # Note the mkdir /usr/obj, which is to work around PR 49535
            extra_anita_args = [
                "--run", "cd /usr/src && mkdir /usr/obj && " +
                    "time sh build.sh -j $(sysctl -n hw.ncpuonline) release >build.log 2>&1; " +
                    "status=$?; tail -n 1000 build.log; test $status = 0",
                "--run-timeout", "14400",
                "--no-install"
            ])

def op():
    return TestOp(test_func, [install_op], name = name)
