<?php

###############################################################################
# german_utf-8.php
#
# This is the German language file for Geeklog, addressing the user as "Du"
# (informal German). See german_formal.php for a language file addressing the
# user with the formal "Sie".
#
# Authors: Dirk Haun <dirk AT haun-online DOT de>
#          Markus Wollschläger
#
# Based on the original english.php, started by Jason Whittenburg.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'utf-8';

$LANG_ISO639_1 = 'de';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Beitrag von:',
    2 => '(mehr)',
    3 => 'Kommentar(e)',
    4 => 'Ändern',
    5 => 'Contributed by: %s on %s',
    6 => 'Last modified on %s',
    7 => '',
    8 => '',
    9 => 'Admin-Funktionen:',
    10 => 'Beiträge',
    11 => 'Artikel',
    12 => 'Blöcke',
    13 => 'Kategorien',
    14 => 'Command &amp; Control',
    15 => '',
    16 => '',
    17 => 'User',
    18 => 'SQL-Query',
    19 => 'Abmelden',
    20 => 'User-Information:',
    21 => 'Username',
    22 => 'User-ID',
    23 => 'Security Level',
    24 => 'Gast',
    25 => 'Antwort',
    26 => 'Die folgenden Kommentare geben Meinungen von Lesern wieder und entsprechen nicht notwendigerweise der Meinung der Betreiber dieser Site. Die Betreiber behalten sich die Löschung von Kommentaren vor.',
    27 => 'Letzter Beitrag',
    28 => 'Löschen',
    29 => 'Keine Kommentare.',
    30 => 'Ältere Artikel',
    31 => 'Erlaubte HTML-Tags: ',
    32 => 'Fehler: Ungültiger Username',
    33 => 'Fehler: Konnte nicht ins Logfile schreiben',
    34 => 'Fehler',
    35 => 'Abmelden',
    36 => 'am',
    37 => 'Keine Artikel.',
    38 => 'Newsfeed',
    39 => 'Neuladen',
    40 => 'Error in password request, invalid username',
    41 => 'Gäste',
    42 => 'Autor:',
    43 => 'Antwort schreiben',
    44 => 'vorherige',
    45 => 'MySQL Fehlernummer',
    46 => 'MySQL Fehlermeldung',
    47 => 'Anmelden',
    48 => 'Mein Profil',
    49 => 'Einstellungen',
    50 => 'Fehler im SQL-Befehl',
    51 => 'Hilfe',
    52 => 'Neu',
    53 => 'Schaltzentrale',
    54 => 'Konnte die Datei nicht öffnen:',
    55 => 'Fehler in',
    56 => 'Abstimmen',
    57 => 'Passwort',
    58 => 'Anmelden',
    59 => "Noch nicht registriert? Melde Dich jetzt als <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">neuer User</a> an",
    60 => 'Kommentar schreiben',
    61 => 'Neuen Account anlegen',
    62 => 'Wörter',
    63 => 'Kommentar-Einstellungen',
    64 => 'Artikel an einen Freund schicken',
    65 => 'Druckfähige Version anzeigen',
    66 => '',
    67 => 'Willkommen bei ',
    68 => 'Home',
    69 => 'Kontakt',
    70 => 'Suchen',
    71 => 'Beitrag',
    72 => 'Links',
    73 => '',
    74 => '',
    75 => 'Erweiterte Suche',
    76 => 'Statistik',
    77 => 'Plugins',
    78 => '',
    79 => 'Was ist neu',
    80 => 'Artikel in den letzten',
    81 => 'Artikel in den letzten',
    82 => 'Stunden',
    83 => 'KOMMENTARE',
    84 => '',
    85 => 'der letzten 48 Stunden',
    86 => 'Keine neuen Kommentare',
    87 => 'der letzten 2 Wochen',
    88 => '',
    89 => '',
    90 => 'Home',
    91 => 'Seite erzeugt in',
    92 => 'Sekunden',
    93 => 'Copyright',
    94 => 'All trademarks and copyrights on this page are owned by their respective owners.',
    95 => 'Powered by',
    96 => 'Gruppen',
    97 => 'Wortliste',
    98 => 'Plugins',
    99 => 'ARTIKEL',
    100 => 'Keine neuen Artikel',
    101 => 'There are no older articles',
    102 => '',
    103 => 'DB Backups',
    104 => 'von',
    105 => 'Mail an User',
    106 => 'Angezeigt',
    107 => 'Update verfügbar?',
    108 => 'Cache löschen',
    109 => 'Beitrag melden',
    110 => 'Site-Admin auf diesen Beitrag hinweisen',
    111 => '',
    112 => 'Registrierte User',
    113 => 'Dokumentation',
    114 => 'TRACKBACKS',
    115 => 'Keine neuen Trackback-Kommentare',
    116 => 'Trackback',
    117 => 'Verzeichnis',
    118 => 'Fortsetzung auf der nächsten Seite:',
    119 => "<a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">Passwort vergessen?</a>",
    120 => 'Permalink',
    121 => 'Kommentare (%d)',
    122 => 'Trackbacks (%d)',
    123 => 'Alle HTML-Tags sind erlaubt',
    124 => 'Alle angekreuzten Einträge löschen',
    125 => 'Sollen alle angekreuzten Einträge wirklich gelöscht werden?',
    126 => 'Alle Einträge ankreuzen oder deselektieren',
    127 => 'Permalink',
    128 => 'Anmelden mit OpenID:',
    129 => 'Konfiguration',
    130 => 'Webservices',
    131 => 'No HTML is allowed',
    132 => 'Information',
    133 => 'Critical',
    134 => 'Help',
    135 => 'Warning',
    136 => 'Warning: Javascript recommended for enhanced functionality',
    137 => 'Warning: Javascript required to enable functionality',
    138 => "Click <a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">here</a> to disable the advanced editor and use the default editor which does not require JavaScript",
    139 => "Click <a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">here</a> to return to the homepage",
    140 => 'Allowed Autotags:',
    141 => 'An Error Occurred',
    142 => 'Unfortunately, an error has occurred rendering this page. Please try again later.',
    143 => 'Comment (%d)',
    144 => 'Parse Error.  An error occurred while parsing PHP code.',
    'loginform' => "<a href=\"{$_CONF['site_url']}/users.php\">Login Here</a>",
    'remoteloginoptions' => 'Remote Login Options',
    'facebook' => 'Login with Facebook',
    'twitter' => 'Login with Twitter',
    'linkedin' => 'Login with LinkedIn',
    'google' => 'Login with Google',
    'microsoft' => 'Login with Microsoft',
    'yahoo' => 'Login with Yahoo',
    'github' => 'Login with GitHub',
    'ctl' => 'Clear Cache',
    'ok' => 'OK',
    'filemanager' => 'File Manager',
    'error_invalid_password' => 'Error, invalid password for username',
    'error_filemanager_disabled' => 'Filemanager is disabled',
    'terms_of_use' => 'Terms of Use',
    'terms_of_service' => 'Terms of Service',
    'privacy_policy' => 'Privacy Policy',
    'about_cookies' => 'About Cookies',
    'parse_php_error' => 'There was an error parsing your PHP code: %s',
    'error_title' => 'An Error Occurred'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Kommentar schreiben',
    2 => 'Format',
    3 => 'Abmelden',
    4 => 'Account anlegen',
    5 => 'Username',
    6 => 'This site requires you to be logged in to post a comment. If you have an account already (or need to create one), please <a href="%s">login here</a>.',
    7 => 'Dein letzter Kommentar war vor ',
    8 => " Sekunden. Zwischen zwei Kommentaren müssen aber mindestens {$_CONF['commentspeedlimit']} Sekunden vergangen sein.",
    9 => 'Kommentar',
    10 => 'Beitrag melden',
    11 => 'Kommentar abschicken',
    12 => 'Bitte die Felder Betreff <em>und</em> Kommentar ausfüllen, um einen Kommentar zu diesem Artikel abzugeben.',
    13 => 'Deine Information',
    14 => 'Vorschau',
    15 => 'Diesen Beitrag melden',
    16 => 'Betreff',
    17 => 'Fehler',
    18 => 'Wichtige Hinweise:',
    19 => 'Bitte nur Kommentare abgeben, die zum Thema gehören.',
    20 => 'Beziehe Dich möglichst auf Kommentare anderer Personen statt einen neuen Thread zu eröffnen.',
    21 => 'Lies bitte die vorhandenen Kommentare bevor Du Deinen eigenen abgibst, um nicht noch einmal zu schreiben, was schon gesagt wurde.',
    22 => 'Benutze eine eindeutige Betreffzeile, die den Inhalt Deines Kommentars zusammenfasst.',
    23 => 'Deine E-Mail-Adresse wird NICHT veröffentlicht.',
    'instr_line6' => 'When logged in as a user your comments will be linked to your account and you can specify if you would like notifications of any replies.',
    24 => 'Gast',
    25 => 'Soll dieser Beitrag wirklich als möglicher Missbrauch gemeldet werden?',
    26 => '%s meldete den folgenden Beitrag als möglichen Missbrauch:',
    27 => 'Hinweis auf Missbrauch',
    28 => 'Vorschau der Änderungen',
    29 => 'Änderungen speichern',
    30 => 'Editiert am',
    31 => 'von',
    32 => 'Kommentar editieren',
    33 => 'Eingereichten Kommentar editieren',
    34 => 'Kommentar-Vorschau',
    35 => 'Änderungen abspeichern',
    36 => 'Mich bei Antworten benachrichtigen',
    37 => 'Neue Antwort auf Kommentar',
    38 => 'Eine Antwort ist eingegangen auf den Kommentar \'%s\'.',
    39 => 'Den Kommentar-Thread kann man an folgender Adresse sehen:',
    40 => 'Wenn keine weiteren Benachrichtigungen gewünscht sind, dann bitte folgenden Link besuchen:',
    41 => 'Hallo %s,',
    42 => 'Abmelden',
    43 => 'Abmelden von Benachrichtigungen auf Kommentare',
    44 => 'Dein Name',
    45 => "Thank you for your comment. You must wait {$_CONF['commentspeedlimit']} seconds to post a new comment.",
    100 => 'Comment Manager',
    101 => 'Existing Comments',
    102 => 'Bulk Action',
    103 => 'Ban this user',
    104 => 'Ban this IP address with the Spamx plugin',
    105 => 'IP Address',
    106 => 'Perform bulk action on comments and comment submissions including approval, deleting, and banning of user or IP address.',
    'record_edit' => 'Record user and time of edit?',
    'ban_plugin_ban_ip' => 'Ban this IP address with the Ban plugin',
    'num_comments' => '%s Comment(s)',
    'anon_user_name' => '%s (Anonymous User)',
    'comments_closed_msg' => 'Comments are closed and no new posts are allowed.',
    'read_comment' => 'Read the full comment at',
    'comment_for' => 'The above comment is for the following item',
    'comment_page_title' => 'Comments for %s',
    'comments' => 'Comments'
);

###############################################################################
# usersettings.php

$LANG04 = array(
    1 => 'Userprofil für',
    2 => 'Username',
    3 => 'Name',
    4 => 'Neues Passwort',
    5 => 'E-Mail',
    6 => 'Homepage',
    7 => 'Biographie',
    8 => 'PGP-Key',
    9 => 'Speichern',
    10 => 'Die letzten 10 Kommentare von',
    11 => 'Keine Kommentare',
    12 => 'User-Einstellungen für',
    13 => 'E-Mail Nightly Digest',
    14 => 'Dieses Passwort wurde mit einem Zufallsgenerator erzeugt. Es wird empfohlen, das Passwort nach dem Anmelden sofort zu ändern. Um Dein Passwort zu ändern, melde Dich bitte an und wähle dann den Punkt Mein Profil im Block Einstellungen.',
    15 => "Dein Account für {$_CONF['site_name']} wurde erfolgreich angelegt. Um ihn benutzen zu können, melde Dich bitte mit den folgenden Informationen an. Diese E-Mail bitte aufheben.",
    'email_convert_remote' => "Your {$_CONF['site_name']} remote account has been converted to a local account. To continue to use your account, you must login using the information below. Please save this mail for further reference.",
    16 => 'Deine Zugangsdaten',
    17 => 'Account existiert nicht',
    18 => 'Die angegebene E-Mail-Adresse scheint keine gültige E-Mail-Adresse zu sein',
    19 => 'Dieser Username oder diese E-Mail-Adresse existieren bereits.',
    20 => 'Die angegebene E-Mail-Adresse scheint keine gültige E-Mail-Adresse zu sein',
    21 => 'Fehler',
    22 => "Anmelden bei {$_CONF['site_name']}!",
    23 => "Indem Du Dich bei {$_CONF['site_name']} anmeldest, kannst Du Artikel und Kommentare unter Deinem eigenen Namen veröffentlichen (andernfalls geht das nur anonym). Übrigens wird Deine E-Mail-Adresse <strong><em>niemals</em></strong> auf dieser Website angezeigt werden.",
    24 => 'Dein Passwort wird Dir an die angegebene E-Mail-Adresse geschickt.',
    25 => 'Passwort vergessen?',
    26 => 'Gib <em>entweder</em> Deinen Usernamen <em>oder</em> die E-Mail-Adresse ein, mit der Du Dich angemeldet hast, und klicke auf Passwort schicken. Eine E-Mail mit einer Anleitung, wie Du ein neues Passwort eingeben kannst, wird dann an die gespeicherte E-Mail-Adresse geschickt.',
    27 => 'Jetzt anmelden!',
    28 => 'Passwort schicken',
    29 => 'ausgeloggt von',
    30 => 'eingeloggt von',
    31 => 'Um diese Funktion nutzen zu können, musst Du angemeldet sein',
    32 => 'Signatur',
    33 => 'Auf der Site nicht sichtbar!',
    34 => 'Dein richtiger Name',
    35 => 'Passwort eingeben, um es zu ändern',
    36 => '(mit http://)',
    37 => 'Wird an Deine Kommentare angefügt',
    38 => 'Alles über Dich - für alle sichtbar',
    39 => 'Dein PGP-Key, so vorhanden',
    42 => 'Datumsformat',
    43 => 'Artikel pro Seite',
    48 => 'Kategorien',
    52 => 'Grundeinstellung:',
    53 => 'Artikel jede Nacht empfangen',
    56 => 'Autoren',
    57 => 'Anzeigemodus',
    58 => 'Sortierreihenfolge',
    59 => 'Kommentarlimit',
    60 => 'Wie sollen Kommentare angezeigt werden?',
    61 => 'Neueste oder älteste zuerst?',
    62 => 'Defaultwert: 100',
    63 => "Dein Passwort sollte in Kürze per E-Mail eintreffen. Bitte beachte die Hinweise in der E-Mail und Danke für Dein Interesse an {$_CONF['site_name']}",
    64 => 'Kommentar-Einstellungen für',
    65 => 'Bitte noch einmal versuchen, Dich anzumelden',
    66 => 'Hast Du Dich vertippt? Bitte versuch noch einmal, Dich hier anzumelden.',
    67 => 'Mitglied seit',
    68 => 'Angemeldet für',
    69 => 'Wie lange soll das System Dich nach dem Anmelden erkennen?',
    'cookietimeout_tooltip' => 'This site will remember you are logged in from the device you are currently using regardless of if your account has been logged out automatically due to no activity. Accounts are logged out after being inactive for %s seconds (this is called the "User Session Timeout"). When "Remember Me For" is set for your account it will include the time you select here PLUS the "User Session timeout".',
    70 => "Aussehen und Inhalt von {$_CONF['site_name']} konfigurieren",
    71 => "Zu den Features von {$_CONF['site_name']} gehört, dass Du selbst festlegen kannst, welche Artikel Du angezeigt bekommst. Darüber hinaus kannst Du auch das Aussehen der Website verändern. Um in den Genuss dieser Features zu kommen, musst Du Dich jedoch zuerst bei {$_CONF['site_name']} <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">anmelden</a>. Oder bist Du schon angemeldet? Dann benutze bitte das Anmeldeformular auf der linken Seite.",
    72 => 'Erscheinungsbild',
    73 => 'Sprache',
    74 => 'Ändere das Aussehen dieser Site',
    75 => 'Artikel per E-Mail für',
    76 => 'Wähle Kategorien aus der folgenden Liste und Du bekommst einmal pro Tag eine E-Mail mit einer Übersicht aller neuen Artikel in den ausgewählten Kategorien. Du brauchst nur die Kategorien anzukreuzen, die Dich interessieren.',
    77 => 'Foto',
    78 => 'Ein Bild von Dir',
    79 => 'Ankreuzen, um dieses Bild zu löschen:',
    80 => 'Anmelden',
    81 => 'E-Mail schreiben',
    82 => 'Die letzten 10 Artikel von',
    83 => 'Statistik für',
    84 => 'Gesamtanzahl Artikel:',
    85 => 'Gesamtanzahl Kommentare',
    86 => 'Alle Artikel und Kommentare von',
    87 => 'Dein Username',
    88 => "Jemand (möglicherweise Du selbst) hat ein neues Passwort für Deinen Account \"%s\" auf {$_CONF['site_name']} <{$_CONF['site_url']}> angefordert.\n\nWenn Du tatsächlich ein neues Passwort benötigst, klicke bitte auf den folgenden Link:\n\n",
    'user_password_action_msg' => 'If you really want this action to be taken, please click on the following link:',
    89 => "Möchtest Du Dein Passwort nicht ändern, so kannst Du diese E-Mail einfach ignorieren (Dein bisheriges Passwort bleibt dann unverändert gültig).\n\n",
    90 => 'Du kannst hier jetzt ein neues Passwort für Deinen Account eingeben. Dein altes Passwort bleibt noch solange gültig, bis Du dieses Formular abschickst.',
    91 => 'Neues Passwort',
    92 => 'Neues Passwort eingeben',
    93 => 'Du hast zuletzt vor %d Sekunden ein neues Passwort angefordert. Zwischen zwei Passwort-Anforderungen müssen aber mindestens %d Sekunden vergangen sein.',
    94 => 'Lösche Account "%s"',
    96 => 'Account löschen',
    97 => 'Account löschen bestätigen',
    98 => 'Bist Du sicher, dass Du Deinen Account löschen willst? Du wirst Dich danach nicht mehr einloggen können (es sei denn, Du legst einen neuen Account an). Wenn Du Dir sicher bist, klicke bitte noch einmal auf "Account Löschen".',
    99 => 'Privatsphäre-Einstellungen für',
    100 => 'E-Mail von Admin',
    101 => 'E-Mails von Site-Admins erlauben',
    102 => 'E-Mail von Usern',
    103 => 'E-Mails von anderen Usern erlauben',
    104 => 'Online-Status zeigen',
    105 => 'Unter "Wer ist online?"',
    106 => 'Wohnort',
    107 => 'Erscheint im öffentlichen Profil',
    108 => 'Neues Passwort bestätigen',
    109 => 'Hier bitte das neue Passwort noch einmal eingeben',
    110 => 'Aktuelles Passwort',
    111 => 'Gib Dein aktuelles Passwort ein',
    112 => 'Du hast die erlaubte Anzahl von Anmeldeversuchen überschritten. Bitte versuche es später noch einmal.',
    113 => 'Anmeldeversuch fehlgeschlagen',
    114 => 'Account gesperrt',
    115 => 'Dein Account wurde gesperrt. Du kannst Dich nicht einloggen. Bitte wende Dich an einen Administrator.',
    116 => 'Account noch nicht freigegeben',
    117 => 'Dein Account muss erst noch von einem Administrator freigegeben werden. Du kannst Dich erst einloggen, wenn Dein Account freigegeben wurde.',
    118 => '',
    119 => '',
    120 => 'Account aktiviert',
    121 => 'Dienst',
    122 => 'Sorry, derzeit können sich keine neuen User anmelden.',
    123 => "Bist Du ein <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">neuer User</a>?",
    124 => 'E-Mail bestätigen',
    125 => 'Die E-Mail-Adressen stimmen nicht überein. Bitte in beiden Feldern die gleiche E-Mail-Adresse eintragen!',
    126 => 'Bitte die gleiche Adresse noch einmal eingeben',
    127 => 'Um diese Angaben zu ändern musst Du Dein aktuelles Passwort eingeben.',
    128 => 'Dein Name',
    129 => 'Passwort &amp; E-Mail',
    130 => 'Über Dich',
    131 => 'Daily Digest Optionen',
    132 => 'Daily Digest-Funktion',
    133 => 'Kommentaranzeige',
    134 => 'Kommentaranzeige',
    135 => '<li>Anzeigemodus: Wie Kommentare angezeigt werden</li><li>Sortierreihenfolge: Wie Kommentare sortiert werden</li><li>Kommentarlimit: Maximale Anzahl Kommentare, die angezeigt werden (Default: 100)</li>',
    138 => 'Darstellung und Sprache',
    139 => 'Darstellung und Sprache',
    140 => '<li>Kategorien ohne Icons: Wenn angekreuzt werden in Artikeln keine Icons mehr angezeigt.</li><li>Keine Blöcke: Wenn angekreuzt werden nur noch die Blöcke Einstellungen, Kategorien und der Admin-Block angezeigt.<li>Einstellung für die maximale Anzahl von Artikeln pro Seite.</li><li>Wähle das Erscheinungsbild der Website, Deine Zeitzone und das bevorzugte Datumsformat.</li>',
    141 => 'Privatsphäre',
    142 => 'Per Grundeinstellung ist es Admins und anderen Usern der Site erlaubt, Dir E-Mails zu schicken sowie Deinen Status unter "Wer Ist Online?" zu sehen. Hier kannst Du diese Einstellungen ändern.',
    145 => 'Vorschau: So sieht Dein Profil aus',
    146 => 'Passwort &amp; E-Mail',
    147 => 'Hier kannst Du Dein Passwort und Deine E-Mai-Adresse ändern sowie bestimmen, wie lange Du eingeloggt bleiben willst. Passwort und E-Mail müssen zum Ändern zweimal eingegeben werden.',
    148 => 'Über Dich',
    149 => 'Hier kannst Du eingeben, was andere User über Dich sehen können:<ul><li>Die Signatur wird an Kommentare angefügt</li><li>In der Biographie kannst Du etwas über Dich erzählen</li><li>Du kannst Deinen PGP-Key hinterlegen</li></ul>',
    150 => '',
    156 => 'Account löschen',
    157 => 'Löschen',
    158 => 'Zeitzone',
    160 => '(max. %d x %d Pixel, %d Bytes; %s)',
    161 => 'wird ggfs. skaliert',
    162 => 'wird nicht skaliert',
    163 => 'Die Wiederauthetifizierung klappte nicht',
    164 => 'Die maximale Anzahl für Wiederauthentifizierungsversuche wurde überschritten. Der Vorgang wurde abgebrochen und die letzten Änderungen gingen verloren, sorry.',
    165 => 'WYSIWYG-Editor',
    166 => 'Re-synch Remote Account',
    167 => 'Remote login',
    168 => 'You may also login with one on of the below remote authentication services',
    169 => 'User has updated his/her profile',
    170 => "Admin at {$_CONF['site_name']} changed the password of your account as follows.  Please save this mail for further reference.",
    171 => 'Post mode for "Signature" and "Bio".',
    'user_login' => 'User Login',
    'user_login_message' => 'Please login below. You must enter both a username and password.',
    'user_remote_login_desc_long' => 'Click on one of the button(s) below to login and/or register via an account you have on another supported remote service. Please note, you must have an account on the remote service. If you are creating a new account on this website, then the remote service may ask you to give this website permissions to access information like your name, email address, and profile photo.',
    'remote_register_instructions' => "<strong>Please note:</strong> To register and create an account via Remote Login, please visit the <a href=\"{$_CONF['site_url']}/users.php\" rel=\"nofollow\">User Login</a>.",
    'user_logged_in_message' => "You are already logged in. Whould you like to <a href=\"{$_CONF['site_url']}/users.php?mode=logout\" rel=\"nofollow\">logout</a>?",
    'user_max_login_attempts' => 'Max Login Attempts and Speed Limit Reached',
    'tfa_two_factor_auth' => 'Two Factor Authentication',
    'tfa_help1' => 'Make sure to install "Google Authenticator" application on your mobile device before you enable Two Factor Authentication.',
    'tfa_help2' => 'Enable Two Factor Authentication.',
    'tfa_help3' => 'Run "Google Authenticator", tap on the plus icon and scan the QR code.',
    'tfa_help4' => 'Print or download the backup codes below in case you cannot use your mobile device you installed the Google Authenticator.  Each backup code is valid only one-time.  If you generate a new set of backup codes, then the current set will be invalid.',
    'tfa_help5' => 'Hit the "Save" button at the bottom of the screen.',
    'tfa_enter_code' => 'Enter the %d-digit code your Google Authenticator app is showing or one of the backup code you have got in your preference page.',
    'tfa_backup_code_desc' => 'Note: You can only use a backup code once, then it becomes invalid. Remember to generate more backup codes from the user preference page if you are getting low.',
    'tfa_code' => 'Google Authenticator Code',
    'tfa_authenticate' => 'Authenticate',
    'tfa_qrcode' => 'QR Code',
    'tfa_show_hide' => 'Show/Hide',
    'tfa_backup_code' => 'Backup Codes',
    'tfa_download' => 'Download Backup Codes',
    'tfa_new_backup_code' => 'Generate a new set of backup codes',
    'tfa_generate_confirm' => 'Go ahead?',
    'lang_tfa_user_edit_desc' => 'You are only allowed to disable Two Factor Authentication (2FA) from this form if needed (like the user does not have their backup codes). It should not be enabled by Admins as the user themselves are required to enable and setup 2FA from their Account, including the Google Authenticator App for their phone and coping the backup codes.',
    'desc_new_pwd_status' => 'You are required to enter a new password for your account. You can enter a new password for your account below. <em>Please note you will not be able to do anything with your account until your password is updated.</em>',
    'new_email' => 'New Email',
    'set_new_email' => 'Set New Email',
    'confirm_new_email' => 'Confirm new email',
    'enter_new_email' => 'Enter New Email',
    'desc_new_email_status' => 'You are required to enter a new email address for your account. You can enter a new email for your account below. <em>Please note you will not be able to do anything with your account until your email is updated and verified.</em>',
    'email_msg_email_status_1' => "You have updated your email address for your account \"%s\" on {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nPlease click on the following link to verify this email address:\n\n",
    'email_msg_verify' => 'Please click on the following link to verify this email address:',
    'email_msg_email_status_2' => "If you do not verify this email address and you log into your account you will be required to enter a new email address and go through this email verification process again.\n\n",
    'email_verify' => 'New Email to be Verified',
    'email_verify_delete' => 'Delete email to be verified',
    'email_verify_msg' => "You have previously updated your email address for your account but it still needs to be verified. Please check your email account for an email from {$_CONF['site_name']} that contains a verification link. Once you click on that link your new email address will be verified and your account will be updated to use it.<br" . XHTML . "><br" . XHTML . ">If you wish you may update the new email to be verified with the email fields above or you can delete it.",
    'remove_account_msg' => 'To remove your account from our database, enter your current password into the above "Current Password", check the checkbox next to "Delete Option" below and click on "Save" . Please note that any articles and comments you posted under this account will <strong>not</strong> be deleted but show up as being posted by "Anonymous".',
    'remove_remote_account_msg' => 'To remove your remote account from our database, check the checkbox next to "Delete Option" below and click on "Save" . Please note that any articles and comments you posted under this account will <strong>not</strong> be deleted but show up as being posted by "Anonymous".',
    'theme_info' => '%1$s %2$s (requires Geeklog %3$s)'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Vorschau',
    'pe_namepass' => 'Username &amp; Passwort',
    'pe_userinfo' => 'Über Dich',
    'pe_layout' => 'Darstellung &amp; Sprache',
    'pe_content' => 'Inhalt',
    'pe_privacy' => 'Privatsphäre'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Keine Artikel',
    2 => 'Es gibt keine Artikel, die angezeigt werden könnten. Entweder gibt es für diese Kategorie keine Artikel oder die persönlichen Einstellungen sind zu restriktiv.',
    3 => '',
    4 => 'Hauptartikel',
    5 => 'weiter',
    6 => 'zurück',
    7 => 'Anfang',
    8 => 'Ende',
    9 => 'Page navigation'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'Es gab einen Fehler beim Versenden der Nachricht. Bitte noch einmal versuchen.',
    2 => 'Nachricht wurde verschickt.',
    3 => 'Bitte sicherstellen, dass Du eine gültige E-Mail-Adresse eingetragen hast.',
    4 => 'Bitte alle Felder ausfüllen: Dein Name, Deine E-Mail, Betreff und Nachricht',
    5 => 'Fehler: Username nicht bekannt.',
    6 => 'Es ist ein Fehler aufgetreten.',
    7 => 'Userprofil für',
    8 => 'Username',
    9 => 'User URL',
    10 => 'Eine Mail schicken an',
    11 => 'Dein Name:',
    12 => 'Deine E-Mail:',
    13 => 'Betreff:',
    14 => 'Nachricht:',
    15 => 'HTML wird nicht interpretiert.',
    16 => 'Nachricht abschicken',
    17 => 'Artikel an einen Freund schicken',
    18 => 'An (Name)',
    19 => 'An (E-Mail)',
    20 => 'Von (Name)',
    21 => 'Von (E-Mail)',
    22 => 'Alle Felder müssen ausgefüllt werden.',
    23 => "Diese Nachricht wurde Dir von %s <%s> geschickt, da er/sie der Meinung war, Du würdest Dich vielleicht für diesen Artikel auf <{$_CONF['site_url']}> interessieren. Dies ist kein Spam und die beteiligten E-Mail-Adressen (Deine und die des Absenders) wurden nicht gespeichert.",
    24 => 'Schreibe einen Kommentar zu diesem Artikel:',
    25 => 'Du musst Dich anmelden, um diese Funktion benutzen zu können. Dies ist leider nötig, um den Missbrauch des Systems zu verhindern',
    26 => 'Mit diesem Formular kannst Du eine E-Mail an diesen User schicken. Alle Felder müssen ausgefüllt werden.',
    27 => 'Kurze Nachricht',
    28 => '%s schrieb: ',
    29 => "Dies sind die neuen Artikel auf {$_CONF['site_name']} vom ",
    30 => ' - Neue Artikel vom ',
    31 => 'Titel',
    32 => 'Datum',
    33 => 'Kompletter Artikel unter',
    34 => 'Ende dieser Nachricht',
    35 => 'Sorry, dieser User möchte keine E-Mails bekommen.',
    36 => 'Kopie:',
    37 => 'Ich möchte eine Kopie der E-Mail bekommen',
    38 => "Dies ist eine Kopie der E-Mail, die Du von <{$_CONF['site_url']}> an %s geschickt hast:",
    39 => 'Your last message was ',
    40 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between sending messages",
    41 => 'This user doesn\'t exist.',
    42 => 'This users email address doesn\'t exist. This most likely means is is an OAuth user account.',
    43 => 'This users email address is invalid.',
    44 => 'This users status is set to something other than Active or New Password therefore the email address is assumed bad.',
    45 => "This is a message sent from {$_CONF['site_name']} by %s. Any replies will need to be sent to the email address: %s",
    46 => "To unsubscribe from the Daily Digest, login to {$_CONF['site_name']} at {$_CONF['site_url']}. Then visit the user settings page at {$_CONF['site_url']}/usersettings.php and view the Content Tab. You can then unsubscribe to the Daily Digest by deselecting all topics and saving your profile."
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Erweiterte Suche',
    2 => 'Suchbegriffe',
    3 => 'Kategorie',
    4 => 'Alle',
    5 => 'Art',
    6 => 'Artikel',
    7 => 'Kommentare',
    8 => 'Autoren',
    9 => 'Alle',
    10 => 'Suchen',
    11 => 'Suchergebnisse',
    12 => 'Treffer',
    13 => 'Erweiterte Suche: Keine Treffer',
    14 => 'Es gab keine Treffer für die Suche nach',
    15 => 'Bitte noch einmal versuchen.',
    16 => 'Titel',
    17 => 'Datum',
    18 => 'Autor',
    19 => "Durchsuche die komplette Datenbank von {$_CONF['site_name']} ...",
    20 => 'Datum',
    21 => 'bis',
    22 => '(Datumsformat: JJJJ-MM-TT)',
    23 => 'Angezeigt',
    24 => '%d Einträge gefunden',
    25 => 'Gesucht wurde nach',
    26 => 'Beiträgen in',
    27 => 'Sekunden.',
    28 => 'Keine Treffer unter den Artikeln und Kommentaren.',
    29 => 'Gefundene Artikel und Kommentare',
    30 => '',
    31 => 'Dieses Plugin lieferte keine Treffer',
    32 => '',
    33 => 'URL',
    34 => 'Ort',
    35 => 'Ganztägig',
    36 => 'Key Word Type',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Der Suchbegriff sollte mindestens 3 Zeichen lang sein.',
    42 => 'Das Datum muss im Format JJJJ-MM-TT (Jahr-Monat-Tag) eingegeben werden.',
    43 => 'genaue Wortgruppe',
    44 => 'alle Wörter',
    45 => 'irgendeines der Wörter',
    46 => 'weiter',
    47 => 'zurück',
    48 => 'Autor',
    49 => 'Datum',
    50 => 'Angezeigt',
    51 => '',
    52 => 'Wohnort',
    53 => 'Gefundene Artikel',
    54 => 'Gefundene Kommentare',
    55 => 'der Wortgruppe',
    56 => '<em>und</em>',
    57 => '<em>oder</em>',
    58 => 'Weitere Ergebnisse &gt;&gt;',
    59 => 'Ergebnisse',
    60 => 'pro Seite',
    61 => 'Suche korrigieren',
    62 => '#',
    63 => 'Beschreibung',
    64 => 'Gezeigt werden %1$d - %2$d von %3$d Ergebnissen',
    65 => 'Artikel',
    66 => 'Kommentar',
    67 => 'Zeige %d Suchergebnisse',
    68 => 'Sortieren nach',
    69 => 'Nur Titel durchsuchen',
    70 => 'Nicht verfügbar ...',
    71 => 'aufsteigend',
    72 => 'absteigend',
    73 => 'Submit',
    74 => 'Limit Results'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Site-Statistik',
    2 => 'Gesamtzahl der Seitenabrufe',
    3 => 'Anzahl Artikel (Kommentare)',
    4 => 'Site Statistic',
    5 => "Overall Site Statistics for {$_CONF['site_name']}",
    6 => '',
    7 => 'Top Ten der Artikel',
    8 => 'Artikelüberschrift',
    9 => 'Angezeigt',
    10 => 'Es gibt keine Artikel oder sie wurden von niemandem gelesen.',
    11 => 'Top Ten der meistkommentierten Artikel',
    12 => 'Kommentare',
    13 => 'Es gibt keine Artikel oder es wurden keine Kommentare dazu abgegeben.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Top Ten der verschickten Artikel',
    23 => 'E-Mails',
    24 => 'Es wurden keine Artikel per E-Mail verschickt.',
    25 => 'Top Ten der Artikel mit Trackback-Kommentaren',
    26 => 'Keine Trackback-Kommentare gefunden.',
    27 => 'Anzahl aktiver User',
    28 => '',
    29 => '',
    30 => 'Angezeigt',
    31 => '',
    32 => 'Top Ten Liked Articles',
    33 => 'No liked articles found.'
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Weiterführende Links',
    2 => 'An einen Freund schicken',
    3 => 'Druckfähige Version',
    4 => 'Optionen',
    5 => '',
    6 => 'Newsfeed \'%s\' abonnieren'
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'To submit a %s you are required to be logged in as a user.',
    2 => 'Anmelden',
    3 => 'Neuer User',
    4 => '',
    5 => '',
    6 => 'Einen Artikel einreichen',
    7 => 'Anmeldung erforderlich',
    8 => 'Abschicken',
    9 => 'Wenn Du Informationen einreichen möchtest, die auf dieser Site veröffentlicht werden sollen, dann bitten wir Dich, folgende Punkte zu beachten:<ul><li>Bitte alle Felder ausfüllen, sie werden benötigt<li>Bitte nur vollständige und exakte Informationen einreichen<li>URLs vor dem Abschicken unbedingt noch einmal kontrollieren</ul>',
    10 => 'Titel',
    11 => '',
    12 => 'Startdatum',
    13 => 'Enddatum',
    14 => 'Ort',
    15 => 'Beschreibung',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Bitte lesen',
    20 => '',
    21 => '',
    22 => 'Fehler: Nicht alle Felder ausgefüllt',
    23 => 'Bitte alle Felder des Formulars ausfüllen. Alle Felder werden benötigt.',
    24 => 'Beitrag gespeichert',
    25 => 'Der %s-Beitrag wurde gespeichert.',
    26 => 'Speed Limit',
    27 => 'Username',
    28 => 'Kategorie',
    29 => 'Artikel',
    30 => 'Dein letzter Beitrag war vor ',
    31 => " Sekunden. Zwischen zwei Beiträgen müssen aber mindestens {$_CONF['speedlimit']} Sekunden vergangen sein.",
    32 => 'Vorschau',
    33 => 'Artikelvorschau',
    34 => 'Abmelden',
    35 => 'HTML-Tags sind nicht erlaubt',
    36 => 'Format',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Addresse, Zeile 1',
    45 => 'Addresse, Zeile 2',
    46 => 'Stadt',
    47 => 'Bundesland',
    48 => 'Postleitzahl',
    49 => '',
    50 => '',
    51 => 'Ort',
    52 => 'Löschen',
    53 => 'Account anlegen',
    54 => 'Einleitung Artikel',
    55 => 'Hauptteil Artikel'
);

###############################################################################
# LIKES feature since Geeklog 2.2.1

$LANG_LIKES = array(
    'like' => 'Like',
    'unlike' => 'Unlike',
    'dislike' => 'Dislike',
    'undislike' => 'Undislike',
    'likes' => 'Likes',
    'unlikes' => 'Unlikes',
    'dislikes' => 'Dislikes',
    'undislikes' => 'Undislikes',
    'i_like_this' => 'I like this',
    'i_dislike_this' => 'I dislike this',
    'thanks_for_action' => 'Thanks for voting!',
    'likes_speedlimit' => 'You last used the Likes system on an item %s seconds ago. This site requires at least %s seconds between using the Likes system',
    'likes_ip_error' => 'Your IP address has already performed this Likes action.',
    'likes_uid_error' => 'Your User account has already performed this Likes action.',
    'own_item_error' => 'Either you own the item or do not have permission to Like/Dislike it.',
    'liked_by' => 'Liked by:',
    'disliked_by' => 'Disliked by:',
    'num_anon_users' => '<br' . XHTML . '>%s Anonymous Users',
    'one_anon_users' => '<br' . XHTML . '>1 Anonymous User',
    'num_more_users' => '<br' . XHTML . '>+%s more Users',
    'username_in_likes_list' => '<br' . XHTML . '>%s',
    'autotag_desc_likes_block' => "[likes_block:aid action:aid wrapper:wid class:likes-autotag type: subtype: time:604800 max:10 cache:3600 line:1 length:20]
\n	- Displays the Likes block. No attributes are required. If attribute not specified then default in configuration used. 
\n	- action = 1 (likes only), 2 (dislikes only), or 3 (both) 
\n	- wrapper = 0 (no wrapper), 1 (block wrapper with title), div wrapper with css class), or both
\n	- class = Specifies the css class used by the div wrapper if enabled else default likes-autotag will be used 
\n	- type = Either empty (for all types) or include 1 supported like type. For example 'article' or 'comment'
\n	- subtype = Specify a sub type of type if needed
\n	- time = Display items that are this many seconds old. 0 will display all items
\n	- max = Maximum number of items to display
\n	- cache = Cached for no longer than this many seconds. If 0 caching is disabled
\n	- line = Display likes icons on new line
\n	- length = Trim item title length to this many characters",
    'num_likes_in_time_limit' => 'The last number of Likes this item received within the time specified.',
    'num_dislikes_in_time_limit' => 'The last number of Dislikes this item received within the time specified.',
    'num_likes_total' => 'The total number of Likes this item has received.',
    'num_dislikes_total' => 'The total number of Dislikes this item has received.',
    'likes_time_span' => 'Most Likes in the last %t %s',
    'dislikes_time_span' => 'Most Dislikes in the last %t %s',
    'all_time_span' => 'Most engaging in the last %t %s',
    'whats_liked' => 'Whats Liked',
    'whats_recently_liked' => 'Whats Recently Liked',
    'whats_disliked' => 'Whats Disliked',
    'whats_recently_disliked' => 'Whats Recently Disliked',
    'whats_popular' => 'Whats Popular',
    'whats_recently_popular' => 'Whats Recently Popular',
    'whats_liked_type' => 'Liked %s',
    'whats_recently_liked_type' => 'Recently Liked %s',
    'whats_disliked_type' => 'Disliked %s',
    'whats_recently_disliked_type' => 'Recently Disliked %s',
    'whats_popular_type' => 'Popular %s',
    'whats_recently_popular_type' => 'Recently Popular %s',
    'no_liked_items_in_time_limit' => 'There have been no Likes during the time specified.',
    'no_disliked_items_in_time_limit' => 'There have been no Dislikes during the time specified.',
    'no_action_items_in_time_limit' => 'There have been no Likes or Dislikes during the time specified.',
    'no_liked_items' => 'There are no Liked items.',
    'no_disliked_items' => 'There are no Disliked items.',
    'no_action_items' => 'There are no Liked or Disliked items.',
    'last_num_likes_by' => 'Last %s Likes and Dislikes by %s',
    'msg_no_likes' => 'No likes or dislikes found by user.',
    'total_num_likes' => 'Total number of likes and dislikes:',
    'title_liked' => '%s Liked on ',
    'title_disliked' => '%s Disliked on ',
    'articles' => 'Articles',
    'comments' => 'Comments'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/logviewer.php

$LANG_LOGVIEW = array(
    'log_viewer' => 'Log Viewer',
    'info' => 'Geeklog log file administration.',
    'logs' => 'Logs',
    'view' => 'View Log File',
    'clear' => 'Clear Log File',
    'log_file' => 'Log File'
);

###############################################################################
# admin/envcheck.php - distribution integrity checker

$LANG_ENVCHECK = array(
    'correct_perms' => 'Please correct the issues identified below. Once they have been corrected, use the <b>Recheck</b> button to validate the environment.',
    'current' => 'Current',
    'current_php_settings' => 'Current PHP Settings',
    'directory_permissions' => 'Directory Permissions',
    'enabled' => 'Enabled',
    'env_check' => 'Environment Check',
    'file_permissions' => 'File Permissions',
    'file_uploads' => 'Many features of Geeklog require the ability to upload files, this should be enabled.',
    'filesystem_check' => 'Directory / File Permissions',
    'gd_lib' => 'GD Libraries',
    'gd_not_found' => 'Unable to locate the GD library functions.  Please ensure that the GD libraries were compiled into PHP or select an alternate graphics library.',
    'gd_ok' => 'GD Libraries v2 are installed.',
    'gd_v1' => 'GD Libraries v1 is installed - This version does not fully support JPG image processing so there may be some quality issues.',
    'graphics' => 'Graphics Library',
    'libraries' => 'Libraries',
    'hosting_env' => 'Hosting Environment Check',
    'imagemagick' => 'ImageMagick Programs',
    'im_not_found' => 'Unable to locate the <strong>convert</strong> executable for ImageMagick.',
    'im_ok' => 'The <strong>convert</strong> executable appears to be valid.',
    'memory_limit' => 'It is recommended that you have at least 48M of memory enabled on your site.',
    'not_writable' => 'NOT WRITABLE',
    'notes' => 'Notes',
    'not_found' => 'Not Found',
    'netpbm' => 'NetPBM Library',
    'np_ok' => 'The NetPBM library is installed',
    'np_not_found' => 'The NetPBM executables were not found.',
    'fileinfo_library' => 'Fileinfo Library',
    'fileinfo_ok' => 'The Fileinfo library is loaded. This library is required when uploading images for articles. It is used to get the mime type of the file being uploaded when creating a thumbnail of the image.',
    'fileinfo_not_found' => 'The Fileinfo library is not loaded. This is required <strong>only</strong> when uploading images in the article editor.',
    'openssl_library' => 'OpenSSL Library',
    'openssl_ok' => 'The OpenSSL library is loaded. This library is required if you wish to use the OAuth user login method with Geeklog.',
    'openssl_not_found' => 'The OpenSSL library is not loaded. This is required <strong>only</strong> if you wish to use the OAuth user login method with Geeklog.',
    'off' => 'Off',
    'ok' => 'OK',
    'on' => 'On',
    'open_basedir' => 'If <strong>open_basedir</strong> restrictions are enabled on your site, it may cause permission problems during the install. The File System Check below should point out any issues.',
    'database_settings' => 'Database Settings',
    'database_mysql_version' => 'MySQL Version',
    'database_mysql_req_version' => 'Geeklog requires MySQL version 4.1.2 or newer (MySQL 5 recommended).',
    'database_pgsql_version' => 'Postgresql Version',
    'database_pgsql_req_version' => 'Geeklog requires Postgresql version 9.1.7 or newer.',
    'database_dms' => 'Database Management System',
    'database_dms_notes' => 'Failed to determine Database Management System. Geeklog requires either MySQL or Postgresql',
    'php_req_version' => 'Geeklog requires PHP version 5.6.4 or newer.',
    'php_settings' => 'PHP Settings',
    'php_version' => 'PHP Version',
    'php_warning' => 'If any of the items below are marked in <span class="no">red</span>, you may encounter problems with your Geeklog site.  Check with your hosting provider for information on changing any of these PHP settings.',
    'post_max_size' => 'Geeklog allows you to upload plugins, images, and files. You should allow at least 8M for the maximum post size.',
    'recheck' => 'Recheck Environment',
    'recommended' => 'Recommended',
    'setting' => 'Setting',
    'unable_mkdir' => 'Unable to create directory',
    'upload_max_filesize' => 'Geeklog allows you to upload plugins, images, and files. You should allow at least 8M for the upload size.',
    'not_checked' => 'Skipped',
    'bypass_note' => 'Since either Safe Mode or open_basedir restrictions were detected, the check for graphic libraries were skipped.',
    'not_used_note' => 'No graphic libraries are set to be used by Geeklog.',
    'location' => 'Location',
    'status' => 'Status',
    'item' => 'Item',
    'jhead' => 'jhead Program',
    'jhead_not_found' => 'Unable to locate the jhead executable.',
    'jhead_ok' => 'The jhead executable is installed.',
    'jpegtran' => 'jpegtran Program',
    'jpegtran_not_found' => 'Unable to locate the jpegtran executable.',
    'jpegtran_ok' => 'The jpegtran executable is installed.',
    'showhide_phpinfo' => 'Show/Hide Full PHP Info',
    'view_online' => 'Click here %s to view online',
    'no_new_items' => 'No New Items',
    'max_execution_time' => 'Geeklog recommends the PHP default value of 30 seconds as a minimum, but plugin uploads and other operations may take longer than this depending upon your hosting environment.  If safe_mode (above) is Off, you may be able to increase this by modifying the value of <b>max_execution_time</b> in your php.ini file.',
    'phpinfo_disabled' => 'In order to view the current php settings, you will have to contact your host and enable access to the phpinfo() function.'
);

###############################################################################
# For Demo Mode (since v2.2.1)

$LANG_DEMO = array(
    'header' => 'Header',
    'subject' => 'Subject:',
    'to' => 'To:',
    'from' => 'From:',
    'priority' => 'Priority:',
    'body' => 'Body',
    'notice' => 'Notice',
    'emails_disabled_msg' => 'Please note sending emails is disabled in Demo mode. An email which would have been sent was:'
);

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Bitte authentifizieren!',
    2 => 'Zugriff verweigert! Anmeldeinformation ungültig',
    3 => 'Ungültiges Passwort für User',
    4 => 'Username:',
    5 => 'Passwort:',
    6 => 'Zugriffe auf die Administrationsseiten dieser Website werden aufgezeichnet und kontrolliert.<br' . XHTML . '>Diese Seiten sind nur für befugte Personen zugänglich.',
    7 => 'einloggen',
    8 => 'Login',
    9 => 'This page is for the use of authorized personnel only. Please note all access to administrative portions of this web site are logged and reviewed.'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Ungenügende Rechte',
    2 => 'Du hast nicht die nötigen Rechte, um diesen Block ändern zu können.',
    3 => 'Block-Editor',
    4 => 'Beim Lesen dieses Newsfeeds trat ein Fehler auf (die Datei error.log enthält nähere Informationen).',
    5 => 'Ja',
    6 => 'Nein',
    7 => 'Alle',
    8 => 'Block-Sicherheitsstufe',
    9 => 'Reihenfolge',
    10 => '',
    11 => 'Portal-Block',
    12 => 'Normaler Block',
    13 => 'Portal-Block: Optionen',
    14 => 'RSS-URL',
    15 => 'Letztes Update',
    16 => 'Normaler Block: Optionen',
    17 => 'Inhalt',
    18 => 'Bitte ausfüllen: Block-Titel, Sicherheitsstufe und Inhalt',
    19 => 'Block-Manager',
    20 => 'Reguläre Blöcke',
    21 => 'Block-Sichh.',
    22 => 'Dynamische Blöcke',
    23 => 'Reihenfolge',
    24 => 'Dynamisch',
    25 => 'Um einen Block zu ändern oder zu löschen, auf das Ändern-Symbol (s.u.) klicken. Um einen neuen Block anzulegen, auf Neu anlegen (s.o.) klicken.',
    26 => 'Layout-Block',
    27 => 'PHP-Block',
    28 => 'PHP-Block: Optionen',
    29 => 'Block-Funktion',
    30 => 'Wenn einer Deiner Blöcke PHP-Code verwenden soll, gib hier bitte den Namen der Funktion ein. Der Funktionsname muss mit "phpblock_" (z.B. phpblock_getweather) beginnen. Wenn sie diese Namenskonvention nicht einhält, wird die Funktion NICHT aufgerufen. Das soll verhindern, dass Hacker evtl. gefährlichen Code einschleusen können. Den Funktionsnamen NICHT mit einem Klammerpaar "()" abschliessen. Ferner wird empfohlen, all Deinen Code für PHP-Blöcke in der Datei /pfad/zu/geeklog/system/lib-custom.php abzulegen. Dort kann der Code auch dann unverändert bleiben, wenn Du auf eine neuere Geeklog-Version umsteigst.',
    31 => 'Fehler in PHP-Block: Funktion %s existiert nicht.',
    32 => 'Fehler: Nicht alle Felder ausgefüllt',
    33 => 'Für Portal-Blöcke muss ein Titel und eine URL zur RSS-Datei angegeben werden.',
    34 => 'Für PHP-Blöcke muss ein Titel und der Funktionsname eingegeben werden.',
    35 => 'Für normale Blöcke muss ein Titel und der Inhalt eingegeben werden.',
    36 => 'Für Layout-Blöcke muss der Inhalt eingegeben werden.',
    37 => 'Ungültiger Funktionsname für einen PHP-Block',
    38 => 'Funktionen für PHP-Blöcke müssen mit \'phpblock_\' beginnen (z.B. phpblock_getweather). Der \'phpblock_\'-Teil wird aus Sicherheitsgründen vorausgesetzt, um das Ausführen von beliebigem Code zu verhindern.',
    39 => 'Seite',
    40 => 'links',
    41 => 'rechts',
    42 => 'Für Geeklog-Default-Blöcke muss ein Block-Titel und die Block-Reihenfolge angegeben werden.',
    43 => 'Nur auf der Startseite',
    44 => 'Multiple',
    45 => "Du hast keine Zugriffsrechte für diesen Block. Dieser Zugriffsversuch wurde protokolliert. <a href=\"{$_CONF['site_admin_url']}/block.php\">Zurück zum Administrator-Menü</a>.",
    46 => 'Bewegen',
    47 => 'None',
    48 => 'Block-Name',
    49 => ' (keine Leerzeichen, muss eindeutig sein)',
    50 => 'Der Block-Name kann nicht leer sein',
    51 => '(mit http://)',
    52 => 'Wenn das Feld leer ist, wird kein Hilfesymbol zu diesem Block angezeigt.',
    53 => 'Aktiv',
    54 => 'Speichern',
    55 => 'Abbruch',
    56 => 'Löschen',
    57 => 'Block nach unten',
    58 => 'Block nach oben',
    59 => 'Block auf die rechte Seite',
    60 => 'Block auf die linke Seite',
    61 => 'Ohne Titel',
    62 => 'Artikellimit',
    63 => 'Block-Titel nicht erlaubt',
    64 => 'Der Titel kann nicht leer sein und darf kein HTML enthalten!',
    65 => 'Reihenfolge',
    66 => 'Autotags',
    67 => 'Ankreuzen, um Autotags zu interpretieren',
    68 => 'Der Newsfeed für diesen Portalblock ist zu lang, um angezeigt zu werden. Bitte eine maximale Anzahl Artikel angeben, die für den Block importiert werden soll. Dieses entweder im Blockeditor einstellen oder in der allgemeinen Voreinstelung in der Geeklog Konfiguration.',
    69 => 'Plugin-Name',
    70 => 'CSS ID',
    71 => 'This field is optional',
    72 => 'CSS Classes',
    73 => 'This field is optional.  You can specify multiple classes separated by space',
    'autotag_desc_block' => '[block:name class:block-autotag] - Displays a block. Class not required. Class specifies the css class and will wrap the block in a div. The class block-autotag will always be included with the div.',
    'newlines' => 'Newlines',
    'convert_newlines' => 'Check to convert newlines (EOL) into line break HTML element',
    'position' => 'Position',
    'cache_time' => 'Cache Time',
    'cache_time_desc' => 'This block will be cached for no longer than this many seconds. If 0 caching is disabled. (3600 = 1 hour,  86400 = 1 day)',
    'block_type_gldefault' => 'System',
    'block_type_normal' => 'Normal',
    'block_type_phpblock' => 'PHP',
    'block_type_portal' => 'Portal',
    'block_type_dynamic' => 'Dynamic'
);

###############################################################################
# Block Locations

$LANG23 = array(
    'blocks_article_footer_name' => 'Article Footer',
    'blocks_article_footer_desc' => 'Display Blocks in article Footer',
    'blocks_article_topic_list_name' => 'Article Topic List',
    'blocks_article_topic_list_desc' => 'Displays Blocks right after every X number of articles in topics.'
);

###############################################################################
# admin/article.php

$LANG24 = array(
    1 => 'Vorherige Artikel',
    2 => 'Nächste Artikel',
    3 => 'Modus',
    4 => 'Format',
    5 => 'Artikel-Editor',
    6 => 'Es sind keine Artikel vorhanden.',
    7 => 'Autor',
    8 => 'Speichern',
    9 => 'Vorschau',
    10 => 'Abbruch',
    11 => 'Löschen',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => 'Datum',
    16 => 'Einleitung',
    17 => 'Haupttext',
    18 => 'Angezeigt',
    19 => 'Kommentare',
    20 => 'Ping',
    21 => 'Senden',
    22 => 'Artikelliste',
    23 => 'Auf das Ändern-Symbol klicken, um einen Artikel zu ändern oder zu löschen. Um einen Artikel anzusehen, auf dessen Titel klicken. Auf Neu anlegen (s.o.) klicken, um einen neuen Artikel zu schreiben.',
    24 => 'Diese ID wird bereits für einen anderen Artikel benutzt. Bitte eine andere ID wählen.',
    25 => 'Fehler beim Speichern des Artikels',
    26 => 'Artikelvorschau',
    27 => '<p>Wenn Du [unscaledX] statt [imageX] verwendest, wird das Bild in Originalgröße eingebunden.',
    28 => '<p><strong>VORSCHAU:</strong> Der Vorschau-Button sollte nur verwendet werden, wenn der Artikel keine Bilder enthält. Bei Artikeln mit Bildern empfiehlt es sich, den Artikel als Entwurf zu markieren, zu speichern und dann von der Liste der Artikel aus zu betrachten.</p>',
    29 => 'Trackbacks',
    30 => 'Fehler beim Datei-Upload',
    31 => 'Bitte mindestens die Felder Titel und Einleitung ausfüllen',
    32 => 'Hauptartikel',
    33 => 'Es kann nur einen Hauptartikel geben',
    34 => 'Entwurf',
    35 => 'Ja',
    36 => 'Nein',
    37 => 'Mehr von',
    38 => 'Mehr aus',
    39 => 'E-Mails',
    40 => '',
    41 => "Du hast keine Zugriffsrechte für diesen Artikel. Dieser Zugriffsversuch wurde protokolliert. Du kannst Dir den Artikel aber ansehen (s.u., Ändern nicht möglich). <a href=\"{$_CONF['site_admin_url']}/article.php\">Zurück zum Administrator-Menü</a>.",
    42 => "Du hast keine Zugriffsrechte für diesen Artikel. Dieser Zugriffsversuch wurde protokolliert. <a href=\"{$_CONF['site_admin_url']}/article.php\">Zurück zum Administrator-Menü</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>HINWEIS:</b> Wenn Du hier ein Datum in der Zukunft einstellst, wird der Artikel erst veröffentlicht, wenn dieser Zeitpunkt erreicht ist. Bis dahin wird der Artikel auch nicht in der RSS-Datei, der Suche und der Statistik erscheinen.',
    47 => 'Bilder',
    48 => 'image',
    49 => 'right',
    50 => 'left',
    51 => '<p>Die oben ausgewählten Bilder können im Artikel verwendet werden, indem dafür spezielle Platzhalter in den Text eingefügt werden. Diese Platzhalter sind [imageX], [imageX_right] und [imageX_left], wobei statt des X jeweils die Nummer des Bildes eingetragen werden muss.<br' . XHTML . '>HINWEIS: Es müssen alle ausgewählten Bilder verwendet werden. Andernfalls kann der Artikel nicht gespeichert werden.<br' . XHTML . '>',
    52 => '',
    53 => 'wurde nicht verwendet. Du musst dieses Bild im Text des Artikels verwenden oder es löschen bevor Du Deine Änderungen sichern kannst.',
    54 => 'Nicht verwendete Bilder',
    55 => 'Folgende Fehler traten beim Versuch, den Artikel zu speichern, auf. Bitte diese Fehler beheben und den Artikel noch einmal speichern.',
    56 => 'mit Symbol',
    57 => 'Bild in Originalgröße',
    58 => 'Archivieren',
    59 => 'Option',
    60 => '',
    61 => 'automatisch archivieren',
    62 => 'automatisch löschen',
    63 => 'Kommentare abschalten',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Editierbereich vergrößern',
    68 => 'Editierbereich verkleinern',
    69 => 'Veröffentlichungsdatum',
    70 => 'Auswahl der Symbolleiste',
    71 => 'Einfache Symbolleiste',
    72 => 'Normale Symbolleiste',
    73 => 'Extra Symbolleiste',
    74 => 'Extra II Symbolleiste',
    75 => 'Alle Symbole',
    76 => 'Veröffentlichung',
    77 => 'JavaScript muß für den WYSIWYG-Editor an sein. Der WYSIWYG-Editor kann in der Geeklog Konfiguration ausgeschaltet werden.',
    78 => 'Klick <a href="%s/article.php?mode=edit&amp;sid=%s&amp;editopt=default">hier</a>, um den Standard-Editor zu verwenden',
    79 => 'Vorschau',
    80 => 'Editor',
    81 => 'Veröffentlichung',
    82 => 'Bilder',
    83 => 'Archivierung',
    84 => 'Rechte',
    85 => 'Alles anzeigen',
    86 => 'WYSIWYG-Editor',
    87 => 'Artikel-Statistik',
    88 => 'Format im Wiki-Stil',
    89 => 'Metatag Description',
    90 => 'Metatag Keywords',
    91 => 'Du kannst aber jederzeit auf "Vorschau" klicken, um diese Zeit zu verlängern.',
    92 => 'You might also like',
    93 => '#',
    94 => 'Resized',
    95 => 'Original',
    96 => 'Upload | Replace',
    97 => 'No Image',
    'autotag_desc_story' => '[article: id alternate title] - Displays a link to an article using the Article Title as the title. An alternate title may be specified but is not required.',
    'autotag_desc_article' => '[article: id alternate title] - Displays a link to an article using the Article Title as the title. An alternate title may be specified but is not required.',
    'cache_time' => 'Cache Time',
    'cache_time_desc' => 'This article will be cached for no longer than this many seconds. If 0 caching is disabled. If -1 cached until article is edited again. (3600 = 1 hour,  86400 = 1 day)'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Kategorie-Editor',
    2 => 'Kategorie-ID',
    3 => 'Kategorie-Name',
    4 => 'Kategorie-Bild',
    5 => '(keine Leerzeichen!)',
    6 => 'Löschen einer Kategorie löscht auch alle dazu gehörenden Artikel und Blöcke',
    7 => 'Bitte die Felder Kategorie-ID und Kategorie-Name ausfüllen',
    8 => 'Kategorie-Manager',
    9 => 'Auf eine Kategorie klicken, um sie zu ändern oder zu löschen. Auf Neu anlegen (s.o.) klicken, um eine neue Kategorie anzulegen. Die nötige Zugriffsberechtigung wird in Klammern hinter der Kategorie angegeben. Das Sternchen(*) markiert die Default-Kategorie.',
    10 => 'Sortierreihenfolge',
    11 => 'Artikel/Seite',
    12 => 'Zugriff verweigert',
    13 => "Du hast keine Zugriffsrechte für diese Kategorie. Dieser Zugriffsversuch wurde protokolliert. <a href=\"{$_CONF['site_admin_url']}/topic.php\">Zurück zum Administrator-Menü</a>.",
    14 => 'Sortiermethode',
    15 => 'alphabetisch',
    16 => 'Grundeinstellung:',
    17 => 'Neue Kategorie',
    18 => 'Schaltzentrale',
    19 => 'Speichern',
    20 => 'Abbruch',
    21 => 'Löschen',
    22 => 'Grundeinstellung',
    23 => 'Zur voreingestellten Kategorie für neue Artikel machen',
    24 => '(*)',
    25 => 'Archiv-Kategorie',
    26 => 'Zur Archiv-Kategorie machen (nur für eine Kategorie möglich)',
    27 => 'oder ein Symbol hochladen',
    28 => 'maximal',
    29 => 'Fehler beim Datei-Upload',
    30 => 'Artikel i.d. Kategorie',
    31 => 'You have used a restricted Topic ID. Please choose another one.',
    32 => 'Übergeordnete Kategorie',
    33 => 'Erben',
    34 => 'Artikel von Unterkategorien erben',
    35 => 'Versteckt',
    36 => 'Kategorie wird versteckt und kann nicht eingesehen werden, nur vererbt',
    37 => 'Root',
    38 => 'Alle',
    39 => 'Nur auf der Startseite',
    40 => 'Assign one or more topics. ',
    41 => 'Wenn "Alle" ausgewählt ist, wird das Objekt für alle Kategorien angezeigt. Wenn "Nur auf der Startseite" ausgewählt ist, wird das Objekt nur auf der Startseite angezeigt. Andernfalls muss mindestens eine Kategorie ausgewählt werden.',
    'topic_control_select_topics' => 'Else you must select at least one topic to assign the item to. ',
    'topic_control_select_topics_disabled' => 'Else you must select at least one topic you have edit access for, to assign the item to (text is darker). ',
    'topic_control_no_topics' => 'Unfortunately you do not have edit access to any topics so none can be selected. ',
    42 => 'Inherit contains the list of assigned topics. If the topic is selected then the item will be inherited by the parent topic. You must save your item first before anything is listed in the inherit box. ',
    43 => 'Default contains the list of assigned topics. This is the default topic that will be used when displaying the item if the actual topic the user is in is not found. ',
    44 => 'Erben',
    45 => 'Default',
    46 => 'Your parent topic cannot be the Archive topic. Please choose a different Parent Topic.',
    47 => 'An Archive Topic cannot have any child topics. Please remove any child topics before making a topic the Archive Topic.',
    48 => 'Parent Topic Id not found.',
    49 => 'This Topic ID is already being used. Please choose another one.',
    50 => 'Ja',
    51 => 'Nein',
    52 => 'Artikel',
    53 => 'Bild',
    54 => 'Selected',
    55 => 'Assigned',
    'breadcrumb_separator' => '>',
    'breadcrumb_root' => 'Home',
    'autotag_desc_topic' => '[topic: id alternate title] - Displays a link to a topic using the ID as the title. An alternate title may be specified but is not required.',
    'autotag_desc_related_topics' => '[related_topics:id type:plugin max:max_items_listed] - Creates a clickable horizontal list of related topics based on the item id and type.',
    'autotag_desc_related_items' => '[related_items:id type:plugin max:max_items_listed trim:max_length include:plugin] - Create a clickable list of related items based on the item id and type.',
    'no_related_items' => 'No related items found.',
    'topics:' => 'Topics:',
    'filed_under:' => 'Filed under:',
    'topic_title' => 'Topic Title',
    'topic_title_desc' => 'Used as the page title for the topic. If empty the topic name will be used.',
    'move_topic_up' => 'Move topic up the sort order',
    'move_topic_down' => 'Move topic down in the sort order',
    'topics_edit_access_select' => 'You can only select topics you have Edit access to you (text is darker).',
    'topics_edit_access_listed' => 'Only topics with Edit access are listed.'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'User-Editor',
    2 => 'User-ID',
    3 => 'Username',
    4 => 'Name',
    5 => 'Passwort',
    6 => 'Security Level',
    7 => 'E-Mail-Adresse',
    8 => 'Homepage',
    9 => '(keine Leerzeichen!)',
    10 => 'Bitte die Felder Username und E-Mail-Adresse ausfüllen.',
    11 => 'User-Manager',
    12 => 'Auf das Ändern-Symbol klicken, um einen User zu ändern oder zu löschen. Ein neuer User kann mit Neu anlegen (s.o.) angelegt werden.',
    13 => 'SecLev',
    14 => 'Reg. Datum',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'Speichern',
    21 => 'Dieser Username existiert bereits.',
    22 => 'Fehler',
    23 => 'Import',
    24 => 'Mehrfach-Import von Usern',
    25 => 'Hier können Userdaten aus einer Datei in Geeklog importiert werden. Die Import-Datei muss ein Textfile sein, bei dem die Datensätze durch Tabs getrennt sind. Zudem müssen die Felder in der Reihenfolge Richtiger Name - Username - E-Mail-Adresse vorliegen. Jeder so importierte User bekommt eine E-Mail mit einem Zufallspasswort zugeschickt. Pro Zeile darf nur ein User stehen. Wenn sich die Importdatei nicht an dieses Format hält, kann es zu Problemen kommen, die nur in mühseliger Handarbeit behoben werden können. Also die Einträge lieber zweimal überprüfen ...',
    26 => '',
    27 => '',
    28 => 'Ankreuzen, um dieses Bild zu löschen:',
    29 => 'Pfad',
    30 => 'Importieren',
    31 => 'Neue User',
    32 => 'Datei bearbeitet. %d User wurden importiert, dabei traten %d Fehler auf.',
    33 => 'Abschicken',
    34 => 'Fehler: Keine Datei zum Upload angegeben.',
    35 => 'Letzte Anmeldung',
    36 => '(noch nie)',
    37 => 'UID',
    38 => 'Gruppenliste',
    39 => 'Passwort (nochmal)',
    40 => 'Registriert',
    41 => 'Letzte Anmeldung',
    42 => 'Gesperrt',
    43 => 'Erwartet Aktivierung',
    44 => 'Erwartet Freigabe',
    45 => 'Aktiv',
    46 => 'User-Status',
    'user_status_desc' => "An explanation of all possible user statuses: <ul>\n\n        <li><strong>Awaiting Activation</strong> - New account awaiting user to login. Email has been sent but not verified. This is only set for a new account and is an automated status (Admins cannot set accounts to this status manually)</li>\n\n        <li><strong>Awaiting Authorization</strong> - New account awaiting moderator approval in the User Submission Queue. When User Submission approved, user will be sent email with password. This is only set for a new account and is an automated status (Admins cannot set accounts to this status manually)</li>\n\n        <li><strong>Active</strong> - This is an Active account.</li>\n\n        <li><strong>Banned</strong> -  This Account is banned/disabled. Username is crossed out on the site for any content they have submitted, User cannot login, emails to account is disabled, and profile cannot be viewed by any user except Admins.</li>\n\n        <li><strong>Locked</strong> - This Account is locked. User cannot login, emails to account is disabled, but profile can still be viewed by all.</li>\n\n        <li><strong>New Email Required</strong> - Emails to account is disabled. When user logs in again they must submit new email address and verify before access to rest of the website (under this user account). Status stays the same until email is verified. If \"Require User Email\" config option true then any users who login (includes remote accounts) that do not have an email address will automatically switch to this status.</li>\n\n        <li><strong>New Password Required</strong> -  When the user logs in they must submit a new password before access to rest of website (under this user account). This is only for regular accounts and not remote accounts.</li>\n\n        </ul>\n\n    ",
    47 => 'Ändern',
    48 => 'Admin-Gruppen anzeigen',
    49 => 'Admin-Gruppe',
    50 => 'Ankreuzen, um diese Gruppe als "Admin-Gruppe" ausfiltern zu können',
    51 => 'Online Days',
    52 => '<br' . XHTML . '>Hinweis: "Online Days" ist die Anzahl der Tage zwischen der ersten Anmeldung und der letzten.',
    53 => 'registriert',
    54 => 'User löschen',
    55 => 'Dies funktioniert nur, wenn die Funktion \'Letzte Anmeldung aufzeichnen\' in der Konfiguration aktiviert wurde.',
    56 => 'Bitte den Typ User wählen, der gelöscht werden soll und "Liste aktualisieren" drücken. Dann die aus der Liste abhaken, die nicht gelöscht werden sollen und "Delete" drücken. Es werden nur die gelöscht, die gegenwärtig sichtbar sind. Dieser Hinweis für den Fall, dass die Liste sich über mehrere Seiten erstreckt.',
    57 => 'Phantom-User',
    58 => 'Einmal-User',
    59 => 'Alte User',
    60 => 'User, angemeldet vor mehr als ',
    61 => ' Monaten, aber nie eingeloggt.',
    62 => 'User, angemeldet vor mehr als  ',
    63 => ' Monaten, dann nur einmalig innerhalb 24 h eingeloggt.',
    64 => 'Normale User, die einfach die Site seit ',
    65 => ' Monaten nicht mehr besucht haben.',
    66 => 'Liste aktualisieren',
    67 => 'Monate seit Anmeldung',
    68 => 'Online Stunden',
    69 => 'Offline Monate',
    70 => 'konnte nicht gelöscht werden',
    71 => 'erfolgreich gelöscht',
    72 => 'Kein User zum Löschen vorgemerkt',
    73 => 'Alle ausgewählten User dauerhaft löschen?',
    74 => 'Aktuelle User',
    75 => 'User, angemeldet in den letzten ',
    76 => ' Monaten.',
    77 => 'Erinnerung zum Einloggen an die ausgewählten User schicken',
    78 => 'Erinnerung schicken',
    79 => 'Keine User ausgewählt für Erinnerung',
    80 => 'Erinnerung erfolgreich verschickt',
    81 => 'Erinnerung, um den Account zu verifizieren für %s',
    82 => "Dein Account auf der Seite {$_CONF['site_name']} wurde nicht benutzt seit %s und wird deaktiviert, wenn Du nicht innerhalb 30 Tagen einloggst.",
    83 => "Dein Account auf der Seite {$_CONF['site_name']} wurde seit der Einrichtung nicht benutzt und wird gelöscht, wenn Du nicht in Kürze einloggst.",
    84 => "Dein Einlogname ist: %s  auf der Site: {$_CONF['site_url']}",
    85 => 'Wenn Du das Passwort vergessen hast, benutze folgenden Link: %s',
    86 => 'Enthalten',
    87 => 'Erinnerungen',
    88 => 'Voreingestellte Gruppe',
    89 => 'Anklicken, um diese Gruppe zur voreingestellten Gruppe zu machen für neue User',
    90 => '"Voreingestellte Gruppe" anwenden, um dies auch bei existierenden Usern zu ändern.',
    91 => 'Send password to user',
    92 => 'Only for new users or when changing password for existing user.',
    'convert_remote' => 'Check here to convert from remote to a local account',
    'convert_remote_desc' => 'When a remote account is converted to a local account, a password will be automatically generated. If the account does not have a confirmed email address, the account will be locked after it is converted since the user will have no way of retrieving the password. Once converted and if the account is active and has an email address the user will be emailed the password or they can request the password by using the forget password link from the Login page. For user accounts that do not have an active status and valid email you will have to manually notify the user of the account change and how to login.',
    'contributed' => 'Contributed',
    'na' => 'NA',
    'nothing' => 'Nothing',
    'autotag_desc_user' => '[user: id alternate title] - Displays a link to a User using the Username as the title. An alternate title may be specified but is not required.',
    'USER_ACCOUNT_LOCKED' => 'Locked',
    'USER_ACCOUNT_NEW_EMAIL' => 'New Email Required',
    'USER_ACCOUNT_NEW_PASSWORD' => 'New Password Required'
);

###############################################################################
# admin/moderation.php
# admin/index.php

$LANG29 = array(
    1 => 'Akzeptieren',
    2 => 'Löschen',
    3 => 'Editieren',
    4 => 'Profil',
    10 => 'Titel',
    11 => 'Startdatum',
    12 => 'URL',
    13 => 'Kategorie',
    14 => 'Datum',
    15 => 'Kategorie',
    16 => 'Username',
    17 => 'Name',
    18 => 'E-Mail',
    34 => 'Schaltzentrale',
    35 => 'Beiträge: Artikel',
    36 => 'Bezug oder Kommentar',
    37 => 'Author',
    38 => 'Abschicken',
    39 => 'Derzeit gibt es keine Beiträge zu moderieren.',
    40 => 'Neue User',
    41 => 'Beiträge: Kommentare',
    42 => 'Username',
    43 => 'Moderation aufheben?',
    44 => 'Results of your moderation',
    45 => 'Approved %1$d items and deleted %2$d items of user submissions.',
    46 => 'User Profile Updated',
    'core' => 'Core',
    'plugins' => 'Plugins',
    'tools' => 'Tools',
    'users' => 'Users',
    'submissions_desc' => 'To modify or delete a user submssion, click on that item\'s edit icon below. To approve and delete multiple submissions use the radio options in the lists and then click submit.',
    'max_invalid_login' => 'Max Invalid Logins Reached for User',
    'max_invalid_login_msg' => 'This user has reached the maximum number of invalid login attempts () within the specified time limit ( seconds). The last IP to make an invalid login attempt is %s. Either the real user has forgotten the password for their account, or someone else is attempting to guess the password for this user account.'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "{$_CONF['site_name']} Mail Utility",
    2 => 'Von (Name)',
    3 => 'Von (E-Mail)',
    4 => 'Betreff',
    5 => 'Nachricht',
    6 => 'Senden',
    7 => 'Alle User',
    8 => 'Admin',
    9 => 'Optionen',
    10 => 'HTML',
    11 => 'Wichtige Nachricht!',
    12 => 'Abschicken',
    13 => 'Reset',
    14 => 'User-Einstellungen ignorieren',
    15 => 'Fehler beim Senden an: ',
    16 => 'E-Mail erfolgreich gesendet an: ',
    17 => "<a href=\"{$_CONF['site_admin_url']}/mail.php\">Noch eine Nachricht schreiben</a>",
    18 => 'An',
    19 => 'HINWEIS: Wenn Du eine Nachricht an alle eingetragenen Benutzer schicken willst, musst Du die Gruppe Logged-in Users auswählen.',
    20 => "<successcount> Nachricht(en) erfolgreich verschickt, bei <failcount> Nachricht(en) traten Fehler auf. Details können der folgenden Liste entnommen werden. Du kannst jetzt <a href=\"{$_CONF['site_admin_url']}/mail.php\">noch eine Nachricht schicken</a> oder <a href=\"{$_CONF['site_admin_url']}/moderation.php\">zurück zum Admin-Menü gehen</a>.",
    21 => 'Fehler',
    22 => 'Erfolgreich',
    23 => 'Keine Fehler',
    24 => 'Keine erfolgreich',
    25 => '-- Gruppe wählen --',
    26 => 'Um eine E-Mail verschicken zu können, müssen alle Felder ausgefüllt und eine Gruppe von Benutzern aus dem Drop-Down-Menü ausgewählt werden.',
    27 => 'The following template variables are available in <strong>Subject</strong> and <strong>Message</strong>: {uid}, {username}, {fullname}, {email}, {homepage}, {theme}, {language}, {location}, {lastgranted}, {lastlogin}, {site_url}, {site_name}, {site_slogan}, {owner_name}, {copyrightyear}, {site_mail}, {noreply_mail}',
    'email_divider' => '------------------------------------------------------------',
    'email_divider_html' => '<hr' . XHTML . '>',
    'sig_divider' => '---',
    'sig_divider_html' => '---<br' . XHTML . '>',
    'email_footer_msg_noreply' => 'The address used to send this email is not monitored. Please do not reply to this email.',
    'email_footer_msg_content' => 'If content from the website is displayed in this email, there may be layout changes which result in formatting issues.',
    'ip_address_email' => 'IP address that initiated email:'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Installing plugins could possibly cause damage to your Geeklog installation and, possibly, to your system.  It is important that you only install plugins downloaded from the <a href="https://www.geeklog.net">Geeklog Homepage</a> as we thoroughly test all plugins submitted to our site on a variety of operating systems.  It is important that you understand that the plugin installation process will require the execution of a few filesystem commands which could lead to security problems particularly if you use plugins from third party sites.  Even with this warning you are getting, we do not gaurantee the success of any installation nor are we liable for damage caused by installing a Geeklog plugin.  In other words, install at your own risk.  For the wary, directions on how to manually install a plugin is included with each plugin package.',
    2 => 'Plugin-Installation -- Disclaimer',
    3 => 'Plugin-Installationsformular',
    4 => 'Plugin-Datei',
    5 => 'Plugin-Liste',
    6 => 'Warnung: Plugin schon installiert!',
    7 => 'Das Plugin, das Du installieren willst, ist schon vorhanden. Bitte lösche es, bevor Du noch einmal versuchst, es zu installieren',
    8 => 'Plugin-Kompatibilitätstest fehlgeschlagen',
    9 => 'Dieses Plugin benötigt eine neuere Version von Geeklog. Abhilfe schafft ein Update von <a href="https://www.geeklog.net/">Geeklog</a>.',
    10 => '<br' . XHTML . '><b>Es sind derzeit keine Plugins installiert.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'Um ein Plugin zu ändern oder zu löschen, auf das Ändern-Symbol klicken. Es werden dann auch weitere Details, inkl. der Homepage des Plugins, angezeigt. Wenn in der Liste (s.u.) zwei Versionsnummern für ein Plugin angezeigt werden, bedeutet das, dass für das Plugin noch ein Update durchgeführt werden muss. Um ein Plugin zu installieren oder aktualisieren bitte auch immer dessen Dokumentation lesen.',
    12 => '(kein Name angegeben)',
    13 => 'Plugin-Editor',
    14 => 'Neues Plugin',
    'installed_plugins' => 'Installed Plugins',
    15 => 'Schaltzentrale',
    16 => 'Name des Plugins',
    17 => 'Plugin-Version',
    18 => 'Geeklog-Version',
    19 => 'Aktiv',
    20 => 'Ja',
    21 => 'Nein',
    22 => 'Installieren',
    23 => 'Speichern',
    24 => 'Abbruch',
    25 => 'Löschen',
    26 => 'Name des Plugins',
    27 => 'Plugin-Homepage',
    28 => 'Plugin-Version',
    29 => 'Geeklog-Version',
    30 => 'Plugin löschen?',
    31 => 'Soll das Plugin wirklich gelöscht werden? Dies wird alle Daten und Datenstrukturen löschen, die dieses Plugin benutzt. Wenn ja, dann jetzt bitte noch einmal auf Löschen klicken.',
    32 => '<p><b>Fehler: Ungültiges Format für Autolink.</b></p>',
    33 => 'Code-Version',
    34 => 'Aktualisieren',
    35 => 'Ändern',
    36 => 'Code',
    37 => 'Aktuell',
    38 => 'Bitte aktualisieren!',
    39 => 'Ein Plugin hochladen',
    40 => 'Ein Plugin-Archiv (.tar.gz, .tgz, .zip) kann hier direkt hochgeladen werden:',
    41 => 'Hochladen',
    42 => 'Für Update klicken',
    43 => 'Reihenfolge',
    44 => 'Plugin früher laden',
    45 => 'Plugin später laden',
    46 => 'Plugin löschen',
    47 => 'Das %s-Plugin wirklich löschen?',
    48 => 'Plugin inaktiv. Zum Aktivieren klicken.',
    49 => 'Plugin aktiv. Zum Deaktivieren klicken.',
    50 => 'Abhängigkeiten',
    51 => 'OK',
    52 => 'Nicht gelöst',
    53 => 'Deaktiviert',
    54 => 'Nicht verfügbar',
    55 => 'Deinstalliert',
    56 => 'Falsche Version',
    57 => 'Die Lade-Reihenfolge von einem oder mehrere Plugins wurde geändert, um Abhängigkeiten aufzulösen.',
    58 => 'The load order of one or more plugins has been altered in order to resolve dependencies',
    59 => 'Info',
    60 => 'Schließen',
    61 => 'Status',
    62 => 'Plugin installieren',
    63 => 'Dieses Plugin kann nicht installiert werden',
    64 => 'Dieses Plugin kann nicht aktiviert werden',
    65 => 'Die Funktion zum Hochladen eine Plugins wurde deaktiviert. Grund:',
    66 => 'Hochladen von Dateien ist in Deiner PHP-Konfiguration deaktiviert.',
    67 => 'Das Verzeichnis "%s" ist nicht beschreibbar.',
    68 => 'Du hast nicht die nötigen Rechte, um Plugins installieren zu können.',
    69 => 'Du hast nicht die nötigen Rechte, um Plugins hochladen zu können.',
    'delete' => 'Delete',
    'delete_plugin' => 'Delete Plugin and all of its files?',
    'click_to_delete_msg' => 'Click to Delete this Plugin files',
    'really_delete_msg' => 'Really Delete %s Plugin files?',
    99 => 'Ein unbekannter Fehler ist aufgetreten',
    100 => 'Ok.',
    101 => 'Die Datei zum Hochladen ist größer als die Einstellung upload_max_filesize auf dem Webspace erlaubt.',
    102 => 'Die Datei zum Hochladen ist größer als die Einstellung MAX_FILE_SIZE, die im HTML-Formular angegeben wurde.',
    103 => 'Die Datei wurde nur teilweise hochgeladen.',
    104 => 'Es ist keine Datei hochgeladen worden.',
    105 => '(undefinierter Fehler)',
    106 => 'Es fehlt ein temporäres Unterverzeichnis.',
    107 => 'Datei konnte nicht geschrieben werden.',
    108 => 'Hochladen wurde wegen der Dateiendung gestoppt.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'Newsfeed anlegen',
    2 => 'Speichern',
    3 => 'Löschen',
    4 => 'Abbruch',
    10 => 'Newsfeed',
    11 => 'Neuer Newsfeed',
    12 => 'Schaltzentrale',
    13 => 'Um einen Newsfeed zu ändern oder zu löschen, auf das Ändern-Symbol (s.u.) klicken. Um einen neuen Newsfeed anzulegen, auf Neu anlegen (s.o.) klicken.',
    14 => 'Titel',
    15 => 'Art',
    16 => 'Dateiname',
    17 => 'Format',
    18 => 'letztes Update',
    19 => 'Aktiv',
    20 => 'Ja',
    21 => 'Nein',
    22 => '<i>(keine Newsfeeds)</i>',
    23 => 'Alle Artikel',
    24 => 'Newsfeed-Editor',
    25 => 'Newsfeed-Titel',
    26 => 'Limit',
    27 => 'Länge d. Einträge',
    28 => '(0 = ohne Text, 1 = kompletter Text, anderer Wert = nur so viele Zeichen)',
    29 => 'Beschreibung',
    30 => 'Letztes Update',
    31 => 'Zeichensatz',
    32 => 'Sprache',
    33 => 'Inhalt',
    34 => 'Einträge',
    35 => 'Stunden',
    36 => 'Art des Newsfeeds festlegen',
    37 => '',
    38 => 'Fehler: Nicht alle Felder ausgefüllt',
    39 => 'Bitte die Felder Newsfeeds-Titel, Beschreibung und Dateiname ausfüllen.',
    40 => 'Bitte ein Limit (Anzahl Einträge oder Anzahl Stunden) eingeben.',
    41 => 'Links',
    42 => '',
    43 => 'Alle',
    44 => 'Keine',
    45 => 'Newsfeed-Link für Kategorie',
    46 => 'Limit Results',
    47 => 'Suchen',
    48 => 'Ändern',
    49 => 'Newsfeed-Logo',
    50 => "Relativ zur URL dieser Site ({$_CONF['site_url']})",
    51 => 'Der gewählte Dateiname wird bereits von einem anderen Newsfeed verwendet. Bitte einen anderen Namen wählen.',
    52 => 'Fehler: Dateiname existiert schon',
    53 => 'Alle auf der Startseite',
    54 => 'Bitte die Art des Newsfeeds auswählen.',
    55 => 'Artikel',
    'num_articles' => '%s Article(s)'
);

###############################################################################
# admin/language.php (since v2.1.2)

$LANG_LANG = array(
    'language_admin_title' => 'Language Overrides',
    'language_manager' => 'Language Manager',
    'new_language_msg' => 'To modify or delete a language item, click on that item\'s edit icon below. To create a new item, click on "Create New" above.',
    'language_editor' => 'Language Editor',
    'id' => 'ID',
    'language' => 'Language',
    'name' => 'Name',
    'var_name' => 'Var Name',
    'name_tip' => 'Required just for language arrays.',
    'var_name_tip' => 'Can be a regular variable or array. Do not include the dollar sign at the beginning of the variable/array name.',
    'value' => 'Value'
);

###############################################################################
# admin/router.php

$LANG_ROUTER = array(
    1 => 'URL routing',
    2 => 'Routing Manager',
    3 => 'ID',
    4 => 'method',
    5 => 'rule',
    6 => 'route',
    7 => 'priority',
    8 => 'Increase priority',
    9 => 'Decrease priority',
    10 => 'Edit routing',
    11 => 'To modify or delete a route, click on the route\'s edit icon below. To create a new route, click on "Create New" above.  When you use placeholders (@), you must define the same placeholders in a rule and its route.',
    12 => 'Bad request method',
    13 => 'Rule is a mandatory item.',
    14 => 'Route is a mandatory item.',
    15 => 'Placeholders (@) in a rule and those in a route must be the same.',
    16 => 'Route must not start with "/index.php/".',
    17 => 'Database error occurred.',
    18 => '<strong>To enable URL routing, you have to enable URL rewrite in the Configuration.</strong>',
    19 => '<strong>To enable URL routing, you have to enable URL routing in the Configuration.</strong>',
    20 => '<ul><li>Placeholders (@) must be the same both in a rule and its route.</li><li>A placeholder starts with "@", followed by an alphabet, optionally followed by any length of alphabet or digit.</li><li>Placeholders are case-sensitive.</li></ul>',
    21 => 'Status Code',
    22 => 'Enabled',
    23 => 'Yes',
    24 => 'No'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Dein Passwort sollte in Kürze per E-Mail bei Dir eintreffen. Bitte beachte die Hinweise in der E-Mail. Danke, dass Du Dich bei {$_CONF['site_name']} angemeldet hast.",
    2 => "Danke für Deinen Beitrag zu {$_CONF['site_name']}. Der Artikel wurde an unser Team weitergeleitet. Wenn er akzeptiert wird, wird er bald auf dieser Website für alle Besucher zu lesen sein.",
    3 => '',
    4 => '',
    5 => 'Userprofil wurde gespeichert.',
    6 => 'Einstellungen wurden gespeichert.',
    7 => 'Kommentar-Einstellungen wurden gespeichert.',
    8 => 'Abmeldung erfolgt. Du bist jetzt nicht mehr angemeldet.',
    9 => 'Artikel wurde gespeichert.',
    10 => 'Artikel wurde gelöscht.',
    11 => 'Block wurde gespeichert.',
    12 => 'Der Block wurde gelöscht.',
    13 => 'Kategorie wurde gespeichert.',
    14 => 'Die Kategorie und alle zugehörigen Artikel wurden gelöscht.',
    15 => 'Der Kommentar wurde gespeichert, muss aber noch von einem Moderator freigegeben werden.',
    16 => 'Abonnement wurde gelöscht. Du wirst nicht länger über Antworten benachrichtigt.',
    17 => 'Your user account has been locked and access to it has been disabled. For more information please contact the Admin.',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Der User wurde gespeichert.',
    22 => 'Der User wurde gelöscht.',
    23 => 'Your passwords must match, please try again. Passwords are case sensitive.',
    24 => 'Your emails must match, please try again.',
    25 => 'You have not entered a valid email address, please try again.',
    26 => 'That email address is already being used by an account, please try again.',
    27 => 'Nachricht wurde verschickt.',
    28 => 'Das Plugin wurde gespeichert.',
    29 => 'Du hast keinen Zugriff auf diese Administrationsseite. Alle Versuche, auf Bereiche ohne entsprechende Berechtigung zuzugreifen, werden protokolliert.',
    30 => 'Zugriff verweigert',
    31 => 'Sorry, This feature is not supported by the  database server this website is using.  Please note that all attempts to access unsupported features are logged.',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'System-Nachricht',
    41 => '',
    42 => '',
    43 => 'Account does not exist.',
    44 => 'Das Plugin wurde erfolgreich installiert.',
    45 => 'Das Plugin wurde gelöscht.',
    46 => 'Your username or email address was not found, please try again.',
    47 => 'Sorry you cannot currently request the password for your account. For more information please contact the Admin.',
    48 => "Danke, dass Du dich bei {$_CONF['site_name']} angemeldet hast. Dein Aufnahmeantrag wird von unserem Team geprüft. Sobald er akzeptiert wird, wirst Du Dein Passwort per E-Mail erhalten.",
    49 => 'Die Gruppe wurde gespeichert.',
    50 => 'Die Gruppe wurde gelöscht.',
    51 => 'Dieser Username ist schon vergeben. Bitte wähle einen anderen.',
    52 => 'Die angegebene E-Mail-Adresse scheint nicht gültig zu sein.',
    53 => 'Dein neues Passwort wurde gespeichert. Bitte melde Dich nun mit dem neuen Passwort an.',
    54 => 'Diese Anfrage für ein neues Passwort ist nicht mehr gültig. Bitte fordere erneut ein neues Passwort an.',
    55 => 'Du solltest in Kürze eine E-Mail erhalten, in der beschrieben wird, wie Du ein neues Passwort für Deinen Account eingeben kannst.',
    56 => 'Die angegebene E-Mail-Adresse wird schon für einen anderen Account verwendet.',
    57 => 'Dein Account wurde gelöscht.',
    58 => 'Der Newsfeed wurde gespeichert.',
    59 => 'Der Newsfeed wurde gelöscht.',
    60 => 'Das Plugin wurde erfolgreich aktualisiert.',
    61 => 'Plugin %s: Unbekannter Text-Platzhalter',
    62 => 'Der Trackback-Kommentar wurde gelöscht.',
    63 => 'Beim Löschen des Trackback-Kommentars trat ein Fehler auf.',
    64 => 'Trackback-Kommentar wurde erfolgreich verschickt.',
    65 => 'Das Weblog-Verzeichnis wurde gespeichert.',
    66 => 'Das Weblog-Verzeichnis wurde gelöscht.',
    67 => 'Das neue Passwort stimmt nicht mit dem Bestätigungs-Passwort überein!',
    68 => 'Gib bitte Dein korrektes aktuelles Passwort ein.',
    69 => 'Dein Account wurde gesperrt!',
    70 => 'Dein Account wurde noch nicht freigeschaltet.',
    71 => 'Dein Account wurde bestätigt, muss aber noch freigeschaltet werden.',
    72 => 'Bei der Installation des Plugins trat ein Fehler auf. Siehe error.log für weitere Informationen.',
    73 => 'Bei der Deinstallation des Plugins trat ein Fehler aus. Siehe error.log für weitere Informationen.',
    74 => 'Der Pingback wurde erfolgreich verschickt.',
    75 => 'Trackbacks müssen als POST-Request verschickt werden.',
    76 => 'Willst Du diesen Eintrag wirklich löschen?',
    77 => 'HINWEIS:<br' . XHTML . '>Du hast UTF-8 als Standard-Zeichensatz angegeben. Dein Webserver unterstützt jedoch kein "multibyte encoding". Installiere bitte die mbstring-Erweiterungen für PHP oder benutze einen anderen Zeichensatz bzw. eine andere Sprache.',
    78 => 'Bitte sicherstellen, dass die angegebene E-Mail-Adresse in beiden Fällen die gleiche ist.',
    79 => 'Diese Funktion ist nicht mehr unter dieser URL verfügbar.',
    80 => 'Das Plugin, das diesen Newsfeed angelegt hat, ist derzeit nicht aktiviert. Dieser Newsfeed kann nicht bearbeitet werden, solange das Plugin deaktiviert ist.',
    81 => 'Hast Du Dich vertippt? Bitte versuche es noch einmal, Dich hier anzumelden.',
    82 => 'Du hast die erlaubte Anzahl von Anmeldeversuchen überschritten. Bitte versuche es später noch einmal.',
    83 => 'Um das Passwort, die E-Mail-Adresse oder die "Angemeldet für"-Zeit zu ändern müsst Du das aktuelle Passwort eingeben.',
    84 => 'Um den Account zu löschen, bitte aktuelles Passwort eingeben.',
    85 => 'Es gab ein Problem, die E-Mail zu senden.',
    86 => 'Der OpenID-Server erklärte Deinen Einlogversuch für ungültig.',
    87 => 'OpenID-Login wurde vom User abgebrochen.',
    88 => 'Der OpenID-Server gab einen Fehler zurück.',
    89 => 'Kann OpenID-Server zu der angegebenen Identity-URL nicht finden.',
    90 => 'OpenID-Identifizierung abgebrochen.',
    91 => 'You specified an invalid identity URL.',
    92 => "Bitte <a href=\"{$_CONF['site_admin_url']}/sectest.php\">die Sicherheit Deiner Site überprüfen</a> bevor Du sie benutzt!",
    93 => 'Database back up war erfolgreich.',
    94 => 'Backup Failed: Dateigröße unter 1kb',
    95 => 'Es gab einen Fehler.',
    96 => '',
    97 => '',
    98 => 'Das Plugin wurde erfolgreich hochgeladen.',
    99 => 'Das Plugin existiert schon.',
    100 => 'Die hochgeladene Plugindatei ist kein GZip oder Zip-Archiv.',
    101 => 'Es gibt keine Kategorien (auf die Du Zugriff hast). Es bedarf mindestens einer Kategorie, um Beiträge zu schreiben.',
    110 => 'Can not get URL for authentication.',
    111 => 'Authentication error.',
    112 => 'Certification has been canceled.',
    113 => 'Your account has been created successfully. {site_url}',
    114 => 'Your re-synch with your remote account has failed but your other account information has been successfully saved.',
    115 => 'Remote service has been disabled.',
    116 => 'Loading...',
    117 => 'Help page is not found.',
    118 => 'Click to select a date',
    119 => 'More..',
    120 => 'Send this?',
    121 => 'Saved a URL routing item.',
    122 => 'Could not save a URL routing item.',
    123 => 'Deleted a URL routing item.',
    130 => 'Your language item has been successfully deleted.',
    131 => 'Your language item has been successfully saved.',
    140 => 'Deleted comment(s).',
    141 => 'Failed to delete a comment.',
    142 => 'Approved comment(s).',
    143 => 'Banned user(s).',
    144 => 'Banned IP addresses with the Spamx plugin.',
    145 => 'Banned IP addresses with the Ban plugin.',
    150 => 'Successfully deleted all the files and directories used during the installation.',
    151 => 'Failed to delete some files and directories used during the installation.  Please remove them manually.',
    152 => 'All the files and directories used during the installation are left as they are.  It is dangerous to keep them on the server, so please don\'t forget to remove them manually.',
    153 => 'You last emailed an article %1$d seconds ago.  This site requires at least %2$d seconds between emailing articles.',
    160 => 'The plugin files was successfully deleted.',
    161 => 'The archive includes a file whose name includes an unsafe character.',
    400 => 'Nicht alle erforderlichen Felder konnten bestätigt werden',
    401 => 'Bitte den echten Namen eingeben',
    500 => 'The Template Cache has been successfully cleared.',
    501 => 'A verification message has been sent to your email address. Please click on the link in the email to confirm your email address and update your account. If you log into your account again before you verify your email address you will be asked again for a email address.<br' . XHTML . '><br' . XHTML . '>Please note you have now been successfully logged out so you can complete this verification.',
    502 => 'Your request for a new email has expired. Please try again below.',
    503 => 'Your email has been successfully verified.',
    504 => 'Passwords must have a minimum of 8 characters and contain at least 1 number and 1 letter. Passwords are case sensitive.',
    505 => "Warning - The current theme {$_CONF['theme']} v{$_CONF['theme_gl_version']} is not 100% compatible with this version of Geeklog (v2.2.1) and you will have issues using this site. The required minimum theme Geeklog version is v{$_CONF['min_theme_gl_version']}.",
    506 => "Warning - The current theme {$_CONF['theme']} (version not known) is not 100% compatible with this version of Geeklog (v2.2.1) and you will have issues using this site. The required minimum theme Geeklog version is v{$_CONF['min_theme_gl_version']}."
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Zugriff',
    'ownerroot' => 'Eigentümer/Root',
    'group' => 'Gruppe',
    'readonly' => 'Nur Lesen',
    'accessrights' => 'Zugriffsrechte',
    'owner' => 'Eigentümer',
    'grantgrouplabel' => 'Obige Gruppenrechte zum Editieren gewähren',
    'permmsg' => 'Hinweis: Mitglieder bedeutet alle eingeloggten Mitglieder und Gast steht für alle nicht eingeloggten Besucher.',
    'securitygroups' => 'Security-Gruppen',
    'editrootmsg' => "Obwohl Du ein User-Administrator bist, kannst Du die Informationen von Usern in der Root-Gruppe nicht ändern, ohne selbst Mitglied der Root-Gruppe zu sein. Du kannst die Informationen aller anderen User bearbeiten, nur nicht die der Mitglieder der Root-Gruppe. Beachte bitte, dass alle derartigen Versuche protokolliert werden. <a href=\"{$_CONF['site_admin_url']}/user.php\">Zurück zur User-Admin-Seite</a>.",
    'securitygroupsmsg' => 'Mit den Anklickkästchen kann man festlegen, zu welchen Gruppen dieser User gehört.',
    'groupeditor' => 'Gruppen-Editor',
    'description' => 'Beschreibung',
    'name' => 'Name',
    'rights' => 'Rechte',
    'missingfields' => 'Fehlende Angaben',
    'missingfieldsmsg' => ' Bite einen Namen und eine Beschreibung für die Gruppe angeben.',
    'groupmanager' => 'Gruppen-Manager',
    'newgroupmsg' => 'Um eine Gruppe zu ändern oder zu löschen, auf das Ändern-Symbol klicken. Neu anlegen (s.o.) legt eine neue Gruppe an. Hinweis: Core-Gruppen können nicht gelöscht werden, da sie vom System benötigt werden.',
    'groupname' => 'Gruppen-Name',
    'coregroup' => 'Core-Gruppe',
    'yes' => 'Ja',
    'no' => 'Nein',
    'corerightsdescr' => "Diese Gruppe ist eine Core-Gruppe auf {$_CONF['site_name']}. Die Rechte dieser Gruppe können daher nicht geändert werden. Das Folgende ist eine (nicht veränderbare) Liste der Rechte dieser Gruppe.",
    'groupmsg' => 'Security-Gruppen auf dieser Site sind hierarchisch organisiert. Wenn Du diese Gruppe zu einer der folgenden Gruppen hinzufügst, bekommt diese Gruppe die gleichen Rechte wie die unten ausgewählte(n). Wenn möglich, sollten Gruppenrechte durch Auswahl von Gruppen aus dieser Liste vergeben werden. Werden nur einzelne Rechte benötigt, können diese auch aus der Liste der Rechte weiter unten ausgewählt werden. Um diese Gruppe zu einer der folgenden hinzuzufügen, kannst Du die gewünschte(n) Gruppe(n) einfach anklicken.',
    'coregroupmsg' => "Diese Gruppe ist eine Core-Gruppe auf {$_CONF['site_name']}. Die Rechte dieser Gruppe können daher nicht geändert werden. Das Folgende ist eine (nicht veränderbare) Liste der Gruppen, zu der diese Gruppe gehört.",
    'rightsdescr' => 'Die folgenden Rechte können an eine Gruppe entweder direkt (durch Auswählen) oder indirekt vergeben werden (wenn die Gruppe zu einer anderen Gruppe gehört, die diese Rechte hat). Die im Folgenden aufgeführten Rechte ohne Checkbox sind indirekte Rechte, die von einer anderen Gruppe geerbt wurden, zu der die aktuelle Gruppe gehört. Alle anderen Rechte können hier direkt vergeben werden.',
    'lock' => 'Lock',
    'members' => 'Mitglieder',
    'anonymous' => 'Gast',
    'permissions' => 'Rechte',
    'permissionskey' => 'R = lesen, E = editieren, Editier-Rechte setzen Lese-Rechte voraus',
    'edit' => 'Edit',
    'none' => 'None',
    'accessdenied' => 'Zugriff verweigert',
    'storydenialmsg' => "Du hast nicht die nötigen Rechte, um diesen Artikel zu lesen. Möglicherweise bist Du kein registrierter User von {$_CONF['site_name']}. Bitte melde Dich als <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">neuer User</a> von {$_CONF['site_name']} an um vollen Zugriff auf alle Bereiche zu bekommen.",
    'nogroupsforcoregroup' => 'Diese Gruppe gehört zu keiner anderen Gruppe.',
    'grouphasnorights' => 'Diese Gruppe hat keine Rechte für die Administration der Website.',
    'newgroup' => 'Neue Gruppe',
    'adminhome' => 'Schaltzentrale',
    'save' => 'Speichern',
    'cancel' => 'Abbruch',
    'delete' => 'Löschen',
    'canteditroot' => 'Du hast versucht die Gruppe Root zu ändern, obwohl Du selbst nicht Mitglied dieser Gruppe bist. Der Zugriff wurde daher verweigert. Wende Dich bitte an den Systemadministrator wenn Du der Meinung bist, dass das ein Fehler wäre.',
    'listusers' => 'Mitglieder',
    'listthem' => 'anzeigen',
    'usersingroup' => 'Mitglieder der Gruppe "%s"',
    'usersingroupmsg' => 'A list of users that belong to the group. Users lists here may belong directly to the group or are inherited from another group that has been added to this group.',
    'usergroupadmin' => 'Usergruppen-Verwaltung',
    'add' => 'Hinzufügen',
    'remove' => 'Löschen',
    'availmembers' => 'Verfügbare Mitglieder',
    'groupmembers' => 'Mitglieder der Gruppe',
    'inheritmembers' => 'Inherited Group Members',
    'canteditgroup' => 'Um diese Gruppe bearbeiten zu können, musst Du selbst ein Mitglied der Gruppe sein. Wende Dich bitte an den Systemadministrator wenn Du der Meinung bist, dass das ein Fehler wäre.',
    'cantlistgroup' => 'Um die Mitglieder dieser Gruppe sehen zu können, musst Du selbst ein Mitglied der Gruppe sein. Wende Dich bitte an den Systemadministrator wenn Du der Meinung bist, dass das ein Fehler wäre.',
    'editgroupmsg' => 'Um die Gruppenmitgliedschaft eines Users zu ändern, den Usernamen anklicken und entsprechend Hinzufügen oder Löschen anklicken. Nur User in der rechten Liste sind Mitglieder der Gruppe. Um die Änderungen zu übernehmen und zur Gruppenliste zurückzukehren, den Button <b>Speichern</b> klicken.',
    'listgroupmsg' => 'Liste aller Mitglieder der Gruppe "<b>%s</b>"',
    'search' => 'Suchen',
    'submit' => 'Abschicken',
    'limitresults' => 'Ergebnisse einschränken',
    'group_id' => 'Gruppen-ID',
    'plugin_access_denied_msg' => 'Du versuchst ohne Berechtigung auf die Plugin-Verwaltungsseite zuzugreifen.  Bitte beachte, dass alle Versuche, ohne Berechtigung auf diese Seite zuzugreifen, aufgezeichnet werden.',
    'groupexists' => 'Gruppenname existiert schon',
    'groupexistsmsg' => 'Es existiert bereits eine Gruppe mit diesem Namen. Gruppennamen müssen eindeutig sein.',
    'demo_mode_denied_msg' => 'This feature is currently disabled while the site is in Demo Mode.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'database_admin' => 'Database Administration',
    'last_ten_backups' => 'Datenbank-Backups',
    'site_db_backup' => "{$_CONF['site_name']} Database Backup",
    'create_backup' => 'Backup Database',
    'do_backup' => 'Backup anlegen',
    'backup_successful' => 'Backup der Datenbank war erfolgreich.',
    'backup_error' => 'Error performing database backup.',
    'db_explanation' => 'Um ein neues Backup der Datenbank anzulegen, bitte auf Neu anlegen (s.o.) klicken. Ein Klick auf einen Dateinamen lädt das Backup herunter.',
    'backup_instructions' => 'To create a new backup of your site database, select the "Do Backup" button below. This will backup all current Geeklog tables. You can download a copy of the backup from the main Database Administration Screen.',
    'zero_size' => 'Backup fehlgeschlagen: Datei ist 0 Bytes groß.',
    'path_not_found' => "{$_CONF['backup_path']} existiert nicht oder ist kein Verzeichnis.",
    'no_access' => "Fehler: Konnte nicht auf das Verzeichnis {$_CONF['backup_path']} zugreifen.",
    'backup_file' => 'Backup-Datei',
    'size' => 'Größe',
    'bytes' => 'Bytes',
    'total_number' => 'Gesamtanzahl Backups: %d',
    'download' => 'Anklicken, um diese Datei runterzuladen',
    'convert_menu' => 'Nach InnoDB konvertieren',
    'convert_title' => 'In InnoDB-Tabellen konvertieren',
    'convert_myisam_menu' => 'Convert to MyISAM',
    'convert_myisam_title' => 'Convert to MyISAM tables',
    'convert_button' => 'Konvertieren',
    'converting' => 'Converting',
    'no_innodb' => 'Your version of MySQL does not support InnoDB tables.',
    'no_myisam' => 'Your version of MySQL does not support MyISAM tables.',
    'innodb_instructions' => 'InnoDB tables can provide better performance on large databases. Please <a href="http://dev.mysql.com/doc/refman/5.7/en/converting-tables-to-innodb.html" target="_blank">read up</a> on the benefits and drawbacks of InnoDB tables before you perform a conversion.',
    'myisam_instructions' => 'MyISAM tables can provide better performance on smaller databases.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'already_converted_myisam' => 'It appears that all of the tables have already been converted to MyISAM.',
    'conversion_message' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Tabellen wurden erfolgreich konvertiert.',
    'myisam_success' => 'Successfully converted tables to MyISAM.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Tabellen optimieren',
    'optimize_title' => 'Tabellen Optimieren',
    'optimize_button' => 'Optimieren',
    'optimizing' => 'Optimizing',
    'optimize_explain' => 'Das Optimieren der Tabellen mag helfen, die Geschwindigkeit des Auftritts zu verbessern. Die tatsächliche Verbesserung hängt ab von der Tabellenverwendung und einige mögen mehr davon profitieren als andere. Bitte keinen riesigen Unterschied in der Geschwindigkeit erwarten. Das <a href="http://dev.mysql.com/doc/mysql/de/optimize-table.html">MySQL-Handbuch</a> gibt an: <q>die Wahrscheinlichkeit, dass Sie dies häufiger als einmal in der Woche oder im Monat tun müssen, ist sehr gering</q>.',
    'last_optimization' => 'Letzte Optimierung',
    'optimization_message' => 'Optimization may take some time - please be patient.',
    'optimize_success' => 'Tabellen wurden erfolgreich optimiert.',
    'conversion_status' => 'Conversion Status',
    'optimization_status' => 'Optimization Status',
    'backup_status' => 'Backup Status',
    'backingup' => 'Performing Backup',
    'backup_title' => 'Backup the Geeklog Database',
    'backup_warning' => 'Note: The configuration is set to only backup database structures. No data will be backed up.',
    'latest_backup' => 'Latest Backup',
    'tables_to_backup' => 'Tables to Backup',
    'include' => 'Include',
    'exclude' => 'Exclude',
    'options' => 'Options',
    'struct_only' => 'Only Backup Table Structure (no data)',
    'max_files' => 'Maximum Backup Files to Keep',
    'disable_purge' => '("0" to disable purging.)',
    'use_gzip' => 'Use GZip if available',
    'configure' => 'Configure',
    'config_instructions' => 'Select any tables you wish to exclude from the backup. Other options can be found in the Geeklog Configuration under the Database tab.',
    'config_successful' => 'Tables to Backup list was saved successfully.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Home',
    2 => 'Kontakt',
    3 => 'Beitrag',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Statistik',
    8 => 'Einstellungen',
    9 => 'Suchen',
    10 => 'Erweiterte Suche',
    11 => 'Verzeichnis'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => 'Fehler 404',
    2 => 'Hmm, ich habe alles versucht, aber <b>%s</b> war nicht aufzufinden.',
    3 => "<p>Sorry, diese Seite oder Datei existiert nicht. Du könntest es auf der <a href=\"{$_CONF['site_url']}\">Startseite</a> oder mit der <a href=\"{$_CONF['site_url']}/search.php\">Suchfunktion</a> probieren, vielleicht wirst Du ja fündig ...",
    4 => "<p>We're sorry, but the page you have requested does not exist. We recommend going back to this <a href=\"%s\">related page</a>, or you may want to check the <a href=\"{$_CONF['site_url']}/\">home page</a>, or the <a href=\"{$_CONF['site_url']}/search.php\">search page</a> to see if you can find what you lost."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Anmeldung erforderlich',
    2 => 'Sorry, aber um auf diesen Bereich zugreifen zu können, muss man als Benutzer registriert sein.',
    3 => 'Anmelden',
    4 => 'Neuer User'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'von',
    'tracked_on' => 'Empfangen am',
    'read_more' => '[mehr]',
    'intro_text' => 'Andere haben folgendes über \'%s\' geschrieben:',
    'no_comments' => 'Keine Trackback-Kommentare für diesen Eintrag.',
    'this_trackback_url' => 'Trackback-URL für diesen Eintrag:',
    'num_comments' => '%d Trackback-Kommentare',
    'send_trackback' => 'Pings senden',
    'preview' => 'Vorschau',
    'editor_title' => 'Trackback-Kommentar senden',
    'trackback_url' => 'Trackback-URL',
    'entry_url' => 'URL des Eintrags',
    'entry_title' => 'Titel des Eintrags',
    'blog_name' => 'Site-Name',
    'excerpt' => 'Auszug',
    'truncate_warning' => 'Hinweis: Die empfangende Site könnte den Auszug kürzen.',
    'button_send' => 'Abschicken',
    'button_preview' => 'Vorschau',
    'send_error' => 'Fehler',
    'send_error_details' => 'Fehler beim Senden des Trackback-Kommentars:',
    'url_missing' => 'Keine URL für den Eintrag',
    'url_required' => 'Es muss mindestens die URL für den Eintrag angegeben werden.',
    'target_missing' => 'Keine Trackback-URL',
    'target_required' => 'Bitte die Trackback-URL eingeben.',
    'error_socket' => 'Socket konnte nicht geöffnet werden.',
    'error_response' => 'Antwort nicht verstanden.',
    'error_unspecified' => 'Fehler nicht näher spezifiziert.',
    'select_url' => 'Trackback-URL auswählen',
    'not_found' => 'Trackback-URL nicht gefunden',
    'autodetect_failed' => 'Geeklog konnte keine Trackback-URL für den Beitrag finden, zu dem der Kommentar gesendet werden sollte. Bitte gib die Trackback-URL von Hand ein.',
    'trackback_explain' => 'Aus den unten aufgeführten Links kannst Du jetzt den Beitrag auswählen, zu dem Dein Kommentar gesendet werden soll. Geeklog wird versuchen, die Trackback-URL selbst zu ermitteln. Andernfalls kannst Du die Trackback-URL aber auch <a href="%s">von Hand eingeben</a>.',
    'no_links_trackback' => 'Keine Links gefunden. Für diesen Beitrag können keine Trackback-Kommentare gesendet werden.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Pingback-Ergebnisse',
    'send_pings' => 'Pings senden',
    'send_pings_for' => 'Pings für "%s" senden',
    'no_links_pingback' => 'Keine Links gefunden. Es wurden keine Pingbacks für diesen Beitrag gesendet.',
    'pingback_success' => 'Pingback gesendet.',
    'no_pingback_url' => 'Keine Pingback-URL gefunden.',
    'resend' => 'Nochmal senden',
    'ping_all_explain' => 'Du kannst jetzt einen <a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a> zu den verlinkten Sites senden, einen Ping an Weblog-Verzeichnisse senden, oder einen <a href="http://de.wikipedia.org/wiki/Trackback">Trackback</a>-Kommentar verschicken, wenn Du über einen Beitrag in einem anderen Weblog geschrieben hast.',
    'pingback_button' => 'Pingback senden',
    'pingback_short' => 'Einen Pingback an alle in diesem Beitrag verlinkten Sites senden.',
    'pingback_disabled' => '(Pingback deaktiviert)',
    'ping_button' => 'Ping senden',
    'ping_short' => 'Weblog-Verzeichnisse "anpingen".',
    'ping_disabled' => '(Ping deaktiviert)',
    'trackback_button' => 'Trackback senden',
    'trackback_short' => 'Einen Trackback-Kommentar senden.',
    'trackback_disabled' => '(Trackback deaktiviert)',
    'may_take_a_while' => 'Hinweis: Das Senden von Pingbacks und Pings kann eine Weile dauern.',
    'ping_results' => 'Ping-Ergebnisse',
    'unknown_method' => 'Unbekannte Ping-Methode',
    'ping_success' => 'Ping gesendet.',
    'error_site_name' => 'Bitte gib den Namen der Site ein.',
    'error_site_url' => 'Bitte gib die URL der Site ein.',
    'error_ping_url' => 'Bitte gib die Ping-URL der Site ein.',
    'no_services' => 'Es sind keine Weblog-Verzeichnisse konfiguriert.',
    'services_headline' => 'Weblog-Verzeichnisse',
    'service_explain' => 'Um ein Weblog-Verzeichnis zu ändern oder zu löschen, auf das Ändern-Icon klicken. Um ein neues Weblog-Verzeichnis einzutragen, auf Neu anlegen (s.o.) klicken.',
    'service' => 'Verzeichnis',
    'ping_method' => 'Ping-Methode',
    'service_website' => 'Website',
    'service_ping_url' => 'Ping-URL',
    'ping_standard' => 'Normaler Ping',
    'ping_extended' => 'Erweiterter Ping',
    'ping_unknown' => '(unbekannte Methode)',
    'edit_service' => 'Weblog-Verzeichnis bearbeiten',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Hier kannst Du Deinen Trackback-Kommentar für <a href="%s">%s</a> eingeben.',
    'editor_intro_none' => 'Trackback-Kommentar eingeben.',
    'trackback_note' => 'Um einen Trackback-Kommentar für einen Artikel zu verschicken, benutze bitte den "Ping"-Eintrag in der Liste der Artikel. Um einen Trackback unabhängig von einem Artikel zu verschicken, bitte <a href="%s">hier klicken</a>.',
    'pingback_explain' => 'Gib eine URL ein, an die der Pingback geschickt werden soll. Der Pingback wird auf die Startseite Deiner Website verweisen.',
    'pingback_url' => 'Pingback-URL',
    'site_url' => 'Die URL dieser Website',
    'pingback_note' => 'Um einen Pingback für einen Artikel zu verschicken, benutze bitte den "Ping"-Eintrag in der Liste der Artikel. Um einen Pingback unabhängig von einem Artikel zu verschicken, bitte <a href="%s">hier klicken</a>.',
    'pbtarget_missing' => 'Keine Pingback-URL',
    'pbtarget_required' => 'Gib bitte die Pingback-URL ein',
    'pb_error_details' => 'Fehler beim Senden des Pingbacks:',
    'delete_trackback' => 'Trackback direkt löschen: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Artikelverzeichnis',
    'title_year' => 'Artikelverzeichnis für %d',
    'title_month_year' => 'Artikelverzeichnis für %s %d',
    'nav_top' => 'Zurück zum Artikelverzeichnis',
    'no_articles' => 'Keine Artikel.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Sicherheits-Check',
    'results' => 'Ergebnis des Sicherheits-Checks',
    'okay' => 'Es scheint alles in Ordnung zu sein.',
    'please_fix' => 'Bitte die o.g. Fehler beheben, um den Webauftritt endgültig zu nutzen!',
    'please_note' => 'Kein Internetauftritt ist 100% sicher. Der Test kann nur bekannte, offensichtliche Probleme untersuchen.',
    'stay_informed' => 'Um über Geeklog-Updates und Sicherheitsprobleme informiert zu bleiben, sollte man die  (low-traffic) %s Mailingliste abonnieren und ggf. mit der %s -Option im Adminmenü nach verfügbaren Updates schauen.',
    'public_html' => '"public_html" sollte nie Teil der URL der Website sein. Bitte den Teil der %s noch einmal lesen und die Installation entsprechend ändern.',
    'installation' => 'Installationsanleitung',
    'directory' => 'Verzeichnis',
    'failed_tmp' => 'Konnte temporäre Datei nicht im %s -Verzeichnis erstellen. Bitte die Rechte überprüfen!',
    'fix_it' => 'Dies ist ein Sicherheitsrisiko und sollte behoben werden!',
    'reachable' => 'Auf das %s kann über das Internet zugegriffen werden.',
    'not_reachable' => 'Prima! Auf das %s kann über das Internet nicht zugegriffen werden.',
    'not_sure' => 'Es kommt ein HTTP-Ergebniscode %s beim Versuch, das %s zu testen. Es ist nicht klar, was das bedeutet ...',
    'remove_inst' => 'Das Installations-Verzeichnis %s sollte entfernt werden, sobald der Webauftritt fehlerfrei läuft.',
    'remove_inst2' => 'Es beizubehalten würde Angreifern die Möglichkeit geben, den Webauftritt zu zerstören, den Auftritt zu kapern oder wichtige Informationen zu erlangen.',
    'inst_removed' => 'Prima! Das Installations-Verzeichnis ist schon entfernt worden.',
    'fix_password' => 'Das <strong>Standardkennwort</strong> "password" des %s Root-Admin-Accounts wurde noch nicht geändert.',
    'password_okay' => 'Prima! Das Standardkennwort ist schon ausgetauscht worden.'
);

###############################################################################
# "What's New" Time Strings
# 
# This here determines the order of the sentence "No new articles in 2 hrs"
# order it so it makes sense in your language:
# %i    item, "Articles"
# %n    amount, "2", "20" etc
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n neue %i für die letzten %t %s',
    'new_last' => 'letzte %t %s',
    'minutes' => 'Minuten',
    'hours' => 'Stunden',
    'days' => 'Tage',
    'weeks' => 'Wochen',
    'months' => 'Monate',
    'years' => 'Jahre',
    'minute' => 'Minute',
    'hour' => 'Stunde',
    'day' => 'Tag',
    'week' => 'Woche',
    'month' => 'Monat',
    'year' => 'Jahr'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Januar',
    2 => 'Februar',
    3 => 'März',
    4 => 'April',
    5 => 'Mai',
    6 => 'Juni',
    7 => 'Juli',
    8 => 'August',
    9 => 'September',
    10 => 'Oktober',
    11 => 'November',
    12 => 'Dezember'
);

###############################################################################
# Short Month names

$LANG_MONTH_SHORT = array(
    1 => 'Jan',
    2 => 'Feb',
    3 => 'Mar',
    4 => 'Apr',
    5 => 'May',
    6 => 'Jun',
    7 => 'Jul',
    8 => 'Aug',
    9 => 'Sep',
    10 => 'Oct',
    11 => 'Nov',
    12 => 'Decr'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Sonntag',
    2 => 'Montag',
    3 => 'Dienstag',
    4 => 'Mittwoch',
    5 => 'Donnerstag',
    6 => 'Freitag',
    7 => 'Samstag'
);

###############################################################################
# Short Weekday Names

$LANG_WEEK_SHORT = array(
    1 => 'Sun',
    2 => 'Mon',
    3 => 'Tue',
    4 => 'Wed',
    5 => 'Thu',
    6 => 'Fri',
    7 => 'Sat'
);

###############################################################################
# AM/PM

$LANG_AMPM = array(
    'am_pm' => array('am' => 'am', 'pm' => 'pm'),
    'AM_PM' => array('am' => 'AM', 'pm' => 'PM')
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Suchen',
    'limit_results' => 'Anzahl Ergebnisse',
    'submit' => 'Abschicken',
    'edit' => 'Ändern',
    'edit_adv' => 'Erw. Editor',
    'admin_home' => 'Schaltzentrale',
    'create_new' => 'Neu anlegen',
    'create_new_adv' => 'Neu anlegen (Erw.)',
    'enabled' => 'Funktion aktivieren',
    'disabled' => 'Disabled',
    'title' => 'Titel',
    'page_title' => 'Seitentitel',
    'type' => 'Typ',
    'topic' => 'Kategorie',
    'info' => 'Info',
    'help_url' => 'URL f. Hilfe-Datei',
    'save' => 'Speichern',
    'cancel' => 'Abbruch',
    'install' => 'Install',
    'delete' => 'Löschen',
    'deleteitem' => 'Delete',
    'delete_sel' => 'Ausgewählte löschen',
    'copy' => 'Kopieren',
    'no_results' => '- Keine Einträge gefunden -',
    'data_error' => 'Es gab einen Fehler bei der Verarbeitung der Subscription-Daten. Bitte die Datenquelle überprüfen.',
    'preview' => 'Vorschau',
    'records_found' => 'Einträge',
    'addchild' => 'Add child',
    'list' => 'auflisten',
    'list_all' => 'Alle auflisten',
    'meta_description' => 'Metatag Description',
    'meta_keywords' => 'Metatag Keywords',
    'na' => 'n/v',
    'unavailable' => 'n/v',
    'warning' => '!!!',
    'token_expiry' => 'Achtung, zeitgesteuerte Sicherheitsfunktion (Security-Token). Nach %s lässt sich diese Seite nicht mehr speichern. Änderungen gehen verloren.',
    'token_expired' => 'Das Security-Token für diese Veränderung ist ausgelaufen. Bitte neu authentifizieren, um weiterzumachen.',
    'reauth_msg' => 'Das Security-Token für diese Veränderung ist ausgelaufen. Wenn Du weitermachen willst, dann bitte unten neu authentifizieren. Damit wird sichergestellt, dass die gerade gemachten Änderungen nicht verloren gehen.',
    'token_expired_remote_user' => 'The security token for this operation has expired. Since you are a remote user you cannot re-authenticate, so you have lost your changes.',
    'token_re_authentication_error' => 'There was an error after your account was re-authenticated. It is unclear if the operation you were performing was executed or not.',
    'authenticate' => 'Authentifizieren',
    'approve' => 'Approve',
    'device' => 'Device',
    'device_desc' => 'For what device do you want this item to display for?',
    'for_all' => 'All',
    'for_mobile' => 'For Mobile',
    'for_computer' => 'For Computer',
    'all' => 'All',
    'mobile' => 'Mobile',
    'computer' => 'Computer',
    'edit_access_only' => 'Edit Access Only'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Kommentare erlaubt',
    -1 => 'Keine Kommentare',
    1 => 'Kommentare geschlossen'
);

$LANG_commentmodes = array(
    'flat' => 'Flach',
    'nested' => 'Verschachtelt',
    'threaded' => 'Nach Thema',
    'nocomment' => 'Keine Kommentare'
);

$LANG_cookiecodes = array(
    0 => '(gar nicht)',
    3600 => '1 Stunde',
    7200 => '2 Stunden',
    10800 => '3 Stunden',
    28800 => '8 Stunden',
    86400 => '1 Tag',
    604800 => '1 Woche',
    2678400 => '1 Monat'
);

$LANG_dateformats = array(
    0 => 'Grundeinstellung'
);

$LANG_featurecodes = array(
    0 => 'Normaler Artikel',
    1 => 'Hauptartikel'
);

$LANG_frontpagecodes = array(
    0 => 'Nur unter der Kategorie',
    1 => 'Auch auf der Startseite'
);

$LANG_postmodes = array(
    'plaintext' => 'als Text',
    'html' => 'in HTML'
);

$LANG_sortcodes = array(
    'ASC' => 'Älteste zuerst',
    'DESC' => 'Neueste zuerst'
);

$LANG_statuscodes = array(
    0 => 'Normal',
    1 => 'Refreshing',
    10 => 'Archive'
);

$LANG_trackbackcodes = array(
    0 => 'Trackbacks erlaubt',
    -1 => 'Keine Trackbacks'
);

$LANG_structureddatatypes = array(
    'none' => 'None',
    'core-webpage' => 'WebPage',
    'core-article' => 'Article',
    'core-newsarticle' => 'NewsArticle',
    'core-blogposting' => 'BlogPosting'
);

$LANG_STRUCT_DATA = array(
    'lang_structured_data_type' => 'Structured Data Type',
    'autotag_desc_structureddata' => '[structureddata:schema_property]Property Value[/structureddata] - Adds a property to the structured data of the content that the autotag is embedded in.'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Verwaltung der Site',
    'sections' => 'Bereich Konfiguration',
    'restore' => 'Zurücksetzen',
    'add_element' => 'Element hinzufügen',
    'save_changes' => 'Änderungen speichern',
    'reset_form' => 'Angaben zurücksetzen',
    'changes_made' => 'Änderungen wurden erfolgreich übernommen',
    'title' => 'Konfigurations-Manager',
    'disable' => 'Funktion deaktivieren',
    'enable' => 'Funktion aktivieren',
    'default_tab_name' => 'Main',
    'search_configuration_label' => 'Konfiguration durchsuchen',
    'error_validation_occurs' => 'There are invalid configuration values. Please correct these fields (just click the config variable to point you to the error field)'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog Konfiguration'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'Pfad Webroot',
    'site_url' => 'URL der Site',
    'site_admin_url' => 'Admin URL',
    'site_mail' => 'Site E-Mail',
    'noreply_mail' => 'No-Reply E-Mail',
    'mail_cc_enabled' => 'Allow to Send Carbon Copies',
    'mail_cc_default' => '"Carbon Copy" on by Default',
    'mail_charset' => 'Email Character Set',
    'site_name' => 'Name des Webauftritts',
    'site_slogan' => 'Slogan im Kopf',
    'path_site_logo' => 'Site Logo',
    'owner_name' => 'Owner Name',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Pfad zum Log',
    'path_language' => 'Pfad zu Sprachdateien',
    'backup_path' => 'Pfad zum Backup',
    'path_data' => 'Pfad zu Data',
    'path_images' => 'Pfad zu Images',
    'path_editors' => 'Advanced Editors',
    'mail_settings' => 'Einstellungen ',
    'dbdump_filename_prefix' => 'Backup File Name Prefix',
    'dbdump_tables_only' => 'Only Backup Table Structure',
    'dbdump_gzip' => 'Use GZip if available',
    'dbdump_max_files' => 'Maximum Backup Files to Keep',
    'theme' => 'Theme',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => 'Elemente des Menüs ',
    'path_themes' => 'Pfad zu Themes',
    'cache_templates' => 'Cache Templates?',
    'cache_mobile' => 'Cache Mobile Devices Separately?',
    'cache_resource' => 'Combine, Minify and Cache CSS and JavaScript Files?',
    'disable_new_user_registration' => 'Registrieren neuer User abschalten',
    'allow_user_themes' => 'User können Theme wählen',
    'allow_user_language' => 'User können Sprache wählen',
    'switchlang_homepage' => 'Switch Language Block Redirects to Homepage',
    'new_item_set_current_lang' => 'Add Current Language Id to New Item',
    'allow_user_photo' => 'User können Foto hochladen',
    'allow_username_change' => 'User können Username ändern',
    'allow_account_delete' => 'User können Account löschen',
    'hide_author_exclusion' => 'Beim Artikel steht kein Autor',
    'show_fullname' => 'Fullname wird angezeigt',
    'show_servicename' => 'Name des Service wird angezeigt',
    'require_user_email' => 'Require User Email',
    'custom_registration' => '"Custom Registration" aktivieren',
    'user_login_method' => 'User-Anmeldemethode ',
    'facebook_login' => 'Facebook OAuth-Anmeldemethode aktivieren',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => 'LinkedIn OAuth-Anmeldemethode aktivieren',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'Twitter OAuth-Anmeldemethode aktivieren',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'google_login' => 'Enable OAuth Login Method Google',
    'google_consumer_key' => 'Google OAuth Consumer Key',
    'google_consumer_secret' => 'Google OAuth Consumer Secret',
    'microsoft_login' => 'Enable OAuth Login Method Microsoft',
    'microsoft_consumer_key' => 'Microsoft OAuth Consumer Key',
    'microsoft_consumer_secret' => 'Microsoft OAuth Consumer Secret',
    'yahoo_login' => 'Enable OAuth Login Method Yahoo',
    'yahoo_consumer_key' => 'Yahoo OAuth Consumer Key',
    'yahoo_consumer_secret' => 'Yahoo OAuth Consumer Secret',
    'github_login' => 'Enable OAuth Login Method GitHub',
    'github_consumer_key' => 'GitHub OAuth Consumer Key',
    'github_consumer_secret' => 'GitHub OAuth Consumer Secret',
    'spamx' => 'Spam-X Actions',
    'sort_admin' => 'Admin Links sortieren',
    'language' => 'Sprache',
    'locale' => 'Locale',
    'date' => 'Datumsformat',
    'daytime' => 'Format Tag und Zeit',
    'shortdate' => 'Format kurzes Datum',
    'dateonly' => 'Format nur Datum',
    'timeonly' => 'Format nur Zeit',
    'week_start' => 'Wochenanfang',
    'hour_mode' => '12 oder 24h-Modus',
    'thousand_separator' => 'Tausender-Trennzeichen',
    'decimal_separator' => 'Dezimal-Trennzeichen',
    'decimal_count' => 'Stellen hinter dem Komma',
    'language_files' => 'Sprachdateien',
    'languages' => 'Sprachen',
    'timezone' => 'Zeitzone',
    'site_disabled_msg' => 'Anzeige bei Abschaltung von Geeklog oder URL',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Session Cookie Name',
    'cookie_name' => 'Permanent Cookie Name',
    'cookie_password' => 'Password Cookie Name',
    'cookie_theme' => 'Theme Cookie Name',
    'cookie_language' => 'Language Cookie Name',
    'cookie_tzid' => 'Zeitzone Cookie Name',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'IP in Cookies einbetten?',
    'default_perm_cookie_timeout' => 'Permanenter Timeout',
    'session_cookie_timeout' => 'Session-Timeout',
    'cookie_path' => 'Cookie-Pfad',
    'cookiedomain' => 'Cookie-Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Letzte Anmeldung aufzeichnen?',
    'num_search_results' => 'Anzahl Suchergebnisse',
    'loginrequired' => 'Anmelden generell nötig?',
    'submitloginrequired' => 'Anmelden für Beiträge?',
    'commentsloginrequired' => 'Anmelden für Kommentare?',
    'statsloginrequired' => 'Anmelden für Statistik?',
    'searchloginrequired' => 'Anmelden für Suche?',
    'profileloginrequired' => 'Anmelden für Profileinsicht?',
    'emailuserloginrequired' => 'Anmelden für E-Mail an User?',
    'emailstoryloginrequired' => 'Anmelden für E-Mail- Artikelversand?',
    'directoryloginrequired' => 'Anmelden für Artikelverzeichnis?',
    'storysubmission' => 'Artikel moderieren?',
    'usersubmission' => 'Neue User zur Moderation?',
    'listdraftstories' => 'Anzahl Artikel auf Entwurf anzeigen?',
    'notification' => 'Admin-Benachrichtigung',
    'postmode' => 'Default Post Mode',
    'speedlimit' => 'Post Speedlimit',
    'skip_preview' => 'Vorschau überspringen in Posts',
    'advanced_editor' => 'WYSIWYG-Editor?',
    'advanced_editor_name' => 'Advanced Editor Name?',
    'wikitext_editor' => 'Wikitext-Editor?',
    'remove_4byte_chars' => 'Remove 4-byte utf-8 characters?',
    'cron_schedule_interval' => 'Zeitabstand für Cronjobs',
    'sortmethod' => 'Kategorien sortieren',
    'showstorycount' => 'Anzahl Artikel anzeigen?',
    'showsubmissioncount' => 'Anzahl Artikel zur Moderation anzeigen?',
    'hide_home_link' => 'Home Link ausblenden?',
    'whosonline_threshold' => 'Session ist gültig (sec.)',
    'whosonline_anonymous' => 'Namen für Gäste ausblenden?',
    'whosonline_photo' => 'Display Thumbnail Photo?',
    'emailstories' => 'Einschalten?',
    'emailstorieslength' => 'Länge der Artikel',
    'emailstoriesperdefault' => 'Neuen Usern alles zusenden?',
    'allow_domains' => 'Automatisch erlaubte Domains',
    'disallow_domains' => 'Automatisch verbotene Domains',
    'newstoriesinterval' => 'Zeitabstand für neue Artikel',
    'newcommentsinterval' => 'Zeitabstand für neue Kommentare',
    'newtrackbackinterval' => 'Zeitabstand für neue Trackbacks',
    'hidenewstories' => 'Neue Artikel ausblenden',
    'hidenewcomments' => 'Neue Kommentare ausblenden',
    'hidenewtrackbacks' => 'Neue Trackbacks ausblenden',
    'hidenewplugins' => 'Neue Plugin-Einträge ausblenden',
    'title_trim_length' => 'Titel abschneiden nach ',
    'whatsnew_cache_time' => 'Max Cache Time',
    'trackback_enabled' => 'Trackback möglich?',
    'pingback_enabled' => 'Pingback möglich?',
    'ping_enabled' => 'Ping möglich?',
    'trackback_code' => 'Trackback Default',
    'multiple_trackbacks' => 'Multiple Trackbacks',
    'trackbackspeedlimit' => 'Trackback Speed-Limit',
    'check_trackback_link' => 'Trackbacks gegenchecken',
    'pingback_self' => 'Pingback an eigene Site?',
    'pingback_excerpt' => 'Pingback-Auszug erzeugen?',
    'link_documentation' => 'Link zur Dokumentation?',
    'link_versionchecker' => 'Link zum Versions-Checker?',
    'maximagesperarticle' => 'Max. Bilder pro Artikel',
    'limitnews' => 'Artikel pro Seite',
    'minnews' => 'Min. Artikel pro Seite',
    'contributedbyline' => 'Autor anzeigen?',
    'hideviewscount' => 'Anzeigezähler ausblenden?',
    'hideemailicon' => 'E-Mail-Symbol ausblenden?',
    'hideprintericon' => 'Druck-Symbol ausblenden?',
    'allow_page_breaks' => 'Seitenumbrüche erlauben?',
    'page_break_comments' => 'Kommentare auf Mehrseiten-Artikeln',
    'article_image_align' => 'Ausrichtung Kategorie-Symbol',
    'show_topic_icon' => 'Kategorie-Symbol anzeigen?',
    'structured_data_type_default' => 'Structured Data Type Default',
    'structured_data_article_topic' => 'Structured Data of Articles in Topics',
    'draft_flag' => 'Als Grundeinstellung auf Entwurf',
    'frontpage' => 'Als Grundeinstellung auf der Titelseite',
    'hide_no_news_msg' => '"No News"-Message ausblenden?',
    'hide_main_page_navigation' => 'Main Page Navigation ausblenden?',
    'onlyrootfeatures' => 'Nur Root kann Hauptartikel schreiben?',
    'aftersave_story' => 'Nachdem der Artikel gespeichert wurde',
    'related_topics' => 'Related Topics',
    'related_topics_max' => 'Max Related Topics to Display',
    'whats_related' => 'What\'s Related',
    'whats_related_max' => 'Max What\'s Related to Display',
    'whats_related_trim' => 'What\'s Related Title Length',
    'default_cache_time_article' => 'Default Article Cache Time',
    'blocks_article_topic_list_repeat_after' => 'Article Topic List Blocks Location Repeat',
    'aftersave_user' => 'Nachdem der User gespeichert wurde',
    'show_right_blocks' => 'Immer rechte Blöcke anzeigen?',
    'showfirstasfeatured' => 'Ersten Artikel als Hauptartikel anzeigen?',
    'template_comments' => 'Template Comments in Output?',
    'backend' => 'Newsfeed einschalten?',
    'rdf_file' => 'Ausgabe-Unterverzeichnis',
    'rdf_limit' => 'Newsfeed Limit',
    'rdf_storytext' => 'Artikellänge',
    'rdf_language' => 'Sprache',
    'syndication_max_headlines' => 'Max. Anzahl von Überschriften (portal blocks)',
    'comment_feeds_article_tag' => 'Article Tag',
    'comment_feeds_article_tag_position' => 'Article Tag Position',
    'comment_feeds_article_author_tag' => 'Article Author Tag',
    'comment_feeds_comment_author_tag' => 'Comment Author Tag',
    'copyrightyear' => 'Copyright-Jahr',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Pfad zu Mogrify',
    'path_to_netpbm' => 'Pfad zu Netpbm',
    'debug_image_upload' => 'Debug Image-Upload?',
    'keep_unscaled_image' => 'Bild in Originalgröße behalten?',
    'allow_user_scaling' => 'User darf skalieren?',
    'jpeg_quality' => 'JPEG-Qualität?',
    'max_image_width' => 'Max. Bildbreite?',
    'max_image_height' => 'Max. Bildhöhe?',
    'max_image_size' => 'Max. Bildgröße?',
    'max_topicicon_width' => 'Max. Breite?',
    'max_topicicon_height' => 'Max. Höhe?',
    'max_topicicon_size' => 'Max. Größe?',
    'max_photo_width' => 'Max. Fotobreite?',
    'max_photo_height' => 'Max. Fotohöhe?',
    'max_photo_size' => 'Max. Fotogröße?',
    'generate_user_icon' => 'Generate User Icon automatically?',
    'use_gravatar' => 'Gravatare von Gravatar.com benutzen?',
    'gravatar_rating' => 'Gravatar-Rating',
    'gravatar_identicon' => 'Gravatar Identicon',
    'force_photo_width' => 'Fotogröße erzwingen',
    'default_photo' => 'Standardfoto',
    'commentspeedlimit' => 'Kommentar Speed-Limit',
    'comment_limit' => 'Max. Anzahl Kommentare',
    'comment_mode' => 'Kommentar-Anzeigemodus',
    'comment_order' => 'Comment Order',
    'comment_code' => 'Kommentar Grundeinstellung',
    'comment_edit' => 'Kommentare editierbar?',
    'comment_edittime' => 'Editierzeit (Sekunden)',
    'commentsubmission' => 'Kommentare moderieren',
    'likes_enabled' => 'Likes Enabled',
    'likes_articles' => 'Article Likes',
    'likes_comments' => 'Comment Likes',
    'likes_speedlimit' => 'Likes Speed Limit',
    'likes_users_listed' => 'User Listed',
    'likes_block_cache_time' => 'Cache Time',
    'likes_block_include_time' => 'Include Time',
    'likes_block_max_items' => 'Max Items Listed',
    'likes_block_displayed_actions' => 'Displayed Actions',
    'likes_block_title_trim_length' => 'Title Trim Length',
    'likes_block_likes_new_line' => 'Likes on New Line',
    'likes_block_type' => 'Type',
    'likes_block_subtype' => 'Sub Type',
    'likes_block_enable' => 'Enabled',
    'likes_block_isleft' => 'Display Block on Left',
    'likes_block_order' => 'Block Order',
    'likes_block_topic_option' => 'Topic Options',
    'likes_block_topic' => 'Topic',
    'likes_block_group_id' => 'Group',
    'likes_block_permissions' => 'Permissions',
    'passwordspeedlimit' => 'Passwort Speed-Limit',
    'login_attempts' => 'Max. Anmeldeversuche',
    'login_speedlimit' => 'Anmelde-Speed-Limit',
    'invalidloginattempts' => 'Max. Invalid Login Attempts',
    'invalidloginmaxtime' => 'Invalid Login Max Time',
    'enable_twofactorauth' => 'Enable Two Factor Authentication?',
    'pass_alg' => 'Password Hash Algorithm',
    'pass_stretch' => 'Hash Stretch Count',
    'user_html' => 'Erlaubtes User HTML',
    'admin_html' => 'Erlaubtes Admin HTML',
    'advanced_html' => 'Zusätzl. HTML f.d. WYSIWYG-Editor',
    'skip_html_filter_for_root' => 'HTML des Root ungefiltert?',
    'allowed_protocols' => 'Erlaubte Protokolle',
    'disable_autolinks' => 'Autotags ausschalten?',
    'clickable_links' => 'URLs anklickbar machen?',
    'linktext_maxlen' => 'Max Link Text Length',
    'compressed_output' => 'Komprimierten Output senden?',
    'frame_options' => 'Schutz gegen "Clickjacking"',
    'page_navigation_max_pages' => 'Max Pages for Navigation',
    'page_navigation_mobile_max_pages' => 'Max Pages for Navigation with Mobile Devices',
    'default_cache_time_block' => 'Default Block Cache Time',
    'titletoid' => 'Enable Title To Id?',
    '404_log' => 'Log 404 Errors',
    'censormode' => 'Zensur-Modus?',
    'censorreplace' => 'Zensurwort wird ersetzt mit',
    'censorlist' => 'Liste zensierter Wörter',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'URL-Rewrite einschalten',
    'url_routing' => 'Enable URL Routing',
    'cdn_hosted' => 'Use CDN-hosted copy of jQuery',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Grundeinstellung Meta Description',
    'meta_keywords' => 'Grundeinstellung Meta Keywords',
    'default_permissions_block' => 'Grundeinstellung Blockrechte',
    'default_permissions_story' => 'Grundeinstellung Artikelrechte',
    'default_permissions_topic' => 'Grundeinstellung Kategorierechte',
    'atom_max_stories' => 'Max. Artikel im Webservices-Feed',
    'disable_webservices' => 'Webservices ausschalten?',
    'restrict_webservices' => 'Webservices beschränken?',
    'article_comment_close_enabled' => 'Automatisch Kommentarmöglichkeit abschalten (Grundeinstellung)',
    'article_comment_close_days' => 'Tage nach denen Kommentare uneditierbar werden (hier nur Grundeinstellung)',
    'comment_close_rec_stories' => 'Anzahl letzter Artikel, die kommentierbar sein sollen',
    'allow_reply_notifications' => 'Benachrichtigung auf Kommentare erlauben?',
    'comment_on_same_page' => 'Comment on Same Page?',
    'show_comments_at_replying' => 'Show Comments at Replying?',
    'search_style' => 'Darstellung der Ergebnisse',
    'search_limits' => 'Seiteneinstellung',
    'search_show_num' => 'Ergebnisnummer zeigen?',
    'search_show_type' => 'Ergebnisart zeigen?',
    'search_show_sort' => 'Darf User Ergebnisse sortieren?',
    'search_show_limit' => 'Seiteneinstellung zeigen?',
    'search_separator' => 'Trennzeichen für Gruppen',
    'search_def_keytype' => 'Grundeinstellung Suchmethode',
    'search_def_sort' => 'Grundeinstellung Sortierreihenfolge',
    'search_use_topic' => 'Use Current Topic',
    'autotag_permissions_story' => '[article: ]-Rechte',
    'autotag_permissions_user' => '[user: ]-Rechte',
    'autotag_permissions_topic' => '[topic: ] Permissions',
    'autotag_permissions_related_topics' => '[related_topics: ] Permissions',
    'autotag_permissions_related_items' => '[related_items: ] Permissions',
    'autotag_permissions_block' => '[block: ] Permissions',
    'autotag_permissions_structureddata' => '[structureddata: ] Permissions',
    'autotag_permissions_likes_block' => '[likes_block: ] Permissions',
    'multiple_breadcrumbs' => 'Multiple Breadcrumbs',
    'disable_breadcrumbs_topics' => 'Disable Topic Breadcrumbs',
    'disable_breadcrumbs_articles' => 'Disable Article Breadcrumbs',
    'disable_breadcrumbs_plugins' => 'Disable Plugins Breadcrumbs',
    'breadcrumb_root_site_name' => 'Site Name as Breadcrumb Root?',
    'filemanager_disabled' => 'Disable Filemanager?',
    'filemanager_browse_only' => 'Browse only mode?',
    'filemanager_default_view_mode' => 'Default view mode',
    'filemanager_show_confirmation' => 'Show confirmation?',
    'filemanager_search_box' => 'Show search box?',
    'filemanager_file_sorting' => 'File sorting',
    'filemanager_chars_only_latin' => 'Allow only latin chars?',
    'filemanager_date_format' => 'Date time format',
    'filemanager_logger' => 'Enable logger?',
    'filemanager_show_thumbs' => 'Show thumbnails?',
    'filemanager_generate_thumbnails' => 'Generate thumbnails?',
    'filemanager_upload_overwrite' => 'Overwrite existing file?',
    'filemanager_upload_file_size_limit' => 'Upload file size limit (MiB)',
    'filemanager_images_ext' => 'Image file extensions',
    'filemanager_show_video_player' => 'Show video player?',
    'filemanager_videos_ext' => 'Video file extensions',
    'filemanager_videos_player_width' => 'Video player width (px)',
    'filemanager_videos_player_height' => 'Video player height (px)',
    'filemanager_show_audio_player' => 'Show audio player?',
    'filemanager_audios_ext' => 'Audio file extensions',
    'cookie_consent' => 'Enable Cookie Consent',
    'terms_of_use_link' => 'Terms of Use Link',
    'privacy_policy_link' => 'Privacy Policy Link',
    'about_cookies_link' => 'About Cookies Consent Link',
    'ip_anonymization' => 'IP Anonymization'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Artikel und Trackbacks',
    'sg_theme' => 'Theme',
    'sg_blocks' => 'Blöcke',
    'sg_users' => 'User und Beiträge',
    'sg_images' => 'Bilder',
    'sg_locale' => 'Sprache und Lokalisierung',
    'sg_misc' => 'Vermischtes',
    'sg_filemanager' => 'Filemanager'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Pfade',
    'fs_theme' => 'Theme',
    'fs_mail' => 'Mail',
    'fs_database_backup' => 'Database Backup',
    'fs_users' => 'User',
    'fs_misc' => 'Vermischtes',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin-Block',
    'fs_locale' => 'Lokalisierung',
    'fs_language' => 'Sprache',
    'fs_multilanguage' => 'Multi-Language Content',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Anmeldeeinstellungen',
    'fs_search' => 'Suche',
    'fs_user_submission' => 'Registrierung User',
    'fs_submission' => 'Registrierungseinstellungen',
    'fs_topics_block' => 'Kategorien-Block',
    'fs_whosonline_block' => 'Wer-ist-online-Block',
    'fs_daily_digest' => 'Tägliche Zusammenfassung der Artikel',
    'fs_whatsnew_block' => 'Was-ist-neu-Block',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Artikel',
    'fs_theme_advanced' => 'Erweiterte Einstellungen',
    'fs_syndication' => 'Newsfeed',
    'fs_syndication_comment' => 'Comment Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Bilder in Artikeln',
    'fs_topicicon' => 'Kategorie-Symbol',
    'fs_userphoto' => 'Fotos',
    'fs_gravatar' => 'Gravatar.com',
    'fs_comments' => 'Kommentare',
    'fs_likes' => 'Likes',
    'fs_likes_block_settings' => 'Block Settings',
    'fs_likes_block_permissions' => 'Block Permissions',
    'fs_htmlfilter' => 'HTML-Filterung',
    'fs_censoring' => 'Zensieren',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Grundeinstellung Artikelrechte',
    'fs_perm_topic' => 'Grundeinstellung Kategorierechte',
    'fs_perm_block' => 'Grundeinstellung Blockrechte',
    'fs_webservices' => 'Webservices',
    'fs_autotag_permissions' => 'Autotag-Rechte',
    'fs_breadcrumbs' => 'Breadcrumbs',
    'fs_pass' => 'Password Settings',
    'fs_filemanager_general' => 'General Settings',
    'fs_filemanager_upload' => 'Upload',
    'fs_filemanager_images' => 'Images',
    'fs_filemanager_videos' => 'Videos',
    'fs_filemanager_audios' => 'Audios'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'Site',
    'tab_paths' => 'Pfade',
    'tab_theme' => 'Theme',
    'tab_mail' => 'Mail',
    'tab_database' => 'Database',
    'tab_users' => 'User',
    'tab_misc' => 'Vermischtes',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => 'Admin-Block',
    'tab_locale' => 'Lokalisierung',
    'tab_language' => 'Sprache',
    'tab_debug' => 'Debug',
    'tab_cookies' => 'Cookies',
    'tab_login' => 'Anmelden',
    'tab_search' => 'Suche',
    'tab_user_submission' => 'Registrierung',
    'tab_submission' => 'Registrierungseinstellungen',
    'tab_topics_block' => 'Kategorien-Block',
    'tab_whosonline_block' => 'Wer-ist-online-Block',
    'tab_daily_digest' => 'Zusammenfassung',
    'tab_whatsnew_block' => 'Was-ist-neu-Block',
    'tab_trackback' => 'Trackback',
    'tab_pingback' => 'Pingback',
    'tab_story' => 'Artikel',
    'tab_theme_advanced' => 'Erweiterte Einstellungen',
    'tab_syndication' => 'Newsfeed',
    'tab_imagelib' => 'Image Library',
    'tab_upload' => 'Upload',
    'tab_articleimg' => 'Bilder in Artikeln',
    'tab_topicicon' => 'Kategorie-Symbol',
    'tab_userphoto' => 'Fotos',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'Kommentare',
    'tab_likes' => 'Likes',
    'tab_htmlfilter' => 'HTML-Filterung',
    'tab_censoring' => 'Zensieren',
    'tab_iplookup' => 'IP Lookup',
    'tab_permissions' => 'Rechte',
    'tab_webservices' => 'Webservices',
    'tab_topics' => 'Topics',
    'tab_filemanager_general' => 'General Settings',
    'tab_filemanager_upload' => 'Upload',
    'tab_filemanager_images' => 'Images',
    'tab_filemanager_videos' => 'Videos',
    'tab_filemanager_audios' => 'Audios'
);

$LANG_configselects['Core'] = array(
    0 => array('Ja' => 1, 'Nein' => 0),
    1 => array('Ja' => true, 'Nein' => false),
    2 => array('Zurückweisen' => 0, 'Nur letzten behalten' => 1, 'Mehrfache Posts erlauben' => 2),
    3 => array('Trackbacks erlaubt' => 0, 'Keine Trackbacks' => -1),
    4 => array('Nichts checken' => 0, 'Site URL checken' => 1, 'Volle URL checken' => 2, 'Site URL und volle URL checken' => 3, 'Trackback IP mit Site IP vergleichen' => 4, 'IP und Site URL checken' => 5, 'IP und volle URL checken' => 6, 'IP, volle URL, und Site URL checken' => 7),
    5 => array('als Text' => 'plaintext', 'in HTML' => 'html', 'Wiki-style Format' => 'wikitext'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Letzte Seite' => 'last', 'Erste Seite' => 'first', 'Jede Seite' => 'all'),
    8 => array('Rechts' => 'right', 'Links' => 'left'),
    9 => array('Auf Seite weiterleiten' => 'item', 'Liste anzeigen' => 'list', 'Home anzeigen' => 'home', 'Admin anzeigen' => 'admin'),
    10 => array('Keine' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flach' => 'flat', 'Verschachtelt' => 'nested', 'Nach Thema' => 'threaded', 'Keine Kommentare' => 'nocomment'),
    12 => array('Kein Zugang' => 0, 'Nur lesen' => 2, 'Lesen-schreiben' => 3),
    13 => array('überspringen' => 0, 'Erlauben mit Speed-Limit' => 1, 'Erlauben ohne Speed-Limit' => 2),
    14 => array('Sonntag' => 'Sun', 'Montag' => 'Mon'),
    15 => array('Nummerisch' => 'sortnum', 'Alphabetisch' => 'alpha'),
    16 => array('Keine Anmeldung benötigt' => 0, 'Nur erweiterte Suche' => 1, 'Einfache und erweiterte Suche' => 2),
    17 => array('Kommentare eingeschaltet' => 0, 'Kommentare ausgeschaltet' => -1),
    18 => array('Aus' => 0, 'Ein (Exakte Übereinstimmung)' => 1, 'Ein (Wortanfang)' => 2, 'Ein (Teilwort)' => 3),
    19 => array('Google' => 'google', 'Tabelle' => 'table'),
    20 => array('Exakter Ausdruck' => 'phrase', 'Alle Worte' => 'all', 'Eines der Worte' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict', 'HTML5' => 'html5', 'HTML5 with XHTML syntax' => 'xhtml5'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Deaktiviert' => 0, 'Aktiviert' => 1, 'Aktiviert (Grundeinstellung nur auf der Startseite)' => 2),
    24 => array('Mitmachen' => 'contribute', 'Home' => 'home', 'Erweiterte Suche' => 'search', 'Verzeichnis' => 'directory', 'Login' => 'login', 'Mein Profil' => 'prefs', 'Plugin Einträge' => 'plugins', 'Custom Einträge' => 'custom', 'Statistik' => 'stats'),
    25 => array('Neuer Artikel' => 'article', 'Neuer Kommentar' => 'comment', 'Neuer Trackback' => 'trackback', 'Neuer Pingback' => 'pingback', 'Neuer User' => 'user', 'User Updates' => 'user_update'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (aufst)' => 'hits|asc', 'Hits (abst)' => 'hits|desc', 'Datum (aufst)' => 'date|asc', 'Datum (abst)' => 'date|desc', 'Titel (aufst)' => 'title|asc', 'Titel (abst)' => 'title|desc', 'Autor (aufst)' => 'uid|asc', 'Autor (abst)' => 'uid|desc'),
    28 => array('No access' => 0, 'Use' => 2),
    29 => array('md5' => 0, 'sha1' => 1, 'sha256' => 2, 'sha512' => 3, 'blowfish' => 4),
    30 => array('Start' => 'start', 'End' => 'end', 'None' => 'none'),
    31 => array('Newest First' => 'DESC', 'Oldest First' => 'ASC'),
    32 => array('Disabled' => 0, 'Just Article Pages' => 1, 'Articles and Topics' => 2),
    33 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (No Links)' => 2, 'Enabled (No Outbound Links)' => 3),
    34 => array('grid' => 'grid', 'list' => 'list'),
    35 => array('default' => 'default', 'Name (asc)' => 'NAME_ASC', 'Name (desc)' => 'NAME_DESC', 'Type (asc)' => 'TYPE_ASC', 'Type (desc)' => 'TYPE_DESC', 'Modified (asc)' => 'MODIFIED_ASC', 'Modified (desc)' => 'MODIFIED_DESC'),
    36 => array('False' => 'false', 'Frontpage only' => 'frontpage', 'Frontpage and Topics' => 'frontpage_topics'),
    37 => array('Disabled' => 0, 'Enabled (with "index.php")' => 1, 'Enabled (without "index.php")' => 2),
    38 => array('Mystery Man' => 'mm', 'Identicon' => 'identicon', 'MonsterId' => 'monsterid', 'WAvatar' => 'wavatar', 'Retro' => 'retro'),
    39 => array('None' => '', 'WebPage' => 'core-webpage', 'Article' => 'core-article', 'NewsArticle' => 'core-newsarticle', 'BlogPosting' => 'core-blogposting'),
    40 => array('False' => 0, 'Users and Anonymous' => 1, 'Users Only' => 2),
    41 => array('False' => 0, 'Likes and Dislikes' => 1, 'Likes Only' => 2),
    42 => array('None' => 0, 'Use individual Article Settings' => 1),
    43 => array('All' => 'all', 'Homepage Only' => 'homeonly', 'Select Topics' => 'selectedtopics'),
    44 => array('No access' => 0, 'Read-Only' => 2),
    46 => array('Likes and Dislikes' => 3, 'Likes Only' => 1, 'Dislikes Only' => 2)
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'This field contains an invalid value',
    'notEmpty' => 'This field cannot be empty',
    'alphaNumeric' => 'This field must be in alpha numeric',
    'alphaNumericOrEmpty' => 'This field must be alpha numeric or empty',
    'between' => 'This field must be in specified range',
    'blank' => 'This field must be blank',
    'comparison' => 'This field does not match the comparison operation',
    'date' => 'This field must be in date format',
    'year' => 'This field must be in year format such as 2010',
    'yearOrRange' => 'This field must be in a year format such as 2010 or range like 2010 - 2012',
    'time' => 'This field must be in time format',
    'datetime' => 'This field must be in datetime format',
    'boolean' => 'This field must be in boolean',
    'decimal' => 'This field must be in decimal',
    'email' => 'This field must contains valid email address',
    'equalTo' => 'This field does not equal',
    'extension' => 'This field only accept allowable file extension',
    'ip' => 'This field must be in valid IP format',
    'minLength' => 'This field is too short',
    'maxLength' => 'This field is too long',
    'numeric' => 'This field must be a numeric',
    'phone' => 'This field must contains valid phone number',
    'range' => 'This field must be in specified range',
    'url' => 'This field must contains valid URL',
    'inList' => 'This field must contain specified list',
    'mail_settings_backend' => 'This field must be one of \'smtp\', \'sendmail\', or \'mail\'',
    'mail_settings_sendmail_path' => 'This field must contains valid path to sendmail binary',
    'mail_settings_host' => 'This field must contain valid hostname',
    'mail_settings_port' => 'This field must be between 0 - 65535',
    'rdf_limit' => 'This field must in numeric or hour such as 24h',
    'path' => 'Path does not exist',
    'file' => 'File does not exist',
    'fileName' => 'This field must be a proper file name',
    'search_limits' => 'This field must be numeric separated with a comma',
    'num_search_results' => 'This field must be numeric and from \'search_limits\' above',
    'theme' => 'Theme directory does not exist',
    'path_themes' => 'Theme path must be in absolute path and make sure the last character contains directory separator',
    'path_to_mogrify' => 'You must set image library to imagemagick and fill this field with complete path to the mogrify executable',
    'path_to_netpbm' => 'You must set image library to netpbm and fill this field with directory where the binaries from the Netpbm package are kept',
    'language' => 'Language file does not exist',
    'timezone' => 'Invalid timezone',
    'single_char' => 'This field must be a single character',
    'page_navigation_max_pages' => 'This field must be between 2 - 21',
    'hash' => 'This field must be a hash function supported by your version of PHP',
    'config_setting_lang_array' => 'Each element requires a unique language shortcut (\'en\', \'de\', etc.) and the corresponding field must contain a value',
    'config_setting_lang_array_element_req' => 'Requires at least one element. Each element requires a unique language shortcut (\'en\', \'de\', etc.) and the corresponding field must contain a value'
);

