<?php

class NewAccountForm extends SOY2ActionForm{

	private $check;
	
    private $siteId;

	private $firstName;
	
	private $lastName;
	
	private $firstNameReading;
	private $lastNameReading;
	private $birthDate;
	private $email;
	private $password;
	private $passwordConfirm;
	
	function getSiteId() {
		return $this->siteId;
	}
	
	/**
	 * @validator string {"require" : true , "max" : 60, "min" : 3 , "regex" : "^[a-z]+[a-z0-9]*$" , 
	 * 	"message" : {
	 *		"require" : "この項目は必須です。",
	 *		"min" : "希望サイトIDは3文字以上、60文字以内でお願いします。",
	 *		"max" : "希望サイトIDは3文字以上、60文字以内でお願いします。",
	 *		"regex" : "希望サイトIDの書式が不正です。"
	 *	}
	 * }
	 */
	function setSiteId($siteId) {
		$this->siteId = $siteId;
	}
	
	function getFirstName() {
		return $this->firstName;
	}
	
	/**
	 * @validator string {"require" : true , "max" : 100, 
	 * 	"message" : {
	 *		"require" : "この項目は必須です。",
	 *		"max" : "名前（名）は100文字以内でお願いします。"
	 *	}
	 * }
	 */
	function setFirstName($firstName) {
		$this->firstName = $firstName;
	}
	
	function getLastName() {
		return $this->lastName;
	}
	
	/**
	 * @validator string {"require" : true , "max" : 100, 
	 * 	"message" : {
	 *		"require" : "この項目は必須です。",
	 *		"max" : "名前（氏）は100文字以内でお願いします。"
	 *	}
	 * }
	 */
	function setLastName($lastName) {
		$this->lastName = $lastName;
	}
	
	function getFirstNameReading() {
		return $this->firstNameReading;
	}
	
	/**
	 * @validator string {"max" : 100, 
	 * 	"message" : {
	 *		"max" : "名前（ふりがな）は100文字以内でお願いします。"
	 *	}
	 * }
	 */
	function setFirstNameReading($firstNameReading) {
		$this->firstNameReading = $firstNameReading;
	}
	
	function getLastNameReading() {
		return $this->lastNameReading;
	}
	
	/**
	 * @validator string {"max" : 100, 
	 * 	"message" : {
	 *		"max" : "名前（ふりがな）は100文字以内でお願いします。"
	 *	}
	 * }
	 */
	function setLastNameReading($lastNameReading) {
		$this->lastNameReading = $lastNameReading;
	}
	
	function getBirthDate() {
		return $this->birthDate;
	}
	
	function setBirthDate($birthDate) {
		if(is_array($birthDate)){
			if($birthDate["day"] && $birthDate["month"] && $birthDate["year"]){
				$date = mktime(0,0,0,$birthDate["month"],$birthDate["day"],$birthDate["year"]);
				$birthDate = $date;
			}else{
				$birthDate = null;
			}
		}
		
		$this->birthDate = $birthDate;
	}
	
	function getEmail() {
		return $this->email;
	}
	
	/**
	 * @validator string {"require" : true , "max" : 100, "min" : 1 , 
	 * 	"message" : {
	 *		"require" : "この項目は必須です。",
	 *		"min" : "この項目は必須です。",
	 *		"max" : "メールアドレスが長すぎます。"
	 *	}
	 * }
	 */
	function setEmail($email) {
		$this->email = $email;
	}
	
	function getPassword() {
		return $this->password;
	}
	
	/**
	 * @validator string {"require" : true , "max" : 20, "min" : 1, 
	 * 	"message" : {
	 *		"require" : "この項目は必須です。",
	 *		"min" : "この項目は必須です。",
	 *		"max" : "パスワードが長すぎます。"
	 *	}
	 * }
	 */
	function setPassword($password) {
		$this->password = $password;
	}
	
	function getPasswordConfirm() {
		return $this->passwordConfirm;
	}
	
	/**
	 * @validator string {"require" : true , "max" : 20, "min" : 1, 
	 * 	"message" : {
	 *		"require" : "この項目は必須です。",
	 *		"min" : "この項目は必須です。",
	 *		"max" : "パスワードが長すぎます。"
	 *	}
	 * }
	 */
	function setPasswordConfirm($passwordConfirm) {
		$this->passwordConfirm = $passwordConfirm;
	}

	function getCheck() {
		return $this->check;
	}
	
	/**
	 * @validator string {"require" : true , 
	 * 	"message" : {
	 *		"require" : "利用規約に同意の上、チェックを入れて下さい。"
	 *	}
	 * }
	 */
	function setCheck($check) {
		$this->check = $check;
	}
}
?>