/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AccViewPanel;
import com.xerox.VTM.engine.GLViewPanel;
import com.xerox.VTM.engine.StdViewPanel;
import com.xerox.VTM.engine.VCursor;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JPanelView
extends View
implements KeyListener {
    private JFrame frame;
    private JPanel viewContainerPanel;
    private JPanel parentPanel;

    public JPanelView(Vector cameraList, String name, int panelWidth, int panelHeight, boolean visible, boolean decorated, VirtualSpaceManager vsm, short viewType, JPanel parentPanel, JFrame frame) {
        this.checkArgs(cameraList, name, viewType, parentPanel, frame);
        this.frame = frame;
        this.parentPanel = parentPanel;
        if (parentPanel == null) {
            parentPanel = (JPanel)frame.getContentPane();
        }
        this.mouse = new VCursor(this);
        this.name = name;
        this.parent = vsm;
        this.detectMultipleFullFills = vsm.defaultMultiFill;
        this.initCameras(cameraList);
        this.viewContainerPanel = new JPanel();
        this.viewContainerPanel.setLayout(new BoxLayout(this.viewContainerPanel, 1));
        this.viewContainerPanel.setAlignmentY(0.0f);
        this.viewContainerPanel.setAlignmentX(0.0f);
        this.panel = this.makePanel(viewType, cameraList);
        this.panel.setSize(panelWidth, panelHeight);
        this.viewContainerPanel.add(this.panel);
        parentPanel.add(this.viewContainerPanel);
        this.viewContainerPanel.addKeyListener(this);
        this.viewContainerPanel.setVisible(visible);
        this.viewContainerPanel.setFocusable(true);
    }

    private ViewPanel makePanel(short viewType, Vector cameraList) {
        switch (viewType) {
            case 0: {
                return new StdViewPanel(this.cameras, this);
            }
            case 1: {
                return new AccViewPanel(this.cameras, this);
            }
            case 2: {
                return new GLViewPanel(this.cameras, this);
            }
        }
        throw new IllegalArgumentException("Invalid view type");
    }

    private void checkArgs(Vector cameraList, String name, short viewType, JPanel parentPanel, JFrame frame) {
        if (frame == null && parentPanel == null) {
            throw new IllegalArgumentException("Failed to provide parentPanel");
        }
        if (viewType < 0 || viewType > 2) {
            throw new IllegalArgumentException("Invalid viewType");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Failed to provide name");
        }
        if (cameraList == null || cameraList.size() == 0) {
            throw new IllegalArgumentException("Failed to provide at least one camera in list");
        }
    }

    public void destroyView() {
        this.panel.stop();
        this.parent.destroyView(this.name);
        this.parentPanel.remove(this.viewContainerPanel);
    }

    public Container getFrame() {
        return this.frame;
    }

    public void requestFocus() {
        if (this.frame.isActive()) {
            this.viewContainerPanel.requestFocusInWindow();
        }
    }

    public boolean isSelected() {
        return this.frame == this.parent.activeJFrame;
    }

    public void setTitle(String title) {
        this.frame.setTitle(title);
    }

    public void setLocation(int x, int y) {
        this.viewContainerPanel.setLocation(x, y);
    }

    public void setSize(int x, int y) {
        this.viewContainerPanel.setSize(x, y);
    }

    public void setResizable(boolean b) {
        this.frame.setResizable(b);
    }

    public void setVisible(boolean visible) {
        this.viewContainerPanel.setVisible(visible);
        if (visible) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    public void toFront() {
        this.frame.toFront();
    }

    public void toBack() {
        this.frame.toBack();
    }

    public void keyTyped(KeyEvent e) {
        if (e.isShiftDown()) {
            if (e.isControlDown()) {
                this.panel.evHs[this.panel.activeLayer].Ktype(this.panel, e.getKeyChar(), e.getKeyCode(), 3, e);
            } else {
                this.panel.evHs[this.panel.activeLayer].Ktype(this.panel, e.getKeyChar(), e.getKeyCode(), 1, e);
            }
        } else if (e.isControlDown()) {
            this.panel.evHs[this.panel.activeLayer].Ktype(this.panel, e.getKeyChar(), e.getKeyCode(), 2, e);
        } else {
            this.panel.evHs[this.panel.activeLayer].Ktype(this.panel, e.getKeyChar(), e.getKeyCode(), 0, e);
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.isShiftDown()) {
            if (e.isControlDown()) {
                this.panel.evHs[this.panel.activeLayer].Kpress(this.panel, e.getKeyChar(), e.getKeyCode(), 3, e);
            } else {
                this.panel.evHs[this.panel.activeLayer].Kpress(this.panel, e.getKeyChar(), e.getKeyCode(), 1, e);
            }
        } else if (e.isControlDown()) {
            this.panel.evHs[this.panel.activeLayer].Kpress(this.panel, e.getKeyChar(), e.getKeyCode(), 2, e);
        } else {
            this.panel.evHs[this.panel.activeLayer].Kpress(this.panel, e.getKeyChar(), e.getKeyCode(), 0, e);
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.isShiftDown()) {
            if (e.isControlDown()) {
                this.panel.evHs[this.panel.activeLayer].Krelease(this.panel, e.getKeyChar(), e.getKeyCode(), 3, e);
            } else {
                this.panel.evHs[this.panel.activeLayer].Krelease(this.panel, e.getKeyChar(), e.getKeyCode(), 1, e);
            }
        } else if (e.isControlDown()) {
            this.panel.evHs[this.panel.activeLayer].Krelease(this.panel, e.getKeyChar(), e.getKeyCode(), 2, e);
        } else {
            this.panel.evHs[this.panel.activeLayer].Krelease(this.panel, e.getKeyChar(), e.getKeyCode(), 0, e);
        }
    }
}

