#    Jools -- a graphical puzzle game in the Tetris tradition
#    
#    Copyright (C) 2002-2003 Paul Pelzl
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# joolsutils.py
#
# miscellaneous utility functions
#


import pygame, os
from pygame.locals import *

def load_image(name, colorkey=None):
   #fullname = os.path.join('data', name)
   fullname = name
   try:
      image = pygame.image.load(fullname)
   except pygame.error, message:
      print 'Cannot load image:', fullname
      if not pygame.image.get_extended():
         print "(Jools requires a Pygame library built with SDL_image support.)"
      raise SystemExit, message
   image = image.convert()
   if colorkey is not None:
      if colorkey is -1:
         colorkey = image.get_at((0,0))
      image.set_colorkey(colorkey, RLEACCEL)
   return image, image.get_rect()


# Load up all the jool graphics
def cacheImages():
   imageCache = []

   os.chdir("images")

   for imageString in ["diamond", "ruby", "emerald", "orange",
      "amethyst", "sphere", "sapphire"]:
      os.chdir(imageString)
      imageFiles = os.listdir(os.getcwd())
      imageFiles.sort()

      imageList = []
      for f in imageFiles:
         # exclude dotfiles
         if f[0] != ".":
            im, rect = load_image(f, -1)
            imageList.append(im)
      imageCache.append(imageList)
      os.chdir("..")

   os.chdir("..")
   return imageCache



# Compare the heights of two jool position tuples.  (Used within a sort()
# call.)
def posHeightCmp(pos1, pos2):
   if pos1[0] < pos2[0]:
      return -1
   elif pos1[0] == pos2[0]:
      return 0
   else:
      return 1


# Compare the depth of two jools.  (Used within a sort() call.)
def joolZCmp(jool1, jool2):
   if jool1.isOnTop:
      return -1
   elif jool2.isOnTop:
      return 1
   else:
      return 0


# Take a list of files and return the the list with absolute
# paths.  The 'fileList' is referenced with respect to 'root'.
def absPathList(root, fileList):
   retList = []
   for file in fileList:
      retList.append(os.path.abspath(os.path.join(root,file)))
   return retList


# Remove an item from a list, if it is present in the list.
def removeItem(list, item):
   try:
      del list[list.index(item)]
   except:
      pass

# Remove dotfiles from a file list.
def removeDotfiles(files):
   filesToRemove = []
   for file in files:
      if file[0] == ".":
         filesToRemove.append(file)
   for file in filesToRemove:
      removeItem(files, file)


# arch-tag: utility functions for jools
