/* -*- Mode: C; c-file-style: "gnu" -*-
   compat.h -- Definitions for substitute functions in arch/
   Created: Chris Toshok <toshok@hungry.com>, 23-Jul-97
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef COMPAT_H
#define COMPAT_H

#include "config.h"

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>

#ifndef HAVE_ALPHASORT
  int alphasort(const void *a, const void *b);
#endif
#ifndef HAVE_SCANDIR
#ifdef HAVE_DIRENT_H
#include <dirent.h> /* For struct dirent */
#else
  /* XXX Naive implementation to keep Watcom compiler happy */
  struct dirent {
    unsigned char d_type;
    char d_name[256];
  };
#endif
  int scandir(const char *dir, struct dirent ***namelist,
	      int (*select)(const struct dirent *),
	      int (*compar)(const void *, const void *));
#endif
#ifndef HAVE_SNPRINTF
#include <stdio.h> /* For size_t */
  int snprintf(char *string1, size_t size, const char *format, ...);
#endif

#ifndef HAVE_VSNPRINTF
#include <stdarg.h> /* for va_list */
  int vsnprintf (char *str, long n, const char *format, va_list varlist);
#endif

#ifndef HAVE_STRERROR
  char *strerror(const int errnum);
#endif

#ifndef HAVE_FMODF
  float fmodf(float a, float b);
#endif

  /* Might be missing on Windows */
#ifndef HAVE_SLEEP
  unsigned int sleep(unsigned int seconds);
#endif

#ifdef HAVE_MMAP
#  ifdef HAVE_SYS_MMAN_H
#    include <sys/mman.h>
#  endif
#  ifndef MAP_FAILED
#    define MAP_FAILED ((char*)(-1))
#  endif
#endif

#ifdef __cplusplus
};
#endif

#endif /* COMPAT_H */
